/*
 * Decompiled with CFR 0.152.
 */
package option.loneterrace.shape.sunnyge.model.sunnyge.creator;

import java.awt.Color;
import java.util.Vector;
import model.parts.Parts;
import option.gad.core.util.GdMutableTypeUtil;
import option.loneterrace.common.entity.BasicInfo;
import option.loneterrace.common.entity.SNYEntities;
import option.loneterrace.common.entity.TerraceInfo;
import option.loneterrace.common.entity.TerracesInfo;
import option.loneterrace.common.service.common.SNYColor;
import option.loneterrace.common.type.KenType;
import option.loneterrace.common.type.SodePosType;
import option.loneterrace.common.type.SubProductType;
import option.loneterrace.common.type.TerraceDepthType;
import option.loneterrace.common.type.TerraceWidthType;
import option.loneterrace.shape.sunnyge.model.sunnyge.creator.SNYTerraceUnitCreator;
import option.loneterrace.shape.sunnyge.model.sunnyge.item.AbstractTerraceUnitItem;
import option.loneterrace.shape.sunnyge.model.sunnyge.parts.AbstractPHokyouHiuchi;
import option.loneterrace.shape.sunnyge.model.sunnyge.parts.PHokyouHiuchiBig;
import option.loneterrace.shape.sunnyge.model.sunnyge.parts.PHokyouHiuchiSmall;

public class MsUnitHokyouHiuchiCreator
extends SNYTerraceUnitCreator {
    public static final float TANBU_OFFSET = 150.0f;
    public static final float TANBU_NIGE = 17.0f;
    public static final float KUTAI_OFFSET = 30.0f;
    public static final float FRONT_OFFSET = 60.0f;
    private static final float NEDA_PITCH = 450.0f;

    @Override
    public void create(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        SNYEntities sNYEntities = abstractTerraceUnitItem.getTerraceItem().getEntities();
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        boolean bl = this.isBigSize(basicInfo.mSubProductType, terraceInfo.mDepthType);
        if (basicInfo.mSubProductType == SubProductType.ALMI_BALCONY_PILLAR) {
            if (GdMutableTypeUtil.matchOR(terraceInfo.mDepthType, TerraceDepthType.T5, TerraceDepthType.T6)) {
                this.createTerraceBothEnds(abstractTerraceUnitItem, parts, bl);
            } else {
                this.createTerraceBothSide(abstractTerraceUnitItem, parts, bl);
            }
        } else if (basicInfo.mSubProductType == SubProductType.ALMI_BALCONY_ROOF) {
            this.createTerraceBothSide(abstractTerraceUnitItem, parts, false);
        }
    }

    private void createTerraceBothSide(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts, boolean bl) {
        this.createLeftHalf(abstractTerraceUnitItem, parts, bl);
        this.createRightHalf(abstractTerraceUnitItem, parts, bl);
    }

    private void createTerraceBothEnds(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts, boolean bl) {
        TerracesInfo terracesInfo = abstractTerraceUnitItem.getTerraceItem().getEntities().mTerracesInfo;
        if (terracesInfo.mWidthType == TerraceWidthType.T10) {
            if (this.isLeftCreateOK(abstractTerraceUnitItem)) {
                this.createLeftCorner(abstractTerraceUnitItem, parts, bl);
            } else if (this.isRightCreateOK(abstractTerraceUnitItem)) {
                this.createRightCorner(abstractTerraceUnitItem, parts, bl);
            }
        } else {
            if (this.isLeftCreateOK(abstractTerraceUnitItem)) {
                this.createLeftCorner(abstractTerraceUnitItem, parts, bl);
            }
            if (this.isRightCreateOK(abstractTerraceUnitItem)) {
                this.createRightCorner(abstractTerraceUnitItem, parts, bl);
            }
        }
    }

    private boolean isLeftCreateOK(AbstractTerraceUnitItem abstractTerraceUnitItem) {
        SNYEntities sNYEntities = abstractTerraceUnitItem.getTerraceItem().getEntities();
        if (abstractTerraceUnitItem.getPrev() != null) {
            return false;
        }
        return !GdMutableTypeUtil.matchOR(sNYEntities.mTerracesInfo.mSodePosType, SodePosType.L, SodePosType.BOTH);
    }

    private boolean isRightCreateOK(AbstractTerraceUnitItem abstractTerraceUnitItem) {
        SNYEntities sNYEntities = abstractTerraceUnitItem.getTerraceItem().getEntities();
        if (abstractTerraceUnitItem.getNext() != null) {
            return false;
        }
        return !GdMutableTypeUtil.matchOR(sNYEntities.mTerracesInfo.mSodePosType, SodePosType.R, SodePosType.BOTH);
    }

    protected void createLeftHalf(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts, boolean bl) {
        SNYEntities sNYEntities = abstractTerraceUnitItem.getTerraceItem().getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        float f = -terraceInfo.mWidth.floatValue() / 2.0f + 150.0f;
        float f2 = -150.0f;
        float f3 = -30.0f;
        float f4 = -terraceInfo.mDepth.floatValue() + 60.0f;
        float f5 = this.calcZ(sNYEntities);
        if (sNYEntities.mBasicInfo.mKenType == KenType.METER && terraceInfo.mWidthType == TerraceWidthType.T20) {
            f2 = -375.0f;
        }
        this.create(f, f3, f2, f4, f5, parts, bl);
    }

    protected void createRightHalf(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts, boolean bl) {
        SNYEntities sNYEntities = abstractTerraceUnitItem.getTerraceItem().getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        float f = terraceInfo.mWidth.floatValue() / 2.0f - 150.0f;
        float f2 = 150.0f;
        float f3 = -30.0f;
        float f4 = -terraceInfo.mDepth.floatValue() + 60.0f;
        float f5 = this.calcZ(sNYEntities);
        if (sNYEntities.mBasicInfo.mKenType == KenType.METER && terraceInfo.mWidthType == TerraceWidthType.T20) {
            f2 = 375.0f;
        }
        this.create(f, f3, f2, f4, f5, parts, bl);
    }

    protected void createLeftCorner(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts, boolean bl) {
        SNYEntities sNYEntities = abstractTerraceUnitItem.getTerraceItem().getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        float f = this.calcHoleB(sNYEntities.mBasicInfo.mKenType, terraceInfo);
        float f2 = -terraceInfo.mWidth.floatValue() / 2.0f + 70.0f;
        float f3 = f2 + f;
        float f4 = -terraceInfo.mDepth.floatValue() + f;
        float f5 = -terraceInfo.mDepth.floatValue() + 60.0f;
        float f6 = this.calcZ(sNYEntities);
        this.create(f2, f4, f3, f5, f6, parts, bl);
    }

    protected void createRightCorner(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts, boolean bl) {
        SNYEntities sNYEntities = abstractTerraceUnitItem.getTerraceItem().getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        float f = this.calcHoleB(sNYEntities.mBasicInfo.mKenType, terraceInfo);
        float f2 = terraceInfo.mWidth.floatValue() / 2.0f - 70.0f;
        float f3 = f2 - f;
        float f4 = -terraceInfo.mDepth.floatValue() + f;
        float f5 = -terraceInfo.mDepth.floatValue() + 60.0f;
        float f6 = this.calcZ(sNYEntities);
        this.create(f2, f4, f3, f5, f6, parts, bl);
    }

    protected boolean isBigSize(SubProductType subProductType, TerraceDepthType terraceDepthType) {
        return subProductType == SubProductType.ALMI_BALCONY_PILLAR && GdMutableTypeUtil.matchOR(terraceDepthType, TerraceDepthType.T5, TerraceDepthType.T6);
    }

    protected float calcZ(SNYEntities sNYEntities) {
        float f = sNYEntities.mPartsFigureInfo.mYukaLevelHeight.floatValue();
        f = (float)((double)f - this.mPartsFigureService.getYukaAtumi(false));
        return f -= 60.0f;
    }

    protected float calcHoleB(KenType kenType, TerraceInfo terraceInfo) {
        int n;
        float[][] fArray = new float[3][0];
        fArray[0] = new float[]{1230.0f, 1330.0f};
        fArray[1] = new float[]{1170.0f, 1170.0f};
        fArray[2] = new float[]{1230.0f, 1530.0f};
        float[][] fArray2 = new float[3][0];
        fArray2[0] = new float[]{1230.0f, 1530.0f};
        fArray2[1] = new float[]{1230.0f, 1305.0f};
        fArray2[2] = new float[]{1230.0f, 1530.0f};
        float f = 0.0f;
        int n2 = n = terraceInfo.mDepthType == TerraceDepthType.T5 ? 0 : 1;
        if (kenType == KenType.KANTOUMA) {
            if (terraceInfo.mWidthType == TerraceWidthType.T10) {
                f = fArray[0][n];
            } else if (terraceInfo.mWidthType == TerraceWidthType.T15) {
                f = fArray[1][n];
            } else if (terraceInfo.mWidthType == TerraceWidthType.T20) {
                f = fArray[2][n];
            }
        } else if (terraceInfo.mWidthType == TerraceWidthType.T10) {
            f = fArray2[0][n];
        } else if (terraceInfo.mWidthType == TerraceWidthType.T15) {
            f = fArray2[1][n];
        } else if (terraceInfo.mWidthType == TerraceWidthType.T20) {
            f = fArray2[2][n];
        }
        return f;
    }

    protected void create(float f, float f2, float f3, float f4, float f5, Parts parts, boolean bl) {
        Vector vector = parts.getChildren(true);
        Color color = SNYColor.getColor(this.mShapeColorManager.getColor(0));
        AbstractPHokyouHiuchi abstractPHokyouHiuchi = this.createFunction(bl);
        double d = f3 - f;
        double d2 = f4 - f2;
        float f6 = (float)Math.toDegrees(Math.atan2(d2, d));
        float f7 = (float)Math.sqrt(d * d + d2 * d2) + 34.0f;
        float f8 = (f + f3) / 2.0f;
        float f9 = (f2 + f4) / 2.0f;
        abstractPHokyouHiuchi.set(f8, f9, f5, f7, f6, color);
        vector.add(abstractPHokyouHiuchi);
    }

    protected AbstractPHokyouHiuchi createFunction(boolean bl) {
        if (bl) {
            return new PHokyouHiuchiBig();
        }
        return new PHokyouHiuchiSmall();
    }
}

