/*
 * Decompiled with CFR 0.152.
 */
package option.loneterrace.shape.sunnyge.model.sunnyge.creator;

import java.awt.Color;
import java.util.List;
import java.util.Vector;
import model.parts.Parts;
import option.loneterrace.common.entity.SNYEntities;
import option.loneterrace.common.entity.TerraceInfo;
import option.loneterrace.common.entity.TerracesInfo;
import option.loneterrace.common.service.common.SNYColor;
import option.loneterrace.common.type.BuildingType;
import option.loneterrace.common.type.EnforcementType;
import option.loneterrace.shape.sunnyge.model.sunnyge.creator.SNYTerraceUnitCreator;
import option.loneterrace.shape.sunnyge.model.sunnyge.item.AbstractTerraceUnitItem;
import option.loneterrace.shape.sunnyge.model.sunnyge.item.MsItemTerrace;
import option.loneterrace.shape.sunnyge.model.sunnyge.parts.PFence;

public class MsUnitFrontFenceCreator
extends SNYTerraceUnitCreator {
    @Override
    public void create(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        EnforcementType enforcementType = terracesInfo.mEnforcementType;
        if (terraceInfo.mBuildingType != BuildingType.CORNER && (enforcementType == EnforcementType.DESUMI || enforcementType == EnforcementType.IRISUMI)) {
            enforcementType = EnforcementType.STD;
        }
        if (enforcementType == EnforcementType.STD) {
            if (terracesInfo.mEnforcementType == EnforcementType.IRISUMI) {
                this.createStandardIrisumi(abstractTerraceUnitItem, parts);
            } else {
                this.createStandard(abstractTerraceUnitItem, parts);
            }
        } else if (enforcementType == EnforcementType.DESUMI) {
            this.createDesumi(abstractTerraceUnitItem, parts);
        } else if (enforcementType == EnforcementType.KUTAI_DEHABA_CHIGAI) {
            this.createStandard(abstractTerraceUnitItem, parts);
        } else if (enforcementType == EnforcementType.HANEDASHI) {
            this.createStandard(abstractTerraceUnitItem, parts);
        }
    }

    private void createStandard(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        Vector vector = parts.getChildren(true);
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        double d = 0.0;
        double d2 = -sNYEntities.mTerracesInfo.mDepth.floatValue();
        double d3 = sNYEntities.mPartsFigureInfo.mYukaHeight.floatValue();
        double d4 = terraceInfo.mWidth.floatValue() - 70.0f;
        this.createFence(d, d2, d3, d4, 0.0, vector);
    }

    private void createStandardIrisumi(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        Vector vector = parts.getChildren(true);
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        double d = 0.0;
        double d2 = -sNYEntities.mTerracesInfo.mDepth.floatValue();
        double d3 = sNYEntities.mPartsFigureInfo.mYukaHeight.floatValue();
        double d4 = terraceInfo.mWidth.floatValue() - 70.0f;
        if (abstractTerraceUnitItem.getPrev() != null && abstractTerraceUnitItem.getPrev().getTerraceInfo().mBuildingType == BuildingType.CORNER) {
            d -= 34.5;
            d4 += 139.0;
        }
        if (abstractTerraceUnitItem.getNext() != null && abstractTerraceUnitItem.getNext().getTerraceInfo().mBuildingType == BuildingType.CORNER) {
            d += 34.5;
            d4 += 139.0;
        }
        this.createFence(d, d2, d3, d4, 0.0, vector);
    }

    private void createDesumi(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        Vector vector = parts.getChildren(true);
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        double d = terraceInfo.mWidth.floatValue() / 2.0f - 48.75f;
        double d2 = -terraceInfo.mDepth.floatValue();
        double d3 = sNYEntities.mPartsFigureInfo.mYukaHeight.floatValue();
        double d4 = terraceInfo.mWidth.floatValue() + 97.5f - 70.0f;
        this.createFence(d, d2, d3, d4, 0.0, vector);
        d = terraceInfo.mWidth.floatValue();
        d2 = -terraceInfo.mDepth.floatValue() / 2.0f + 48.75f;
        this.createFence(d, d2, d3, d4, 90.0, vector);
    }

    private void createFence(double d, double d2, double d3, double d4, double d5, List<Parts> list) {
        Color color = SNYColor.getColor(this.mShapeColorManager.getColor(0));
        PFence pFence = new PFence();
        pFence.set(d, d2, d3, d4, d5, color);
        list.add(pFence);
    }
}

