/*
 * Decompiled with CFR 0.152.
 */
package option.loneterrace.shape.sunnyge.model.sunnyge.creator;

import java.awt.Color;
import java.util.List;
import java.util.Vector;
import model.parts.Parts;
import option.loneterrace.common.entity.BasicInfo;
import option.loneterrace.common.entity.SNYEntities;
import option.loneterrace.common.entity.TerraceInfo;
import option.loneterrace.common.entity.TerracesInfo;
import option.loneterrace.common.service.common.SNYColor;
import option.loneterrace.common.type.BuildingType;
import option.loneterrace.common.type.EnforcementDirType;
import option.loneterrace.common.type.EnforcementType;
import option.loneterrace.common.type.SNYColorType;
import option.loneterrace.common.type.SodePosType;
import option.loneterrace.common.type.SubProductType;
import option.loneterrace.shape.sunnyge.model.sunnyge.creator.SNYTerraceUnitCreator;
import option.loneterrace.shape.sunnyge.model.sunnyge.item.AbstractTerraceUnitItem;
import option.loneterrace.shape.sunnyge.model.sunnyge.item.MsItemTerrace;
import option.loneterrace.shape.sunnyge.model.sunnyge.parts.PBalcony;
import option.loneterrace.shape.sunnyge.model.sunnyge.parts.PBalconyMizuukezai;

public class MsUnitBalconyCreator
extends SNYTerraceUnitCreator {
    @Override
    public void create(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        if (sNYEntities.mBasicInfo.mFloorNum == null) {
            return;
        }
        if (sNYEntities.mBasicInfo.mFloorNum < 2) {
            return;
        }
        EnforcementType enforcementType = terracesInfo.mEnforcementType;
        if (terraceInfo.mBuildingType != BuildingType.CORNER && (enforcementType == EnforcementType.DESUMI || enforcementType == EnforcementType.IRISUMI)) {
            enforcementType = EnforcementType.STD;
        }
        if (enforcementType == EnforcementType.STD || enforcementType == EnforcementType.BUBUN_KAKOI) {
            this.createStandard(abstractTerraceUnitItem, parts);
        } else if (enforcementType == EnforcementType.DESUMI) {
            this.createDesumi(abstractTerraceUnitItem, parts);
        } else if (enforcementType == EnforcementType.IRISUMI) {
            this.createIrisumi(abstractTerraceUnitItem, parts);
        } else if (enforcementType == EnforcementType.KUTAI_DEHABA_CHIGAI) {
            this.createKutaiDehabaChigai(abstractTerraceUnitItem, parts);
        }
    }

    private void createStandard(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        Vector vector = parts.getChildren(true);
        double d = terraceInfo.mWidth.floatValue() / 2.0f;
        float f = msItemTerrace.getFloorlevel();
        float f2 = terraceInfo.mDepth.floatValue();
        double d2 = -d;
        double d3 = d;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = -f2;
        double d7 = this.calcWallZ1(sNYEntities, f);
        double d8 = f + sNYEntities.mPartsFigureInfo.mBottomHeight.floatValue() - 60.0f;
        double d9 = f + sNYEntities.mPartsFigureInfo.mBottomHeight.floatValue();
        double d10 = this.calcYukaZ(sNYEntities, f);
        double d11 = 0.0;
        double d12 = 0.0;
        double d13 = this.mPartsFigureService.calcTsukuritsukeYukaSlopeAngle(terracesInfo);
        boolean bl = this.isFirstSideKabe(sNYEntities, terraceInfo);
        boolean bl2 = this.isEndSideKabe(sNYEntities, terraceInfo);
        int n = 0;
        int n2 = 0;
        if (abstractTerraceUnitItem.getTerraceInfo().mIsLeftEnd.booleanValue()) {
            n = 1;
        }
        if (abstractTerraceUnitItem.getTerraceInfo().mIsRightEnd.booleanValue()) {
            n2 = 1;
        }
        if (!bl) {
            n = 0;
        }
        if (!bl2) {
            n2 = 0;
        }
        if (terracesInfo.mEnforcementType == EnforcementType.DESUMI) {
            if (this.mPartsFigureService.isPrevConner(abstractTerraceUnitItem)) {
                d2 -= 97.5;
                n = 0;
            }
            if (this.mPartsFigureService.isNextConner(abstractTerraceUnitItem)) {
                d3 += 97.5;
                n2 = 0;
            }
        } else if (terracesInfo.mEnforcementType == EnforcementType.IRISUMI) {
            if (this.mPartsFigureService.isPrevConner(abstractTerraceUnitItem)) {
                d2 -= 139.0;
                n = -1;
                d11 = -55.0;
            }
            if (this.mPartsFigureService.isNextConner(abstractTerraceUnitItem)) {
                d3 += 139.0;
                n2 = -1;
                d12 = 55.0;
            }
        }
        if (abstractTerraceUnitItem.getPrev() != null) {
            n = 99;
        }
        if (abstractTerraceUnitItem.getNext() != null) {
            n2 = 99;
        }
        d4 = d2;
        d5 = d3;
        this.createKabe(d4, d5, d6, d7, d8, n, n2, d13, 0.0, vector);
        this.createKasagi(d4, d5, d6, d8, n, n2, 0.0, vector);
        if (terraceInfo.mBuildingType != BuildingType.BALCONY) {
            double d14 = abstractTerraceUnitItem.getPrev() != null ? 0.0f : 35.0f;
            double d15 = abstractTerraceUnitItem.getNext() != null ? 0.0f : 35.0f;
            this.createMizuukezai(d4 + d14, d5 - d15, d6, d9, 0.0, vector);
        }
        d4 = d2 + d11;
        d5 = d3 + d12;
        this.createYuka(d4, 0.0, d7, d10, d5 - d4, f2, d13, 0.0, vector);
        if (bl && abstractTerraceUnitItem.getTerraceInfo().mIsLeftEnd.booleanValue()) {
            d5 = d4 + (double)f2;
            d6 = 0.0;
            this.createKabe(d4, d5, d6, d7, d8, 0, 1, 0.0, -90.0, vector);
            this.createKasagi(d4, d5, d6, d8, 0, 1, -90.0, vector);
            if (terraceInfo.mBuildingType != BuildingType.BALCONY) {
                this.createMizuukezai(d4, d5 - 35.0, d6 - 35.0, d9, -90.0, vector);
            }
        }
        if (bl2 && abstractTerraceUnitItem.getTerraceInfo().mIsRightEnd.booleanValue()) {
            d4 = d3;
            d5 = d4 + (double)f2;
            d6 = -f2;
            this.createKabe(d4, d5, d6, d7, d8, 1, 0, 0.0, 90.0, vector);
            this.createKasagi(d4, d5, d6, d8, 1, 0, 90.0, vector);
            if (terraceInfo.mBuildingType != BuildingType.BALCONY) {
                this.createMizuukezai(d4, d5 - 35.0, d6 + 35.0, d9, 90.0, vector);
            }
        }
    }

    private void createDesumi(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        Vector vector = parts.getChildren(true);
        float f = msItemTerrace.getFloorlevel();
        float f2 = terraceInfo.mDepth.floatValue();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = -f2;
        double d4 = this.calcWallZ1(sNYEntities, f);
        double d5 = f + sNYEntities.mPartsFigureInfo.mBottomHeight.floatValue() - 60.0f;
        double d6 = f + sNYEntities.mPartsFigureInfo.mBottomHeight.floatValue();
        double d7 = this.calcYukaZ(sNYEntities, f);
        double d8 = this.mPartsFigureService.calcTsukuritsukeYukaSlopeAngle(terracesInfo);
        d = 0.0;
        d2 = f2;
        this.createKabe(d, d2, d3, d4, d5, 99, 1, d8, 0.0, vector);
        this.createKasagi(d, d2, d3, d5, 99, 1, 0.0, vector);
        this.createMizuukezai(d, d2 - 35.0, d3, d6, 0.0, vector);
        d = f2;
        d2 = d + (double)f2;
        d3 = -f2;
        this.createKabe(d, d2, d3, d4, d5, 1, 99, 0.0, 90.0, vector);
        this.createKasagi(d, d2, d3, d5, 1, 99, 90.0, vector);
        this.createMizuukezai(d, d2, d3 + 35.0, d6, 90.0, vector);
        d = 0.0;
        d2 = f2 - 55.0f;
        this.createDesumiConnerYuka(d, 0.0, d4, d7, d2 - d, f2, d8, 0.0, vector);
    }

    private void createIrisumi(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        Vector vector = parts.getChildren(true);
        float f = msItemTerrace.getFloorlevel();
        float f2 = terraceInfo.mDepth.floatValue();
        double d = 0.0;
        double d2 = d + (double)f2;
        double d3 = f + sNYEntities.mPartsFigureInfo.mBottomHeight.floatValue() - 1100.0f - 60.0f;
        double d4 = this.mPartsFigureService.calcTsukuritsukeYukaSlopeAngle(terracesInfo);
        this.createIrisumiConnerYuka(d, 0.0, d3, d3 + 110.0, d2 - d - 55.0, f2, d4, 0.0, vector);
    }

    private void createKutaiDehabaChigai(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        Vector vector = parts.getChildren(true);
        double d = terraceInfo.mWidth.floatValue() / 2.0f;
        float f = msItemTerrace.getFloorlevel();
        float f2 = terraceInfo.mDepth.floatValue();
        double d2 = -d;
        double d3 = d;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = -f2;
        double d7 = this.calcWallZ1(sNYEntities, f);
        double d8 = f + sNYEntities.mPartsFigureInfo.mBottomHeight.floatValue() - 60.0f;
        double d9 = f + sNYEntities.mPartsFigureInfo.mBottomHeight.floatValue();
        double d10 = this.calcYukaZ(sNYEntities, f);
        double d11 = this.mPartsFigureService.calcTsukuritsukeYukaSlopeAngle(terracesInfo);
        boolean bl = this.isFirstSideKabe(sNYEntities, terraceInfo);
        boolean bl2 = this.isEndSideKabe(sNYEntities, terraceInfo);
        int n = 0;
        int n2 = 0;
        f2 = terracesInfo.mDepth.floatValue();
        double d12 = 0.0;
        double d13 = 0.0;
        double d14 = 0.0;
        double d15 = 0.0;
        double d16 = 0.0;
        if (terracesInfo.mEnforcementDirType == EnforcementDirType.R) {
            d13 = f2 - terraceInfo.mRightDepth.floatValue();
            d14 = d3 - d2 - (double)terraceInfo.mRightWidth.floatValue();
            d15 = terraceInfo.mWidth.floatValue() - terraceInfo.mRightWidth.floatValue();
            d16 = terraceInfo.mRightWidth.floatValue();
        } else {
            d12 = f2 - terraceInfo.mLeftDepth.floatValue();
            d14 = terraceInfo.mLeftWidth.floatValue();
            d15 = terraceInfo.mLeftWidth.floatValue();
            d16 = terraceInfo.mWidth.floatValue() - terraceInfo.mLeftWidth.floatValue();
        }
        if (abstractTerraceUnitItem.getTerraceInfo().mIsLeftEnd.booleanValue()) {
            n = 1;
        }
        if (abstractTerraceUnitItem.getTerraceInfo().mIsRightEnd.booleanValue()) {
            n2 = 1;
        }
        if (!bl) {
            n = 0;
        }
        if (!bl2) {
            n2 = 0;
        }
        if (abstractTerraceUnitItem.getPrev() != null) {
            n = 99;
        }
        if (abstractTerraceUnitItem.getNext() != null) {
            n2 = 99;
        }
        double d17 = abstractTerraceUnitItem.getPrev() != null ? 0.0f : 35.0f;
        double d18 = abstractTerraceUnitItem.getNext() != null ? 0.0f : 35.0f;
        if (terraceInfo.mIsMaster.booleanValue()) {
            d4 = d2;
            d5 = d3;
            this.createKabe(d4, d5, d6, d7, d8, n, n2, d11, 0.0, vector);
            this.createKasagi(d4, d5, d6, d8, n, n2, 0.0, vector);
            this.createMizuukezai(d4 + d17, d5 - d18, d6, d9, 0.0, vector);
            this.createYuka(d4, -d12, d7, d10, d15, (double)f2 - d12, d11, 0.0, vector);
            this.createYuka(d4 + d15, -d13, d7, d10, d16, (double)f2 - d13, d11, 0.0, vector);
        } else {
            d4 = d2;
            d5 = d3;
            d6 = -f2;
            d14 = d5 - d4;
            this.createKabe(d4, d5, d6, d7, d8, n, n2, d11, 0.0, vector);
            this.createKasagi(d4, d5, d6, d8, n, n2, 0.0, vector);
            this.createMizuukezai(d4 + d17, d5 - d18, d6, d9, 0.0, vector);
            d6 = f2 - terraceInfo.mDepth.floatValue();
            this.createYuka(d4, -d6, d7, d10, d14, terraceInfo.mDepth.floatValue(), d11, 0.0, vector);
        }
        if (bl && abstractTerraceUnitItem.getTerraceInfo().mIsLeftEnd.booleanValue()) {
            d4 = d2;
            d5 = d4 + ((double)f2 - d12);
            d6 = -d12;
            this.createKabe(d4, d5, d6, d7, d8, 0, 1, 0.0, -90.0, vector);
            this.createKasagi(d4, d5, d6, d8, 0, 1, -90.0, vector);
            this.createMizuukezai(d4, d5 - 35.0, d6 - 35.0, d9, -90.0, vector);
        }
        if (bl2 && abstractTerraceUnitItem.getTerraceInfo().mIsRightEnd.booleanValue()) {
            d4 = d3;
            d5 = d4 + ((double)f2 - d13);
            d6 = -f2;
            this.createKabe(d4, d5, d6, d7, d8, 1, 0, 0.0, 90.0, vector);
            this.createKasagi(d4, d5, d6, d8, 1, 0, 90.0, vector);
            this.createMizuukezai(d4, d5 - 35.0, d6 + 35.0, d9, 90.0, vector);
        }
    }

    protected boolean isFirstSideKabe(SNYEntities sNYEntities, TerraceInfo terraceInfo) {
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        return sNYEntities.mTerraceInfoList.getFirst().mId != terraceInfo.mId || terracesInfo.mSodePosType != SodePosType.L && terracesInfo.mSodePosType != SodePosType.BOTH;
    }

    protected boolean isEndSideKabe(SNYEntities sNYEntities, TerraceInfo terraceInfo) {
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        return sNYEntities.mTerraceInfoList.getLast().mId != terraceInfo.mId || terracesInfo.mSodePosType != SodePosType.R && terracesInfo.mSodePosType != SodePosType.BOTH;
    }

    private double calcWallZ1(SNYEntities sNYEntities, float f) {
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        double d = 0.0;
        if (basicInfo.mSubProductType == SubProductType.TSUKURITSUKE && terracesInfo.mEnforcementType == EnforcementType.BUBUN_KAKOI) {
            double d2 = this.mPartsFigureService.calcTsukuritsukeYukaSlopeAngle(terracesInfo);
            double d3 = (double)terracesInfo.mDepth.floatValue() * Math.tan(d2);
            d = (double)f - d3 - 45.0;
        } else {
            d = f + sNYEntities.mPartsFigureInfo.mBottomHeight.floatValue() - 1100.0f - 60.0f;
        }
        return d;
    }

    private double calcYukaZ(SNYEntities sNYEntities, float f) {
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        double d = 0.0;
        d = basicInfo.mSubProductType == SubProductType.TSUKURITSUKE && terracesInfo.mEnforcementType == EnforcementType.BUBUN_KAKOI ? (double)f : (double)(f + sNYEntities.mPartsFigureInfo.mBottomHeight.floatValue() - 1100.0f - 60.0f + 110.0f);
        return d;
    }

    private void createKabe(double d, double d2, double d3, double d4, double d5, int n, int n2, double d6, double d7, List<Parts> list) {
        Color color = SNYColor.getColor(SNYColorType.IVORY_WHITE);
        PBalcony pBalcony = new PBalcony();
        pBalcony.set(d, d2, d3, d4, d5, n, n2, d6, d7, color);
        list.add(pBalcony);
    }

    private void createKasagi(double d, double d2, double d3, double d4, int n, int n2, double d5, List<Parts> list) {
        Color color = SNYColor.getColor(SNYColorType.BRONZ_B);
        PBalcony pBalcony = new PBalcony();
        pBalcony.setKasagi(d, d2, d3, d4, n, n2, d5, color);
        list.add(pBalcony);
    }

    private void createYuka(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, List<Parts> list) {
        Color color = SNYColor.getColor(SNYColorType.IVORY_WHITE);
        PBalcony pBalcony = new PBalcony();
        pBalcony.setYuka(d, d2, d3, d4, d5, d6, d7, d8, color);
        list.add(pBalcony);
    }

    private void createDesumiConnerYuka(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, List<Parts> list) {
        Color color = SNYColor.getColor(SNYColorType.IVORY_WHITE);
        PBalcony pBalcony = new PBalcony();
        pBalcony.setConnerYuka(d, d2, d3, d4, 1, d5, d6, d7, d8, color);
        list.add(pBalcony);
    }

    private void createIrisumiConnerYuka(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, List<Parts> list) {
        Color color = SNYColor.getColor(SNYColorType.IVORY_WHITE);
        PBalcony pBalcony = new PBalcony();
        pBalcony.setConnerYuka(d, d2, d3, d4, -1, d5, d6, d7, d8, color);
        list.add(pBalcony);
    }

    private void createMizuukezai(double d, double d2, double d3, double d4, double d5, List<Parts> list) {
        Color color = SNYColor.getColor(this.mShapeColorManager.getColor(0));
        PBalconyMizuukezai pBalconyMizuukezai = new PBalconyMizuukezai();
        pBalconyMizuukezai.set(d, d2, d3, d4, d5, color);
        list.add(pBalconyMizuukezai);
    }
}

