/*
 * Decompiled with CFR 0.152.
 */
package option.loneterrace.shape.sunnyge.model.sunnyge.creator;

import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import model.parts.Parts;
import nethome.geom.primitive.GPoint2Df;
import option.loneterrace.common.entity.FrontPanelInfo;
import option.loneterrace.common.entity.SNYEntities;
import option.loneterrace.common.entity.SidePanelInfo;
import option.loneterrace.common.entity.TerraceInfo;
import option.loneterrace.common.entity.TerracesInfo;
import option.loneterrace.common.service.common.SNYColor;
import option.loneterrace.common.type.BuildingType;
import option.loneterrace.common.type.EnforcementType;
import option.loneterrace.common.type.OpeningPanelType;
import option.loneterrace.common.type.SubProductType;
import option.loneterrace.common.type.TerraceDepthType;
import option.loneterrace.shape.sunnyge.model.sunnyge.creator.SNYTerraceUnitCreator;
import option.loneterrace.shape.sunnyge.model.sunnyge.item.AbstractTerraceUnitItem;
import option.loneterrace.shape.sunnyge.model.sunnyge.item.MsItemTerrace;
import option.loneterrace.shape.sunnyge.model.sunnyge.parts.PAlumiTesuri;

public class MsUnitAlumiTesuriCreator
extends SNYTerraceUnitCreator {
    @Override
    public void create(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        EnforcementType enforcementType = terracesInfo.mEnforcementType;
        if (terraceInfo.mBuildingType != BuildingType.CORNER && (enforcementType == EnforcementType.DESUMI || enforcementType == EnforcementType.IRISUMI)) {
            enforcementType = EnforcementType.STD;
        }
        if (enforcementType == EnforcementType.STD) {
            this.createStandard(abstractTerraceUnitItem, parts);
        }
    }

    private void createStandard(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        GPoint2Df gPoint2Df;
        GPoint2Df gPoint2Df2;
        Vector vector = parts.getChildren(true);
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerracesInfo cfr_ignored_0 = sNYEntities.mTerracesInfo;
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        double d = msItemTerrace.getFloorlevel();
        double d2 = 0.0;
        double d3 = -sNYEntities.mTerracesInfo.mDepth.floatValue();
        double d4 = d + (double)sNYEntities.mPartsFigureInfo.mYukaLevelHeight.floatValue();
        double d5 = terraceInfo.mWidth.floatValue() - 20.0f;
        ArrayList<GPoint2Df> arrayList = this.getMakeFrontTesuriPosition(sNYEntities, terraceInfo);
        int n = 0;
        while (n < arrayList.size()) {
            GPoint2Df gPoint2Df3 = arrayList.get(n);
            gPoint2Df2 = arrayList.get(n + 1);
            d5 = gPoint2Df2.getX() - gPoint2Df3.getX();
            d2 = (double)(-terraceInfo.mWidth.floatValue() / 2.0f) + (gPoint2Df3.getX() + gPoint2Df2.getX()) / 2.0;
            this.createTesuri(d2, d3, d4, d5, 0, 0, 0.0, vector);
            n += 2;
        }
        if (this.mPartsFigureService.isLeftCreateOK(abstractTerraceUnitItem)) {
            ArrayList<GPoint2Df> arrayList2 = this.getMakeLeftTesuriPosition(sNYEntities, terraceInfo);
            int n2 = 0;
            while (n2 < arrayList2.size()) {
                gPoint2Df2 = arrayList2.get(n2);
                gPoint2Df = arrayList2.get(n2 + 1);
                d5 = gPoint2Df.getX() - gPoint2Df2.getX();
                d2 = -terraceInfo.mWidth.floatValue() / 2.0f;
                d3 = (double)(-terraceInfo.mDepth.floatValue()) + (gPoint2Df2.getX() + gPoint2Df.getX()) / 2.0 - 20.0;
                this.createTesuri(d2, d3, d4, d5, 0, 1, -90.0, vector);
                n2 += 2;
            }
        }
        if (this.mPartsFigureService.isRightCreateOK(abstractTerraceUnitItem)) {
            ArrayList<GPoint2Df> arrayList3 = this.getMakeRightTesuriPosition(sNYEntities, terraceInfo);
            int n3 = 0;
            while (n3 < arrayList3.size()) {
                gPoint2Df2 = arrayList3.get(n3);
                gPoint2Df = arrayList3.get(n3 + 1);
                d5 = gPoint2Df.getX() - gPoint2Df2.getX();
                d2 = terraceInfo.mWidth.floatValue() / 2.0f;
                d3 = (double)(-terraceInfo.mDepth.floatValue()) + (gPoint2Df2.getX() + gPoint2Df.getX()) / 2.0 - 20.0;
                this.createTesuri(d2, d3, d4, d5, 1, 0, 90.0, vector);
                n3 += 2;
            }
        }
    }

    private ArrayList<GPoint2Df> getMakeFrontTesuriPosition(SNYEntities sNYEntities, TerraceInfo terraceInfo) {
        LinkedList<FrontPanelInfo> linkedList = sNYEntities.mFrontPanelInfoList;
        ArrayList<GPoint2Df> arrayList = new ArrayList<GPoint2Df>();
        if (sNYEntities.mBasicInfo.mSubProductType == SubProductType.ALMI_BALCONY_PILLAR || sNYEntities.mBasicInfo.mSubProductType == SubProductType.ALMI_BALCONY_ROOF) {
            int n;
            int n2 = Math.round(terraceInfo.mWidth.floatValue() / sNYEntities.mBasicInfo.mKenLen.floatValue() / 0.5f);
            int[] nArray = new int[n2];
            int n3 = 0;
            while (n3 < n2) {
                nArray[n3] = 1;
                ++n3;
            }
            for (FrontPanelInfo frontPanelInfo : linkedList) {
                if (frontPanelInfo.mTerraceId != terraceInfo.mId || frontPanelInfo.mPanelType != OpeningPanelType.FIX && frontPanelInfo.mPanelType != OpeningPanelType.TAKAMADO && frontPanelInfo.mPanelType != OpeningPanelType.TATESUBERI) continue;
                n = frontPanelInfo.mIndex;
                int n4 = frontPanelInfo.mIndex + frontPanelInfo.mSpan;
                int n5 = n;
                while (n5 < n4) {
                    nArray[n5] = 0;
                    ++n5;
                }
            }
            int n6 = 0;
            while (n6 < n2) {
                if (nArray[n6] == 1) {
                    int n7 = 1;
                    n = n6 + 1;
                    while (n < n2) {
                        if (nArray[n] == 0) break;
                        ++n7;
                        ++n;
                    }
                    float f = (float)n6 * sNYEntities.mBasicInfo.mKenLen.floatValue() * 0.5f;
                    float f2 = f + (float)n7 * sNYEntities.mBasicInfo.mKenLen.floatValue() * 0.5f;
                    arrayList.add(new GPoint2Df(f, 0.0f));
                    arrayList.add(new GPoint2Df(f2, 0.0f));
                    n6 = n6 + n7 - 1;
                }
                ++n6;
            }
        }
        return arrayList;
    }

    private ArrayList<GPoint2Df> getMakeLeftTesuriPosition(SNYEntities sNYEntities, TerraceInfo terraceInfo) {
        LinkedList<SidePanelInfo> linkedList = sNYEntities.mLeftPanelInfoList;
        ArrayList<GPoint2Df> arrayList = new ArrayList<GPoint2Df>();
        float f = this.getSideSplitModule(terraceInfo.mDepthType);
        if (sNYEntities.mBasicInfo.mSubProductType == SubProductType.ALMI_BALCONY_PILLAR || sNYEntities.mBasicInfo.mSubProductType == SubProductType.ALMI_BALCONY_ROOF) {
            int n;
            int n2 = Math.round(terraceInfo.mDepth.floatValue() / f);
            int[] nArray = new int[n2];
            int n3 = 0;
            while (n3 < n2) {
                nArray[n3] = 1;
                ++n3;
            }
            for (SidePanelInfo sidePanelInfo : linkedList) {
                if (sidePanelInfo.mTerraceId != terraceInfo.mId || sidePanelInfo.mPanelType != OpeningPanelType.FIX && sidePanelInfo.mPanelType != OpeningPanelType.LOUVER && sidePanelInfo.mPanelType != OpeningPanelType.TAKAMADO && sidePanelInfo.mPanelType != OpeningPanelType.TATESUBERI) continue;
                n = sidePanelInfo.mIndex;
                int n4 = sidePanelInfo.mIndex + sidePanelInfo.mSpan;
                int n5 = n;
                while (n5 < n4) {
                    nArray[n5] = 0;
                    ++n5;
                }
            }
            int n6 = 0;
            while (n6 < n2) {
                if (nArray[n6] == 1) {
                    int n7 = 1;
                    n = n6 + 1;
                    while (n < n2) {
                        if (nArray[n] == 0) break;
                        ++n7;
                        ++n;
                    }
                    float f2 = (float)n6 * f;
                    float f3 = f2 + (float)n7 * f;
                    arrayList.add(new GPoint2Df(f2, 0.0f));
                    arrayList.add(new GPoint2Df(f3, 0.0f));
                    n6 = n6 + n7 - 1;
                }
                ++n6;
            }
        }
        return arrayList;
    }

    private ArrayList<GPoint2Df> getMakeRightTesuriPosition(SNYEntities sNYEntities, TerraceInfo terraceInfo) {
        LinkedList<SidePanelInfo> linkedList = sNYEntities.mRightPanelInfoList;
        ArrayList<GPoint2Df> arrayList = new ArrayList<GPoint2Df>();
        float f = this.getSideSplitModule(terraceInfo.mDepthType);
        if (sNYEntities.mBasicInfo.mSubProductType == SubProductType.ALMI_BALCONY_PILLAR || sNYEntities.mBasicInfo.mSubProductType == SubProductType.ALMI_BALCONY_ROOF) {
            int n;
            int n2 = Math.round(terraceInfo.mDepth.floatValue() / f);
            int[] nArray = new int[n2];
            int n3 = 0;
            while (n3 < n2) {
                nArray[n3] = 1;
                ++n3;
            }
            for (SidePanelInfo sidePanelInfo : linkedList) {
                if (sidePanelInfo.mTerraceId != terraceInfo.mId || sidePanelInfo.mPanelType != OpeningPanelType.FIX && sidePanelInfo.mPanelType != OpeningPanelType.LOUVER && sidePanelInfo.mPanelType != OpeningPanelType.TAKAMADO && sidePanelInfo.mPanelType != OpeningPanelType.TATESUBERI) continue;
                n = sidePanelInfo.mIndex;
                int n4 = sidePanelInfo.mIndex + sidePanelInfo.mSpan;
                int n5 = n;
                while (n5 < n4) {
                    nArray[n5] = 0;
                    ++n5;
                }
            }
            int n6 = 0;
            while (n6 < n2) {
                if (nArray[n6] == 1) {
                    int n7 = 1;
                    n = n6 + 1;
                    while (n < n2) {
                        if (nArray[n] == 0) break;
                        ++n7;
                        ++n;
                    }
                    float f2 = (float)n6 * f;
                    float f3 = f2 + (float)n7 * f;
                    arrayList.add(new GPoint2Df(f2, 0.0f));
                    arrayList.add(new GPoint2Df(f3, 0.0f));
                    n6 = n6 + n7 - 1;
                }
                ++n6;
            }
        }
        return arrayList;
    }

    private float getSideSplitModule(TerraceDepthType terraceDepthType) {
        float f = 0.0f;
        if (terraceDepthType == TerraceDepthType.T3) {
            f = 295.0f;
        } else if (terraceDepthType == TerraceDepthType.T4) {
            f = 296.0f;
        } else if (terraceDepthType == TerraceDepthType.T5) {
            f = 297.0f;
        } else if (terraceDepthType == TerraceDepthType.T6) {
            f = 297.0f;
        } else if (terraceDepthType == TerraceDepthType.T7) {
            f = 297.0f;
        } else if (terraceDepthType == TerraceDepthType.T8) {
            f = 298.0f;
        } else if (terraceDepthType == TerraceDepthType.T9) {
            f = 298.0f;
        }
        return f;
    }

    private void createTesuri(double d, double d2, double d3, double d4, int n, int n2, double d5, List<Parts> list) {
        Color color = SNYColor.getColor(this.mShapeColorManager.getColor(0));
        PAlumiTesuri pAlumiTesuri = new PAlumiTesuri();
        pAlumiTesuri.set(d, d2, d3, d4, n, n2, d5, color);
        list.add(pAlumiTesuri);
    }
}

