/*
 * Decompiled with CFR 0.152.
 */
package option.loneterrace.shape.sunnyge.model.option.parts;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import model.parts.Parts;
import model.primitive.SBox;
import model.primitive.SImagePlane;
import model.shape.primitive.SMatrix4d;
import option.loneterrace.shape.common.util.SNYBoxFactory;

public class Kankisen
extends Parts {
    public static final float WIDTH = 230.0f;
    public static final float HEIGHT = 230.0f;
    private static final float KANKIBOX_BODY_W = 168.0f;
    private static final float KANKIBOX_BODY_H = 168.0f;
    private static final float KANKIBOX_BODY_D = 90.0f;
    private static final float KANKIBOX_FRAME_W = 230.0f;
    private static final float KANKIBOX_FRAME_H = 230.0f;
    private static final float KANKIBOX_FRAME_D = 10.0f;
    private static final float GRILL_H = 230.0f;
    private static final float GRILL_W = 230.0f;
    private static final float GRILL_D = 45.0f;
    private static final float GRILL_SIDE_W = 18.75f;
    private static final float SPENCER_H = 266.8f;
    private static final float SPENCER_W = 240.0f;
    private static final float SPENCER_D = 3.0f;
    private static Image image;

    public void set(float f, float f2, float f3, float f4, Color color) {
        this.mat = new SMatrix4d();
        this.mat.move((double)f, (double)f2, (double)f3);
        temp1 = new SMatrix4d();
        temp1.rotXY(Math.toRadians(f4));
        this.mat.multi(temp1);
        this.createPrimitives();
        this.createKankisenBox(color);
        this.createGrill(color);
        this.createSpencer(color);
        this.createWetherCover(color);
    }

    private void createKankisenBox(Color color) {
        double[][] dArrayArray = new double[][]{{-84.0, 0.0, -84.0}, {84.0, 0.0, -84.0}, {84.0, 0.0, 84.0}, {-84.0, 0.0, 84.0}};
        SBox sBox = SNYBoxFactory.getPlainBox();
        sBox.draw3d = true;
        sBox.fillColor = color;
        sBox.points = dArrayArray;
        sBox.dir = new double[]{0.0, -90.0, 0.0};
        this.primitives.add(sBox);
        double[][] dArrayArray2 = new double[][]{{115.0, 0.0, -115.0}, {-115.0, 0.0, -115.0}, {-115.0, 0.0, 115.0}, {115.0, 0.0, 115.0}};
        SBox sBox2 = SNYBoxFactory.getPlainBox();
        sBox2.draw3d = true;
        sBox2.fillColor = color;
        sBox2.points = dArrayArray2;
        sBox2.dir = new double[]{0.0, 10.0, 0.0};
        this.primitives.add(sBox2);
    }

    private void createGrill(Color color) {
        this.createGrillSide(-105.625f, color);
        this.createGrillSide(105.625f, color);
        this.createGrillFrontFace(color);
        this.createGrillUpperFace(color);
        this.createGrillLowerFace(color);
    }

    private void createGrillSide(float f, Color color) {
        double d = 18.75;
        SBox sBox = SNYBoxFactory.getPlainBox();
        sBox.draw3d = true;
        sBox.fillColor = color;
        double[][] dArrayArray = new double[][]{{(double)f + d / 2.0, 0.0, -115.0}, {(double)f - d / 2.0, 0.0, -115.0}, {(double)f - d / 2.0, 0.0, 115.0}, {(double)f + d / 2.0, 0.0, 115.0}};
        sBox.points = dArrayArray;
        sBox.dir = new double[]{0.0, 45.0, 0.0};
        this.primitives.add(sBox);
    }

    private void createGrillFrontFace(Color color) {
        double d = -96.25;
        double d2 = 96.25;
        SImagePlane sImagePlane = new SImagePlane();
        sImagePlane.group_id_object = 3;
        sImagePlane.drawBothSide = true;
        sImagePlane.edgeColor = Color.BLACK;
        sImagePlane.fillColor = new Color(255, 255, 255, 0);
        double[][] dArrayArray = new double[][]{{d2, 45.0, -115.0}, {d, 45.0, -115.0}, {d, 45.0, 115.0}, {d2, 45.0, 115.0}};
        sImagePlane.points = dArrayArray;
        sImagePlane.o = new double[]{0.0, 230.0, 230.0};
        sImagePlane.u = new double[]{230.0, 230.0, 230.0};
        double d3 = 230.0;
        sImagePlane.object = Kankisen.getImage(color);
        sImagePlane.dpu = 1.0 / Math.abs(d3);
        sImagePlane.dpv = 1.0 / Math.abs(d3);
        sImagePlane.drawEdge = true;
        this.primitives.add(sImagePlane);
    }

    private void createGrillUpperFace(Color color) {
        double d = -96.25;
        double d2 = 96.25;
        SImagePlane sImagePlane = new SImagePlane();
        sImagePlane.group_id_object = 3;
        sImagePlane.drawBothSide = true;
        sImagePlane.edgeColor = Color.BLACK;
        sImagePlane.fillColor = new Color(255, 255, 255, 0);
        double[][] dArrayArray = new double[][]{{d, 10.0, 115.0}, {d2, 10.0, 115.0}, {d2, 45.0, 115.0}, {d, 45.0, 115.0}};
        sImagePlane.points = dArrayArray;
        sImagePlane.o = new double[]{0.0, 45.0, 0.0};
        sImagePlane.u = new double[]{230.0, 45.0, 0.0};
        double d3 = 230.0;
        sImagePlane.object = Kankisen.getImage(color);
        sImagePlane.dpu = 1.0 / Math.abs(d3);
        sImagePlane.dpv = 1.0 / Math.abs(d3);
        sImagePlane.drawEdge = true;
        this.primitives.add(sImagePlane);
    }

    private void createGrillLowerFace(Color color) {
        double d = -96.25;
        double d2 = 96.25;
        SImagePlane sImagePlane = new SImagePlane();
        sImagePlane.group_id_object = 3;
        sImagePlane.drawBothSide = true;
        sImagePlane.edgeColor = Color.BLACK;
        sImagePlane.fillColor = new Color(255, 255, 255, 0);
        double[][] dArrayArray = new double[][]{{d2, 10.0, -115.0}, {d, 10.0, -115.0}, {d, 45.0, -115.0}, {d2, 45.0, -115.0}};
        sImagePlane.points = dArrayArray;
        sImagePlane.o = new double[]{0.0, 45.0, 0.0};
        sImagePlane.u = new double[]{230.0, 45.0, 0.0};
        double d3 = 230.0;
        sImagePlane.object = Kankisen.getImage(color);
        sImagePlane.dpu = 1.0 / Math.abs(d3);
        sImagePlane.dpv = 1.0 / Math.abs(d3);
        sImagePlane.drawEdge = true;
        this.primitives.add(sImagePlane);
    }

    private void createSpencer(Color color) {
        double[][] dArrayArray = new double[][]{{-120.0, 0.0, -133.4f}, {120.0, 0.0, -133.4f}, {120.0, 0.0, 133.4f}, {-120.0, 0.0, 133.4f}};
        SBox sBox = SNYBoxFactory.getPlainBox();
        sBox.draw3d = true;
        sBox.fillColor = color;
        sBox.points = dArrayArray;
        sBox.dir = new double[]{0.0, -3.0, 0.0};
        this.primitives.add(sBox);
    }

    private void createWetherCover(Color color) {
        double[][] dArrayArray = new double[][]{{0.0, 0.0, -115.0}, {0.0, -6.0, -115.0}, {0.0, -176.0, -65.26}, {0.0, -165.0, 0.0}, {0.0, -147.32, 47.2}, {0.0, -107.0, 84.35}, {0.0, -63.6, 100.37}, {0.0, -6.0, 115.0}, {0.0, 0.0, 115.0}};
        double[][] dArray = new double[9][3];
        double[][] dArray2 = new double[9][3];
        int n = 0;
        while (n < dArrayArray.length) {
            dArray[n][0] = -103.0;
            dArray[n][1] = dArrayArray[n][1];
            dArray[n][2] = dArrayArray[n][2];
            dArray2[n][0] = 107.0;
            dArray2[n][1] = dArrayArray[n][1];
            dArray2[n][2] = dArrayArray[n][2];
            ++n;
        }
        SBox sBox = SNYBoxFactory.getPlainBox();
        sBox.draw3d = true;
        sBox.fillColor = color;
        sBox.points = dArray;
        sBox.dir = new double[]{-2.0, 0.0, 0.0};
        this.primitives.add(sBox);
        SBox sBox2 = SNYBoxFactory.getPlainBox();
        sBox2.draw3d = true;
        sBox2.fillColor = color;
        sBox2.points = dArray2;
        sBox2.dir = new double[]{-2.0, 0.0, 0.0};
        this.primitives.add(sBox2);
        int n2 = 2;
        while (n2 < dArrayArray.length - 1) {
            double[][] dArray3 = new double[4][3];
            dArray3[0][0] = -105.0;
            dArray3[0][1] = dArrayArray[n2][1];
            dArray3[0][2] = dArrayArray[n2][2];
            dArray3[1][0] = 105.0;
            dArray3[1][1] = dArrayArray[n2][1];
            dArray3[1][2] = dArrayArray[n2][2];
            dArray3[2][0] = 105.0;
            dArray3[2][1] = dArrayArray[n2 + 1][1];
            dArray3[2][2] = dArrayArray[n2 + 1][2];
            dArray3[3][0] = -105.0;
            dArray3[3][1] = dArrayArray[n2 + 1][1];
            dArray3[3][2] = dArrayArray[n2 + 1][2];
            SBox sBox3 = SNYBoxFactory.getPlainBox();
            sBox3.draw3d = true;
            sBox3.fillColor = color;
            sBox3.points = dArray3;
            sBox3.dir = new double[]{0.0, 0.0, 0.0};
            this.primitives.add(sBox3);
            ++n2;
        }
    }

    public static Image getImage(Color color) {
        if (image != null) {
            image.flush();
            image = null;
        }
        if (image == null) {
            int n = 256;
            int n2 = 256;
            BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int n3 = 0;
            while (n3 < n) {
                int n4 = n3 % 8;
                if (n4 == 4 || n4 == 5 || n4 == 6) {
                    graphics2D.setColor(new Color(color.getRGB()));
                } else {
                    graphics2D.setColor(new Color(0, 0, 0, 255));
                }
                graphics2D.drawLine(n3, 0, n3, n2);
                ++n3;
            }
            graphics2D.setColor(new Color(color.getRGB()));
            n3 = 80;
            while (n3 < 85) {
                graphics2D.drawLine(0, n3, n, n3);
                ++n3;
            }
            graphics2D.dispose();
            image = bufferedImage;
        }
        return image;
    }
}

