/*
 * Decompiled with CFR 0.152.
 */
package option.loneterrace.shape.sunnyge.model.option.creator;

import java.awt.Color;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import model.parts.Parts;
import option.loneterrace.common.entity.FloorInfo;
import option.loneterrace.common.entity.SNYEntities;
import option.loneterrace.common.entity.TerraceInfo;
import option.loneterrace.common.entity.TerracesInfo;
import option.loneterrace.common.entity.paneloption.PanelOptionInfo;
import option.loneterrace.common.entity.paneloption.SideFenceInfo;
import option.loneterrace.common.service.common.SNYColor;
import option.loneterrace.common.type.SideFenceType;
import option.loneterrace.common.type.SubProductType;
import option.loneterrace.common.type.paneloption.PanelOptionType;
import option.loneterrace.shape.sunnyge.model.option.creator.AbstractMsOptionCreator;
import option.loneterrace.shape.sunnyge.model.option.item.MsItemGeneral;
import option.loneterrace.shape.sunnyge.model.option.parts.SideFenceDoorParts;
import option.loneterrace.shape.sunnyge.model.option.parts.SideFenceNotDoorParts;
import option.loneterrace.shape.sunnyge.model.option.parts.SideFenceParts;
import option.loneterrace.shape.sunnyge.model.option.parts.SideFencePlusDoorParts;
import option.loneterrace.shape.sunnyge.model.option.parts.SidePanelOptionParts;
import option.loneterrace.shape.sunnyge.model.sunnyge.item.AbstractTerraceUnitItem;
import option.loneterrace.shape.sunnyge.model.sunnyge.item.MsItemTerrace;
import option.loneterrace.shape.sunnyge.model.sunnyge.parts.PKutaiTateWaku;

public class MsSideFencePartsCreator
extends AbstractMsOptionCreator<MsItemGeneral> {
    @Override
    protected PanelOptionType configPanelOptionType() {
        return PanelOptionType.SIDE_FENCE;
    }

    @Override
    protected Class<?> configPanelOptionInfoClass() {
        return SideFenceInfo.class;
    }

    @Override
    public void create(MsItemGeneral msItemGeneral, AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        FloorInfo floorInfo = sNYEntities.mFloorInfo;
        float f = msItemTerrace.getFloorlevel();
        float f2 = terracesInfo.mHeight.floatValue() - floorInfo.mFloorLevel.floatValue();
        Vector vector = parts.getChildren(true);
        if (abstractTerraceUnitItem.getPrev() == null) {
            this.createLeft(abstractTerraceUnitItem, vector, f, f2);
        }
        if (abstractTerraceUnitItem.getNext() == null) {
            this.createRight(abstractTerraceUnitItem, vector, f, f2);
        }
    }

    private void createLeft(AbstractTerraceUnitItem abstractTerraceUnitItem, List<Parts> list, float f, float f2) {
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerracesInfo cfr_ignored_0 = sNYEntities.mTerracesInfo;
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        LinkedList<PanelOptionInfo> linkedList = sNYEntities.mLeftPanelOptionInfoList;
        float f3 = -terraceInfo.mWidth.floatValue() / 2.0f;
        float f4 = -terraceInfo.mDepth.floatValue() + 35.0f;
        float f5 = this.calcY2(sNYEntities);
        SideFenceInfo sideFenceInfo = (SideFenceInfo)this.mSidePanelOptionShapeService.findSidePanelOptionInfo(linkedList, this.configPanelOptionInfoClass(), this.configPanelOptionType(), 0);
        if (sideFenceInfo == null) {
            return;
        }
        float f6 = this.mPanelOptionShapeService.calcHeight(this.configPanelOptionType(), sNYEntities, terraceInfo);
        float f7 = this.mPanelOptionShapeService.calcBaseHeight(this.configPanelOptionType(), sNYEntities, terraceInfo) - sNYEntities.mFloorInfo.mFloorLevel.floatValue();
        float f8 = this.mSidePanelOptionShapeService.getLeftPanelOffset(msItemTerrace, terraceInfo, this.configPanelOptionType());
        Color color = SNYColor.getColor(sideFenceInfo.mColorType);
        Color color2 = SNYColor.getColor(sNYEntities.mBasicInfo.mBodyColorType);
        SidePanelOptionParts<SideFenceInfo> sidePanelOptionParts = this.createSideFenceParts(sideFenceInfo);
        if (sidePanelOptionParts != null) {
            sidePanelOptionParts.set(f3 + f8, f4, f5, f7, f7 + f6, 90, sNYEntities.mFloorInfo.mFloorLevel.floatValue(), color2, color, sideFenceInfo);
            list.add(sidePanelOptionParts);
            this.createKutaiTateWaku(f3 + f8, 0.0f, f7, 1030.0f, color2, list);
        }
    }

    private void createRight(AbstractTerraceUnitItem abstractTerraceUnitItem, List<Parts> list, float f, float f2) {
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        LinkedList<PanelOptionInfo> linkedList = sNYEntities.mRightPanelOptionInfoList;
        float f3 = terraceInfo.mWidth.floatValue() / 2.0f;
        float f4 = -terracesInfo.mDepth.floatValue() + 35.0f;
        float f5 = this.calcY2(sNYEntities);
        SideFenceInfo sideFenceInfo = (SideFenceInfo)this.mSidePanelOptionShapeService.findSidePanelOptionInfo(linkedList, this.configPanelOptionInfoClass(), this.configPanelOptionType(), 0);
        if (sideFenceInfo == null) {
            return;
        }
        float f6 = this.mPanelOptionShapeService.calcHeight(this.configPanelOptionType(), sNYEntities, terraceInfo);
        float f7 = this.mPanelOptionShapeService.calcBaseHeight(this.configPanelOptionType(), sNYEntities, terraceInfo) - sNYEntities.mFloorInfo.mFloorLevel.floatValue();
        float f8 = this.mSidePanelOptionShapeService.getRightPanelOffset(msItemTerrace, terraceInfo, this.configPanelOptionType());
        Color color = SNYColor.getColor(sideFenceInfo.mColorType);
        Color color2 = SNYColor.getColor(sNYEntities.mBasicInfo.mBodyColorType);
        SidePanelOptionParts<SideFenceInfo> sidePanelOptionParts = this.createSideFenceParts(sideFenceInfo);
        if (sidePanelOptionParts != null) {
            sidePanelOptionParts.set(f3 + f8, f5, f4, f7, f7 + f6, -90, sNYEntities.mFloorInfo.mFloorLevel.floatValue(), color2, color, sideFenceInfo);
            list.add(sidePanelOptionParts);
            this.createKutaiTateWaku(f3 + f8, 0.0f, f7, 1030.0f, color2, list);
        }
    }

    private float calcY2(SNYEntities sNYEntities) {
        float f = -35.0f;
        if (sNYEntities.mBasicInfo.mSubProductType == SubProductType.HALF_KAKOI) {
            f = -sNYEntities.mPartsFigureInfo.mKutaiUniversalPillarDepth1.floatValue() - 35.0f;
        }
        return f;
    }

    private SidePanelOptionParts<SideFenceInfo> createSideFenceParts(SideFenceInfo sideFenceInfo) {
        if (sideFenceInfo.mSideFenceType == SideFenceType.FENCE) {
            return new SideFenceParts();
        }
        if (sideFenceInfo.mSideFenceType == SideFenceType.DOOR) {
            return new SideFenceDoorParts();
        }
        if (sideFenceInfo.mSideFenceType == SideFenceType.FENCE_DOOR) {
            return new SideFencePlusDoorParts();
        }
        if (sideFenceInfo.mSideFenceType == SideFenceType.FENCE_NOT_DOOR) {
            return new SideFenceNotDoorParts();
        }
        return null;
    }

    private void createKutaiTateWaku(float f, float f2, float f3, float f4, Color color, List<Parts> list) {
        PKutaiTateWaku pKutaiTateWaku = new PKutaiTateWaku();
        pKutaiTateWaku.set(f, f2, f3, f4, color);
        list.add(pKutaiTateWaku);
    }
}

