/*
 * Decompiled with CFR 0.152.
 */
package option.loneterrace.shape.sunnyge.model.option.creator;

import java.awt.Color;
import java.util.Vector;
import model.parts.Parts;
import option.loneterrace.common.entity.BasicInfo;
import option.loneterrace.common.entity.SNYEntities;
import option.loneterrace.common.entity.TerraceInfo;
import option.loneterrace.common.entity.paneloption.InnerShadeInfo;
import option.loneterrace.common.entity.type.TypeTerraceDepthInfo;
import option.loneterrace.common.service.common.SNYColor;
import option.loneterrace.common.type.BuildingType;
import option.loneterrace.common.type.EnforcementDirType;
import option.loneterrace.common.type.EnforcementType;
import option.loneterrace.common.type.FloorType;
import option.loneterrace.common.type.RoofFigureType;
import option.loneterrace.common.type.SubProductType;
import option.loneterrace.common.type.TerraceDepthType;
import option.loneterrace.common.type.paneloption.PanelOptionType;
import option.loneterrace.shape.sunnyge.model.option.creator.AbstractMsOptionCreator;
import option.loneterrace.shape.sunnyge.model.option.item.MsItemGeneral;
import option.loneterrace.shape.sunnyge.model.option.parts.HiyokeFtypeParts;
import option.loneterrace.shape.sunnyge.model.option.parts.HiyokeRtypeParts;
import option.loneterrace.shape.sunnyge.model.sunnyge.item.AbstractTerraceUnitItem;
import option.loneterrace.shape.sunnyge.model.sunnyge.item.MsItemTerrace;

public class MsHiyokeCreator
extends AbstractMsOptionCreator<MsItemGeneral> {
    private static final float OFFSET_BACK_H = 98.5f;
    private static final float OFFSET_FRONT_Y = 55.72f;
    private static final float OFFSET_BACK_Y = 48.47f;

    @Override
    protected PanelOptionType configPanelOptionType() {
        return PanelOptionType.INNER_SHADE;
    }

    @Override
    protected Class<?> configPanelOptionInfoClass() {
        return InnerShadeInfo.class;
    }

    @Override
    public void create(MsItemGeneral msItemGeneral, AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        EnforcementType enforcementType = sNYEntities.mTerracesInfo.mEnforcementType;
        InnerShadeInfo innerShadeInfo = (InnerShadeInfo)this.mFrontPanelOptionShapeService.searchFrontPanelOptionInfo(sNYEntities.mFrontPanelOptionInfoList, this.configPanelOptionInfoClass(), this.configPanelOptionType(), terraceInfo.mId, 0);
        if (innerShadeInfo == null) {
            return;
        }
        if (basicInfo.mRoofFigureType == RoofFigureType.F) {
            if (enforcementType == EnforcementType.STD || enforcementType == EnforcementType.DOMA_YUKA_D || enforcementType == EnforcementType.DOMA_YUKA_W) {
                this.createFtypeStandard(msItemGeneral, abstractTerraceUnitItem, parts, innerShadeInfo);
            } else if (enforcementType == EnforcementType.IRISUMI) {
                if (terraceInfo.mBuildingType != BuildingType.CORNER) {
                    this.createFtypeStandard(msItemGeneral, abstractTerraceUnitItem, parts, innerShadeInfo);
                }
            } else if (enforcementType == EnforcementType.DESUMI) {
                if (terraceInfo.mBuildingType != BuildingType.CORNER) {
                    this.createFtypeStandard(msItemGeneral, abstractTerraceUnitItem, parts, innerShadeInfo);
                }
            } else if (enforcementType == EnforcementType.KUTAI_DEHABA_CHIGAI) {
                this.createFtypeKutaiDehabaChigai(msItemGeneral, abstractTerraceUnitItem, parts, innerShadeInfo);
            } else if (enforcementType == EnforcementType.HANEDASHI) {
                this.createFtypeStandard(msItemGeneral, abstractTerraceUnitItem, parts, innerShadeInfo);
            } else if (enforcementType == EnforcementType.BUBUN_IRISUMI) {
                this.createFtypeBubunIrisumi(msItemGeneral, abstractTerraceUnitItem, parts, innerShadeInfo);
            } else if (enforcementType == EnforcementType.BUBUN_KAKOI) {
                this.createFtypeBubunKakoi(msItemGeneral, abstractTerraceUnitItem, parts, innerShadeInfo);
            }
        } else if (basicInfo.mRoofFigureType == RoofFigureType.R) {
            if (enforcementType == EnforcementType.STD || enforcementType == EnforcementType.DOMA_YUKA_D || enforcementType == EnforcementType.DOMA_YUKA_W) {
                this.createRtypeStandard(msItemGeneral, abstractTerraceUnitItem, parts, innerShadeInfo);
            } else if (enforcementType == EnforcementType.IRISUMI) {
                if (terraceInfo.mBuildingType != BuildingType.CORNER) {
                    this.createRtypeStandard(msItemGeneral, abstractTerraceUnitItem, parts, innerShadeInfo);
                }
            } else if (enforcementType == EnforcementType.DESUMI) {
                if (terraceInfo.mBuildingType != BuildingType.CORNER) {
                    this.createRtypeStandard(msItemGeneral, abstractTerraceUnitItem, parts, innerShadeInfo);
                }
            } else if (enforcementType == EnforcementType.KUTAI_DEHABA_CHIGAI) {
                this.createRtypeKutaiDehabaChigai(msItemGeneral, abstractTerraceUnitItem, parts, innerShadeInfo);
            } else if (enforcementType == EnforcementType.HANEDASHI) {
                this.createRtypeStandard(msItemGeneral, abstractTerraceUnitItem, parts, innerShadeInfo);
            } else if (enforcementType == EnforcementType.BUBUN_IRISUMI) {
                this.createRtypeBubunIrisumi(msItemGeneral, abstractTerraceUnitItem, parts, innerShadeInfo);
            } else if (enforcementType == EnforcementType.BUBUN_KAKOI) {
                this.createRtypeBubunKakoi(msItemGeneral, abstractTerraceUnitItem, parts, innerShadeInfo);
            }
        }
    }

    private void createFtypeStandard(MsItemGeneral msItemGeneral, AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts, InnerShadeInfo innerShadeInfo) {
        float f;
        Color color = SNYColor.getColor(innerShadeInfo.mColorType);
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        Vector vector = parts.getChildren(true);
        float[] fArray = abstractTerraceUnitItem.getPitches();
        float f2 = terraceInfo.mDepth.floatValue();
        float f3 = sNYEntities.mPartsFigureInfo.mWallHeight.floatValue() + sNYEntities.mPartsFigureInfo.mTooshiHeight.floatValue();
        float f4 = f3 - (float)((double)f2 * Math.tan(Math.toRadians(10.0))) - 98.5f;
        float f5 = f3 - 98.5f;
        float f6 = -f2 + 55.72f;
        float f7 = -48.47f;
        if (sNYEntities.mBasicInfo.mSubProductType == SubProductType.HALF_KAKOI) {
            TypeTerraceDepthInfo typeTerraceDepthInfo = this.mTypeTerraceDepthCacheDao.findOneStdByType(TerraceDepthType.T4);
            f = (float)((double)typeTerraceDepthInfo.length.floatValue() * Math.tan(Math.toRadians(10.0)));
            f4 = f3 - f - 98.5f;
            f6 = -typeTerraceDepthInfo.length.floatValue() + 55.72f;
        }
        boolean bl = this.mPartsFigureService.isHalfSpanPitch(sNYEntities.mBasicInfo, sNYEntities.mTerracesInfo);
        float f8 = f = -terraceInfo.mWidth.floatValue() / 2.0f;
        int n = 0;
        while (n < fArray.length) {
            float f9;
            if (bl) {
                f9 = f8 + fArray[n];
                if (n < fArray.length - 1) {
                    f9 += fArray[n + 1];
                    ++n;
                }
            } else {
                f9 = f8 + fArray[n];
            }
            HiyokeFtypeParts hiyokeFtypeParts = new HiyokeFtypeParts();
            hiyokeFtypeParts.set(f8, f9, f6, f7, f4, f5, color);
            vector.add(hiyokeFtypeParts);
            f8 = f9;
            ++n;
        }
    }

    private void createRtypeStandard(MsItemGeneral msItemGeneral, AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts, InnerShadeInfo innerShadeInfo) {
        float f;
        Color color = SNYColor.getColor(innerShadeInfo.mColorType);
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        Vector vector = parts.getChildren(true);
        float[] fArray = abstractTerraceUnitItem.getPitches();
        float f2 = terraceInfo.mDepth.floatValue();
        float f3 = sNYEntities.mPartsFigureInfo.mHeight.floatValue() + sNYEntities.mPartsFigureInfo.mTooshiHeight.floatValue();
        float f4 = sNYEntities.mPartsFigureInfo.mWallHeight.floatValue() + sNYEntities.mPartsFigureInfo.mTooshiHeight.floatValue();
        float f5 = f3;
        float f6 = f4 - 98.5f;
        float f7 = -f2 + 55.72f;
        float f8 = -48.47f;
        boolean bl = this.mPartsFigureService.isHalfSpanPitch(sNYEntities.mBasicInfo, sNYEntities.mTerracesInfo);
        float f9 = f = -terraceInfo.mWidth.floatValue() / 2.0f;
        int n = 0;
        while (n < fArray.length) {
            float f10;
            if (bl) {
                f10 = f9 + fArray[n];
                if (n < fArray.length - 1) {
                    f10 += fArray[n + 1];
                    ++n;
                }
            } else {
                f10 = f9 + fArray[n];
            }
            HiyokeRtypeParts hiyokeRtypeParts = new HiyokeRtypeParts();
            hiyokeRtypeParts.set(f9, f10, f7, f8, f5, f6, color);
            vector.add(hiyokeRtypeParts);
            f9 = f10;
            ++n;
        }
    }

    private void createFtypeKutaiDehabaChigai(MsItemGeneral msItemGeneral, AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts, InnerShadeInfo innerShadeInfo) {
        float f;
        Color color = SNYColor.getColor(innerShadeInfo.mColorType);
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        Vector vector = parts.getChildren(true);
        float[] fArray = abstractTerraceUnitItem.getPitches();
        float f2 = sNYEntities.mTerracesInfo.mDepth.floatValue();
        float f3 = sNYEntities.mPartsFigureInfo.mWallHeight.floatValue() + sNYEntities.mPartsFigureInfo.mTooshiHeight.floatValue();
        float f4 = f3 - (float)((double)f2 * Math.tan(Math.toRadians(10.0))) - 98.5f;
        float f5 = f3 - 98.5f;
        float f6 = sNYEntities.mTerracesInfo.mDepth.floatValue() - terraceInfo.mDepth.floatValue();
        float f7 = -f2 + 55.72f;
        float f8 = -f6 - 48.47f;
        float f9 = 0.0f;
        float f10 = 0.0f;
        float f11 = 0.0f;
        float f12 = 0.0f;
        if (terraceInfo.mIsStarting.booleanValue()) {
            float f13 = (float)((double)Math.abs(terraceInfo.mLeftDepth.floatValue() - terraceInfo.mRightDepth.floatValue()) * Math.tan(Math.toRadians(10.0)));
            if (terraceInfo.mLeftDepth.floatValue() < terraceInfo.mRightDepth.floatValue()) {
                f9 = -48.47f - (terraceInfo.mRightDepth.floatValue() - terraceInfo.mLeftDepth.floatValue());
                f10 = f3 - f13 - 98.5f;
                f11 = -48.47f;
                f12 = f5;
            } else {
                f9 = -48.47f;
                f10 = f5;
                f11 = -48.47f - (terraceInfo.mLeftDepth.floatValue() - terraceInfo.mRightDepth.floatValue());
                f12 = f3 - f13 - 98.5f;
            }
        }
        boolean bl = this.mPartsFigureService.isHalfSpanPitch(sNYEntities.mBasicInfo, sNYEntities.mTerracesInfo);
        float f14 = f = -terraceInfo.mWidth.floatValue() / 2.0f;
        int n = 0;
        while (n < fArray.length) {
            float f15;
            if (bl) {
                f15 = f14 + fArray[n];
                if (n < fArray.length - 1) {
                    f15 += fArray[n + 1];
                    ++n;
                }
            } else {
                f15 = f14 + fArray[n];
            }
            if (terraceInfo.mIsStarting.booleanValue()) {
                f8 = f14 < f + terraceInfo.mLeftWidth.floatValue() ? f9 : f11;
                f5 = f14 < f + terraceInfo.mLeftWidth.floatValue() ? f10 : f12;
            }
            HiyokeFtypeParts hiyokeFtypeParts = new HiyokeFtypeParts();
            hiyokeFtypeParts.set(f14, f15, f7, f8, f4, f5, color);
            vector.add(hiyokeFtypeParts);
            f14 = f15;
            ++n;
        }
    }

    private void createRtypeKutaiDehabaChigai(MsItemGeneral msItemGeneral, AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts, InnerShadeInfo innerShadeInfo) {
        float f;
        Color color = SNYColor.getColor(innerShadeInfo.mColorType);
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        Vector vector = parts.getChildren(true);
        float[] fArray = abstractTerraceUnitItem.getPitches();
        float f2 = sNYEntities.mTerracesInfo.mDepth.floatValue();
        float f3 = sNYEntities.mPartsFigureInfo.mHeight.floatValue() + sNYEntities.mPartsFigureInfo.mTooshiHeight.floatValue();
        float f4 = sNYEntities.mPartsFigureInfo.mWallHeight.floatValue() + sNYEntities.mPartsFigureInfo.mTooshiHeight.floatValue();
        float f5 = f3;
        float f6 = f4 - 98.5f;
        float f7 = sNYEntities.mTerracesInfo.mDepth.floatValue() - terraceInfo.mDepth.floatValue();
        float f8 = -f2 + 55.72f;
        float f9 = -f7 - 48.47f;
        float f10 = 0.0f;
        float f11 = 0.0f;
        float f12 = 0.0f;
        float f13 = 0.0f;
        if (terraceInfo.mIsStarting.booleanValue()) {
            float f14 = (float)((double)Math.abs(terraceInfo.mLeftDepth.floatValue() - terraceInfo.mRightDepth.floatValue()) * Math.tan(Math.toRadians(10.0)));
            if (terraceInfo.mLeftDepth.floatValue() < terraceInfo.mRightDepth.floatValue()) {
                f10 = -48.47f - (terraceInfo.mRightDepth.floatValue() - terraceInfo.mLeftDepth.floatValue());
                f11 = f4 - f14 - 98.5f;
                f12 = -48.47f;
                f13 = f6;
            } else {
                f10 = -48.47f;
                f11 = f6;
                f12 = -48.47f - (terraceInfo.mLeftDepth.floatValue() - terraceInfo.mRightDepth.floatValue());
                f13 = f4 - f14 - 98.5f;
            }
        }
        boolean bl = this.mPartsFigureService.isHalfSpanPitch(sNYEntities.mBasicInfo, sNYEntities.mTerracesInfo);
        float f15 = f = -terraceInfo.mWidth.floatValue() / 2.0f;
        int n = 0;
        while (n < fArray.length) {
            float f16;
            if (bl) {
                f16 = f15 + fArray[n];
                if (n < fArray.length - 1) {
                    f16 += fArray[n + 1];
                    ++n;
                }
            } else {
                f16 = f15 + fArray[n];
            }
            if (terraceInfo.mIsStarting.booleanValue()) {
                f9 = f15 < f + terraceInfo.mLeftWidth.floatValue() ? f10 : f12;
                f6 = f15 < f + terraceInfo.mLeftWidth.floatValue() ? f11 : f13;
            }
            HiyokeRtypeParts hiyokeRtypeParts = new HiyokeRtypeParts();
            hiyokeRtypeParts.set(f15, f16, f8, f9, f5, f6, color);
            vector.add(hiyokeRtypeParts);
            f15 = f16;
            ++n;
        }
    }

    private void createFtypeBubunIrisumi(MsItemGeneral msItemGeneral, AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts, InnerShadeInfo innerShadeInfo) {
        float f;
        Color color = SNYColor.getColor(innerShadeInfo.mColorType);
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        Vector vector = parts.getChildren(true);
        float[] fArray = abstractTerraceUnitItem.getPitches();
        float f2 = terraceInfo.mDepth.floatValue();
        float f3 = sNYEntities.mPartsFigureInfo.mWallHeight.floatValue() + sNYEntities.mPartsFigureInfo.mTooshiHeight.floatValue();
        float f4 = f3 - (float)((double)f2 * Math.tan(Math.toRadians(10.0))) - 98.5f;
        float f5 = f3 - 98.5f;
        float f6 = -terraceInfo.mDepth.floatValue() + 55.72f;
        float f7 = -48.47f;
        boolean bl = this.mPartsFigureService.isHalfSpanPitch(sNYEntities.mBasicInfo, sNYEntities.mTerracesInfo);
        float f8 = f = -terraceInfo.mWidth.floatValue() / 2.0f;
        int n = 0;
        while (n < fArray.length) {
            float f9;
            if (bl) {
                f9 = f8 + fArray[n];
                if (n < fArray.length - 1) {
                    f9 += fArray[n + 1];
                    ++n;
                }
            } else {
                f9 = f8 + fArray[n];
            }
            HiyokeFtypeParts hiyokeFtypeParts = new HiyokeFtypeParts();
            hiyokeFtypeParts.set(f8, f9, f6, f7, f4, f5, color);
            vector.add(hiyokeFtypeParts);
            f8 = f9;
            ++n;
        }
    }

    private void createRtypeBubunIrisumi(MsItemGeneral msItemGeneral, AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts, InnerShadeInfo innerShadeInfo) {
        float f;
        Color color = SNYColor.getColor(innerShadeInfo.mColorType);
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        Vector vector = parts.getChildren(true);
        float[] fArray = abstractTerraceUnitItem.getPitches();
        float f2 = terraceInfo.mDepth.floatValue();
        float f3 = sNYEntities.mPartsFigureInfo.mHeight.floatValue() + sNYEntities.mPartsFigureInfo.mTooshiHeight.floatValue();
        float f4 = sNYEntities.mPartsFigureInfo.mWallHeight.floatValue() + sNYEntities.mPartsFigureInfo.mTooshiHeight.floatValue();
        float f5 = f3;
        float f6 = f4 - 98.5f;
        float f7 = -f2 + 55.72f;
        float f8 = -48.47f;
        boolean bl = this.mPartsFigureService.isHalfSpanPitch(sNYEntities.mBasicInfo, sNYEntities.mTerracesInfo);
        float f9 = f = -terraceInfo.mWidth.floatValue() / 2.0f;
        int n = 0;
        while (n < fArray.length) {
            float f10;
            if (bl) {
                f10 = f9 + fArray[n];
                if (n < fArray.length - 1) {
                    f10 += fArray[n + 1];
                    ++n;
                }
            } else {
                f10 = f9 + fArray[n];
            }
            HiyokeRtypeParts hiyokeRtypeParts = new HiyokeRtypeParts();
            hiyokeRtypeParts.set(f9, f10, f7, f8, f5, f6, color);
            vector.add(hiyokeRtypeParts);
            f9 = f10;
            ++n;
        }
    }

    private void createFtypeBubunKakoi(MsItemGeneral msItemGeneral, AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts, InnerShadeInfo innerShadeInfo) {
        Color color = SNYColor.getColor(innerShadeInfo.mColorType);
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        Vector vector = parts.getChildren(true);
        float[] fArray = abstractTerraceUnitItem.getPitches();
        float f = terraceInfo.mDepth.floatValue();
        float f2 = sNYEntities.mPartsFigureInfo.mWallHeight.floatValue() + sNYEntities.mPartsFigureInfo.mTooshiHeight.floatValue();
        float f3 = f2 - (float)((double)f * Math.tan(Math.toRadians(10.0))) - 98.5f;
        float f4 = f2 - 98.5f;
        float f5 = -terraceInfo.mDepth.floatValue() + 55.72f;
        float f6 = -48.47f;
        float f7 = -terraceInfo.mWidth.floatValue() / 2.0f;
        float f8 = -terraceInfo.mWidth.floatValue() / 2.0f;
        float f9 = terraceInfo.mWidth.floatValue() / 2.0f;
        if (sNYEntities.mBasicInfo.mSubProductType != SubProductType.TSUKURITSUKE) {
            if (terraceInfo.mIsMaster.booleanValue()) {
                if (sNYEntities.mTerracesInfo.mEnforcementDirType == EnforcementDirType.L) {
                    f8 = -terraceInfo.mWidth.floatValue() / 2.0f;
                    f9 = -terraceInfo.mWidth.floatValue() / 2.0f + terraceInfo.mLeftWidth.floatValue();
                } else {
                    f8 = terraceInfo.mWidth.floatValue() / 2.0f - terraceInfo.mRightWidth.floatValue();
                    f9 = terraceInfo.mWidth.floatValue() / 2.0f;
                }
            } else if (terraceInfo.mFloorType == FloorType.DOMA) {
                return;
            }
        }
        boolean bl = this.mPartsFigureService.isHalfSpanPitch(sNYEntities.mBasicInfo, sNYEntities.mTerracesInfo);
        float f10 = f7;
        int n = 0;
        while (n < fArray.length) {
            float f11;
            float f12;
            if (bl) {
                float f13;
                f12 = f10 + fArray[n];
                if (n < fArray.length - 1 && (f13 = (f10 + f12 + fArray[n + 1]) / 2.0f) > f8 && f13 < f9) {
                    f12 += fArray[n + 1];
                    ++n;
                }
            } else {
                f12 = f10 + fArray[n];
            }
            if ((f11 = (f10 + f12) / 2.0f) > f8 && f11 < f9) {
                HiyokeFtypeParts hiyokeFtypeParts = new HiyokeFtypeParts();
                hiyokeFtypeParts.set(f10, f12, f5, f6, f3, f4, color);
                vector.add(hiyokeFtypeParts);
            }
            f10 = f12;
            ++n;
        }
    }

    private void createRtypeBubunKakoi(MsItemGeneral msItemGeneral, AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts, InnerShadeInfo innerShadeInfo) {
        Color color = SNYColor.getColor(innerShadeInfo.mColorType);
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        Vector vector = parts.getChildren(true);
        float[] fArray = abstractTerraceUnitItem.getPitches();
        float f = terraceInfo.mDepth.floatValue();
        float f2 = sNYEntities.mPartsFigureInfo.mHeight.floatValue() + sNYEntities.mPartsFigureInfo.mTooshiHeight.floatValue();
        float f3 = sNYEntities.mPartsFigureInfo.mWallHeight.floatValue() + sNYEntities.mPartsFigureInfo.mTooshiHeight.floatValue();
        float f4 = f2;
        float f5 = f3 - 98.5f;
        float f6 = -f + 55.72f;
        float f7 = -48.47f;
        float f8 = -terraceInfo.mWidth.floatValue() / 2.0f;
        float f9 = -terraceInfo.mWidth.floatValue() / 2.0f;
        float f10 = terraceInfo.mWidth.floatValue() / 2.0f;
        if (sNYEntities.mBasicInfo.mSubProductType != SubProductType.TSUKURITSUKE) {
            if (terraceInfo.mIsMaster.booleanValue()) {
                if (sNYEntities.mTerracesInfo.mEnforcementDirType == EnforcementDirType.L) {
                    f9 = -terraceInfo.mWidth.floatValue() / 2.0f;
                    f10 = -terraceInfo.mWidth.floatValue() / 2.0f + terraceInfo.mLeftWidth.floatValue();
                } else {
                    f9 = terraceInfo.mWidth.floatValue() / 2.0f - terraceInfo.mRightWidth.floatValue();
                    f10 = terraceInfo.mWidth.floatValue() / 2.0f;
                }
            } else if (terraceInfo.mFloorType == FloorType.DOMA) {
                return;
            }
        }
        boolean bl = this.mPartsFigureService.isHalfSpanPitch(sNYEntities.mBasicInfo, sNYEntities.mTerracesInfo);
        float f11 = f8;
        int n = 0;
        while (n < fArray.length) {
            float f12;
            float f13;
            if (bl) {
                float f14;
                f13 = f11 + fArray[n];
                if (n < fArray.length - 1 && (f14 = (f11 + f13 + fArray[n + 1]) / 2.0f) > f9 && f14 < f10) {
                    f13 += fArray[n + 1];
                    ++n;
                }
            } else {
                f13 = f11 + fArray[n];
            }
            if ((f12 = (f11 + f13) / 2.0f) > f9 && f12 < f10) {
                HiyokeRtypeParts hiyokeRtypeParts = new HiyokeRtypeParts();
                hiyokeRtypeParts.set(f11, f13, f6, f7, f4, f5, color);
                vector.add(hiyokeRtypeParts);
            }
            f11 = f13;
            ++n;
        }
    }
}

