/*
 * Decompiled with CFR 0.152.
 */
package option.loneterrace.shape.sunnyge.model.option.creator;

import java.awt.Color;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import model.parts.Parts;
import option.gad.core.util.GdMutableTypeUtil;
import option.loneterrace.common.entity.BasicInfo;
import option.loneterrace.common.entity.FrontPanelInfo;
import option.loneterrace.common.entity.PanelInfo;
import option.loneterrace.common.entity.SNYEntities;
import option.loneterrace.common.entity.TerraceInfo;
import option.loneterrace.common.entity.TerracesInfo;
import option.loneterrace.common.entity.paneloption.NakasanInfo;
import option.loneterrace.common.entity.paneloption.PanelOptionInfo;
import option.loneterrace.common.service.common.SNYColor;
import option.loneterrace.common.type.BuildingType;
import option.loneterrace.common.type.EnforcementType;
import option.loneterrace.common.type.SubProductType;
import option.loneterrace.common.type.paneloption.PanelOptionType;
import option.loneterrace.shape.sunnyge.model.option.creator.AbstractMsOptionCreator;
import option.loneterrace.shape.sunnyge.model.option.item.MsItemGeneral;
import option.loneterrace.shape.sunnyge.model.option.parts.FrontPanelOptionParts;
import option.loneterrace.shape.sunnyge.model.sunnyge.item.AbstractTerraceUnitItem;
import option.loneterrace.shape.sunnyge.model.sunnyge.item.MsItemTerrace;

public class MsFrontNakasanPartsCreator
extends AbstractMsOptionCreator<MsItemGeneral> {
    @Override
    protected PanelOptionType configPanelOptionType() {
        return PanelOptionType.NAKASAN;
    }

    @Override
    protected Class<?> configPanelOptionInfoClass() {
        return NakasanInfo.class;
    }

    @Override
    public void create(MsItemGeneral msItemGeneral, AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        if (terraceInfo.mBuildingType != null && terraceInfo.mBuildingType == BuildingType.CORNER) {
            return;
        }
        if (terracesInfo.mEnforcementType == EnforcementType.IRISUMI) {
            this.createIrisumi(abstractTerraceUnitItem, parts);
        } else if (terracesInfo.mEnforcementType == EnforcementType.DESUMI) {
            this.createDesumi(abstractTerraceUnitItem, parts);
        } else {
            this.createStandard(abstractTerraceUnitItem, parts);
        }
    }

    protected void createStandard(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        Vector vector = parts.getChildren(true);
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        float f = -terraceInfo.mWidth.floatValue() / 2.0f;
        float f2 = terraceInfo.mWidth.floatValue() / 2.0f;
        float f3 = f;
        float f4 = -sNYEntities.mTerracesInfo.mDepth.floatValue();
        if (sNYEntities.mBasicInfo.mSubProductType == SubProductType.HALF_KAKOI) {
            f4 = -sNYEntities.mPartsFigureInfo.mKutaiUniversalPillarDepth1.floatValue();
        }
        this.createNakasan(f, f3, f2, f4, sNYEntities, terraceInfo, vector);
    }

    private void createIrisumi(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        float f;
        Vector vector = parts.getChildren(true);
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        float f2 = f = -terraceInfo.mWidth.floatValue() / 2.0f;
        float f3 = terraceInfo.mWidth.floatValue() / 2.0f;
        float f4 = -sNYEntities.mTerracesInfo.mDepth.floatValue();
        this.mPartsFigureService.isPrevConner(abstractTerraceUnitItem);
        this.mPartsFigureService.isNextConner(abstractTerraceUnitItem);
        this.createNakasan(f, f2, f3, f4, sNYEntities, terraceInfo, vector);
    }

    private void createDesumi(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        float f;
        Vector vector = parts.getChildren(true);
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        float f2 = f = -terraceInfo.mWidth.floatValue() / 2.0f;
        float f3 = terraceInfo.mWidth.floatValue() / 2.0f;
        float f4 = -sNYEntities.mTerracesInfo.mDepth.floatValue();
        if (this.mPartsFigureService.isPrevConner(abstractTerraceUnitItem)) {
            f = -terraceInfo.mWidth.floatValue() / 2.0f - terraceInfo.mDepth.floatValue() - 97.5f;
        }
        if (this.mPartsFigureService.isNextConner(abstractTerraceUnitItem)) {
            f3 = terraceInfo.mWidth.floatValue() / 2.0f + terraceInfo.mDepth.floatValue() + 97.5f;
        }
        this.createNakasan(f, f2, f3, f4, sNYEntities, terraceInfo, vector);
    }

    private void createNakasan(float f, float f2, float f3, float f4, SNYEntities sNYEntities, TerraceInfo terraceInfo, List<Parts> list) {
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        LinkedList<PanelOptionInfo> linkedList = sNYEntities.mFrontPanelOptionInfoList;
        float f5 = sNYEntities.mBasicInfo.mKenLen.floatValue();
        float f6 = f5 / 2.0f;
        for (PanelOptionInfo panelOptionInfo : linkedList) {
            FrontPanelInfo frontPanelInfo;
            if (!(panelOptionInfo instanceof NakasanInfo)) continue;
            NakasanInfo nakasanInfo = (NakasanInfo)panelOptionInfo;
            if (nakasanInfo.mTerraceId != terraceInfo.mId || (frontPanelInfo = this.mFrontPanelCommonService.findOneFrontPanelInfo(sNYEntities.mFrontPanelInfoList, nakasanInfo.mTerraceId, nakasanInfo.mIndex)) == null) continue;
            Color color = SNYColor.getColor(nakasanInfo.mColorType);
            Color color2 = SNYColor.getColor(sNYEntities.mBasicInfo.mBodyColorType);
            float f7 = this.calcFrontPanelTotalWidth(sNYEntities.mFrontPanelInfoList, terraceInfo.mId, frontPanelInfo.mIndex, f6);
            float f8 = f + f7;
            float f9 = frontPanelInfo.mWidth.floatValue() - 70.0f;
            float f10 = this.mPanelOptionShapeService.calcHeight(this.configPanelOptionType(), sNYEntities, terraceInfo);
            float f11 = this.calcBaseHeight(this.configPanelOptionType(), sNYEntities, terraceInfo, frontPanelInfo);
            float f12 = f8;
            float f13 = f8 + f9;
            float f14 = f4;
            float f15 = f11;
            float f16 = f15 + f10;
            FrontPanelOptionParts frontPanelOptionParts = this.mFrontPanelOptionPartsFactory.create(this.configPanelOptionType(), basicInfo);
            frontPanelOptionParts.set(f12, f13, f14, f15, f16, 0.0f, f5, color2, color, nakasanInfo);
            list.add(frontPanelOptionParts);
        }
    }

    private float calcBaseHeight(PanelOptionType panelOptionType, SNYEntities sNYEntities, TerraceInfo terraceInfo, PanelInfo panelInfo) {
        SubProductType subProductType = sNYEntities.mBasicInfo.mSubProductType;
        float f = this.mPanelOptionShapeService.calcBaseHeight(panelOptionType, sNYEntities, terraceInfo, panelInfo);
        if (!GdMutableTypeUtil.matchOR(subProductType, SubProductType.ALMI_BALCONY_PILLAR, SubProductType.ALMI_BALCONY_ROOF)) {
            f -= sNYEntities.mFloorInfo.mFloorLevel.floatValue();
        }
        return f;
    }

    private float calcFrontPanelTotalWidth(LinkedList<FrontPanelInfo> linkedList, int n, int n2, float f) {
        boolean bl = false;
        if (n2 > 0) {
            int n3 = n2 - 1;
            for (FrontPanelInfo frontPanelInfo : linkedList) {
                if (frontPanelInfo.mTerraceId != n) continue;
                int n4 = frontPanelInfo.mIndex;
                int n5 = frontPanelInfo.mIndex + frontPanelInfo.mSpan;
                if (n3 < n4 || n3 > n5) continue;
                bl = true;
                break;
            }
        }
        if (bl) {
            float f2 = 0.0f;
            int n6 = 0;
            while (n6 < n2) {
                boolean bl2 = false;
                for (FrontPanelInfo frontPanelInfo : linkedList) {
                    if (frontPanelInfo.mTerraceId != n || frontPanelInfo.mIndex != n6) continue;
                    bl2 = true;
                    f2 += frontPanelInfo.mWidth.floatValue();
                    n6 = frontPanelInfo.mIndex + frontPanelInfo.mSpan;
                    break;
                }
                if (bl2) continue;
                f2 += f;
                ++n6;
            }
            return f2;
        }
        return f * (float)n2;
    }
}

