/*
 * Decompiled with CFR 0.152.
 */
package option.loneterrace.shape.sunnyge.model.option.creator;

import java.awt.Color;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import model.parts.Parts;
import option.loneterrace.common.entity.BasicInfo;
import option.loneterrace.common.entity.FrontPanelInfo;
import option.loneterrace.common.entity.SNYEntities;
import option.loneterrace.common.entity.TerraceInfo;
import option.loneterrace.common.entity.TerracesInfo;
import option.loneterrace.common.entity.paneloption.MekakushiPanelSetInfo;
import option.loneterrace.common.entity.paneloption.PanelOptionInfo;
import option.loneterrace.common.service.common.SNYColor;
import option.loneterrace.common.type.BuildingType;
import option.loneterrace.common.type.EnforcementDirType;
import option.loneterrace.common.type.EnforcementType;
import option.loneterrace.common.type.FloorType;
import option.loneterrace.common.type.SubProductType;
import option.loneterrace.common.type.TerraceDepthType;
import option.loneterrace.common.type.paneloption.PanelOptionType;
import option.loneterrace.shape.sunnyge.model.option.creator.AbstractMsOptionCreator;
import option.loneterrace.shape.sunnyge.model.option.item.MsItemGeneral;
import option.loneterrace.shape.sunnyge.model.option.parts.FrontPanelOptionParts;
import option.loneterrace.shape.sunnyge.model.sunnyge.item.AbstractTerraceUnitItem;
import option.loneterrace.shape.sunnyge.model.sunnyge.item.MsItemTerrace;

public class MsFrontMekakushiPanelSetPartsCreator
extends AbstractMsOptionCreator<MsItemGeneral> {
    @Override
    protected PanelOptionType configPanelOptionType() {
        return PanelOptionType.MEKAKUSHI_PANEL_SET;
    }

    @Override
    protected Class<?> configPanelOptionInfoClass() {
        return MekakushiPanelSetInfo.class;
    }

    @Override
    public void create(MsItemGeneral msItemGeneral, AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        if (terraceInfo.mBuildingType != null && terraceInfo.mBuildingType == BuildingType.CORNER) {
            return;
        }
        if (terracesInfo.mEnforcementType == EnforcementType.IRISUMI) {
            this.createIrisumi(abstractTerraceUnitItem, parts);
        } else if (terracesInfo.mEnforcementType == EnforcementType.DESUMI) {
            this.createDesumi(abstractTerraceUnitItem, parts);
        } else if (terracesInfo.mEnforcementType == EnforcementType.BUBUN_KAKOI) {
            this.createBubunKakoi(abstractTerraceUnitItem, parts);
        } else {
            this.createStandard(abstractTerraceUnitItem, parts);
        }
    }

    protected void createStandard(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        Vector vector = parts.getChildren(true);
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        float f = -terraceInfo.mWidth.floatValue() / 2.0f;
        float f2 = terraceInfo.mWidth.floatValue() / 2.0f;
        float f3 = f;
        float f4 = -sNYEntities.mTerracesInfo.mDepth.floatValue();
        if (sNYEntities.mBasicInfo.mSubProductType == SubProductType.HALF_KAKOI) {
            f4 = -sNYEntities.mPartsFigureInfo.mKutaiUniversalPillarDepth1.floatValue();
        }
        this.createMekakushiPanelSet(f, f3, f2, f4, sNYEntities, terraceInfo, vector);
    }

    private void createIrisumi(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        float f;
        Vector vector = parts.getChildren(true);
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        float f2 = f = -terraceInfo.mWidth.floatValue() / 2.0f;
        float f3 = terraceInfo.mWidth.floatValue() / 2.0f;
        float f4 = -sNYEntities.mTerracesInfo.mDepth.floatValue();
        this.mPartsFigureService.isPrevConner(abstractTerraceUnitItem);
        this.mPartsFigureService.isNextConner(abstractTerraceUnitItem);
        this.createMekakushiPanelSet(f, f2, f3, f4, sNYEntities, terraceInfo, vector);
    }

    private void createDesumi(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        float f;
        Vector vector = parts.getChildren(true);
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        float f2 = f = -terraceInfo.mWidth.floatValue() / 2.0f;
        float f3 = terraceInfo.mWidth.floatValue() / 2.0f;
        float f4 = -sNYEntities.mTerracesInfo.mDepth.floatValue();
        if (this.mPartsFigureService.isPrevConner(abstractTerraceUnitItem)) {
            f = -terraceInfo.mWidth.floatValue() / 2.0f - terraceInfo.mDepth.floatValue() - 97.5f;
        }
        if (this.mPartsFigureService.isNextConner(abstractTerraceUnitItem)) {
            f3 = terraceInfo.mWidth.floatValue() / 2.0f + terraceInfo.mDepth.floatValue() + 97.5f;
        }
        this.createMekakushiPanelSet(f, f2, f3, f4, sNYEntities, terraceInfo, vector);
    }

    protected void createBubunKakoi(AbstractTerraceUnitItem abstractTerraceUnitItem, Parts parts) {
        Vector vector = parts.getChildren(true);
        MsItemTerrace msItemTerrace = abstractTerraceUnitItem.getTerraceItem();
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        TerraceInfo terraceInfo = abstractTerraceUnitItem.getTerraceInfo();
        float f = -terraceInfo.mWidth.floatValue() / 2.0f;
        float f2 = terraceInfo.mWidth.floatValue() / 2.0f;
        float f3 = f;
        float f4 = -sNYEntities.mTerracesInfo.mDepth.floatValue();
        if (sNYEntities.mBasicInfo.mSubProductType != SubProductType.TSUKURITSUKE) {
            if (terraceInfo.mIsMaster.booleanValue()) {
                if (terracesInfo.mEnforcementDirType == EnforcementDirType.L) {
                    f2 = f + terraceInfo.mLeftWidth.floatValue();
                } else {
                    f = terraceInfo.mWidth.floatValue() / 2.0f - terraceInfo.mRightWidth.floatValue();
                }
            } else if (terraceInfo.mFloorType == FloorType.DOMA) {
                return;
            }
        }
        this.createMekakushiPanelSet(f, f3, f2, f4, sNYEntities, terraceInfo, vector);
    }

    private void createMekakushiPanelSet(float f, float f2, float f3, float f4, SNYEntities sNYEntities, TerraceInfo terraceInfo, List<Parts> list) {
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        LinkedList<PanelOptionInfo> linkedList = sNYEntities.mFrontPanelOptionInfoList;
        float f5 = this.mPanelOptionShapeService.calcHeight(this.configPanelOptionType(), sNYEntities, terraceInfo);
        float f6 = sNYEntities.mBasicInfo.mKenLen.floatValue() / 2.0f;
        for (PanelOptionInfo panelOptionInfo : linkedList) {
            FrontPanelInfo frontPanelInfo;
            if (!(panelOptionInfo instanceof MekakushiPanelSetInfo)) continue;
            MekakushiPanelSetInfo mekakushiPanelSetInfo = (MekakushiPanelSetInfo)panelOptionInfo;
            if (mekakushiPanelSetInfo.mTerraceId != terraceInfo.mId || (frontPanelInfo = this.findFrontPanelInfo(sNYEntities.mFrontPanelInfoList, mekakushiPanelSetInfo)) == null) continue;
            Color color = SNYColor.getColor(mekakushiPanelSetInfo.mColorType);
            Color color2 = SNYColor.getColor(sNYEntities.mBasicInfo.mBodyColorType);
            float f7 = this.mPanelOptionShapeService.calcBaseHeight(this.configPanelOptionType(), sNYEntities, terraceInfo, frontPanelInfo) - sNYEntities.mFloorInfo.mFloorLevel.floatValue();
            float f8 = frontPanelInfo.mWidth.floatValue();
            float f9 = f + (float)mekakushiPanelSetInfo.mIndex.intValue() * f6;
            if (terracesInfo.mEnforcementType == EnforcementType.DESUMI && f != f2) {
                int n = this.calcIndexCount(terraceInfo.mDepthType);
                f9 = n <= frontPanelInfo.mIndex ? f2 + (float)(frontPanelInfo.mIndex - n) * f6 : f2 - f6 * (float)n + (float)frontPanelInfo.mIndex.intValue() * f6;
            }
            float f10 = f9 + 35.0f;
            float f11 = f10 + f8 - 70.0f;
            float f12 = f4 + 17.5f;
            float f13 = this.calcBottomHeight(sNYEntities, terraceInfo, f10, f11, f7);
            float f14 = f13 + f5;
            if (frontPanelInfo.mLowerHeightCut != null) {
                f14 -= frontPanelInfo.mLowerHeightCut.floatValue();
            }
            FrontPanelOptionParts frontPanelOptionParts = this.mFrontPanelOptionPartsFactory.create(this.configPanelOptionType(), basicInfo);
            frontPanelOptionParts.set(f10, f11, f12, f13, f14, 0.0f, 0.0f, color2, color, mekakushiPanelSetInfo);
            list.add(frontPanelOptionParts);
        }
    }

    private FrontPanelInfo findFrontPanelInfo(LinkedList<FrontPanelInfo> linkedList, MekakushiPanelSetInfo mekakushiPanelSetInfo) {
        for (FrontPanelInfo frontPanelInfo : linkedList) {
            if (frontPanelInfo.mTerraceId != mekakushiPanelSetInfo.mTerraceId || frontPanelInfo.mIndex != mekakushiPanelSetInfo.mIndex) continue;
            return frontPanelInfo;
        }
        return null;
    }

    private float calcBottomHeight(SNYEntities sNYEntities, TerraceInfo terraceInfo, float f, float f2, float f3) {
        float f4 = f3;
        if (sNYEntities.mBasicInfo.mSubProductType == SubProductType.ALMI_BALCONY_PILLAR || sNYEntities.mBasicInfo.mSubProductType == SubProductType.ALMI_BALCONY_ROOF) {
            f4 = f3 + sNYEntities.mFloorInfo.mFloorLevel.floatValue();
        } else if (sNYEntities.mTerracesInfo.mEnforcementType == EnforcementType.DOMA_YUKA_W) {
            f4 = this.mPartsFigureService.isFrontPanelBuildOnDoma(sNYEntities, terraceInfo, f, f2) ? -sNYEntities.mFloorInfo.mFloorLevel.floatValue() + 50.0f : f3;
        } else if (sNYEntities.mTerracesInfo.mEnforcementType == EnforcementType.DOMA_YUKA_D) {
            f4 = 50.0f;
        }
        return f4;
    }

    private int calcIndexCount(TerraceDepthType terraceDepthType) {
        int n = 0;
        if (terraceDepthType == TerraceDepthType.T3) {
            n = 2;
        } else if (terraceDepthType == TerraceDepthType.T4) {
            n = 4;
        } else if (terraceDepthType == TerraceDepthType.T5) {
            n = 4;
        } else if (terraceDepthType == TerraceDepthType.T6) {
            n = 4;
        }
        return n;
    }
}

