/*
 * Decompiled with CFR 0.152.
 */
package option.loneterrace.shape.sunnyge.model.common.service;

import java.util.LinkedList;
import java.util.List;
import option.gad.core.inject.GdInject;
import option.loneterrace.common.entity.SNYEntities;
import option.loneterrace.common.entity.SidePanelInfo;
import option.loneterrace.common.service.parts.SidePanelCommonService;
import option.loneterrace.common.type.OpeningPanelType;
import option.loneterrace.shape.sunnyge.model.common.service.CommonShapeService;
import option.loneterrace.shape.sunnyge.model.sunnyge.item.AbstractTerraceUnitItem;
import option.loneterrace.shape.sunnyge.model.sunnyge.item.MsItemTerrace;

public class SidePanelShapeService
extends SidePanelCommonService {
    @GdInject
    private CommonShapeService mCommonShapeService;

    public boolean isUsed(MsItemTerrace msItemTerrace, OpeningPanelType openingPanelType) {
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        return this.isUsed(sNYEntities.mLeftPanelInfoList, sNYEntities.mRightPanelInfoList, openingPanelType);
    }

    public boolean isUsed(LinkedList<SidePanelInfo> linkedList, LinkedList<SidePanelInfo> linkedList2, OpeningPanelType openingPanelType) {
        for (SidePanelInfo sidePanelInfo : linkedList) {
            if (sidePanelInfo.mPanelType != openingPanelType) continue;
            return true;
        }
        for (SidePanelInfo sidePanelInfo : linkedList2) {
            if (sidePanelInfo.mPanelType != openingPanelType) continue;
            return true;
        }
        return false;
    }

    public boolean isUsed(LinkedList<SidePanelInfo> linkedList, OpeningPanelType openingPanelType) {
        for (SidePanelInfo sidePanelInfo : linkedList) {
            if (sidePanelInfo.mPanelType != openingPanelType) continue;
            return true;
        }
        return false;
    }

    public SidePanelInfo findSidePanelInfo(LinkedList<SidePanelInfo> linkedList, OpeningPanelType openingPanelType, int n, int n2) {
        for (SidePanelInfo sidePanelInfo : linkedList) {
            if (sidePanelInfo.mPanelType != openingPanelType || sidePanelInfo.mTerraceId != n || sidePanelInfo.mIndex != n2) continue;
            return sidePanelInfo;
        }
        return null;
    }

    public float calcGapPillarToSidePanel() {
        float f = 55.0f;
        return f;
    }

    public SidePanelInfo findSidePanel(LinkedList<SidePanelInfo> linkedList, int n) {
        for (SidePanelInfo sidePanelInfo : linkedList) {
            if (sidePanelInfo.mIndex != n) continue;
            return sidePanelInfo;
        }
        return null;
    }

    public boolean hasLeftPanel(AbstractTerraceUnitItem abstractTerraceUnitItem, MsItemTerrace msItemTerrace) {
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        return this.hasLeftPanel(abstractTerraceUnitItem, msItemTerrace, sNYEntities.mLeftPanelInfoList);
    }

    public boolean hasLeftPanel(AbstractTerraceUnitItem abstractTerraceUnitItem, MsItemTerrace msItemTerrace, LinkedList<SidePanelInfo> linkedList) {
        AbstractTerraceUnitItem abstractTerraceUnitItem2 = this.mCommonShapeService.getFirstUnit(msItemTerrace);
        return this.hasSidePanel(linkedList, abstractTerraceUnitItem, abstractTerraceUnitItem2);
    }

    public boolean hasRightPanel(AbstractTerraceUnitItem abstractTerraceUnitItem, MsItemTerrace msItemTerrace) {
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        return this.hasRightPanel(abstractTerraceUnitItem, msItemTerrace, sNYEntities.mRightPanelInfoList);
    }

    public boolean hasRightPanel(AbstractTerraceUnitItem abstractTerraceUnitItem, MsItemTerrace msItemTerrace, LinkedList<SidePanelInfo> linkedList) {
        AbstractTerraceUnitItem abstractTerraceUnitItem2 = this.mCommonShapeService.getLastUnit(msItemTerrace);
        return this.hasSidePanel(linkedList, abstractTerraceUnitItem, abstractTerraceUnitItem2);
    }

    private boolean hasSidePanel(LinkedList<SidePanelInfo> linkedList, AbstractTerraceUnitItem abstractTerraceUnitItem, AbstractTerraceUnitItem abstractTerraceUnitItem2) {
        if (linkedList.size() == 0) {
            return false;
        }
        return abstractTerraceUnitItem == abstractTerraceUnitItem2;
    }

    public float getLeftPanelWidth(MsItemTerrace msItemTerrace) {
        List<AbstractTerraceUnitItem> list = msItemTerrace.getUnits();
        for (AbstractTerraceUnitItem abstractTerraceUnitItem : list) {
            if (!this.hasLeftPanel(abstractTerraceUnitItem, msItemTerrace)) continue;
            return abstractTerraceUnitItem.getCx() + abstractTerraceUnitItem.getWidthL() - 70.0f;
        }
        return 0.0f;
    }

    public float getRightPanelWidth(MsItemTerrace msItemTerrace) {
        List<AbstractTerraceUnitItem> list = msItemTerrace.getUnits();
        for (AbstractTerraceUnitItem abstractTerraceUnitItem : list) {
            if (!this.hasRightPanel(abstractTerraceUnitItem, msItemTerrace)) continue;
            return abstractTerraceUnitItem.getCx() + abstractTerraceUnitItem.getWidthR() + 70.0f;
        }
        return 0.0f;
    }

    public float calcLeftKutaiSidePanelY(AbstractTerraceUnitItem abstractTerraceUnitItem, LinkedList<SidePanelInfo> linkedList, float f) {
        return this.calcCommonKutaiSidePanelY(abstractTerraceUnitItem, linkedList, f);
    }

    public float calcRightKutaiSidePanelY(AbstractTerraceUnitItem abstractTerraceUnitItem, LinkedList<SidePanelInfo> linkedList, float f) {
        return this.calcCommonKutaiSidePanelY(abstractTerraceUnitItem, linkedList, f);
    }

    private float calcCommonKutaiSidePanelY(AbstractTerraceUnitItem abstractTerraceUnitItem, LinkedList<SidePanelInfo> linkedList, float f) {
        float f2 = -f + this.calcGapPillarToSidePanel();
        for (SidePanelInfo sidePanelInfo : linkedList) {
            if (sidePanelInfo == null) continue;
            f2 += sidePanelInfo.mWidth.floatValue();
        }
        return f2;
    }
}

