/*
 * Decompiled with CFR 0.152.
 */
package option.loneterrace.shape.sunnyge.model.common.service;

import java.util.LinkedList;
import option.gad.core.inject.GdInject;
import option.loneterrace.common.entity.BasicInfo;
import option.loneterrace.common.entity.FloorInfo;
import option.loneterrace.common.entity.PanelCutInfo;
import option.loneterrace.common.entity.PanelInfo;
import option.loneterrace.common.entity.PartsFigureInfo;
import option.loneterrace.common.entity.PartsFigureUnitInfo;
import option.loneterrace.common.entity.SNYEntities;
import option.loneterrace.common.entity.TerraceInfo;
import option.loneterrace.common.entity.TerracesInfo;
import option.loneterrace.common.entity.paneloption.PanelOptionInfo;
import option.loneterrace.common.service.cut.PanelCutCommonService;
import option.loneterrace.common.service.parts.PanelOptionCommonService;
import option.loneterrace.common.service.parts.SidePanelCommonService;
import option.loneterrace.common.type.DirectionType;
import option.loneterrace.common.type.RanmaUseType;
import option.loneterrace.common.type.RoofFigureType;
import option.loneterrace.common.type.StrengthType;
import option.loneterrace.common.type.TerraceDepthType;
import option.loneterrace.common.type.paneloption.PanelOptionType;
import option.loneterrace.shape.sunnyge.model.common.service.TerraceShapeService;
import option.loneterrace.shape.sunnyge.model.option.parts.TobukuroNige;
import option.loneterrace.shape.sunnyge.model.sunnyge.item.MsItemTerrace;
import option.loneterrace.shape.sunnyge.model.sunnyge.service.PartsFigureService;

public class PanelOptionShapeService
extends PanelOptionCommonService {
    @GdInject
    protected TerraceShapeService mTerraceShapeService;
    @GdInject
    protected SidePanelCommonService mSidePanelCommonService;
    @GdInject
    protected PanelCutCommonService mPanelCutCommonService;
    @GdInject
    protected PartsFigureService mPartsFigureService;

    public boolean isUsed(MsItemTerrace msItemTerrace, PanelOptionType panelOptionType) {
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        LinkedList<PanelOptionInfo> linkedList = sNYEntities.mLeftPanelOptionInfoList;
        LinkedList<PanelOptionInfo> linkedList2 = sNYEntities.mRightPanelOptionInfoList;
        for (PanelOptionInfo panelOptionInfo : linkedList) {
            if (panelOptionInfo.mPanelOptionType != panelOptionType) continue;
            return true;
        }
        for (PanelOptionInfo panelOptionInfo : linkedList2) {
            if (panelOptionInfo.mPanelOptionType != panelOptionType) continue;
            return true;
        }
        return false;
    }

    public boolean isUsed(LinkedList<PanelOptionInfo> linkedList, LinkedList<PanelOptionInfo> linkedList2, PanelOptionType panelOptionType) {
        for (PanelOptionInfo panelOptionInfo : linkedList) {
            if (panelOptionInfo.mPanelOptionType != panelOptionType) continue;
            return true;
        }
        for (PanelOptionInfo panelOptionInfo : linkedList2) {
            if (panelOptionInfo.mPanelOptionType != panelOptionType) continue;
            return true;
        }
        return false;
    }

    public PanelOptionInfo findPanelOptionInfo(LinkedList<PanelOptionInfo> linkedList, PanelOptionType panelOptionType, int n) {
        for (PanelOptionInfo panelOptionInfo : linkedList) {
            if (panelOptionInfo.mPanelOptionType != panelOptionType || panelOptionInfo.mIndex != n) continue;
            return panelOptionInfo;
        }
        return null;
    }

    public PanelOptionInfo findPanelOptionInfo(LinkedList<PanelOptionInfo> linkedList, PanelOptionType panelOptionType) {
        for (PanelOptionInfo panelOptionInfo : linkedList) {
            if (panelOptionInfo.mPanelOptionType != panelOptionType) continue;
            return panelOptionInfo;
        }
        return null;
    }

    public float calcBaseHeight(PanelOptionType panelOptionType, SNYEntities sNYEntities, TerraceInfo terraceInfo) {
        return this.calcBaseHeight(panelOptionType, sNYEntities, terraceInfo, null);
    }

    public float calcBaseHeight(PanelOptionType panelOptionType, SNYEntities sNYEntities, TerraceInfo terraceInfo, PanelInfo panelInfo) {
        float f = 0.0f;
        if (panelOptionType == PanelOptionType.INNER_SHADE) {
            f = this.calcInnerShadeBaseHeight(sNYEntities);
        } else if (panelOptionType == PanelOptionType.TOBUKURO_NIGE) {
            f = this.calcTobukuroNigeBaseHeight(sNYEntities);
        } else if (panelOptionType == PanelOptionType.KANKISEN) {
            f = this.calcKankisenBaseHeight(sNYEntities, terraceInfo, panelInfo);
        } else if (panelOptionType == PanelOptionType.STEP) {
            f = this.calcStepBaseHeight(sNYEntities);
        } else if (panelOptionType == PanelOptionType.ECOCARAT) {
            f = this.calcEcocaratBaseHeight(sNYEntities, terraceInfo, panelInfo);
        } else if (panelOptionType == PanelOptionType.YUKASHITA_MESH_KAKOI) {
            f = this.calcYukashitaMeshKakoiBaseHeight(sNYEntities);
        } else if (panelOptionType == PanelOptionType.ASHIGAKARI_BOUSHI_NET) {
            f = this.calcAshigakariBoushiNetBaseHeight(sNYEntities);
        } else if (panelOptionType == PanelOptionType.AMIDO) {
            f = this.calcAmidoBaseHeight(sNYEntities, terraceInfo, panelInfo);
        } else if (panelOptionType == PanelOptionType.NAKASAN) {
            f = this.calcNakasanBaseHeight(sNYEntities, terraceInfo, panelInfo);
        } else if (panelOptionType == PanelOptionType.RANMA_SLIDING) {
            f = this.calcRanmaSlidingBaseHeight(sNYEntities);
        } else if (panelOptionType == PanelOptionType.MEKAKUSHI_PANEL_SET) {
            f = this.calcMekakushiPanelSetBaseHeight(sNYEntities, terraceInfo, panelInfo);
        } else if (panelOptionType == PanelOptionType.SIDE_FENCE) {
            f = this.calcSideFenceBaseHeight(sNYEntities, terraceInfo);
        }
        return f;
    }

    private float calcInnerShadeBaseHeight(SNYEntities sNYEntities) {
        PartsFigureInfo partsFigureInfo = sNYEntities.mPartsFigureInfo;
        return partsFigureInfo.mMaeketaShitaToGL.floatValue();
    }

    private float calcTobukuroNigeBaseHeight(SNYEntities sNYEntities) {
        PartsFigureInfo partsFigureInfo = sNYEntities.mPartsFigureInfo;
        return partsFigureInfo.mOpeningLevel.floatValue() + TobukuroNige.HEIGHT_Z;
    }

    private float calcKankisenBaseHeight(SNYEntities sNYEntities, TerraceInfo terraceInfo, PanelInfo panelInfo) {
        float f = this.calcKankisenHeight();
        float f2 = this.getKankisenZ(sNYEntities, terraceInfo, panelInfo);
        return f2 - f / 2.0f;
    }

    private float calcStepBaseHeight(SNYEntities sNYEntities) {
        PartsFigureInfo partsFigureInfo = sNYEntities.mPartsFigureInfo;
        return partsFigureInfo.mDomaLevel.floatValue();
    }

    private float calcEcocaratBaseHeight(SNYEntities sNYEntities, TerraceInfo terraceInfo, PanelInfo panelInfo) {
        PartsFigureUnitInfo partsFigureUnitInfo = this.mPartsFigureService.findOnePartsFigureUnitInfo(sNYEntities.mPartsFigureUnitInfoList, terraceInfo);
        float f = this.mPartsFigureService.getOpeningLevel(partsFigureUnitInfo, panelInfo.mPanelDirectionType, panelInfo.mFrontPanelDirectionType);
        return (float)((double)f + 50.0);
    }

    private float calcYukashitaMeshKakoiBaseHeight(SNYEntities sNYEntities) {
        PartsFigureInfo partsFigureInfo = sNYEntities.mPartsFigureInfo;
        return partsFigureInfo.mDomaLevel.floatValue();
    }

    private float calcAshigakariBoushiNetBaseHeight(SNYEntities sNYEntities) {
        PartsFigureInfo partsFigureInfo = sNYEntities.mPartsFigureInfo;
        return partsFigureInfo.mOpeningLevel.floatValue();
    }

    private float calcAmidoBaseHeight(SNYEntities sNYEntities, TerraceInfo terraceInfo, PanelInfo panelInfo) {
        PartsFigureUnitInfo partsFigureUnitInfo = this.mPartsFigureService.findOnePartsFigureUnitInfo(sNYEntities.mPartsFigureUnitInfoList, terraceInfo);
        float f = this.mPartsFigureService.getOpeningLevel(partsFigureUnitInfo, panelInfo.mPanelDirectionType, panelInfo.mFrontPanelDirectionType);
        return f;
    }

    private float calcNakasanBaseHeight(SNYEntities sNYEntities, TerraceInfo terraceInfo, PanelInfo panelInfo) {
        PartsFigureUnitInfo partsFigureUnitInfo = this.mPartsFigureService.findOnePartsFigureUnitInfo(sNYEntities.mPartsFigureUnitInfoList, terraceInfo);
        float f = this.mPartsFigureService.getOpeningLevel(partsFigureUnitInfo, panelInfo.mPanelDirectionType, panelInfo.mFrontPanelDirectionType);
        return f + 989.0f - 30.0f;
    }

    private float calcRanmaSlidingBaseHeight(SNYEntities sNYEntities) {
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        FloorInfo floorInfo = sNYEntities.mFloorInfo;
        float f = this.calcRanmaSlidingHeight();
        return terracesInfo.mHeight.floatValue() - floorInfo.mFloorLevel.floatValue() - f;
    }

    private float calcMekakushiPanelSetBaseHeight(SNYEntities sNYEntities, TerraceInfo terraceInfo, PanelInfo panelInfo) {
        PartsFigureUnitInfo partsFigureUnitInfo = this.mPartsFigureService.findOnePartsFigureUnitInfo(sNYEntities.mPartsFigureUnitInfoList, terraceInfo);
        float f = this.mPartsFigureService.getOpeningLevel(partsFigureUnitInfo, panelInfo.mPanelDirectionType, panelInfo.mFrontPanelDirectionType);
        return (float)((double)f + 50.0);
    }

    private float calcSideFenceBaseHeight(SNYEntities sNYEntities, TerraceInfo terraceInfo) {
        PartsFigureInfo partsFigureInfo = sNYEntities.mPartsFigureInfo;
        return partsFigureInfo.mOpeningLevel.floatValue();
    }

    public float calcHeight(PanelOptionType panelOptionType, SNYEntities sNYEntities, TerraceInfo terraceInfo) {
        return this.calcHeight(panelOptionType, sNYEntities, terraceInfo, null);
    }

    public float calcHeight(PanelOptionType panelOptionType, SNYEntities sNYEntities, TerraceInfo terraceInfo, PanelInfo panelInfo) {
        return this.calcHeight(panelOptionType, sNYEntities, terraceInfo, panelInfo, null);
    }

    public float calcHeight(PanelOptionType panelOptionType, SNYEntities sNYEntities, TerraceInfo terraceInfo, PanelInfo panelInfo, PanelOptionInfo panelOptionInfo) {
        float f = 0.0f;
        if (panelOptionType == PanelOptionType.INNER_SHADE) {
            f = this.calcInnerShadeHeight(sNYEntities, terraceInfo);
        } else if (panelOptionType == PanelOptionType.TOBUKURO_NIGE) {
            f = this.calcTobukuroNigeHeight(sNYEntities);
        } else if (panelOptionType == PanelOptionType.KANKISEN) {
            f = this.calcKankisenHeight();
        } else if (panelOptionType == PanelOptionType.STEP) {
            f = this.calcStepHeight(sNYEntities);
        } else if (panelOptionType == PanelOptionType.ECOCARAT) {
            f = this.calcEcocaratHeight(sNYEntities, terraceInfo, panelInfo, panelOptionInfo);
        } else if (panelOptionType == PanelOptionType.YUKASHITA_MESH_KAKOI) {
            f = this.calcYukashitaMeshKakoiHeight();
        } else if (panelOptionType == PanelOptionType.ASHIGAKARI_BOUSHI_NET) {
            f = this.calcAshigakariBoushiNetHeight();
        } else if (panelOptionType == PanelOptionType.AMIDO) {
            f = this.calcAmidoHeight(sNYEntities, terraceInfo, panelInfo);
        } else if (panelOptionType == PanelOptionType.NAKASAN) {
            f = this.calcNakasanHeight();
        } else if (panelOptionType == PanelOptionType.RANMA_SLIDING) {
            f = this.calcRanmaSlidingHeight();
        } else if (panelOptionType == PanelOptionType.MEKAKUSHI_PANEL_SET) {
            f = this.calcMekakushiPanelSetHeight(sNYEntities, terraceInfo, panelInfo, panelOptionInfo);
        } else if (panelOptionType == PanelOptionType.SIDE_FENCE) {
            f = this.calcSideFenceHeight();
        }
        return f;
    }

    private float calcInnerShadeHeight(SNYEntities sNYEntities, TerraceInfo terraceInfo) {
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        return (float)((double)terracesInfo.mDepth.floatValue() * Math.tan(Math.toRadians(10.0)));
    }

    private float calcTobukuroNigeHeight(SNYEntities sNYEntities) {
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        float f = TobukuroNige.HEIGHT_H;
        if (terracesInfo.mDefaultHeight != terracesInfo.mHeight) {
            float f2 = terracesInfo.mDefaultHeight.floatValue() - terracesInfo.mHeight.floatValue();
            f -= f2;
        }
        return f;
    }

    private float calcKankisenHeight() {
        return 230.0f;
    }

    private float calcStepHeight(SNYEntities sNYEntities) {
        PartsFigureInfo partsFigureInfo = sNYEntities.mPartsFigureInfo;
        return partsFigureInfo.mFloorLevel.floatValue();
    }

    private float calcEcocaratHeight(SNYEntities sNYEntities, TerraceInfo terraceInfo, PanelInfo panelInfo, PanelOptionInfo panelOptionInfo) {
        float f = 0.0f;
        if (panelInfo == null || panelOptionInfo == null) {
            f = 904.0f;
        } else {
            LinkedList<PanelCutInfo> linkedList = this.mPanelCutCommonService.getPanelCutInfoList(sNYEntities, panelInfo.mPanelDirectionType);
            PanelCutCommonService.ClassifiedCutInfo classifiedCutInfo = this.mPanelCutCommonService.getClassifiedCutInfo(panelInfo, linkedList);
            if (panelOptionInfo.mHeightIndex == 0) {
                if (classifiedCutInfo.lowerCutInfo != null) {
                    f = (float)((double)(classifiedCutInfo.lowerCutInfo.mStandardHeight.floatValue() - classifiedCutInfo.lowerCutInfo.mCutHeight.floatValue()) - 50.0);
                }
            } else if (panelOptionInfo.mHeightIndex == 1 && classifiedCutInfo.upperCutInfo != null) {
                f = (float)((double)(classifiedCutInfo.upperCutInfo.mStandardHeight.floatValue() - classifiedCutInfo.upperCutInfo.mCutHeight.floatValue()) - 24.5);
            }
        }
        return f;
    }

    private float calcYukashitaMeshKakoiHeight() {
        return 323.0f;
    }

    private float calcAshigakariBoushiNetHeight() {
        return 950.0f;
    }

    private float calcAmidoHeight(SNYEntities sNYEntities, TerraceInfo terraceInfo, PanelInfo panelInfo) {
        PartsFigureUnitInfo partsFigureUnitInfo = this.mPartsFigureService.findOnePartsFigureUnitInfo(sNYEntities.mPartsFigureUnitInfoList, terraceInfo);
        return this.mPartsFigureService.calcPanelHeight(sNYEntities, partsFigureUnitInfo, panelInfo);
    }

    private float calcNakasanHeight() {
        return 60.0f;
    }

    private float calcRanmaSlidingHeight() {
        return 430.0f;
    }

    private float calcMekakushiPanelSetHeight(SNYEntities sNYEntities, TerraceInfo terraceInfo, PanelInfo panelInfo, PanelOptionInfo panelOptionInfo) {
        float f = 0.0f;
        if (panelInfo == null || panelOptionInfo == null) {
            f = 904.0f;
        } else {
            LinkedList<PanelCutInfo> linkedList = this.mPanelCutCommonService.getPanelCutInfoList(sNYEntities, panelInfo.mPanelDirectionType);
            PanelCutCommonService.ClassifiedCutInfo classifiedCutInfo = this.mPanelCutCommonService.getClassifiedCutInfo(panelInfo, linkedList);
            if (panelOptionInfo.mHeightIndex == 0) {
                if (classifiedCutInfo.lowerCutInfo != null) {
                    f = (float)((double)(classifiedCutInfo.lowerCutInfo.mStandardHeight.floatValue() - classifiedCutInfo.lowerCutInfo.mCutHeight.floatValue()) - 50.0);
                }
            } else if (panelOptionInfo.mHeightIndex == 1 && classifiedCutInfo.upperCutInfo != null) {
                f = (float)((double)(classifiedCutInfo.upperCutInfo.mStandardHeight.floatValue() - classifiedCutInfo.upperCutInfo.mCutHeight.floatValue()) - 24.5);
            }
        }
        return f;
    }

    private float calcSideFenceHeight() {
        return 1000.0f;
    }

    public float getKankisenZ(SNYEntities sNYEntities, TerraceInfo terraceInfo) {
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        boolean bl = basicInfo.mRanmaUseType == RanmaUseType.EXIST;
        return this.getKankisenZ(sNYEntities, terraceInfo, bl);
    }

    public float getKankisenZ(SNYEntities sNYEntities, TerraceInfo terraceInfo, PanelInfo panelInfo) {
        boolean bl = false;
        if (panelInfo != null) {
            bl = panelInfo.mRanmaUseType == RanmaUseType.EXIST;
        }
        return this.getKankisenZ(sNYEntities, terraceInfo, bl);
    }

    public float getKankisenZ(SNYEntities sNYEntities, TerraceInfo terraceInfo, DirectionType directionType) {
        boolean bl = false;
        if (directionType == DirectionType.LEFT) {
            bl = this.mSidePanelCommonService.hasRanma(sNYEntities.mLeftPanelInfoList);
        } else if (directionType == DirectionType.RIGHT) {
            bl = this.mSidePanelCommonService.hasRanma(sNYEntities.mRightPanelInfoList);
        }
        return this.getKankisenZ(sNYEntities, terraceInfo, bl);
    }

    public float getKankisenZ(SNYEntities sNYEntities, TerraceInfo terraceInfo, boolean bl) {
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        PartsFigureInfo partsFigureInfo = sNYEntities.mPartsFigureInfo;
        float f = 0.0f;
        if (bl) {
            f = partsFigureInfo.mRanmaHeight.floatValue();
        }
        float f2 = partsFigureInfo.mMaeketaShitaToGL.floatValue();
        f2 = basicInfo.mRoofFigureType == RoofFigureType.F ? (terraceInfo == null ? (f2 -= 210.0f) : (terraceInfo.mDepthType == TerraceDepthType.T3 || terraceInfo.mDepthType == TerraceDepthType.T4 || terraceInfo.mDepthType == TerraceDepthType.T5 || terraceInfo.mDepthType == TerraceDepthType.T6 ? (f2 -= 210.0f + f) : (terraceInfo.mDepthType == TerraceDepthType.T9 ? (basicInfo.mStrengthType == StrengthType.T600 ? (f2 += 348.0f) : (f2 += 358.0f)) : (f2 -= 210.0f + f)))) : (terraceInfo == null ? (basicInfo.mStrengthType == StrengthType.T600 ? (f2 += 246.0f) : (f2 += 281.0f)) : (terraceInfo.mDepthType == TerraceDepthType.T3 || terraceInfo.mDepthType == TerraceDepthType.T4 ? (f2 -= 210.0f + f) : (terraceInfo.mDepthType == TerraceDepthType.T5 || terraceInfo.mDepthType == TerraceDepthType.T6 ? (basicInfo.mStrengthType == StrengthType.T600 ? (f2 += 246.0f) : (f2 += 281.0f)) : (basicInfo.mStrengthType == StrengthType.T600 ? (f2 += 469.0f) : (f2 += 504.0f)))));
        return f2;
    }

    public float getKankisenY(TerraceInfo terraceInfo, RoofFigureType roofFigureType) {
        float f = -215.0f;
        if (roofFigureType == RoofFigureType.R && (terraceInfo.mDepthType == TerraceDepthType.T4 || terraceInfo.mDepthType == TerraceDepthType.T5 || terraceInfo.mDepthType == TerraceDepthType.T6)) {
            f = -180.0f;
        }
        return f;
    }
}

