/*
 * Decompiled with CFR 0.152.
 */
package option.loneterrace.shape.common.dao;

import com.kt.annotation.Reflectable;
import com.kt.util.tree.ObjectFolder;
import com.kt.util.tree.ObjectNode;
import java.util.Collection;
import java.util.LinkedList;
import option.gad.core.annotation.GdProperty;
import option.gad.core.dao.GdAbstractSaveFileDao;
import option.gad.core.inject.GdInject;
import option.gad.core.util.ObjectFolderUtil;
import option.loneterrace.common.dxo.SNYSaveDataConverter;
import option.loneterrace.common.entity.BasicInfo;
import option.loneterrace.common.entity.FloorInfo;
import option.loneterrace.common.entity.FrontPanelInfo;
import option.loneterrace.common.entity.FrontPanelOptionInfo;
import option.loneterrace.common.entity.IBasicInfo;
import option.loneterrace.common.entity.IFloorInfo;
import option.loneterrace.common.entity.IFrontPanelInfo;
import option.loneterrace.common.entity.IFrontPanelOptionInfo;
import option.loneterrace.common.entity.IPanelCutInfo;
import option.loneterrace.common.entity.ISidePanelInfo;
import option.loneterrace.common.entity.ISidePanelOptionInfo;
import option.loneterrace.common.entity.ITerraceInfo;
import option.loneterrace.common.entity.ITerracesInfo;
import option.loneterrace.common.entity.PanelCutInfo;
import option.loneterrace.common.entity.PartsFigureInfo;
import option.loneterrace.common.entity.PartsFigureUnitInfo;
import option.loneterrace.common.entity.SNYEntities;
import option.loneterrace.common.entity.SNYInfos;
import option.loneterrace.common.entity.SidePanelInfo;
import option.loneterrace.common.entity.SidePanelOptionInfo;
import option.loneterrace.common.entity.TerraceInfo;
import option.loneterrace.common.entity.TerracesInfo;
import option.loneterrace.shape.common.modelset.NodeNameSunnyge;
import option.loneterrace.shape.sunnyge.model.sunnyge.item.MsItemTerrace;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Reflectable
public abstract class SNYModelSetDao<PER, DOC, TSI extends ITerracesInfo, TI extends ITerraceInfo, BI extends IBasicInfo, FI extends IFloorInfo, FPI extends IFrontPanelInfo, FPIS extends Collection<FPI>, LSPI extends ISidePanelInfo, LSPIS extends Collection<LSPI>, RSPI extends ISidePanelInfo, RSPIS extends Collection<RSPI>, FPOI extends IFrontPanelOptionInfo, FPOIS extends Collection<FPOI>, LSPOI extends ISidePanelOptionInfo, LSPOIS extends Collection<LSPOI>, RSPOI extends ISidePanelOptionInfo, RSPOIS extends Collection<RSPOI>, FPCI extends IPanelCutInfo, FPCIS extends Collection<FPCI>, LSPCI extends IPanelCutInfo, LPCIS extends Collection<LSPCI>, RSPCI extends IPanelCutInfo, RPCIS extends Collection<RSPCI>>
extends GdAbstractSaveFileDao<PER, PER, DOC> {
    @GdInject
    private SNYSaveDataConverter mConverter;
    private static final Log mLog = LogFactory.getLog(SNYModelSetDao.class);

    protected SNYModelSetDao() {
    }

    public void save(ObjectFolder objectFolder, MsItemTerrace msItemTerrace) {
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        this.saveFolder(objectFolder, NodeNameSunnyge.BASICINFO.name(), sNYEntities.mBasicInfo);
        this.saveFolder(objectFolder, NodeNameSunnyge.FLOORINFO.name(), sNYEntities.mFloorInfo);
        this.saveFolders(objectFolder, NodeNameSunnyge.FRONTPANELINFOS.name(), NodeNameSunnyge.FRONTPANELINFO.name(), sNYEntities.mFrontPanelInfoList);
        this.saveFolders(objectFolder, NodeNameSunnyge.LEFTPANELINFOS.name(), NodeNameSunnyge.LEFTPANELINFO.name(), sNYEntities.mLeftPanelInfoList);
        this.saveFolders(objectFolder, NodeNameSunnyge.RIGHTPANELINFOS.name(), NodeNameSunnyge.RIGHTPANELINFO.name(), sNYEntities.mRightPanelInfoList);
        this.saveFolders(objectFolder, NodeNameSunnyge.FRONTPANELOPTIONINFOS.name(), NodeNameSunnyge.FRONTPANELOPTIONINFO.name(), sNYEntities.mFrontPanelOptionInfoList);
        this.saveFolders(objectFolder, NodeNameSunnyge.LEFTPANELOPTIONINFOS.name(), NodeNameSunnyge.LEFTPANELOPTIONINFO.name(), sNYEntities.mLeftPanelOptionInfoList);
        this.saveFolders(objectFolder, NodeNameSunnyge.RIGHTPANELOPTIONINFOS.name(), NodeNameSunnyge.RIGHTPANELOPTIONINFO.name(), sNYEntities.mRightPanelOptionInfoList);
        this.saveFolders(objectFolder, NodeNameSunnyge.FRONTPANELCUTINFOS.name(), NodeNameSunnyge.FRONTPANELCUTINFO.name(), sNYEntities.mFrontPanelCutInfoList);
        this.saveFolders(objectFolder, NodeNameSunnyge.LEFTPANELCUTINFOS.name(), NodeNameSunnyge.LEFTPANELCUTINFO.name(), sNYEntities.mLeftPanelCutInfoList);
        this.saveFolders(objectFolder, NodeNameSunnyge.RIGHTPANELCUTINFOS.name(), NodeNameSunnyge.RIGHTPANELCUTINFO.name(), sNYEntities.mRightPanelCutInfoList);
        ObjectFolder objectFolder2 = new ObjectFolder(NodeNameSunnyge.TERRACEINFOS.name());
        for (TerraceInfo terraceInfo : sNYEntities.mTerraceInfoList) {
            objectFolder2.addChild((ObjectNode)ObjectFolderUtil.createFolder((Object)terraceInfo, (String)NodeNameSunnyge.TERRACEINFO.name(), GdProperty.class), true);
        }
        ObjectFolderUtil.addObject((ObjectFolder)objectFolder2, (Object)sNYEntities.mTerracesInfo, GdProperty.class);
        objectFolder.addChild((ObjectNode)objectFolder2);
    }

    public void load(ObjectFolder objectFolder, MsItemTerrace msItemTerrace) {
        BI BI = this.loadBasicInfo(objectFolder);
        FI FI = this.loadFloorInfo(objectFolder);
        TSI TSI = this.loadTerracesInfo(objectFolder);
        Collection<TI> collection = this.loadTerraceInfos(objectFolder);
        Collection<FPI> collection2 = this.loadFrontPanelInfo(objectFolder);
        Collection<LSPI> collection3 = this.loadLeftPanelInfo(objectFolder);
        Collection<RSPI> collection4 = this.loadRighrPanelInfo(objectFolder);
        Collection<FPOI> collection5 = this.loadFrontPanelOptionInfo(objectFolder);
        Collection<LSPOI> collection6 = this.loadLeftPanelOptionInfo(objectFolder);
        Collection<RSPOI> collection7 = this.loadRighrPanelOptionInfo(objectFolder);
        Collection<FPCI> collection8 = this.loadFrontPanelCutInfo(objectFolder);
        Collection<LSPCI> collection9 = this.loadLeftPanelCutInfo(objectFolder);
        Collection<RSPCI> collection10 = this.loadRightPanelCutInfo(objectFolder);
        SNYInfos sNYInfos = SNYInfos.newInstance();
        sNYInfos.value1 = TSI;
        sNYInfos.value2 = collection;
        sNYInfos.value3 = BI;
        sNYInfos.value4 = collection2;
        sNYInfos.value5 = collection3;
        sNYInfos.value6 = collection4;
        sNYInfos.value7 = collection5;
        sNYInfos.value8 = collection6;
        sNYInfos.value9 = collection7;
        sNYInfos.value10 = collection8;
        sNYInfos.value11 = collection9;
        sNYInfos.value12 = collection10;
        sNYInfos.value13 = FI;
        this.repair((IBasicInfo)sNYInfos.value3, (ITerracesInfo)sNYInfos.value1, (Collection)sNYInfos.value2, (Collection)sNYInfos.value4, (Collection)sNYInfos.value5, (Collection)sNYInfos.value6, (Collection)sNYInfos.value7, (Collection)sNYInfos.value8, (Collection)sNYInfos.value9, (Collection)sNYInfos.value10, (Collection)sNYInfos.value11, (Collection)sNYInfos.value12, (IFloorInfo)sNYInfos.value13);
        SNYInfos sNYInfos2 = (SNYInfos)this.mConverter.convert(msItemTerrace.getVersion(), sNYInfos);
        this.restore(msItemTerrace, (BasicInfo)sNYInfos2.value3, (TerracesInfo)sNYInfos2.value1, (Collection)sNYInfos2.value2, (Collection)sNYInfos2.value4, (Collection)sNYInfos2.value5, (Collection)sNYInfos2.value6, (Collection)sNYInfos2.value7, (Collection)sNYInfos2.value8, (Collection)sNYInfos2.value9, (Collection)sNYInfos2.value10, (Collection)sNYInfos2.value11, (Collection)sNYInfos2.value12, (FloorInfo)sNYInfos2.value13);
    }

    protected BI loadBasicInfo(ObjectFolder objectFolder) {
        return (BI)((IBasicInfo)this.loadFolder(objectFolder, NodeNameSunnyge.BASICINFO.name()));
    }

    protected FI loadFloorInfo(ObjectFolder objectFolder) {
        return (FI)((IFloorInfo)this.loadFolder(objectFolder, NodeNameSunnyge.FLOORINFO.name()));
    }

    protected Collection<FPI> loadFrontPanelInfo(ObjectFolder objectFolder) {
        return this.loadFolders(objectFolder, NodeNameSunnyge.FRONTPANELINFOS.name(), NodeNameSunnyge.FRONTPANELINFO.name());
    }

    protected Collection<LSPI> loadLeftPanelInfo(ObjectFolder objectFolder) {
        return this.loadFolders(objectFolder, NodeNameSunnyge.LEFTPANELINFOS.name(), NodeNameSunnyge.LEFTPANELINFO.name());
    }

    protected Collection<RSPI> loadRighrPanelInfo(ObjectFolder objectFolder) {
        return this.loadFolders(objectFolder, NodeNameSunnyge.RIGHTPANELINFOS.name(), NodeNameSunnyge.RIGHTPANELINFO.name());
    }

    protected Collection<FPOI> loadFrontPanelOptionInfo(ObjectFolder objectFolder) {
        return this.loadFolders(objectFolder, NodeNameSunnyge.FRONTPANELOPTIONINFOS.name(), NodeNameSunnyge.FRONTPANELOPTIONINFO.name());
    }

    protected Collection<LSPOI> loadLeftPanelOptionInfo(ObjectFolder objectFolder) {
        return this.loadFolders(objectFolder, NodeNameSunnyge.LEFTPANELOPTIONINFOS.name(), NodeNameSunnyge.LEFTPANELOPTIONINFO.name());
    }

    protected Collection<RSPOI> loadRighrPanelOptionInfo(ObjectFolder objectFolder) {
        return this.loadFolders(objectFolder, NodeNameSunnyge.RIGHTPANELOPTIONINFOS.name(), NodeNameSunnyge.RIGHTPANELOPTIONINFO.name());
    }

    protected Collection<FPCI> loadFrontPanelCutInfo(ObjectFolder objectFolder) {
        return this.loadFolders(objectFolder, NodeNameSunnyge.FRONTPANELCUTINFOS.name(), NodeNameSunnyge.FRONTPANELCUTINFO.name());
    }

    protected Collection<LSPCI> loadLeftPanelCutInfo(ObjectFolder objectFolder) {
        return this.loadFolders(objectFolder, NodeNameSunnyge.LEFTPANELCUTINFOS.name(), NodeNameSunnyge.LEFTPANELCUTINFO.name());
    }

    protected Collection<RSPCI> loadRightPanelCutInfo(ObjectFolder objectFolder) {
        return this.loadFolders(objectFolder, NodeNameSunnyge.RIGHTPANELCUTINFOS.name(), NodeNameSunnyge.RIGHTPANELCUTINFO.name());
    }

    protected TSI loadTerracesInfo(ObjectFolder objectFolder) {
        return (TSI)((ITerracesInfo)this.loadFolder(objectFolder, NodeNameSunnyge.TERRACEINFOS.name()));
    }

    protected Collection<TI> loadTerraceInfos(ObjectFolder objectFolder) {
        ObjectFolder objectFolder22;
        Collection collection = ObjectFolderUtil.findChildFolders((ObjectFolder)objectFolder, (String)NodeNameSunnyge.TERRACEINFO.name());
        ObjectFolder objectFolder3 = new ObjectFolder(NodeNameSunnyge.TERRACEINFOS.name());
        objectFolder3.addChild(new ObjectNode("type", (Object)"java.util.ArrayList"));
        for (ObjectFolder objectFolder22 : collection) {
            objectFolder3.addChild((ObjectNode)objectFolder22, true);
        }
        objectFolder22 = new ObjectFolder("root");
        objectFolder22.addChild((ObjectNode)objectFolder3);
        return this.loadFolders(objectFolder22, NodeNameSunnyge.TERRACEINFOS.name(), NodeNameSunnyge.TERRACEINFO.name(), TerraceInfo.class);
    }

    protected void repair(BI BI, TSI TSI, Collection<TI> collection, Collection<FPI> collection2, Collection<LSPI> collection3, Collection<RSPI> collection4, Collection<FPOI> collection5, Collection<LSPOI> collection6, Collection<RSPOI> collection7, Collection<FPCI> collection8, Collection<LSPCI> collection9, Collection<RSPCI> collection10, FI FI) {
    }

    protected void restore(MsItemTerrace msItemTerrace, BasicInfo basicInfo, TerracesInfo terracesInfo, Collection<TerraceInfo> collection, Collection<FrontPanelInfo> collection2, Collection<SidePanelInfo> collection3, Collection<SidePanelInfo> collection4, Collection<FrontPanelOptionInfo> collection5, Collection<SidePanelOptionInfo> collection6, Collection<SidePanelOptionInfo> collection7, Collection<PanelCutInfo> collection8, Collection<PanelCutInfo> collection9, Collection<PanelCutInfo> collection10, FloorInfo floorInfo) {
        SNYEntities sNYEntities = msItemTerrace.getEntities();
        sNYEntities.mBasicInfo = basicInfo;
        sNYEntities.mTerracesInfo = terracesInfo;
        sNYEntities.mTerraceInfoList = new LinkedList<TerraceInfo>(collection);
        sNYEntities.mFrontPanelInfoList = new LinkedList<FrontPanelInfo>(collection2);
        sNYEntities.mLeftPanelInfoList = new LinkedList<SidePanelInfo>(collection3);
        sNYEntities.mRightPanelInfoList = new LinkedList<SidePanelInfo>(collection4);
        sNYEntities.mFrontPanelOptionInfoList = new LinkedList<FrontPanelOptionInfo>(collection5);
        sNYEntities.mLeftPanelOptionInfoList = new LinkedList<SidePanelOptionInfo>(collection6);
        sNYEntities.mRightPanelOptionInfoList = new LinkedList<SidePanelOptionInfo>(collection7);
        sNYEntities.mFrontPanelCutInfoList = new LinkedList<PanelCutInfo>(collection8);
        sNYEntities.mLeftPanelCutInfoList = new LinkedList<PanelCutInfo>(collection9);
        sNYEntities.mRightPanelCutInfoList = new LinkedList<PanelCutInfo>(collection10);
        sNYEntities.mFloorInfo = floorInfo;
        sNYEntities.mPartsFigureInfo = new PartsFigureInfo();
        for (TerraceInfo terraceInfo : sNYEntities.mTerraceInfoList) {
            PartsFigureUnitInfo partsFigureUnitInfo = new PartsFigureUnitInfo();
            partsFigureUnitInfo.mId = terraceInfo.mId;
            sNYEntities.mPartsFigureUnitInfoList.add(partsFigureUnitInfo);
        }
    }
}

