/*
 * Decompiled with CFR 0.152.
 */
package option.loneterrace.common.service.parts;

import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import option.gad.core.inject.GdInject;
import option.gad.core.util.GdMutableTypeUtil;
import option.gad.core.util.NumberUtil;
import option.loneterrace.common.dao.cache.type.TypeTerraceDepthCacheDao;
import option.loneterrace.common.dao.cache.type.TypeTerraceWidthCacheDao;
import option.loneterrace.common.dxo.DirectionTypeDxo;
import option.loneterrace.common.entity.BasicInfo;
import option.loneterrace.common.entity.Constants;
import option.loneterrace.common.entity.FloorInfo;
import option.loneterrace.common.entity.SNYEntities;
import option.loneterrace.common.entity.TerraceInfo;
import option.loneterrace.common.entity.TerracesInfo;
import option.loneterrace.common.entity.type.TypeTerraceDepthInfo;
import option.loneterrace.common.entity.type.TypeTerraceWidthInfo;
import option.loneterrace.common.service.parts.SidePanelFigureCommonService;
import option.loneterrace.common.service.parts.TerraceCommonService;
import option.loneterrace.common.type.BuildingType;
import option.loneterrace.common.type.DirectionType;
import option.loneterrace.common.type.EnforcementDirType;
import option.loneterrace.common.type.EnforcementType;
import option.loneterrace.common.type.KenType;
import option.loneterrace.common.type.RoofFigureType;
import option.loneterrace.common.type.SodePosType;
import option.loneterrace.common.type.StrengthType;
import option.loneterrace.common.type.SubProductType;
import option.loneterrace.common.type.TerraceDepthType;
import option.loneterrace.common.type.TerraceHeightType;
import option.loneterrace.common.type.TerraceWidthType;

public class TerraceFigureCommonService {
    @GdInject
    protected Constants mConstants;
    @GdInject
    protected TerraceCommonService mTerraceCommonService;
    @GdInject
    protected SidePanelFigureCommonService mSidePanelFigureCommonService;
    @GdInject
    protected TypeTerraceWidthCacheDao mTypeTerraceWidthCacheDao;
    @GdInject
    protected TypeTerraceDepthCacheDao mTypeTerraceDepthCacheDao;
    public static final float FL_OPENING_DIFF = 50.0f;
    public static final float ALMI_BALCONY_FL_OPENING_DIFF = 56.0f;
    public static final float PILLAR_WIDTH = 70.0f;
    public static final float ADJUST_KUTAI_WAKU = 15.0f;

    public TerraceDepthType getFrameDepthType(TerraceInfo terraceInfo, DirectionType directionType) {
        TerraceDepthType terraceDepthType = null;
        terraceDepthType = directionType == DirectionType.LEFT ? terraceInfo.mLeftDepthType : (directionType == DirectionType.RIGHT ? terraceInfo.mRightDepthType : terraceInfo.mDepthType);
        return terraceDepthType;
    }

    public float getDefaultFrameDepth(SNYEntities sNYEntities, DirectionType directionType) {
        TerraceInfo terraceInfo = this.mTerraceCommonService.getEdgeTerraceInfo(sNYEntities, directionType);
        return this.getDefaultFrameDepth(sNYEntities, terraceInfo, directionType);
    }

    public float getDefaultFrameDepth(SNYEntities sNYEntities, TerraceInfo terraceInfo, DirectionType directionType) {
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        TerraceDepthType terraceDepthType = this.getFrameDepthType(terraceInfo, directionType);
        TypeTerraceDepthInfo typeTerraceDepthInfo = this.mTypeTerraceDepthCacheDao.findOnePartsByType(terraceDepthType, basicInfo.mSubProductType);
        return typeTerraceDepthInfo.length.floatValue();
    }

    public float getFrameDepth(SNYEntities sNYEntities, DirectionType directionType) {
        TerraceInfo terraceInfo = this.mTerraceCommonService.getEdgeTerraceInfo(sNYEntities, directionType);
        return this.getFrameDepth(terraceInfo, directionType);
    }

    public float getFrameDepth(TerraceInfo terraceInfo, DirectionType directionType) {
        float f = 0.0f;
        f = directionType == DirectionType.LEFT ? terraceInfo.mLeftDepth.floatValue() : (directionType == DirectionType.RIGHT ? terraceInfo.mRightDepth.floatValue() : terraceInfo.mDepth.floatValue());
        return f;
    }

    public float calcTurningAngle(List<TerraceInfo> list, int n) {
        float f = 0.0f;
        int n2 = 0;
        while (n2 < list.size()) {
            TerraceInfo terraceInfo = list.get(n2);
            if (n2 == 0) {
                f += ((Float)NumberUtil.emptyToDefault((Object)terraceInfo.mTurningAngle, (Object)Float.valueOf(0.0f))).floatValue();
            }
            if (terraceInfo.mId.equals(n)) break;
            if (n2 > 0) {
                f += ((Float)NumberUtil.emptyToDefault((Object)terraceInfo.mTurningAngle, (Object)Float.valueOf(0.0f))).floatValue();
            }
            ++n2;
        }
        return f;
    }

    public float calcWidth(TerracesInfo terracesInfo, TerraceInfo terraceInfo) {
        return this.calcWidth(terracesInfo, terraceInfo, terraceInfo.mDefaultWidth.floatValue(), terraceInfo.mCutWidth.floatValue());
    }

    public float calcWidth(TerracesInfo terracesInfo, TerraceInfo terraceInfo, float f, float f2) {
        float f3 = f - f2;
        if (terraceInfo.mIsLeftEnd.booleanValue() && GdMutableTypeUtil.matchOR(terracesInfo.mSodePosType, SodePosType.L, SodePosType.BOTH)) {
            f3 -= terraceInfo.mLeftKutaiPillarWidth.floatValue() + this.mConstants.openingPillarHalfWidth.floatValue();
        }
        if (terraceInfo.mIsRightEnd.booleanValue() && GdMutableTypeUtil.matchOR(terracesInfo.mSodePosType, SodePosType.R, SodePosType.BOTH)) {
            f3 -= terraceInfo.mRightKutaiPillarWidth.floatValue() + this.mConstants.openingPillarHalfWidth.floatValue();
        }
        return f3;
    }

    public float calcOpeningWidth(TerracesInfo terracesInfo, TerraceInfo terraceInfo) {
        float f = this.calcWidth(terracesInfo, terraceInfo);
        if (terracesInfo.mEnforcementType == EnforcementType.DESUMI) {
            if (terraceInfo.mIsStarting.booleanValue()) {
                f += this.mConstants.kutaiPillarWidthForDesumi.floatValue() + terraceInfo.mDepth.floatValue();
            }
        } else if (terracesInfo.mEnforcementType == EnforcementType.IRISUMI && terraceInfo.mIsStarting.booleanValue()) {
            f += this.mConstants.cornerAddWidthForIrisumi.floatValue() - this.mConstants.openingPillarHalfWidth.floatValue();
        }
        return f -= this.mConstants.openingPillarHalfWidth.floatValue() * 2.0f;
    }

    public float calcGroupWidth(TerracesInfo terracesInfo, List<TerraceInfo> list, int n) {
        return this.calcGroupWidth(terracesInfo, list, n, true);
    }

    public float calcGroupWidth(TerracesInfo terracesInfo, List<TerraceInfo> list, int n, boolean bl) {
        return this.calcGroupWidth(terracesInfo, list, n, bl, true);
    }

    public float calcGroupWidth(TerracesInfo terracesInfo, List<TerraceInfo> list, int n, boolean bl, boolean bl2) {
        float f = 0.0f;
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MIN_VALUE;
        for (TerraceInfo terraceInfo : list) {
            if (!terraceInfo.mGroupId.equals(n)) continue;
            f += terraceInfo.mWidth.floatValue();
            n2 = Math.min(n2, terraceInfo.mId);
            n3 = Math.max(n3, terraceInfo.mId);
        }
        if (bl) {
            for (TerraceInfo terraceInfo : list) {
                if (terraceInfo.mId.equals(n2 - 1) && terraceInfo.mBuildingType == BuildingType.CORNER) {
                    f += terraceInfo.mWidth.floatValue();
                }
                if (!terraceInfo.mId.equals(n3 + 1) || terraceInfo.mBuildingType != BuildingType.CORNER) continue;
                f += terraceInfo.mWidth.floatValue();
            }
        }
        if (bl2) {
            if (terracesInfo.mEnforcementType == EnforcementType.DESUMI) {
                f += this.mConstants.kutaiPillarWidthForDesumi.floatValue();
            } else if (terracesInfo.mEnforcementType == EnforcementType.IRISUMI) {
                f += this.mConstants.cornerAddWidthForIrisumi.floatValue();
            }
        }
        return f;
    }

    public float calcTotalWidth(TerracesInfo terracesInfo, List<TerraceInfo> list, boolean bl, boolean bl2) {
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        for (TerraceInfo terraceInfo : list) {
            treeSet.add(terraceInfo.mGroupId);
        }
        float f = 0.0f;
        for (Integer n : treeSet) {
            f += this.calcGroupWidth(terracesInfo, list, n, bl, bl2);
        }
        return f;
    }

    public float calcTotalBalconyWidth(List<TerraceInfo> list) {
        float f = 0.0f;
        for (TerraceInfo terraceInfo : list) {
            if (terraceInfo.mBuildingType != BuildingType.BALCONY) continue;
            f = terraceInfo.mWidth.floatValue();
        }
        return f;
    }

    public float calcDefaultDepthInner(SNYEntities sNYEntities, DirectionType directionType) {
        float f = this.getDefaultFrameDepth(sNYEntities, directionType);
        return f - 35.0f;
    }

    public float calcDepthInner(SNYEntities sNYEntities) {
        return this.calcDepthInner(sNYEntities, null);
    }

    public float calcDepthInner(SNYEntities sNYEntities, DirectionType directionType) {
        float f = this.getFrameDepth(sNYEntities, directionType);
        return f - 35.0f;
    }

    public float calcDepthGap(SNYEntities sNYEntities, DirectionType directionType) {
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        float f = this.getFrameDepth(sNYEntities, directionType);
        float f2 = 0.0f;
        if (terracesInfo.mEnforcementType == EnforcementType.KUTAI_DEHABA_CHIGAI) {
            f2 = terracesInfo.mDepth.floatValue() - f;
        }
        return f2;
    }

    public int calcFrontHalfSpanNum(SNYEntities sNYEntities) {
        return this.calcFrontHalfSpanNum(sNYEntities, true, true);
    }

    public int calcFrontHalfSpanNum(SNYEntities sNYEntities, boolean bl, boolean bl2) {
        LinkedList<TerraceInfo> linkedList = sNYEntities.mTerraceInfoList;
        int n = 0;
        for (TerraceInfo terraceInfo : linkedList) {
            if (terraceInfo.mBuildingType == BuildingType.CORNER || terraceInfo.mBuildingType == BuildingType.BALCONY) continue;
            n += this.calcFrontHalfSpanNum(sNYEntities, terraceInfo, bl, bl2);
        }
        return n;
    }

    public int calcFrontHalfSpanNum(SNYEntities sNYEntities, TerraceInfo terraceInfo) {
        return this.calcFrontHalfSpanNum(sNYEntities, terraceInfo, true, true);
    }

    public int calcLeftFrontHalfSpanNum(SNYEntities sNYEntities, TerraceInfo terraceInfo) {
        return this.calcFrontHalfSpanNum(sNYEntities, terraceInfo, true, false);
    }

    public int calcRightFrontHalfSpanNum(SNYEntities sNYEntities, TerraceInfo terraceInfo) {
        return this.calcFrontHalfSpanNum(sNYEntities, terraceInfo, false, true);
    }

    public int calcFrontHalfSpanNum(SNYEntities sNYEntities, TerraceInfo terraceInfo, boolean bl, boolean bl2) {
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        if (GdMutableTypeUtil.matchOR(basicInfo.mSubProductType, SubProductType.OPEN)) {
            return 0;
        }
        int n = 0;
        TerraceWidthType terraceWidthType = null;
        if (terracesInfo.mEnforcementType == EnforcementType.BUBUN_KAKOI && basicInfo.mSubProductType != SubProductType.TSUKURITSUKE) {
            if (terraceInfo.mId < 0) {
                if (bl) {
                    terraceWidthType = terraceInfo.mWidthType;
                }
            } else if (terraceInfo.mId == 0) {
                if (bl && bl2) {
                    terraceWidthType = terraceInfo.mWidthType;
                } else if (bl && !bl2) {
                    terraceWidthType = terraceInfo.mLeftWidthType;
                } else if (!bl && bl2) {
                    terraceWidthType = terraceInfo.mRightWidthType;
                }
            } else if (terraceInfo.mId > 0 && bl2) {
                terraceWidthType = terraceInfo.mWidthType;
            }
        } else if (terracesInfo.mEnforcementType == EnforcementType.DOMA_YUKA_W) {
            if (terraceInfo.mId < 0) {
                terraceWidthType = terraceInfo.mWidthType;
            } else if (terraceInfo.mId == 0) {
                if (bl && bl2) {
                    terraceWidthType = terraceInfo.mWidthType;
                } else if (bl && !bl2) {
                    terraceWidthType = terraceInfo.mLeftWidthType;
                } else if (!bl && bl2) {
                    terraceWidthType = terraceInfo.mRightWidthType;
                }
            } else if (terraceInfo.mId > 0) {
                terraceWidthType = terraceInfo.mWidthType;
            }
        } else {
            float f = terraceInfo.mOpeningWidth.floatValue() + this.mConstants.openingPillarHalfWidth.floatValue() * 2.0f;
            TypeTerraceWidthInfo typeTerraceWidthInfo = this.mTypeTerraceWidthCacheDao.findOneByLength(Float.valueOf(f), basicInfo.mKenType);
            n = typeTerraceWidthInfo.span;
        }
        if (n == 0 && terraceWidthType != null && terraceWidthType != TerraceWidthType.T00) {
            TypeTerraceWidthInfo typeTerraceWidthInfo = this.mTypeTerraceWidthCacheDao.findOneByType(terraceWidthType, basicInfo.mKenType);
            n = typeTerraceWidthInfo.span;
        }
        return n;
    }

    public int calcFrontSpanNum(TerraceWidthType terraceWidthType, KenType kenType) {
        TypeTerraceWidthInfo typeTerraceWidthInfo = this.mTypeTerraceWidthCacheDao.findOneByType(terraceWidthType, kenType);
        return typeTerraceWidthInfo.span;
    }

    public int calcLeftSpanNum(SNYEntities sNYEntities, boolean bl) {
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        if (GdMutableTypeUtil.matchOR(terracesInfo.mSodePosType, SodePosType.L, SodePosType.BOTH) && terracesInfo.mEnforcementType != EnforcementType.BUBUN_IRISUMI) {
            return 0;
        }
        return this.calcSideSpanNum(sNYEntities.mTerraceInfoList.getFirst().mLeftDepth.floatValue(), sNYEntities.mBasicInfo, bl);
    }

    public int calcRightSpanNum(SNYEntities sNYEntities, boolean bl) {
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        if (GdMutableTypeUtil.matchOR(terracesInfo.mSodePosType, SodePosType.R, SodePosType.BOTH) && terracesInfo.mEnforcementType != EnforcementType.BUBUN_IRISUMI) {
            return 0;
        }
        return this.calcSideSpanNum(sNYEntities.mTerraceInfoList.getLast().mRightDepth.floatValue(), sNYEntities.mBasicInfo, bl);
    }

    public int calcSideSpanNum(float f, BasicInfo basicInfo, boolean bl) {
        return this.calcSideSpanNum(f, basicInfo.mSubProductType, bl);
    }

    public int calcSideSpanNum(float f, SubProductType subProductType, boolean bl) {
        if (GdMutableTypeUtil.matchOR(subProductType, SubProductType.OPEN)) {
            return 0;
        }
        if (!bl && GdMutableTypeUtil.matchOR(subProductType, SubProductType.HALF_KAKOI)) {
            TypeTerraceDepthInfo typeTerraceDepthInfo = this.mTypeTerraceDepthCacheDao.findOneStdByType(TerraceDepthType.T4);
            f = typeTerraceDepthInfo.length.floatValue();
        }
        return this.calcSideSpanNum(f);
    }

    public int calcSideSpanNum(float f) {
        TypeTerraceDepthInfo typeTerraceDepthInfo = this.mTypeTerraceDepthCacheDao.findOneStdByLength(Float.valueOf(f));
        return typeTerraceDepthInfo.span;
    }

    public double calcRoofHeight(SNYEntities sNYEntities) {
        TerraceInfo terraceInfo = this.mTerraceCommonService.findMasterTerraceInfo(sNYEntities.mTerraceInfoList);
        return this.calcRoofHeight(sNYEntities, terraceInfo, DirectionType.LEFT);
    }

    public double calcRoofHeight(SNYEntities sNYEntities, TerraceInfo terraceInfo, DirectionType directionType) {
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        double d = 10.0;
        double d2 = Math.tan(Math.toRadians(d));
        float f = this.getFrameDepth(terraceInfo, directionType);
        double d3 = (double)f * d2;
        double d4 = 0.0;
        if (basicInfo.mRoofFigureType == RoofFigureType.F) {
            d4 = basicInfo.mStrengthType == StrengthType.T600 ? 152.5 : 172.58;
        } else if (basicInfo.mRoofFigureType == RoofFigureType.R) {
            d4 = basicInfo.mStrengthType == StrengthType.T600 ? 273.5 : 308.5;
        }
        double d5 = d3 + d4;
        return d5;
    }

    public float calcH2(BasicInfo basicInfo, FloorInfo floorInfo) {
        float f = 0.0f;
        if (floorInfo.mFloorLevel.floatValue() > 50.0f && !GdMutableTypeUtil.matchOR(basicInfo.mSubProductType, SubProductType.ALMI_BALCONY_PILLAR, SubProductType.ALMI_BALCONY_ROOF)) {
            f = floorInfo.mFloorLevel.floatValue() - 50.0f;
        }
        return f;
    }

    public float getTsumadarukiHeight(TerraceHeightType terraceHeightType) {
        float f = 0.0f;
        if (terraceHeightType == TerraceHeightType.STD) {
            f = 2587.0f;
        } else if (terraceHeightType == TerraceHeightType.LONG) {
            f = 3287.0f;
        }
        return f;
    }

    public float calcYukaX1(SNYEntities sNYEntities, TerraceInfo terraceInfo, float f) {
        float f2 = this.calcAdjustXForKakoi(sNYEntities, terraceInfo);
        return f + f2;
    }

    public float calcYukaX2(SNYEntities sNYEntities, TerraceInfo terraceInfo, float f) {
        return this.calcYukaX1(sNYEntities, terraceInfo, f) + this.calcYukaWidth(sNYEntities, terraceInfo);
    }

    public float calcYukaWidth(SNYEntities sNYEntities, TerraceInfo terraceInfo) {
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        if (basicInfo.mSubProductType == SubProductType.TSUKURITSUKE) {
            return 0.0f;
        }
        if (basicInfo.mSubProductType == SubProductType.DOMA) {
            return 0.0f;
        }
        float f = 0.0f;
        if (terracesInfo.mEnforcementType == EnforcementType.BUBUN_KAKOI) {
            if (terracesInfo.mEnforcementDirType == EnforcementDirType.L) {
                if (terraceInfo.mId < 0) {
                    f = terraceInfo.mWidth.floatValue();
                } else if (terraceInfo.mId == 0) {
                    f = terraceInfo.mLeftWidth.floatValue();
                } else {
                    terraceInfo.mId.intValue();
                }
            } else if (terracesInfo.mEnforcementDirType == EnforcementDirType.R && terraceInfo.mId >= 0) {
                if (terraceInfo.mId == 0) {
                    f = terraceInfo.mRightWidth.floatValue();
                } else if (terraceInfo.mId > 0) {
                    f = terraceInfo.mWidth.floatValue();
                }
            }
        } else if (terracesInfo.mEnforcementType == EnforcementType.DOMA_YUKA_W) {
            if (terracesInfo.mEnforcementDirType == EnforcementDirType.L) {
                if (terraceInfo.mId >= 0) {
                    if (terraceInfo.mId == 0) {
                        f = terraceInfo.mRightWidth.floatValue();
                    } else if (terraceInfo.mId > 0) {
                        f = terraceInfo.mWidth.floatValue();
                    }
                }
            } else if (terracesInfo.mEnforcementDirType == EnforcementDirType.R) {
                if (terraceInfo.mId < 0) {
                    f = terraceInfo.mWidth.floatValue();
                } else if (terraceInfo.mId == 0) {
                    f = terraceInfo.mLeftWidth.floatValue();
                } else {
                    terraceInfo.mId.intValue();
                }
            }
        } else {
            f = terraceInfo.mWidth.floatValue();
        }
        return f;
    }

    public float calcAdjustXForKakoi(SNYEntities sNYEntities, TerraceInfo terraceInfo) {
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        float f = 0.0f;
        if (terraceInfo.mIsMaster.booleanValue() && terracesInfo.mEnforcementType == EnforcementType.BUBUN_KAKOI && basicInfo.mSubProductType != SubProductType.TSUKURITSUKE && terracesInfo.mEnforcementDirType == EnforcementDirType.R) {
            f = terraceInfo.mLeftWidth.floatValue();
        }
        return f;
    }

    public float calcAdjustYForHalfKakoi(SNYEntities sNYEntities, int n) {
        DirectionType directionType = DirectionTypeDxo.convert(n);
        return this.calcAdjustYForHalfKakoi(sNYEntities, directionType);
    }

    public float calcAdjustYForHalfKakoi(SNYEntities sNYEntities, DirectionType directionType) {
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        TerraceInfo terraceInfo = this.mTerraceCommonService.getEdgeTerraceInfo(sNYEntities, directionType);
        int n = directionType == DirectionType.LEFT ? 1 : -1;
        float f = 0.0f;
        if (basicInfo.mSubProductType == SubProductType.HALF_KAKOI) {
            TypeTerraceDepthInfo typeTerraceDepthInfo = this.mTypeTerraceDepthCacheDao.findOneStdByType(terraceInfo.mFrontDepthType);
            f = this.mSidePanelFigureCommonService.calcOpeningWidth(sNYEntities, (int)typeTerraceDepthInfo.span, n) + 35.0f;
        }
        return f;
    }

    public float calcAdjustYForTsukuritsukeBubunKakoi(SNYEntities sNYEntities, DirectionType directionType) {
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        float f = 0.0f;
        if (terracesInfo.mEnforcementType == EnforcementType.BUBUN_KAKOI && basicInfo.mSubProductType == SubProductType.TSUKURITSUKE) {
            if (terracesInfo.mEnforcementDirType == EnforcementDirType.L) {
                if (directionType == DirectionType.RIGHT) {
                    f = terracesInfo.mDepth.floatValue() - terracesInfo.mKutaiCoping.floatValue();
                }
            } else if (terracesInfo.mEnforcementDirType == EnforcementDirType.R && directionType == DirectionType.LEFT) {
                f = terracesInfo.mDepth.floatValue() - terracesInfo.mKutaiCoping.floatValue();
            }
        }
        return f;
    }

    public float calcMaxBubunIrisumi(float f) {
        return f - 255.0f;
    }

    public float calcMaxKutaiCoping(float f) {
        return f - 83.0f;
    }

    public float calcMinKutaiCoping(float f) {
        return f - 112.0f;
    }
}

