/*
 * Decompiled with CFR 0.152.
 */
package option.loneterrace.common.service.parts;

import com.kt.annotation.Reflectable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import option.gad.core.inject.GdInject;
import option.gad.core.util.GdMutableTypeUtil;
import option.gad.core.util.Tuple;
import option.loneterrace.common.dao.cache.type.TypeTerraceDepthCacheDao;
import option.loneterrace.common.dao.cache.type.TypeTerraceWidthCacheDao;
import option.loneterrace.common.entity.BasicInfo;
import option.loneterrace.common.entity.Constants;
import option.loneterrace.common.entity.SNYEntities;
import option.loneterrace.common.entity.TerraceInfo;
import option.loneterrace.common.entity.TerracesInfo;
import option.loneterrace.common.entity.type.TypeTerraceDepthInfo;
import option.loneterrace.common.entity.type.TypeTerraceWidthInfo;
import option.loneterrace.common.service.common.EnforcementCommonService;
import option.loneterrace.common.service.cut.PanelCutCommonService;
import option.loneterrace.common.service.floor.DomaTileCommonService;
import option.loneterrace.common.service.material.TerraceInfoService;
import option.loneterrace.common.type.BuildingType;
import option.loneterrace.common.type.DirectionType;
import option.loneterrace.common.type.EnforcementDirType;
import option.loneterrace.common.type.EnforcementType;
import option.loneterrace.common.type.FloorArrangementType;
import option.loneterrace.common.type.PanelDirectionType;
import option.loneterrace.common.type.SubProductType;
import option.loneterrace.common.type.TerraceDepthType;
import option.loneterrace.common.type.TerraceWidthType;
import option.loneterrace.common.type.factory.TerraceDepthTypeFactory;
import option.loneterrace.common.type.factory.TerraceWidthTypeFactory;

@Reflectable
public class TerraceCommonService {
    @GdInject
    protected Constants mConstants;
    @GdInject
    protected TerraceInfoService mTerraceInfoService;
    @GdInject
    protected EnforcementCommonService mEnforcementCommonService;
    @GdInject
    protected PanelCutCommonService mPanelCutCommonService;
    @GdInject
    protected DomaTileCommonService mDomaTileAppletService;
    @GdInject
    protected TypeTerraceDepthCacheDao mTypeTerraceDepthCacheDao;
    @GdInject
    protected TypeTerraceWidthCacheDao mTypeTerraceWidthCacheDao;
    private static final float DEPTH_MINUS_DIFF = 15.0f;

    public TerraceInfo getEdgeTerraceInfo(SNYEntities sNYEntities, DirectionType directionType) {
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        LinkedList<TerraceInfo> linkedList = sNYEntities.mTerraceInfoList;
        TerraceInfo terraceInfo = null;
        terraceInfo = terracesInfo.mEnforcementType == EnforcementType.BUBUN_KAKOI && basicInfo.mSubProductType == SubProductType.TSUKURITSUKE && terracesInfo.mEnforcementDirType == EnforcementDirType.L ? (directionType == DirectionType.LEFT ? linkedList.getFirst() : (directionType == DirectionType.RIGHT ? linkedList.get(linkedList.size() - 2) : this.findMasterTerraceInfo(linkedList))) : (terracesInfo.mEnforcementType == EnforcementType.BUBUN_KAKOI && basicInfo.mSubProductType == SubProductType.TSUKURITSUKE && terracesInfo.mEnforcementDirType == EnforcementDirType.R ? (directionType == DirectionType.LEFT ? linkedList.get(1) : (directionType == DirectionType.RIGHT ? linkedList.getLast() : this.findMasterTerraceInfo(linkedList))) : (directionType == DirectionType.LEFT ? linkedList.getFirst() : (directionType == DirectionType.RIGHT ? linkedList.getLast() : this.findMasterTerraceInfo(linkedList))));
        return terraceInfo;
    }

    public TerraceDepthType getFrameDepthType(SNYEntities sNYEntities, DirectionType directionType) {
        TerraceInfo terraceInfo = this.getEdgeTerraceInfo(sNYEntities, directionType);
        TerraceDepthType terraceDepthType = null;
        terraceDepthType = directionType == DirectionType.LEFT ? terraceInfo.mLeftDepthType : terraceInfo.mRightDepthType;
        return terraceDepthType;
    }

    public void changeWidth(SNYEntities sNYEntities) {
        this.changeWidth(sNYEntities, null, null);
    }

    public void changeWidth(SNYEntities sNYEntities, TerraceWidthType terraceWidthType, Float f) {
        TerraceWidthType terraceWidthType2;
        Object object;
        Serializable serializable;
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        LinkedList<TerraceInfo> linkedList = sNYEntities.mTerraceInfoList;
        TerraceInfo terraceInfo = this.findMasterTerraceInfo(linkedList);
        EnforcementType enforcementType = terracesInfo.mEnforcementType;
        if (enforcementType == EnforcementType.KUTAI_DEHABA_CHIGAI && terracesInfo.mEnforcementDirType == EnforcementDirType.L) {
            if (terraceWidthType == null) {
                terraceWidthType = TerraceWidthType.T05;
            }
        } else if (enforcementType == EnforcementType.KUTAI_DEHABA_CHIGAI && terracesInfo.mEnforcementDirType == EnforcementDirType.R && terraceWidthType == null) {
            terraceWidthType = TerraceWidthType.T05;
        }
        if (terraceWidthType == null) {
            terraceWidthType = TerraceWidthType.T00;
        }
        if (f == null) {
            serializable = this.mTypeTerraceWidthCacheDao.findOneByType(terraceWidthType, basicInfo.mKenType);
            f = serializable.length;
        }
        terracesInfo.mWidthGapType = terraceWidthType;
        terracesInfo.mWidthGap = f;
        if (enforcementType == EnforcementType.KUTAI_DEHABA_CHIGAI && terracesInfo.mEnforcementDirType == EnforcementDirType.L) {
            terraceInfo.mLeftWidth = Float.valueOf(terraceInfo.mWidth.floatValue() - f.floatValue());
            terraceInfo.mRightWidth = f;
            terracesInfo.mLeftTotalWidth = Float.valueOf(this.calcLeftTotalWidth(linkedList));
            terracesInfo.mRightTotalWidth = Float.valueOf(this.calcRightTotalWidth(linkedList));
            this.mDomaTileAppletService.setCutWidth(sNYEntities, terracesInfo.mWidth.floatValue() - f.floatValue());
        } else if (enforcementType == EnforcementType.KUTAI_DEHABA_CHIGAI && terracesInfo.mEnforcementDirType == EnforcementDirType.R) {
            terraceInfo.mLeftWidth = f;
            terraceInfo.mRightWidth = Float.valueOf(terraceInfo.mWidth.floatValue() - f.floatValue());
            terracesInfo.mLeftTotalWidth = Float.valueOf(this.calcLeftTotalWidth(linkedList));
            terracesInfo.mRightTotalWidth = Float.valueOf(this.calcRightTotalWidth(linkedList));
            this.mDomaTileAppletService.setCutWidth(sNYEntities, terracesInfo.mWidth.floatValue() - f.floatValue());
        } else if (enforcementType == EnforcementType.SOKUMEN_DAIKEI) {
            terraceInfo.mFrontWidthType = terraceInfo.mWidthType;
            terraceInfo.mFrontWidth = Float.valueOf(terraceInfo.mWidth.floatValue() - basicInfo.mKenLen.floatValue());
            terraceInfo.mBackWidthType = terraceInfo.mWidthType;
            terraceInfo.mBackWidth = terraceInfo.mWidth;
        } else if (enforcementType == EnforcementType.HANEDASHI && terracesInfo.mEnforcementDirType == EnforcementDirType.L) {
            terracesInfo.mLeftHanedashiLen = this.mConstants.minHanedashiLen;
        } else if (enforcementType == EnforcementType.HANEDASHI && terracesInfo.mEnforcementDirType == EnforcementDirType.R) {
            terracesInfo.mRightHanedashiLen = this.mConstants.minHanedashiLen;
        } else if (enforcementType == EnforcementType.BUBUN_KAKOI && terracesInfo.mEnforcementDirType == EnforcementDirType.L) {
            if (basicInfo.mSubProductType == SubProductType.TSUKURITSUKE) {
                object = linkedList.iterator();
                while (object.hasNext()) {
                    serializable = (TerraceInfo)object.next();
                    if (((TerraceInfo)serializable).mBuildingType != BuildingType.BALCONY) continue;
                    ((TerraceInfo)serializable).mDefaultWidth = terraceInfo.mDefaultWidth;
                    ((TerraceInfo)serializable).mWidth = terraceInfo.mWidth;
                    ((TerraceInfo)serializable).mWidthType = terraceInfo.mWidthType;
                }
            } else {
                terraceInfo.mRightWidth = Float.valueOf(terraceInfo.mWidth.floatValue() - terraceInfo.mLeftWidth.floatValue());
                terracesInfo.mLeftTotalWidth = Float.valueOf(this.calcLeftTotalWidth(linkedList));
                terracesInfo.mRightTotalWidth = Float.valueOf(this.calcRightTotalWidth(linkedList));
            }
        } else if (enforcementType == EnforcementType.BUBUN_KAKOI && terracesInfo.mEnforcementDirType == EnforcementDirType.R) {
            if (basicInfo.mSubProductType == SubProductType.TSUKURITSUKE) {
                object = linkedList.iterator();
                while (object.hasNext()) {
                    serializable = (TerraceInfo)object.next();
                    if (((TerraceInfo)serializable).mBuildingType != BuildingType.BALCONY) continue;
                    ((TerraceInfo)serializable).mDefaultWidth = terraceInfo.mDefaultWidth;
                    ((TerraceInfo)serializable).mWidth = terraceInfo.mWidth;
                    ((TerraceInfo)serializable).mWidthType = terraceInfo.mWidthType;
                }
            } else {
                terraceInfo.mLeftWidth = Float.valueOf(terraceInfo.mWidth.floatValue() - terraceInfo.mRightWidth.floatValue());
                terracesInfo.mLeftTotalWidth = Float.valueOf(this.calcLeftTotalWidth(linkedList));
                terracesInfo.mRightTotalWidth = Float.valueOf(this.calcRightTotalWidth(linkedList));
            }
        } else if (enforcementType == EnforcementType.DOMA_YUKA_W && terracesInfo.mEnforcementDirType == EnforcementDirType.L) {
            terracesInfo.mLeftTotalWidth = Float.valueOf(this.calcLeftTotalWidth(linkedList));
            terracesInfo.mRightTotalWidth = Float.valueOf(this.calcRightTotalWidth(linkedList));
        } else if (enforcementType == EnforcementType.DOMA_YUKA_W && terracesInfo.mEnforcementDirType == EnforcementDirType.R) {
            terracesInfo.mLeftTotalWidth = Float.valueOf(this.calcLeftTotalWidth(linkedList));
            terracesInfo.mRightTotalWidth = Float.valueOf(this.calcRightTotalWidth(linkedList));
        } else {
            terraceInfo.mLeftWidth = Float.valueOf(0.0f);
            terraceInfo.mRightWidth = Float.valueOf(0.0f);
            terracesInfo.mLeftTotalWidth = Float.valueOf(0.0f);
            terracesInfo.mRightTotalWidth = Float.valueOf(0.0f);
            this.mDomaTileAppletService.setCutWidth(sNYEntities, f.floatValue());
        }
        serializable = this.mTypeTerraceWidthCacheDao.findOneByLength(terraceInfo.mLeftWidth, basicInfo.mKenType);
        terraceInfo.mLeftWidthType = object = (TerraceWidthType)TerraceWidthTypeFactory.getInstance().getTypeById(serializable.typeTerraceWidthId);
        TypeTerraceWidthInfo typeTerraceWidthInfo = this.mTypeTerraceWidthCacheDao.findOneByLength(terraceInfo.mRightWidth, basicInfo.mKenType);
        terraceInfo.mRightWidthType = terraceWidthType2 = (TerraceWidthType)TerraceWidthTypeFactory.getInstance().getTypeById(typeTerraceWidthInfo.typeTerraceWidthId);
        this.mTerraceInfoService.updateWidth(sNYEntities);
    }

    public void changeAllDepthByDepthType(SNYEntities sNYEntities, TerraceDepthType terraceDepthType) {
        TypeTerraceDepthInfo typeTerraceDepthInfo = this.mTypeTerraceDepthCacheDao.findOneStdById(terraceDepthType.id());
        this.changeAllDepthByDepth(sNYEntities, typeTerraceDepthInfo.length.floatValue());
    }

    public void changeAllDepthByDepth(SNYEntities sNYEntities, float f) {
        this.changeAllDepth(sNYEntities, Float.valueOf(f), null, null, null);
    }

    public void changeAllDepthByDepthGap(SNYEntities sNYEntities, float f) {
        this.changeAllDepth(sNYEntities, null, Float.valueOf(f), null, null);
    }

    public void changeAllDepth(SNYEntities sNYEntities, Float f, Float f2, Float f3, Integer n) {
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        LinkedList<TerraceInfo> linkedList = sNYEntities.mTerraceInfoList;
        EnforcementType enforcementType = terracesInfo.mEnforcementType;
        EnforcementDirType enforcementDirType = terracesInfo.mEnforcementDirType;
        if (f == null) {
            f = terracesInfo.mDepth;
        }
        TypeTerraceDepthInfo typeTerraceDepthInfo = this.mTypeTerraceDepthCacheDao.findOnePartsByLength(f, basicInfo.mSubProductType);
        float f4 = typeTerraceDepthInfo.length.floatValue();
        TerraceDepthType terraceDepthType = (TerraceDepthType)TerraceDepthTypeFactory.getInstance().getTypeById(typeTerraceDepthInfo.typeTerraceDepthId);
        if (f2 == null) {
            f2 = terracesInfo.mDepthGap;
        }
        float f5 = f.floatValue() - f2.floatValue();
        TypeTerraceDepthInfo typeTerraceDepthInfo2 = this.mTypeTerraceDepthCacheDao.findOnePartsByLength(Float.valueOf(f5), basicInfo.mSubProductType);
        float f6 = typeTerraceDepthInfo2.length.floatValue();
        TerraceDepthType terraceDepthType2 = (TerraceDepthType)TerraceDepthTypeFactory.getInstance().getTypeById(typeTerraceDepthInfo2.typeTerraceDepthId);
        TypeTerraceDepthInfo typeTerraceDepthInfo3 = null;
        TerraceDepthType terraceDepthType3 = null;
        Float f7 = null;
        TypeTerraceDepthInfo typeTerraceDepthInfo4 = null;
        TerraceDepthType terraceDepthType4 = null;
        if (enforcementType == EnforcementType.STD) {
            if (enforcementType == EnforcementType.STD && terraceDepthType3 == null) {
                terraceDepthType3 = TerraceDepthType.T4;
            }
        } else if (enforcementType == EnforcementType.DOMA_YUKA_D && terraceDepthType3 == null) {
            terraceDepthType3 = TerraceDepthType.T3;
        }
        if (terraceDepthType3 == null) {
            terraceDepthType3 = TerraceDepthType.T0;
        }
        if (f3 == null) {
            typeTerraceDepthInfo3 = this.mTypeTerraceDepthCacheDao.findOneStdByType(terraceDepthType3);
            f3 = typeTerraceDepthInfo3.length;
        }
        typeTerraceDepthInfo3 = this.mTypeTerraceDepthCacheDao.findOneStdByLength(f3);
        terraceDepthType3 = (TerraceDepthType)TerraceDepthTypeFactory.getInstance().getTypeById(typeTerraceDepthInfo3.typeTerraceDepthId);
        f7 = Float.valueOf(f.floatValue() - f3.floatValue() - 15.0f);
        typeTerraceDepthInfo4 = this.mTypeTerraceDepthCacheDao.findOneStdByLength(f7);
        terraceDepthType4 = (TerraceDepthType)TerraceDepthTypeFactory.getInstance().getTypeById(typeTerraceDepthInfo4.typeTerraceDepthId);
        for (TerraceInfo terraceInfo : linkedList) {
            if (n != null && !terraceInfo.mGroupId.equals(n)) continue;
            if (enforcementType == EnforcementType.STD && basicInfo.mSubProductType == SubProductType.HALF_KAKOI) {
                terraceInfo.mDepthType = terraceDepthType;
                terraceInfo.mDefaultDepth = Float.valueOf(f4);
                terraceInfo.mDepth = f;
                terraceInfo.mLeftDepthType = terraceDepthType;
                terraceInfo.mLeftDepth = f;
                terraceInfo.mRightDepthType = terraceDepthType;
                terraceInfo.mRightDepth = f;
                terraceInfo.mFrontDepthType = terraceDepthType4;
                terraceInfo.mFrontDepth = f7;
                terraceInfo.mBackDepthType = terraceDepthType3;
                terraceInfo.mBackDepth = f3;
            } else if (enforcementType == EnforcementType.KUTAI_DEHABA_CHIGAI) {
                if (enforcementDirType == EnforcementDirType.L && terraceInfo.mId < 0 || enforcementDirType == EnforcementDirType.R && terraceInfo.mId > 0) {
                    terraceInfo.mDepthType = terraceDepthType2;
                    terraceInfo.mDefaultDepth = Float.valueOf(f6);
                    terraceInfo.mDepth = Float.valueOf(f5);
                    terraceInfo.mLeftDepthType = terraceDepthType2;
                    terraceInfo.mLeftDepth = Float.valueOf(f5);
                    terraceInfo.mRightDepthType = terraceDepthType2;
                    terraceInfo.mRightDepth = Float.valueOf(f5);
                } else if (enforcementDirType == EnforcementDirType.L && terraceInfo.mId == 0) {
                    terraceInfo.mDepthType = terraceDepthType;
                    terraceInfo.mDefaultDepth = Float.valueOf(f4);
                    terraceInfo.mDepth = f;
                    terraceInfo.mLeftDepthType = terraceDepthType2;
                    terraceInfo.mLeftDepth = Float.valueOf(f5);
                    terraceInfo.mRightDepthType = terraceDepthType;
                    terraceInfo.mRightDepth = f;
                } else if (enforcementDirType == EnforcementDirType.R && terraceInfo.mId == 0) {
                    terraceInfo.mDepthType = terraceDepthType;
                    terraceInfo.mDefaultDepth = Float.valueOf(f4);
                    terraceInfo.mDepth = f;
                    terraceInfo.mLeftDepthType = terraceDepthType;
                    terraceInfo.mLeftDepth = f;
                    terraceInfo.mRightDepthType = terraceDepthType2;
                    terraceInfo.mRightDepth = Float.valueOf(f5);
                } else {
                    terraceInfo.mDepthType = terraceDepthType;
                    terraceInfo.mDefaultDepth = Float.valueOf(f4);
                    terraceInfo.mDepth = f;
                    terraceInfo.mLeftDepthType = terraceDepthType;
                    terraceInfo.mLeftDepth = f;
                    terraceInfo.mRightDepthType = terraceDepthType;
                    terraceInfo.mRightDepth = f;
                }
            } else if (enforcementType == EnforcementType.SHOMEN_DAIKEI) {
                if (enforcementDirType == EnforcementDirType.L) {
                    terraceInfo.mDepthType = terraceDepthType;
                    terraceInfo.mDefaultDepth = Float.valueOf(f4);
                    terraceInfo.mDepth = f;
                    terraceInfo.mLeftDepthType = terraceDepthType;
                    terraceInfo.mLeftDepth = Float.valueOf(f.floatValue() - 300.0f);
                    terraceInfo.mRightDepthType = terraceDepthType;
                    terraceInfo.mRightDepth = f;
                } else if (enforcementDirType == EnforcementDirType.R) {
                    terraceInfo.mDepthType = terraceDepthType;
                    terraceInfo.mDefaultDepth = Float.valueOf(f4);
                    terraceInfo.mDepth = f;
                    terraceInfo.mLeftDepthType = terraceDepthType;
                    terraceInfo.mLeftDepth = f;
                    terraceInfo.mRightDepthType = terraceDepthType;
                    terraceInfo.mRightDepth = Float.valueOf(f.floatValue() - 300.0f);
                }
            } else if (enforcementType == EnforcementType.DOMA_YUKA_D) {
                terraceInfo.mDepthType = terraceDepthType;
                terraceInfo.mDefaultDepth = Float.valueOf(f4);
                terraceInfo.mDepth = f;
                terraceInfo.mLeftDepthType = terraceDepthType;
                terraceInfo.mLeftDepth = f;
                terraceInfo.mRightDepthType = terraceDepthType;
                terraceInfo.mRightDepth = f;
                terraceInfo.mFrontDepthType = terraceDepthType4;
                terraceInfo.mFrontDepth = f7;
                terraceInfo.mBackDepthType = terraceDepthType3;
                terraceInfo.mBackDepth = f3;
            } else {
                terraceInfo.mDepthType = terraceDepthType;
                terraceInfo.mDefaultDepth = Float.valueOf(f4);
                terraceInfo.mDepth = f;
                terraceInfo.mLeftDepthType = terraceDepthType;
                terraceInfo.mLeftDepth = f;
                terraceInfo.mRightDepthType = terraceDepthType;
                terraceInfo.mRightDepth = f;
            }
            if (terraceInfo.mBuildingType != BuildingType.CORNER) continue;
            terraceInfo.mWidth = f;
            terraceInfo.mDefaultWidth = f;
        }
        this.mTerraceInfoService.updateDepth(sNYEntities);
    }

    public TerraceInfo findMasterTerraceInfo(LinkedList<TerraceInfo> linkedList) {
        for (TerraceInfo terraceInfo : linkedList) {
            if (!terraceInfo.mIsMaster.booleanValue()) continue;
            return terraceInfo;
        }
        return null;
    }

    public LinkedList<TerraceInfo> findManyTerraceInfoByCorner(LinkedList<TerraceInfo> linkedList) {
        LinkedList<TerraceInfo> linkedList2 = new LinkedList<TerraceInfo>();
        for (TerraceInfo terraceInfo : linkedList) {
            if (terraceInfo.mBuildingType != BuildingType.CORNER) continue;
            linkedList2.add(terraceInfo);
        }
        return linkedList2;
    }

    public TerraceInfo findTerraceInfoByIndex(List<TerraceInfo> list, int n) {
        for (TerraceInfo terraceInfo : list) {
            if (terraceInfo.mId != n) continue;
            return terraceInfo;
        }
        return null;
    }

    public List<TerraceInfo> findManyByGroupId(List<TerraceInfo> list, Integer n) {
        ArrayList<TerraceInfo> arrayList = new ArrayList<TerraceInfo>();
        for (TerraceInfo terraceInfo : list) {
            if (!terraceInfo.mGroupId.equals(n)) continue;
            arrayList.add(terraceInfo);
        }
        return arrayList;
    }

    public TerraceInfo findLeftEdgeTerrace(LinkedList<TerraceInfo> linkedList) {
        for (TerraceInfo terraceInfo : linkedList) {
            if (!terraceInfo.mIsLeftEnd.booleanValue()) continue;
            return terraceInfo;
        }
        return null;
    }

    public TerraceInfo findRightEdgeTerrace(LinkedList<TerraceInfo> linkedList) {
        for (TerraceInfo terraceInfo : linkedList) {
            if (!terraceInfo.mIsRightEnd.booleanValue()) continue;
            return terraceInfo;
        }
        return null;
    }

    public LinkedList<TerraceInfo> findManyTerraceInfoExceptBalcony(LinkedList<TerraceInfo> linkedList) {
        LinkedList<TerraceInfo> linkedList2 = new LinkedList<TerraceInfo>();
        for (TerraceInfo terraceInfo : linkedList) {
            if (terraceInfo.mBuildingType == BuildingType.BALCONY) continue;
            linkedList2.add(terraceInfo);
        }
        return linkedList2;
    }

    public TerraceInfo findTerraceInfoByMaxWidthType(BasicInfo basicInfo, TerracesInfo terracesInfo, LinkedList<TerraceInfo> linkedList, boolean bl) {
        TerraceInfo terraceInfo = this.findMasterTerraceInfo(linkedList);
        TypeTerraceWidthInfo typeTerraceWidthInfo = this.mTypeTerraceWidthCacheDao.findOneByType(TerraceWidthType.T05, basicInfo.mKenType);
        Float f = Float.valueOf(0.0f);
        if (typeTerraceWidthInfo != null) {
            f = typeTerraceWidthInfo.length;
        }
        for (TerraceInfo terraceInfo2 : linkedList) {
            TypeTerraceWidthInfo typeTerraceWidthInfo2 = this.mTypeTerraceWidthCacheDao.findOneByType(terraceInfo2.mWidthType, basicInfo.mKenType);
            if (typeTerraceWidthInfo2 == null) continue;
            float f2 = typeTerraceWidthInfo2.length.floatValue();
            if (bl) {
                f2 += this.calcJizaiketaHanedashiLength(terracesInfo, terraceInfo2);
            }
            if (!(f.floatValue() < f2)) continue;
            f = Float.valueOf(f2);
            terraceInfo = terraceInfo2;
        }
        return terraceInfo;
    }

    public TerraceInfo findTerraceInfoByMaxWidthType(BasicInfo basicInfo, TerracesInfo terracesInfo, LinkedList<TerraceInfo> linkedList) {
        return this.findTerraceInfoByMaxWidthType(basicInfo, terracesInfo, linkedList, false);
    }

    public TerraceInfo findTerraceInfoByMaxDepthType(LinkedList<TerraceInfo> linkedList) {
        TerraceInfo terraceInfo = this.findMasterTerraceInfo(linkedList);
        TypeTerraceDepthInfo typeTerraceDepthInfo = this.mTypeTerraceDepthCacheDao.findOneStdByType(TerraceDepthType.T2);
        Float f = Float.valueOf(0.0f);
        if (typeTerraceDepthInfo != null) {
            f = typeTerraceDepthInfo.length;
        }
        for (TerraceInfo terraceInfo2 : linkedList) {
            TypeTerraceDepthInfo typeTerraceDepthInfo2 = this.mTypeTerraceDepthCacheDao.findOneStdByType(terraceInfo2.mDepthType);
            if (typeTerraceDepthInfo2 == null || !(f.floatValue() < typeTerraceDepthInfo2.length.floatValue())) continue;
            f = typeTerraceDepthInfo2.length;
            terraceInfo = terraceInfo2;
        }
        return terraceInfo;
    }

    public TerraceInfo findTerraceWithSidePanel(TerracesInfo terracesInfo, LinkedList<TerraceInfo> linkedList, DirectionType directionType) {
        EnforcementType enforcementType = terracesInfo.mEnforcementType;
        EnforcementDirType enforcementDirType = terracesInfo.mEnforcementDirType;
        if (enforcementType == EnforcementType.BUBUN_KAKOI) {
            if (enforcementDirType == EnforcementDirType.L) {
                if (directionType == DirectionType.LEFT) {
                    return this.findLeftEdgeTerrace(linkedList);
                }
                return this.findMasterTerraceInfo(linkedList);
            }
            if (directionType == DirectionType.LEFT) {
                return this.findMasterTerraceInfo(linkedList);
            }
            return this.findRightEdgeTerrace(linkedList);
        }
        if (directionType == DirectionType.LEFT) {
            return this.findLeftEdgeTerrace(linkedList);
        }
        return this.findRightEdgeTerrace(linkedList);
    }

    public int findMaxIndex(List<TerraceInfo> list) {
        int n = Integer.MIN_VALUE;
        for (TerraceInfo terraceInfo : list) {
            if (n >= terraceInfo.mId) continue;
            n = terraceInfo.mId;
        }
        return n;
    }

    public int findMinIndex(List<TerraceInfo> list) {
        int n = Integer.MAX_VALUE;
        for (TerraceInfo terraceInfo : list) {
            if (n <= terraceInfo.mId) continue;
            n = terraceInfo.mId;
        }
        return n;
    }

    public float findOneMaxDepth(List<TerraceInfo> list) {
        float f = 0.0f;
        for (TerraceInfo terraceInfo : list) {
            f = Math.max(f, terraceInfo.mDepth.floatValue());
        }
        return f;
    }

    public boolean isRentou(TerracesInfo terracesInfo, List<TerraceInfo> list, TerraceInfo terraceInfo) {
        if (list.size() <= 1) {
            return false;
        }
        boolean bl = false;
        bl = this.mEnforcementCommonService.hasDeirisumi(terracesInfo) ? terraceInfo.mIsStarting == false : !this.judgeMinIndexTerrace(list, terraceInfo);
        return bl;
    }

    public boolean isRentou(LinkedList<TerraceInfo> linkedList) {
        return linkedList.size() > 1;
    }

    public boolean isStartingWidthType(List<TerraceInfo> list, TerraceWidthType terraceWidthType) {
        for (TerraceInfo terraceInfo : list) {
            if (!terraceInfo.mIsStarting.booleanValue() || terraceInfo.mWidthType != terraceWidthType) continue;
            return true;
        }
        return false;
    }

    public boolean isTsukuritsuke(TerracesInfo terracesInfo, SubProductType subProductType, EnforcementType enforcementType, EnforcementDirType enforcementDirType, PanelDirectionType panelDirectionType) {
        if (subProductType != SubProductType.TSUKURITSUKE) {
            return false;
        }
        if (enforcementType == EnforcementType.BUBUN_KAKOI) {
            if (enforcementDirType == EnforcementDirType.L && panelDirectionType == PanelDirectionType.RIGHT) {
                return false;
            }
            if (enforcementDirType == EnforcementDirType.R && panelDirectionType == PanelDirectionType.LEFT) {
                return false;
            }
        }
        return true;
    }

    public boolean isTsukuritsuke(SNYEntities sNYEntities, PanelDirectionType panelDirectionType) {
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        SubProductType subProductType = sNYEntities.mBasicInfo.mSubProductType;
        EnforcementType enforcementType = terracesInfo.mEnforcementType;
        EnforcementDirType enforcementDirType = terracesInfo.mEnforcementDirType;
        return this.isTsukuritsuke(terracesInfo, subProductType, enforcementType, enforcementDirType, panelDirectionType);
    }

    public boolean hasYuka(BasicInfo basicInfo, TerracesInfo terracesInfo, TerraceInfo terraceInfo) {
        return this.judgeYukaWidthType((BasicInfo)basicInfo, (TerracesInfo)terracesInfo, (TerraceInfo)terraceInfo).value1 != TerraceWidthType.T00;
    }

    public boolean judgeMaxIndexTerrace(List<TerraceInfo> list, TerraceInfo terraceInfo) {
        int n = this.findMaxIndex(list);
        return terraceInfo.mId == n;
    }

    public boolean judgeMinIndexTerrace(List<TerraceInfo> list, TerraceInfo terraceInfo) {
        int n = this.findMinIndex(list);
        return terraceInfo.mId == n;
    }

    public boolean judgeCornerConnect(TerraceInfo terraceInfo, LinkedList<TerraceInfo> linkedList) {
        boolean bl = false;
        LinkedList<TerraceInfo> linkedList2 = this.findManyTerraceInfoByCorner(linkedList);
        for (TerraceInfo terraceInfo2 : linkedList2) {
            if (!terraceInfo.mId.equals(terraceInfo2.mId - 1) && !terraceInfo.mId.equals(terraceInfo2.mId + 1)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public TerraceDepthType judgeLeftOptionDepthType(TerracesInfo terracesInfo, TerraceInfo terraceInfo) {
        float f = terraceInfo.mLeftDepth.floatValue();
        if (terracesInfo.mEnforcementType == EnforcementType.BUBUN_IRISUMI && terracesInfo.mEnforcementDirType == EnforcementDirType.L) {
            f -= 50.0f;
        }
        for (TerraceDepthType terraceDepthType : TerraceDepthTypeFactory.getInstance().values()) {
            TypeTerraceDepthInfo typeTerraceDepthInfo = this.mTypeTerraceDepthCacheDao.findOneStdById(terraceDepthType.id());
            if (f != typeTerraceDepthInfo.length.floatValue()) continue;
            return terraceDepthType;
        }
        return null;
    }

    public TerraceDepthType judgeRightOptionDepthType(TerracesInfo terracesInfo, TerraceInfo terraceInfo) {
        float f = terraceInfo.mRightDepth.floatValue();
        if (terracesInfo.mEnforcementType == EnforcementType.BUBUN_IRISUMI && terracesInfo.mEnforcementDirType == EnforcementDirType.R) {
            f -= 50.0f;
        }
        for (TerraceDepthType terraceDepthType : TerraceDepthTypeFactory.getInstance().values()) {
            TypeTerraceDepthInfo typeTerraceDepthInfo = this.mTypeTerraceDepthCacheDao.findOneStdById(terraceDepthType.id());
            if (f != typeTerraceDepthInfo.length.floatValue()) continue;
            return terraceDepthType;
        }
        return null;
    }

    public Tuple<TerraceWidthType, Float> judgeYukaWidthType(BasicInfo basicInfo, TerracesInfo terracesInfo, TerraceInfo terraceInfo) {
        Tuple tuple = new Tuple();
        if (!GdMutableTypeUtil.matchOR(basicInfo.mSubProductType, SubProductType.YUKA, SubProductType.DOMA_YUKA, SubProductType.ALMI_BALCONY_PILLAR, SubProductType.ALMI_BALCONY_ROOF, SubProductType.HALF_KAKOI, SubProductType.OPEN)) {
            tuple.value1 = TerraceWidthType.T00;
            tuple.value2 = Float.valueOf(0.0f);
            return tuple;
        }
        EnforcementType enforcementType = terracesInfo.mEnforcementType;
        if (enforcementType == EnforcementType.DOMA_YUKA_W) {
            Tuple<TerraceWidthType, Float> tuple2 = this.judgeYukaWidthTypeBySpecial(basicInfo, terracesInfo, terraceInfo, true);
            tuple.value1 = (TerraceWidthType)tuple2.value1;
            tuple.value2 = (Float)tuple2.value2;
        } else if (enforcementType == EnforcementType.BUBUN_KAKOI) {
            Tuple<TerraceWidthType, Float> tuple3 = this.judgeYukaWidthTypeBySpecial(basicInfo, terracesInfo, terraceInfo, false);
            tuple.value1 = (TerraceWidthType)tuple3.value1;
            tuple.value2 = (Float)tuple3.value2;
        } else {
            tuple.value1 = terraceInfo.mWidthType;
            tuple.value2 = terraceInfo.mWidth;
        }
        return tuple;
    }

    private Tuple<TerraceWidthType, Float> judgeYukaWidthTypeBySpecial(BasicInfo basicInfo, TerracesInfo terracesInfo, TerraceInfo terraceInfo, boolean bl) {
        EnforcementDirType enforcementDirType;
        Tuple tuple = new Tuple();
        EnforcementDirType enforcementDirType2 = terracesInfo.mEnforcementDirType;
        EnforcementDirType enforcementDirType3 = bl ? EnforcementDirType.L : EnforcementDirType.R;
        EnforcementDirType enforcementDirType4 = enforcementDirType = bl ? EnforcementDirType.R : EnforcementDirType.L;
        if (terraceInfo.mIsStarting.booleanValue()) {
            if (enforcementDirType2 == enforcementDirType3) {
                tuple.value1 = terraceInfo.mRightWidthType;
                tuple.value2 = terraceInfo.mRightWidth;
            } else if (enforcementDirType2 == enforcementDirType) {
                tuple.value1 = terraceInfo.mLeftWidthType;
                tuple.value2 = terraceInfo.mLeftWidth;
            }
        } else if (enforcementDirType2 == enforcementDirType3) {
            if (terraceInfo.mId < 0) {
                tuple.value1 = TerraceWidthType.T00;
                tuple.value2 = Float.valueOf(0.0f);
            } else {
                tuple.value1 = terraceInfo.mWidthType;
                tuple.value2 = terraceInfo.mWidth;
            }
        } else if (enforcementDirType2 == enforcementDirType) {
            if (terraceInfo.mId > 0) {
                tuple.value1 = TerraceWidthType.T00;
                tuple.value2 = Float.valueOf(0.0f);
            } else {
                tuple.value1 = terraceInfo.mWidthType;
                tuple.value2 = terraceInfo.mWidth;
            }
        }
        return tuple;
    }

    public Tuple<TerraceDepthType, Float> judgeYukaDepthType(BasicInfo basicInfo, TerracesInfo terracesInfo, TerraceInfo terraceInfo) {
        Tuple tuple = new Tuple();
        if (!GdMutableTypeUtil.matchOR(basicInfo.mSubProductType, SubProductType.YUKA, SubProductType.DOMA_YUKA, SubProductType.ALMI_BALCONY_PILLAR, SubProductType.ALMI_BALCONY_ROOF, SubProductType.HALF_KAKOI, SubProductType.OPEN)) {
            tuple.value1 = TerraceDepthType.T0;
            tuple.value2 = Float.valueOf(0.0f);
            return tuple;
        }
        EnforcementType enforcementType = terracesInfo.mEnforcementType;
        if (enforcementType == EnforcementType.DOMA_YUKA_D) {
            tuple.value1 = terraceInfo.mBackDepthType;
            tuple.value2 = terraceInfo.mBackDepth;
        } else {
            tuple.value1 = terraceInfo.mDepthType;
            tuple.value2 = terraceInfo.mDepth;
        }
        return tuple;
    }

    public TerraceWidthType judgeKakoiWidthType(BasicInfo basicInfo, TerracesInfo terracesInfo, TerraceInfo terraceInfo) {
        TerraceWidthType terraceWidthType = terraceInfo.mWidthType;
        if (terracesInfo.mEnforcementType == EnforcementType.BUBUN_KAKOI) {
            if (terraceInfo.mIsMaster.booleanValue()) {
                if (basicInfo.mSubProductType != SubProductType.TSUKURITSUKE) {
                    if (terracesInfo.mEnforcementDirType == EnforcementDirType.L) {
                        terraceWidthType = terraceInfo.mLeftWidthType;
                    } else if (terracesInfo.mEnforcementDirType == EnforcementDirType.R) {
                        terraceWidthType = terraceInfo.mRightWidthType;
                    }
                }
            } else if (terracesInfo.mEnforcementDirType == EnforcementDirType.L) {
                if (terraceInfo.mId > 0) {
                    terraceWidthType = TerraceWidthType.T00;
                }
            } else if (terracesInfo.mEnforcementDirType == EnforcementDirType.R && terraceInfo.mId < 0) {
                terraceWidthType = TerraceWidthType.T00;
            }
        }
        return terraceWidthType;
    }

    public FloorArrangementType judgeFrontFloorArrangementType(SNYEntities sNYEntities, TerraceInfo terraceInfo, int n) {
        return this.judgeFrontFloorArrangementType(sNYEntities.mBasicInfo, sNYEntities.mTerracesInfo, terraceInfo, n);
    }

    public FloorArrangementType judgeFrontFloorArrangementType(BasicInfo basicInfo, TerracesInfo terracesInfo, TerraceInfo terraceInfo, int n) {
        FloorArrangementType floorArrangementType = null;
        if (basicInfo.mSubProductType == SubProductType.DOMA) {
            floorArrangementType = FloorArrangementType.DOMA;
        } else if (basicInfo.mSubProductType == SubProductType.YUKA) {
            floorArrangementType = FloorArrangementType.YUKA;
        } else if (basicInfo.mSubProductType == SubProductType.DOMA_YUKA) {
            if (terracesInfo.mEnforcementType == EnforcementType.DOMA_YUKA_W) {
                if (terracesInfo.mEnforcementDirType == EnforcementDirType.L) {
                    if (terraceInfo.mId < 0) {
                        floorArrangementType = FloorArrangementType.DOMA;
                    } else if (terraceInfo.mId == 0) {
                        TypeTerraceWidthInfo typeTerraceWidthInfo = this.mTypeTerraceWidthCacheDao.findOneByType(terraceInfo.mLeftWidthType, basicInfo.mKenType);
                        floorArrangementType = typeTerraceWidthInfo.span > n ? FloorArrangementType.DOMA : FloorArrangementType.YUKA;
                    } else {
                        floorArrangementType = FloorArrangementType.YUKA;
                    }
                } else if (terraceInfo.mId < 0) {
                    floorArrangementType = FloorArrangementType.YUKA;
                } else if (terraceInfo.mId == 0) {
                    TypeTerraceWidthInfo typeTerraceWidthInfo = this.mTypeTerraceWidthCacheDao.findOneByType(terraceInfo.mLeftWidthType, basicInfo.mKenType);
                    floorArrangementType = typeTerraceWidthInfo.span > n ? FloorArrangementType.YUKA : FloorArrangementType.DOMA;
                } else {
                    floorArrangementType = FloorArrangementType.DOMA;
                }
            } else if (terracesInfo.mEnforcementType == EnforcementType.DOMA_YUKA_D) {
                floorArrangementType = FloorArrangementType.DOMA;
            }
        } else if (basicInfo.mSubProductType == SubProductType.HALF_KAKOI) {
            floorArrangementType = FloorArrangementType.YUKA;
        } else if (GdMutableTypeUtil.matchOR(basicInfo.mSubProductType, SubProductType.ALMI_BALCONY_PILLAR, SubProductType.ALMI_BALCONY_ROOF)) {
            floorArrangementType = FloorArrangementType.YUKA;
        } else if (basicInfo.mSubProductType == SubProductType.TSUKURITSUKE) {
            floorArrangementType = FloorArrangementType.KOSHIKABE;
        }
        return floorArrangementType;
    }

    public FloorArrangementType judgeSideFloorArrangementType(SNYEntities sNYEntities, TerraceInfo terraceInfo, int n, PanelDirectionType panelDirectionType) {
        return this.judgeSideFloorArrangementType(sNYEntities.mBasicInfo, sNYEntities.mTerracesInfo, terraceInfo, n, panelDirectionType);
    }

    public FloorArrangementType judgeSideFloorArrangementType(BasicInfo basicInfo, TerracesInfo terracesInfo, TerraceInfo terraceInfo, int n, PanelDirectionType panelDirectionType) {
        FloorArrangementType floorArrangementType = null;
        if (basicInfo.mSubProductType == SubProductType.DOMA) {
            floorArrangementType = FloorArrangementType.DOMA;
        } else if (basicInfo.mSubProductType == SubProductType.YUKA) {
            floorArrangementType = FloorArrangementType.YUKA;
        } else if (basicInfo.mSubProductType == SubProductType.DOMA_YUKA) {
            if (terracesInfo.mEnforcementType == EnforcementType.DOMA_YUKA_W) {
                floorArrangementType = terracesInfo.mEnforcementDirType == EnforcementDirType.L ? (panelDirectionType == PanelDirectionType.LEFT ? FloorArrangementType.DOMA : FloorArrangementType.YUKA) : (panelDirectionType == PanelDirectionType.LEFT ? FloorArrangementType.YUKA : FloorArrangementType.DOMA);
            } else if (terracesInfo.mEnforcementType == EnforcementType.DOMA_YUKA_D) {
                TypeTerraceDepthInfo typeTerraceDepthInfo = this.mTypeTerraceDepthCacheDao.findOneStdByType(terraceInfo.mFrontDepthType);
                floorArrangementType = typeTerraceDepthInfo.span > n ? FloorArrangementType.DOMA : FloorArrangementType.YUKA;
            }
        } else if (basicInfo.mSubProductType == SubProductType.HALF_KAKOI) {
            floorArrangementType = FloorArrangementType.YUKA;
        } else if (GdMutableTypeUtil.matchOR(basicInfo.mSubProductType, SubProductType.ALMI_BALCONY_PILLAR, SubProductType.ALMI_BALCONY_ROOF)) {
            floorArrangementType = FloorArrangementType.YUKA;
        } else if (basicInfo.mSubProductType == SubProductType.TSUKURITSUKE) {
            floorArrangementType = terracesInfo.mEnforcementType == EnforcementType.BUBUN_KAKOI ? (terracesInfo.mEnforcementDirType == EnforcementDirType.L ? (panelDirectionType == PanelDirectionType.LEFT ? FloorArrangementType.KOSHIKABE : FloorArrangementType.YUKA) : (panelDirectionType == PanelDirectionType.LEFT ? FloorArrangementType.YUKA : FloorArrangementType.KOSHIKABE)) : FloorArrangementType.KOSHIKABE;
        }
        return floorArrangementType;
    }

    public PanelDirectionType judgeFrontPanelDirectionType(SNYEntities sNYEntities, TerraceInfo terraceInfo, int n) {
        return this.judgeFrontPanelDirectionType(sNYEntities.mBasicInfo, sNYEntities.mTerracesInfo, terraceInfo, n);
    }

    public PanelDirectionType judgeFrontPanelDirectionType(BasicInfo basicInfo, TerracesInfo terracesInfo, TerraceInfo terraceInfo, int n) {
        PanelDirectionType panelDirectionType = null;
        if (basicInfo.mSubProductType == SubProductType.DOMA_YUKA && terracesInfo.mEnforcementType == EnforcementType.DOMA_YUKA_W && terraceInfo.mId == 0) {
            TypeTerraceWidthInfo typeTerraceWidthInfo = this.mTypeTerraceWidthCacheDao.findOneByType(terraceInfo.mLeftWidthType, basicInfo.mKenType);
            panelDirectionType = typeTerraceWidthInfo.span > n ? PanelDirectionType.LEFT : PanelDirectionType.RIGHT;
        }
        if (panelDirectionType == null) {
            panelDirectionType = PanelDirectionType.FRONT;
        }
        return panelDirectionType;
    }

    public boolean existTerraceWidthType(List<TerraceInfo> list, TerraceWidthType terraceWidthType) {
        for (TerraceInfo terraceInfo : list) {
            if (terraceInfo.mWidthType != terraceWidthType) continue;
            return true;
        }
        return false;
    }

    public float calcLeftTotalWidth(LinkedList<TerraceInfo> linkedList) {
        TerraceInfo terraceInfo = this.findMasterTerraceInfo(linkedList);
        float f = terraceInfo.mLeftWidth.floatValue();
        for (TerraceInfo terraceInfo2 : linkedList) {
            if (terraceInfo2.mId >= 0) continue;
            f += terraceInfo2.mWidth.floatValue();
        }
        return f;
    }

    public float calcRightTotalWidth(LinkedList<TerraceInfo> linkedList) {
        TerraceInfo terraceInfo = this.findMasterTerraceInfo(linkedList);
        float f = terraceInfo.mRightWidth.floatValue();
        for (TerraceInfo terraceInfo2 : linkedList) {
            if (terraceInfo2.mId <= 0) continue;
            f += terraceInfo2.mWidth.floatValue();
        }
        return f;
    }

    public float calcJizaiketaHanedashiLength(TerracesInfo terracesInfo, TerraceInfo terraceInfo) {
        float f = 0.0f;
        if (terracesInfo.mEnforcementType != EnforcementType.JIZAIKETA_HANEDASHI) {
            return f;
        }
        if (terraceInfo.mIsLeftEnd.booleanValue()) {
            f += terracesInfo.mLeftJizaiKetaLen.floatValue();
        }
        if (terraceInfo.mIsRightEnd.booleanValue()) {
            f += terracesInfo.mRightJizaiKetaLen.floatValue();
        }
        return f;
    }
}

