/*
 * Decompiled with CFR 0.152.
 */
package option.loneterrace.common.service.parts;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import option.gad.core.inject.GdInject;
import option.gad.core.inject.GdInjector;
import option.gad.core.util.EnumUtil;
import option.gad.core.util.GdMutableTypeUtil;
import option.gad.core.util.ObjectUtil;
import option.loneterrace.common.dao.cache.spec.SpecOpeningOptionCacheDao;
import option.loneterrace.common.entity.BasicInfo;
import option.loneterrace.common.entity.SNYEntities;
import option.loneterrace.common.entity.SidePanelOptionInfo;
import option.loneterrace.common.entity.TerraceInfo;
import option.loneterrace.common.entity.TerracesInfo;
import option.loneterrace.common.entity.paneloption.PanelOptionInfo;
import option.loneterrace.common.entity.spec.SpecOpeningOptionComboInfo;
import option.loneterrace.common.entity.spec.SpecOpeningOptionInfo;
import option.loneterrace.common.service.parts.PanelOptionCommonService;
import option.loneterrace.common.type.DirectionType;
import option.loneterrace.common.type.FloorArrangementType;
import option.loneterrace.common.type.OpeningPanelType;
import option.loneterrace.common.type.PanelDirectionType;
import option.loneterrace.common.type.RanmaType;
import option.loneterrace.common.type.RanmaUseType;
import option.loneterrace.common.type.SodePosType;
import option.loneterrace.common.type.TerraceDepthType;
import option.loneterrace.common.type.constant.HeightArrangementType;
import option.loneterrace.common.type.constant.SurfaceArrangementType;
import option.loneterrace.common.type.paneloption.PanelOptionType;

public class SidePanelOptionCommonService
extends PanelOptionCommonService {
    @GdInject
    protected SpecOpeningOptionCacheDao mSpecOpeningOptionCacheDao;

    public SidePanelOptionCommonService() {
        GdInjector.getInstance().inject((Object)this);
    }

    public void addSide(SNYEntities sNYEntities, PanelOptionInfo panelOptionInfo, List<SpecOpeningOptionComboInfo> list) {
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        this.add(sNYEntities, panelOptionInfo, list);
        if (!GdMutableTypeUtil.matchOR(terracesInfo.mSodePosType, SodePosType.BOTH)) {
            PanelOptionInfo panelOptionInfo2 = this.createOppoPanelOptionInfo(sNYEntities, panelOptionInfo);
            this.add(sNYEntities, panelOptionInfo2, list);
        }
    }

    public void removeSide(SNYEntities sNYEntities, PanelOptionInfo panelOptionInfo, List<SpecOpeningOptionComboInfo> list) {
        PanelOptionInfo panelOptionInfo2 = this.createOppoPanelOptionInfo(sNYEntities, panelOptionInfo);
        LinkedList<PanelOptionInfo> linkedList = this.getPanelOptionInfoList(sNYEntities, panelOptionInfo.mDirectionType);
        LinkedList<PanelOptionInfo> linkedList2 = this.getPanelOptionInfoList(sNYEntities, panelOptionInfo2.mDirectionType);
        this.remove(sNYEntities, linkedList, panelOptionInfo, list);
        this.remove(sNYEntities, linkedList2, panelOptionInfo2, list);
    }

    private PanelOptionInfo createOppoPanelOptionInfo(SNYEntities sNYEntities, PanelOptionInfo panelOptionInfo) {
        LinkedList<TerraceInfo> linkedList = sNYEntities.mTerraceInfoList;
        PanelOptionInfo panelOptionInfo2 = (PanelOptionInfo)ObjectUtil.shallowCopy((Object)panelOptionInfo);
        TerraceInfo terraceInfo = null;
        if (panelOptionInfo.mDirectionType == PanelDirectionType.LEFT) {
            terraceInfo = linkedList.getLast();
            panelOptionInfo2.mDirectionType = PanelDirectionType.RIGHT;
        } else {
            terraceInfo = linkedList.getFirst();
            panelOptionInfo2.mDirectionType = PanelDirectionType.LEFT;
        }
        panelOptionInfo2.mTerraceId = terraceInfo.mId;
        return panelOptionInfo2;
    }

    public boolean hasPanelOptionType(SNYEntities sNYEntities, DirectionType directionType, PanelOptionType panelOptionType) {
        LinkedList<PanelOptionInfo> linkedList = directionType == DirectionType.LEFT ? sNYEntities.mLeftPanelOptionInfoList : sNYEntities.mRightPanelOptionInfoList;
        return this.hasPanelOptionType(linkedList, panelOptionType);
    }

    public boolean hasPanelOptionType(List<PanelOptionInfo> list, PanelOptionType panelOptionType) {
        for (PanelOptionInfo panelOptionInfo : list) {
            if (panelOptionInfo.mPanelOptionType != panelOptionType) continue;
            return true;
        }
        return false;
    }

    public List<SidePanelOptionInfo> packAllSidePanelOption(List<SidePanelOptionInfo> list, List<SidePanelOptionInfo> list2) {
        LinkedList<SidePanelOptionInfo> linkedList = new LinkedList<SidePanelOptionInfo>();
        linkedList.addAll(list);
        linkedList.addAll(list2);
        return linkedList;
    }

    public LinkedList<PanelOptionInfo> findManyOptionInfoByTypes(LinkedList<PanelOptionInfo> linkedList, PanelOptionType ... panelOptionTypeArray) {
        LinkedList<PanelOptionInfo> linkedList2 = new LinkedList<PanelOptionInfo>();
        for (PanelOptionInfo panelOptionInfo : linkedList) {
            if (!EnumUtil.matchOR((Enum)panelOptionInfo.mPanelOptionType, (Enum[])panelOptionTypeArray)) continue;
            linkedList2.add(panelOptionInfo);
        }
        return linkedList2;
    }

    public LinkedList<PanelOptionInfo> findManySimilarSidePanelOptionByOptionInfo(List<PanelOptionInfo> list, List<PanelOptionType> list2, PanelOptionInfo panelOptionInfo) {
        LinkedList<PanelOptionInfo> linkedList = new LinkedList<PanelOptionInfo>();
        for (PanelOptionInfo panelOptionInfo2 : list) {
            if (!panelOptionInfo2.mIndex.equals(panelOptionInfo.mIndex) || !panelOptionInfo2.mHeightIndex.equals(panelOptionInfo.mHeightIndex)) continue;
            if (panelOptionInfo2.mPanelOptionType == panelOptionInfo.mPanelOptionType) {
                linkedList.add(panelOptionInfo2);
            }
            for (PanelOptionType panelOptionType : list2) {
                if (panelOptionInfo2.mPanelOptionType != panelOptionType) continue;
                linkedList.add(panelOptionInfo2);
            }
        }
        return linkedList;
    }

    public boolean isSideOptionPerm(SNYEntities sNYEntities, PanelOptionType panelOptionType, OpeningPanelType openingPanelType, HeightArrangementType heightArrangementType, FloorArrangementType floorArrangementType, Integer n) {
        LinkedList<TerraceInfo> linkedList = sNYEntities.mTerraceInfoList;
        boolean bl = false;
        bl |= this.isSideOptionPermForGeom(sNYEntities, linkedList.getFirst(), panelOptionType, DirectionType.LEFT, null, null, null, openingPanelType, heightArrangementType, floorArrangementType, n);
        return bl |= this.isSideOptionPermForGeom(sNYEntities, linkedList.getLast(), panelOptionType, DirectionType.RIGHT, null, null, null, openingPanelType, heightArrangementType, floorArrangementType, n);
    }

    public boolean isSideOptionPermForGeom(SNYEntities sNYEntities, TerraceInfo terraceInfo, PanelOptionType panelOptionType, DirectionType directionType, TerraceDepthType terraceDepthType, RanmaType ranmaType, RanmaUseType ranmaUseType, OpeningPanelType openingPanelType, HeightArrangementType heightArrangementType, FloorArrangementType floorArrangementType, Integer n) {
        if (terraceDepthType == null) {
            terraceDepthType = terraceInfo.mDepthType;
        }
        return this.isSideOptionPermForList(sNYEntities, terraceInfo, panelOptionType, directionType, terraceDepthType, ranmaType, ranmaUseType, openingPanelType, heightArrangementType, floorArrangementType, n);
    }

    public boolean isSideOptionPermForList(SNYEntities sNYEntities, TerraceInfo terraceInfo, PanelOptionType panelOptionType, DirectionType directionType, TerraceDepthType terraceDepthType, RanmaType ranmaType, RanmaUseType ranmaUseType, OpeningPanelType openingPanelType, HeightArrangementType heightArrangementType, FloorArrangementType floorArrangementType, Integer n) {
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        Integer n2 = openingPanelType == null ? null : openingPanelType.id();
        boolean bl = !terraceInfo.mDefaultWidth.equals(terraceInfo.mWidth);
        boolean bl2 = !terraceInfo.mDefaultDepth.equals(terraceInfo.mDepth);
        boolean bl3 = !terracesInfo.mDefaultHeight.equals(terracesInfo.mHeight);
        Collection<SpecOpeningOptionInfo> collection = this.mSpecOpeningOptionCacheDao.findManyByTypes(panelOptionType, basicInfo, terracesInfo, terraceInfo.mDepthType, terraceInfo.mWidthType, n2, terraceDepthType, null, ranmaType, ranmaUseType, n, directionType, SurfaceArrangementType.SIDE, heightArrangementType, floorArrangementType, bl, bl2, bl3);
        boolean bl4 = false;
        for (SpecOpeningOptionInfo specOpeningOptionInfo : collection) {
            if (!specOpeningOptionInfo.permission.equals("1")) continue;
            bl4 = true;
            break;
        }
        return bl4;
    }
}

