/*
 * Decompiled with CFR 0.152.
 */
package option.loneterrace.common.service.parts;

import java.io.Serializable;
import java.util.LinkedList;
import option.gad.core.inject.GdInject;
import option.loneterrace.common.dao.cache.type.TypeTerraceDepthCacheDao;
import option.loneterrace.common.dxo.DirectionTypeDxo;
import option.loneterrace.common.entity.BasicInfo;
import option.loneterrace.common.entity.SNYEntities;
import option.loneterrace.common.entity.TerraceInfo;
import option.loneterrace.common.entity.TerracesInfo;
import option.loneterrace.common.entity.type.TypeTerraceDepthInfo;
import option.loneterrace.common.service.parts.PanelFigureCommonService;
import option.loneterrace.common.service.parts.TerraceCommonService;
import option.loneterrace.common.service.parts.TerraceFigureCommonService;
import option.loneterrace.common.type.DirectionType;
import option.loneterrace.common.type.EnforcementDirType;
import option.loneterrace.common.type.EnforcementType;
import option.loneterrace.common.type.SubProductType;
import option.loneterrace.common.type.TerraceDepthType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SidePanelFigureCommonService
extends PanelFigureCommonService {
    @GdInject
    protected TerraceCommonService mTerraceCommonService;
    @GdInject
    protected TerraceFigureCommonService mTerraceFigureCommonService;
    @GdInject
    protected TypeTerraceDepthCacheDao mTypeTerraceDepthCacheDao;
    private Log mLog = LogFactory.getLog(SidePanelFigureCommonService.class);

    public float calcDefaultOpeningDepth(SNYEntities sNYEntities, int n, DirectionType directionType) {
        float f = this.calcOpeningDepth(sNYEntities, directionType);
        float f2 = f + this.mConstants.openingPillarHalfWidth.floatValue() * 2.0f;
        TypeTerraceDepthInfo typeTerraceDepthInfo = this.mTypeTerraceDepthCacheDao.findOneStdByLength(Float.valueOf(f2));
        float f3 = typeTerraceDepthInfo.length.floatValue() / (float)typeTerraceDepthInfo.span.intValue() * (float)n;
        return f3;
    }

    public float calcOpeningDepth(SNYEntities sNYEntities, DirectionType directionType) {
        TerraceInfo terraceInfo = this.mTerraceCommonService.getEdgeTerraceInfo(sNYEntities, directionType);
        float f = 0.0f;
        if (directionType == DirectionType.LEFT) {
            f = this.calcLeftOpeningDepth(sNYEntities, terraceInfo);
        } else if (directionType == DirectionType.RIGHT) {
            f = this.calcRightOpeningDepth(sNYEntities, terraceInfo);
        }
        return f;
    }

    public float calcLeftOpeningDepth(SNYEntities sNYEntities, TerraceInfo terraceInfo) {
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        float f = 0.0f;
        f = terracesInfo.mEnforcementType == EnforcementType.BUBUN_KAKOI && basicInfo.mSubProductType == SubProductType.TSUKURITSUKE && terracesInfo.mEnforcementDirType == EnforcementDirType.R ? terracesInfo.mKutaiCoping.floatValue() - 105.0f : terraceInfo.mLeftDepth.floatValue() - this.mConstants.openingPillarHalfWidth.floatValue() * 2.0f;
        return f;
    }

    public float calcRightOpeningDepth(SNYEntities sNYEntities, TerraceInfo terraceInfo) {
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        float f = 0.0f;
        f = terracesInfo.mEnforcementType == EnforcementType.BUBUN_KAKOI && basicInfo.mSubProductType == SubProductType.TSUKURITSUKE && terracesInfo.mEnforcementDirType == EnforcementDirType.L ? terracesInfo.mKutaiCoping.floatValue() - 105.0f : terraceInfo.mRightDepth.floatValue() - this.mConstants.openingPillarHalfWidth.floatValue() * 2.0f;
        return f;
    }

    public float calcOpeningY1(SNYEntities sNYEntities, TerraceInfo terraceInfo, float f, int n, int n2) {
        DirectionType directionType = DirectionTypeDxo.convert(n2);
        return f - this.calcDefaultOpeningDepth(sNYEntities, n, directionType) * (float)n2;
    }

    public float calcOpeningY2(SNYEntities sNYEntities, TerraceInfo terraceInfo, float f, int n, int n2, int n3) {
        DirectionType directionType = DirectionTypeDxo.convert(n3);
        return f - this.calcDefaultOpeningDepth(sNYEntities, n + n2, directionType) * (float)n3;
    }

    public float calcOpeningWidth(SNYEntities sNYEntities, int n, int n2) {
        DirectionType directionType = DirectionTypeDxo.convert(n2);
        return this.calcOpeningWidth(sNYEntities, n, directionType);
    }

    public float calcOpeningWidth(SNYEntities sNYEntities, int n, DirectionType directionType) {
        float f = this.mTerraceFigureCommonService.calcDepthInner(sNYEntities, directionType) - 35.0f;
        TerraceDepthType terraceDepthType = this.mTerraceCommonService.getFrameDepthType(sNYEntities, directionType);
        TypeTerraceDepthInfo typeTerraceDepthInfo = this.mTypeTerraceDepthCacheDao.findOneStdByType(terraceDepthType);
        float f2 = f / (float)typeTerraceDepthInfo.span.intValue() * (float)n;
        return f2;
    }

    public float calcFenceStartY(SNYEntities sNYEntities, TerraceInfo terraceInfo, int n) {
        return this.mTerraceFigureCommonService.calcDepthInner(sNYEntities) * (float)n;
    }

    public float calcFenceY1(SNYEntities sNYEntities, float f, int n, int n2) {
        return f - this.calcFenceAreaWidth(sNYEntities, n, n2) * (float)n2;
    }

    public float calcFenceY2(SNYEntities sNYEntities, float f, int n, int n2, int n3) {
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        LinkedList<TerraceInfo> linkedList = sNYEntities.mTerraceInfoList;
        float f2 = 0.0f;
        TerraceDepthType terraceDepthType = null;
        if (basicInfo.mSubProductType == SubProductType.HALF_KAKOI) {
            Serializable serializable;
            if (n3 == 1) {
                serializable = linkedList.getFirst();
                terraceDepthType = serializable.mFrontDepthType;
            } else {
                serializable = linkedList.getLast();
                terraceDepthType = serializable.mFrontDepthType;
            }
            serializable = this.mTypeTerraceDepthCacheDao.findOneStdByType(terraceDepthType);
            n2 = ((TypeTerraceDepthInfo)serializable).span;
        } else if (basicInfo.mSubProductType == SubProductType.OPEN) {
            f2 = 35.0f;
        }
        return f - (this.calcFenceAreaWidth(sNYEntities, n + n2, n3) + f2) * (float)n3;
    }

    public float calcFenceAreaWidth(SNYEntities sNYEntities, int n, int n2) {
        Serializable serializable;
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        LinkedList<TerraceInfo> linkedList = sNYEntities.mTerraceInfoList;
        TerraceDepthType terraceDepthType = null;
        if (basicInfo.mSubProductType == SubProductType.HALF_KAKOI) {
            if (n2 == 1) {
                serializable = linkedList.getFirst();
                terraceDepthType = serializable.mFrontDepthType;
            } else {
                serializable = linkedList.getLast();
                terraceDepthType = serializable.mFrontDepthType;
            }
        } else if (n2 == 1) {
            serializable = linkedList.getFirst();
            terraceDepthType = serializable.mLeftDepthType;
        } else {
            serializable = linkedList.getLast();
            terraceDepthType = serializable.mRightDepthType;
        }
        serializable = this.mTypeTerraceDepthCacheDao.findOneStdByType(terraceDepthType);
        float f = ((TypeTerraceDepthInfo)serializable).length.floatValue() - 70.0f;
        float f2 = f / (float)((TypeTerraceDepthInfo)serializable).span.intValue() * (float)n;
        return f2;
    }
}

