/*
 * Decompiled with CFR 0.152.
 */
package option.loneterrace.common.service.parts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import option.gad.core.inject.GdInject;
import option.gad.core.util.GdMutableTypeUtil;
import option.gad.core.util.Tuple3;
import option.loneterrace.common.dao.cache.spec.SpecOpeningPanelCacheDao;
import option.loneterrace.common.dao.cache.spec.SpecOpeningPanelHeightCacheDao;
import option.loneterrace.common.dao.cache.type.TypeTerraceDepthCacheDao;
import option.loneterrace.common.dxo.DirectionTypeDxo;
import option.loneterrace.common.entity.BasicInfo;
import option.loneterrace.common.entity.Constants;
import option.loneterrace.common.entity.SNYEntities;
import option.loneterrace.common.entity.SidePanelInfo;
import option.loneterrace.common.entity.TerraceInfo;
import option.loneterrace.common.entity.TerracesInfo;
import option.loneterrace.common.entity.paneloption.PanelOptionInfo;
import option.loneterrace.common.entity.spec.SpecOpeningPanelHeightInfo;
import option.loneterrace.common.entity.spec.SpecOpeningPanelInfo;
import option.loneterrace.common.entity.type.TypeTerraceDepthInfo;
import option.loneterrace.common.service.cut.PanelCutCommonService;
import option.loneterrace.common.service.material.PanelInfoCommonService;
import option.loneterrace.common.service.parts.SidePanelOptionCommonService;
import option.loneterrace.common.service.parts.TerraceCommonService;
import option.loneterrace.common.service.parts.TerraceFigureCommonService;
import option.loneterrace.common.type.DirectionType;
import option.loneterrace.common.type.EnforcementDirType;
import option.loneterrace.common.type.EnforcementType;
import option.loneterrace.common.type.FloorArrangementType;
import option.loneterrace.common.type.FloorType;
import option.loneterrace.common.type.KamachiType;
import option.loneterrace.common.type.OpeningPanelDepthType;
import option.loneterrace.common.type.OpeningPanelType;
import option.loneterrace.common.type.PanelDirectionType;
import option.loneterrace.common.type.PanelHeightType;
import option.loneterrace.common.type.RanmaType;
import option.loneterrace.common.type.RanmaUseType;
import option.loneterrace.common.type.SodePosType;
import option.loneterrace.common.type.SubProductType;
import option.loneterrace.common.type.TerraceDepthType;
import option.loneterrace.common.type.constant.TsukuritsukeKoshikabeType;
import option.loneterrace.common.type.factory.TerraceDepthTypeFactory;
import option.loneterrace.common.type.paneloption.PanelOptionType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SidePanelCommonService {
    private Log mLog = LogFactory.getLog(SidePanelCommonService.class);
    @GdInject
    protected TerraceCommonService mTerraceCommonService;
    @GdInject
    protected TerraceFigureCommonService mTerraceFigureCommonService;
    @GdInject
    protected SidePanelOptionCommonService mSidePanelOptionCommonService;
    @GdInject
    protected PanelCutCommonService mPanelCutCommonService;
    @GdInject
    protected PanelInfoCommonService mPanelInfoCommonService;
    @GdInject
    protected SpecOpeningPanelCacheDao mSpecOpeningPanelCacheDao;
    @GdInject
    protected SpecOpeningPanelHeightCacheDao mSpecOpeningPanelHeightCacheDao;
    @GdInject
    protected TypeTerraceDepthCacheDao mTypeTerraceDepthCacheDao;
    @GdInject
    protected Constants mConstants;

    public LinkedList<SidePanelInfo> getPanelInfoList(SNYEntities sNYEntities, PanelDirectionType panelDirectionType) {
        LinkedList<SidePanelInfo> linkedList = null;
        if (panelDirectionType == PanelDirectionType.LEFT) {
            linkedList = sNYEntities.mLeftPanelInfoList;
        } else if (panelDirectionType == PanelDirectionType.RIGHT) {
            linkedList = sNYEntities.mRightPanelInfoList;
        }
        return linkedList;
    }

    public void initSidePanel(SNYEntities sNYEntities) {
        sNYEntities.mLeftPanelInfoList.clear();
        sNYEntities.mRightPanelInfoList.clear();
        sNYEntities.mLeftPanelCutInfoList.clear();
        sNYEntities.mRightPanelCutInfoList.clear();
        sNYEntities.mLeftPanelOptionInfoList.clear();
        sNYEntities.mRightPanelOptionInfoList.clear();
        sNYEntities.mTerracesInfo.mIsCutAdjustment = false;
        this.mPanelCutCommonService.updateRearPanelCutInfo(sNYEntities);
    }

    public void resetSidePanels(SNYEntities sNYEntities) {
        this.resetSidePanels(sNYEntities, sNYEntities.mLeftPanelInfoList);
        this.resetSidePanels(sNYEntities, sNYEntities.mRightPanelInfoList);
    }

    public void resetSidePanels(SNYEntities sNYEntities, LinkedList<SidePanelInfo> linkedList) {
        for (SidePanelInfo sidePanelInfo : linkedList) {
            this.resetSidePanel(sNYEntities, sidePanelInfo);
        }
    }

    public void resetSidePanel(SNYEntities sNYEntities, SidePanelInfo sidePanelInfo) {
        sidePanelInfo.mWidth = sidePanelInfo.mDefaultWidth;
        sidePanelInfo.mHeight = sidePanelInfo.mDefaultHeight;
        this.mPanelCutCommonService.updateSidePanelCutInfo(sNYEntities, sidePanelInfo, sidePanelInfo.mPanelDirectionType);
    }

    public SidePanelInfo createSidePanelInfo(int n, int n2, int n3, float f, TerraceDepthType terraceDepthType) {
        SidePanelInfo sidePanelInfo = new SidePanelInfo();
        sidePanelInfo.mTerraceId = n;
        sidePanelInfo.mIndex = n2;
        sidePanelInfo.mSpan = n3;
        sidePanelInfo.mWidth = Float.valueOf(f);
        sidePanelInfo.mDepthType = terraceDepthType;
        return sidePanelInfo;
    }

    public void add(SNYEntities sNYEntities, SidePanelInfo sidePanelInfo, PanelDirectionType panelDirectionType, int n, int n2, int n3) {
        LinkedList<SidePanelInfo> linkedList = this.getPanelInfoList(sNYEntities, panelDirectionType);
        this.add(sNYEntities, linkedList, sidePanelInfo, panelDirectionType, n, n2, n3);
    }

    public void add(SNYEntities sNYEntities, LinkedList<SidePanelInfo> linkedList, SidePanelInfo sidePanelInfo, PanelDirectionType panelDirectionType, int n, int n2, int n3) {
        this.remove(sNYEntities, panelDirectionType, n, n2, n3);
        linkedList.add(sidePanelInfo);
        Collections.sort(linkedList, new Comparator<SidePanelInfo>(){

            @Override
            public int compare(SidePanelInfo sidePanelInfo, SidePanelInfo sidePanelInfo2) {
                return sidePanelInfo.mIndex < sidePanelInfo2.mIndex ? -1 : 1;
            }
        });
        this.mPanelCutCommonService.updateSidePanelCutInfo(sNYEntities, sidePanelInfo, panelDirectionType);
    }

    public void remove(SNYEntities sNYEntities, PanelDirectionType panelDirectionType, int n, int n2, int n3) {
        LinkedList<SidePanelInfo> linkedList = this.getPanelInfoList(sNYEntities, panelDirectionType);
        this.remove(sNYEntities, linkedList, panelDirectionType, n, n2, n3);
    }

    public void remove(SNYEntities sNYEntities, LinkedList<SidePanelInfo> linkedList, PanelDirectionType panelDirectionType, int n, int n2, int n3) {
        List<SidePanelInfo> list = this.findManySidePanelInfo(linkedList, n2, n3);
        linkedList.removeAll(list);
        this.mPanelCutCommonService.removeSidePanelCutInfo(sNYEntities, list, panelDirectionType);
        this.mSidePanelOptionCommonService.remove(sNYEntities, panelDirectionType, n, n2);
    }

    public LinkedList<SidePanelInfo> findManySidePanelInfo(List<SidePanelInfo> list, OpeningPanelType ... openingPanelTypeArray) {
        LinkedList<SidePanelInfo> linkedList = new LinkedList<SidePanelInfo>();
        for (SidePanelInfo sidePanelInfo : list) {
            if (!GdMutableTypeUtil.matchOR(sidePanelInfo.mPanelType, openingPanelTypeArray)) continue;
            linkedList.add(sidePanelInfo);
        }
        return linkedList;
    }

    public SidePanelInfo findOneSidePanelInfo(List<SidePanelInfo> list, int n) {
        for (SidePanelInfo sidePanelInfo : list) {
            if (sidePanelInfo.mIndex != n) continue;
            return sidePanelInfo;
        }
        return null;
    }

    public SidePanelInfo findOneSidePanelInfo(List<SidePanelInfo> list, int n, int n2) {
        for (SidePanelInfo sidePanelInfo : list) {
            if (sidePanelInfo.mIndex != n || sidePanelInfo.mSpan != n2) continue;
            return sidePanelInfo;
        }
        return null;
    }

    public List<SidePanelInfo> findManySidePanelInfo(List<SidePanelInfo> list, int n, int n2) {
        ArrayList<SidePanelInfo> arrayList = new ArrayList<SidePanelInfo>();
        for (SidePanelInfo sidePanelInfo : list) {
            if (sidePanelInfo.mIndex + sidePanelInfo.mSpan <= n || sidePanelInfo.mIndex >= n + n2) continue;
            arrayList.add(sidePanelInfo);
        }
        return arrayList;
    }

    public int calcBothSidePanelRestSpan(SNYEntities sNYEntities, PanelDirectionType panelDirectionType) {
        int n = this.calcLeftPanelRestSpan(sNYEntities, panelDirectionType);
        int n2 = this.calcRightPanelRestSpan(sNYEntities, panelDirectionType);
        return Math.max(n, n2);
    }

    public int calcLeftPanelRestSpan(SNYEntities sNYEntities, PanelDirectionType panelDirectionType) {
        return this.calcSidePanelRestSpan(sNYEntities, PanelDirectionType.LEFT, panelDirectionType);
    }

    public int calcRightPanelRestSpan(SNYEntities sNYEntities, PanelDirectionType panelDirectionType) {
        return this.calcSidePanelRestSpan(sNYEntities, PanelDirectionType.RIGHT, panelDirectionType);
    }

    public int calcSidePanelRestSpan(SNYEntities sNYEntities, PanelDirectionType panelDirectionType, PanelDirectionType panelDirectionType2) {
        DirectionType directionType = DirectionTypeDxo.convert(panelDirectionType);
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        TerraceInfo terraceInfo = sNYEntities.mTerraceInfoList.getLast();
        LinkedList<SidePanelInfo> linkedList = this.getPanelInfoList(sNYEntities, panelDirectionType);
        if (terracesInfo.mEnforcementType != EnforcementType.BUBUN_IRISUMI) {
            if (panelDirectionType == PanelDirectionType.LEFT && GdMutableTypeUtil.matchOR(terracesInfo.mSodePosType, SodePosType.L, SodePosType.BOTH)) {
                return 0;
            }
            if (panelDirectionType == PanelDirectionType.RIGHT && GdMutableTypeUtil.matchOR(terracesInfo.mSodePosType, SodePosType.R, SodePosType.BOTH)) {
                return 0;
            }
        }
        float f = 0.0f;
        float f2 = 0.0f;
        FloorArrangementType floorArrangementType = null;
        if (basicInfo.mSubProductType == SubProductType.HALF_KAKOI) {
            f = terraceInfo.mBackDepth.floatValue();
        } else if (terracesInfo.mEnforcementType == EnforcementType.DOMA_YUKA_D) {
            f2 = terraceInfo.mFrontDepth.floatValue();
            if (panelDirectionType2 == PanelDirectionType.FRONT) {
                f = terraceInfo.mFrontDepth.floatValue();
                floorArrangementType = FloorArrangementType.DOMA;
            } else if (panelDirectionType2 == PanelDirectionType.REAR) {
                f = terraceInfo.mBackDepth.floatValue();
                floorArrangementType = FloorArrangementType.YUKA;
            }
        } else {
            f = this.mTerraceFigureCommonService.getFrameDepth(sNYEntities, directionType);
        }
        int n = this.mTerraceFigureCommonService.calcSideSpanNum(f);
        int n2 = this.mTerraceFigureCommonService.calcSideSpanNum(f2);
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (panelDirectionType2 == PanelDirectionType.REAR) {
            n5 += n2;
            n += n2;
        }
        while (n5 < n) {
            SidePanelInfo sidePanelInfo = this.findOneSidePanelInfo(linkedList, n5);
            if (sidePanelInfo != null && (floorArrangementType == null || floorArrangementType != null && sidePanelInfo.mFloorArrangementType == floorArrangementType)) {
                n3 = Math.max(n3, n4);
                n4 = 0;
                n5 += sidePanelInfo.mSpan.intValue();
                continue;
            }
            ++n4;
            ++n5;
        }
        if (n5 == n) {
            n3 = Math.max(n3, n4);
        }
        return n3;
    }

    public boolean hasSidePanelType(List<SidePanelInfo> list, OpeningPanelType openingPanelType) {
        for (SidePanelInfo sidePanelInfo : list) {
            if (sidePanelInfo.mPanelType != openingPanelType) continue;
            return true;
        }
        return false;
    }

    public boolean hasRanma(List<SidePanelInfo> list) {
        return this.hasRanmaType(list, RanmaType.FIX, RanmaType.SLIDING);
    }

    public boolean hasRanmaType(List<SidePanelInfo> list, RanmaType ... ranmaTypeArray) {
        for (SidePanelInfo sidePanelInfo : list) {
            if (sidePanelInfo.mRanmaType == null || !GdMutableTypeUtil.matchOR(sidePanelInfo.mRanmaType, ranmaTypeArray)) continue;
            return true;
        }
        return false;
    }

    public boolean hasOnlySidePanelType(List<SidePanelInfo> list, OpeningPanelType openingPanelType) {
        if (list.isEmpty()) {
            return false;
        }
        boolean bl = true;
        for (SidePanelInfo sidePanelInfo : list) {
            if (sidePanelInfo.mPanelType == openingPanelType) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public List<SidePanelInfo> packAllSidePanel(List<SidePanelInfo> list, List<SidePanelInfo> list2) {
        LinkedList<SidePanelInfo> linkedList = new LinkedList<SidePanelInfo>();
        linkedList.addAll(list);
        linkedList.addAll(list2);
        return linkedList;
    }

    public boolean useLeftIdouHoutate(EnforcementType enforcementType, EnforcementDirType enforcementDirType) {
        return enforcementType == EnforcementType.BUBUN_IRISUMI && enforcementDirType == EnforcementDirType.L;
    }

    public boolean useRightIdouHoutate(EnforcementType enforcementType, EnforcementDirType enforcementDirType) {
        return enforcementType == EnforcementType.BUBUN_IRISUMI && enforcementDirType == EnforcementDirType.R;
    }

    public float calcPanelDepth(LinkedList<SidePanelInfo> linkedList, OpeningPanelType ... openingPanelTypeArray) {
        float f = 0.0f;
        for (SidePanelInfo sidePanelInfo : this.findManySidePanelInfo(linkedList, openingPanelTypeArray)) {
            f += sidePanelInfo.mWidth.floatValue();
        }
        return f;
    }

    public List<SidePanelInfo> findManyCombSidePanelInfo(List<SidePanelInfo> list) {
        ArrayList<SidePanelInfo> arrayList = new ArrayList<SidePanelInfo>();
        int n = this.findMaxIndex(list);
        for (SidePanelInfo sidePanelInfo : list) {
            if (sidePanelInfo.mIndex == n) continue;
            arrayList.add(sidePanelInfo);
        }
        return arrayList;
    }

    public int findMinIndex(List<SidePanelInfo> list) {
        int n = Integer.MAX_VALUE;
        for (SidePanelInfo sidePanelInfo : list) {
            if (n <= sidePanelInfo.mIndex) continue;
            n = sidePanelInfo.mIndex;
        }
        return n;
    }

    public int findMaxIndex(List<SidePanelInfo> list) {
        int n = Integer.MIN_VALUE;
        for (SidePanelInfo sidePanelInfo : list) {
            if (n >= sidePanelInfo.mIndex) continue;
            n = sidePanelInfo.mIndex;
        }
        return n;
    }

    public boolean isSidePanelPerm(SNYEntities sNYEntities, OpeningPanelType openingPanelType, OpeningPanelDepthType openingPanelDepthType, PanelHeightType panelHeightType, FloorArrangementType floorArrangementType, RanmaUseType ranmaUseType, RanmaType ranmaType, KamachiType kamachiType, DirectionType directionType, int n) {
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        TerraceInfo terraceInfo = this.mTerraceCommonService.findTerraceWithSidePanel(sNYEntities.mTerracesInfo, sNYEntities.mTerraceInfoList, directionType);
        EnforcementType enforcementType = terracesInfo.mEnforcementType;
        SodePosType sodePosType = terracesInfo.mSodePosType;
        TsukuritsukeKoshikabeType tsukuritsukeKoshikabeType = this.judgeKoshikabeType(directionType, basicInfo, terracesInfo);
        TsukuritsukeKoshikabeType tsukuritsukeKoshikabeType2 = null;
        if (basicInfo.mSubProductType == SubProductType.TSUKURITSUKE) {
            tsukuritsukeKoshikabeType2 = floorArrangementType == FloorArrangementType.KOSHIKABE ? TsukuritsukeKoshikabeType.EXIST : TsukuritsukeKoshikabeType.NONE;
        }
        Tuple3<Float, Float, FloorType> tuple3 = this.findSideOpening(sNYEntities, directionType, n);
        float f = ((Float)tuple3.value1).floatValue();
        float f2 = ((Float)tuple3.value2).floatValue();
        FloorType floorType = (FloorType)tuple3.value3;
        int n2 = (int)Math.ceil((f + 15.0f) / 300.0f);
        TypeTerraceDepthInfo typeTerraceDepthInfo = this.mTypeTerraceDepthCacheDao.findOneStdBySpan(n2);
        TerraceDepthType terraceDepthType = (TerraceDepthType)TerraceDepthTypeFactory.getInstance().getTypeById(typeTerraceDepthInfo.typeTerraceDepthId);
        if (enforcementType != EnforcementType.BUBUN_IRISUMI) {
            if (directionType == DirectionType.LEFT && GdMutableTypeUtil.matchOR(sodePosType, SodePosType.L, SodePosType.BOTH)) {
                return false;
            }
            if (directionType == DirectionType.RIGHT && GdMutableTypeUtil.matchOR(sodePosType, SodePosType.R, SodePosType.BOTH)) {
                return false;
            }
        }
        if (tsukuritsukeKoshikabeType != tsukuritsukeKoshikabeType2) {
            return false;
        }
        SpecOpeningPanelInfo specOpeningPanelInfo = this.mSpecOpeningPanelCacheDao.findOneDepthByTypes(basicInfo, terracesInfo, openingPanelType, openingPanelDepthType, kamachiType, terraceDepthType, tsukuritsukeKoshikabeType);
        if (specOpeningPanelInfo == null) {
            return false;
        }
        if (!specOpeningPanelInfo.permission.equals("1")) {
            return false;
        }
        SpecOpeningPanelHeightInfo specOpeningPanelHeightInfo = this.mSpecOpeningPanelHeightCacheDao.findOneDepthByTypes(openingPanelType, panelHeightType, ranmaUseType, ranmaType, kamachiType, openingPanelDepthType, f2, floorType, basicInfo, terracesInfo, terraceInfo);
        return specOpeningPanelHeightInfo != null && specOpeningPanelHeightInfo.permission.equals("1");
    }

    public TsukuritsukeKoshikabeType judgeKoshikabeType(DirectionType directionType, BasicInfo basicInfo, TerracesInfo terracesInfo) {
        if (basicInfo.mSubProductType != SubProductType.TSUKURITSUKE) {
            return null;
        }
        if (terracesInfo.mEnforcementType != EnforcementType.BUBUN_KAKOI) {
            return TsukuritsukeKoshikabeType.EXIST;
        }
        if (terracesInfo.mEnforcementDirType == EnforcementDirType.L == (directionType == DirectionType.LEFT)) {
            return TsukuritsukeKoshikabeType.EXIST;
        }
        return TsukuritsukeKoshikabeType.NONE;
    }

    public boolean judgeInstalledLeftPanel(SNYEntities sNYEntities) {
        int n = this.mTerraceFigureCommonService.calcLeftSpanNum(sNYEntities, false);
        return this.judgeInstalledPanel(n, sNYEntities.mLeftPanelInfoList, sNYEntities.mLeftPanelOptionInfoList);
    }

    public boolean judgeInstalledRightPanel(SNYEntities sNYEntities) {
        int n = this.mTerraceFigureCommonService.calcRightSpanNum(sNYEntities, false);
        return this.judgeInstalledPanel(n, sNYEntities.mRightPanelInfoList, sNYEntities.mRightPanelOptionInfoList);
    }

    private boolean judgeInstalledPanel(int n, List<SidePanelInfo> list, List<PanelOptionInfo> list2) {
        int n2 = 0;
        for (SidePanelInfo sidePanelInfo : list) {
            n2 += sidePanelInfo.mSpan.intValue();
        }
        if (this.mSidePanelOptionCommonService.hasPanelOptionType(list2, PanelOptionType.TOBUKURO_NIGE)) {
            ++n2;
        }
        return n2 == n;
    }

    public boolean hasLeftKutaiSidePanel(SNYEntities sNYEntities) {
        return this.hasLeftKutaiSidePanel(sNYEntities.mBasicInfo, sNYEntities.mTerraceInfoList, sNYEntities.mLeftPanelInfoList);
    }

    public boolean hasLeftKutaiSidePanel(BasicInfo basicInfo, LinkedList<TerraceInfo> linkedList, LinkedList<SidePanelInfo> linkedList2) {
        float f = linkedList.getFirst().mLeftDepth.floatValue();
        int n = this.mTerraceFigureCommonService.calcSideSpanNum(f, basicInfo, true);
        int n2 = n - 1;
        return this.hasPanelByIndex(linkedList2, n2);
    }

    public boolean hasRightKutaiSidePanel(SNYEntities sNYEntities) {
        return this.hasRightKutaiSidePanel(sNYEntities.mBasicInfo, sNYEntities.mTerraceInfoList, sNYEntities.mRightPanelInfoList);
    }

    public boolean hasRightKutaiSidePanel(BasicInfo basicInfo, LinkedList<TerraceInfo> linkedList, LinkedList<SidePanelInfo> linkedList2) {
        float f = linkedList.getLast().mRightDepth.floatValue();
        int n = this.mTerraceFigureCommonService.calcSideSpanNum(f, basicInfo, true);
        int n2 = n - 1;
        return this.hasPanelByIndex(linkedList2, n2);
    }

    /*
     * WARNING - void declaration
     */
    public boolean hasPanelByIndex(LinkedList<SidePanelInfo> linkedList, int n) {
        void var4_8;
        HashMap<Integer, Boolean> hashMap = new HashMap<Integer, Boolean>();
        for (SidePanelInfo serializable2 : linkedList) {
            int n2 = serializable2.mIndex;
            while (n2 < serializable2.mIndex + serializable2.mSpan) {
                hashMap.put(n2, true);
                ++n2;
            }
        }
        Boolean bl = (Boolean)hashMap.get(n);
        if (bl == null) {
            Boolean bl2 = false;
        }
        return var4_8.booleanValue();
    }

    public Tuple3<Float, Float, FloorType> findSideOpening(SNYEntities sNYEntities, DirectionType directionType, int n) {
        List<Tuple3<Float, Float, FloorType>> list = this.createSideOpeningList(sNYEntities, directionType);
        TypeTerraceDepthInfo typeTerraceDepthInfo = this.mTypeTerraceDepthCacheDao.findOneStdById(n);
        float f = 15.0f;
        float f2 = typeTerraceDepthInfo.length.floatValue() + f;
        float f3 = 0.0f;
        for (Tuple3<Float, Float, FloorType> tuple3 : list) {
            if (!(f2 < (f3 += ((Float)tuple3.value1).floatValue()))) continue;
            return tuple3;
        }
        if (!list.isEmpty()) {
            return list.get(list.size() - 1);
        }
        return null;
    }

    public List<Tuple3<Float, Float, FloorType>> createSideOpeningList(SNYEntities sNYEntities, DirectionType directionType) {
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        LinkedList<TerraceInfo> linkedList = sNYEntities.mTerraceInfoList;
        TerraceInfo terraceInfo = this.mTerraceCommonService.findTerraceWithSidePanel(terracesInfo, linkedList, directionType);
        EnforcementType enforcementType = terracesInfo.mEnforcementType;
        SubProductType subProductType = sNYEntities.mBasicInfo.mSubProductType;
        TsukuritsukeKoshikabeType tsukuritsukeKoshikabeType = this.judgeKoshikabeType(directionType, basicInfo, terracesInfo);
        FloorType floorType = null;
        Float f = null;
        if (directionType == DirectionType.LEFT) {
            floorType = terraceInfo.mLeftFloorType;
            f = terraceInfo.mLeftDepth;
        } else {
            floorType = terraceInfo.mRightFloorType;
            f = terraceInfo.mRightDepth;
        }
        if (floorType == null) {
            floorType = terraceInfo.mFloorType;
        }
        if (f == null) {
            f = terraceInfo.mDepth;
        }
        if (terracesInfo.mEnforcementType == EnforcementType.BUBUN_KAKOI && subProductType == SubProductType.TSUKURITSUKE && tsukuritsukeKoshikabeType == TsukuritsukeKoshikabeType.NONE) {
            f = directionType == DirectionType.LEFT ? Float.valueOf(terracesInfo.mKutaiCoping.floatValue() - this.mConstants.openingPillarHalfWidth.floatValue() * 1.0f) : Float.valueOf(terracesInfo.mKutaiCoping.floatValue() - this.mConstants.openingPillarHalfWidth.floatValue() * 1.0f);
        }
        if (GdMutableTypeUtil.matchOR(subProductType, SubProductType.TSUKURITSUKE)) {
            floorType = null;
        }
        ArrayList<Tuple3<Float, Float, FloorType>> arrayList = new ArrayList<Tuple3<Float, Float, FloorType>>();
        if (enforcementType == EnforcementType.DOMA_YUKA_D) {
            arrayList.add(this.createOpening(sNYEntities, terraceInfo, terraceInfo.mFrontDepth, FloorType.DOMA, tsukuritsukeKoshikabeType));
            arrayList.add(this.createOpening(sNYEntities, terraceInfo, terraceInfo.mBackDepth, FloorType.YUKA, tsukuritsukeKoshikabeType));
        } else if (enforcementType == EnforcementType.BUBUN_KAKOI && subProductType == SubProductType.YUKA) {
            arrayList.add(this.createOpening(sNYEntities, terraceInfo, f, FloorType.YUKA, tsukuritsukeKoshikabeType));
        } else {
            arrayList.add(this.createOpening(sNYEntities, terraceInfo, f, floorType, tsukuritsukeKoshikabeType));
        }
        return arrayList;
    }

    private Tuple3<Float, Float, FloorType> createOpening(SNYEntities sNYEntities, TerraceInfo terraceInfo, Float f, FloorType floorType, TsukuritsukeKoshikabeType tsukuritsukeKoshikabeType) {
        float f2 = this.mPanelInfoCommonService.calcOpeningHeight(sNYEntities, terraceInfo, floorType, tsukuritsukeKoshikabeType);
        return new Tuple3((Object)f, (Object)Float.valueOf(f2), (Object)floorType);
    }
}

