/*
 * Decompiled with CFR 0.152.
 */
package option.loneterrace.common.service.parts;

import com.kt.annotation.Reflectable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import option.estsys.terrace.common.service.parts.TRCPanelOptionService;
import option.gad.core.inject.GdInject;
import option.gad.core.util.GdMutableTypeUtil;
import option.gad.core.util.Tuple;
import option.loneterrace.common.entity.PanelInfo;
import option.loneterrace.common.entity.SNYEntities;
import option.loneterrace.common.entity.TerraceInfo;
import option.loneterrace.common.entity.paneloption.AmidoInfo;
import option.loneterrace.common.entity.paneloption.NakasanInfo;
import option.loneterrace.common.entity.paneloption.PanelOptionInfo;
import option.loneterrace.common.entity.paneloption.RanmaSlidingInfo;
import option.loneterrace.common.entity.paneloption.TobukuroNigeInfo;
import option.loneterrace.common.entity.spec.SpecOpeningOptionComboInfo;
import option.loneterrace.common.service.cut.PanelCutCommonService;
import option.loneterrace.common.type.PanelDirectionType;
import option.loneterrace.common.type.RanmaType;
import option.loneterrace.common.type.constant.HeightArrangementType;
import option.loneterrace.common.type.paneloption.PanelOptionType;

@Reflectable
public class PanelOptionCommonService
extends TRCPanelOptionService {
    @GdInject
    private PanelCutCommonService mPanelCutCommonService;

    public void clearAllPanelOptions(SNYEntities sNYEntities) {
        sNYEntities.mFrontPanelOptionInfoList.clear();
        sNYEntities.mLeftPanelOptionInfoList.clear();
        sNYEntities.mRightPanelOptionInfoList.clear();
    }

    public void add(SNYEntities sNYEntities, PanelOptionInfo panelOptionInfo, List<SpecOpeningOptionComboInfo> list) {
        LinkedList<PanelOptionInfo> linkedList = this.getPanelOptionInfoList(sNYEntities, panelOptionInfo.mDirectionType);
        this.add(sNYEntities, linkedList, panelOptionInfo, list);
    }

    public void add(SNYEntities sNYEntities, LinkedList<PanelOptionInfo> linkedList, PanelOptionInfo panelOptionInfo, List<SpecOpeningOptionComboInfo> list) {
        this.remove(sNYEntities, linkedList, panelOptionInfo, list);
        linkedList.add(panelOptionInfo);
        HashSet<PanelInfo> hashSet = this.mPanelCutCommonService.getChangedPanelSet(sNYEntities, panelOptionInfo, null, panelOptionInfo.mDirectionType);
        this.updatePanelCutInfo(sNYEntities, hashSet, panelOptionInfo.mDirectionType);
    }

    public void remove(SNYEntities sNYEntities, PanelDirectionType panelDirectionType, int n, int n2) {
        LinkedList<PanelOptionInfo> linkedList = this.getPanelOptionInfoList(sNYEntities, panelDirectionType);
        this.remove(sNYEntities, linkedList, n, n2);
    }

    public void remove(SNYEntities sNYEntities, LinkedList<PanelOptionInfo> linkedList, int n, int n2) {
        LinkedList<PanelOptionInfo> linkedList2 = this.findManyPanelOptionInfoForPanel(linkedList, n, n2);
        linkedList.removeAll(linkedList2);
    }

    public void remove(SNYEntities sNYEntities, PanelOptionInfo panelOptionInfo, List<SpecOpeningOptionComboInfo> list) {
        LinkedList<PanelOptionInfo> linkedList = this.getPanelOptionInfoList(sNYEntities, panelOptionInfo.mDirectionType);
        this.remove(sNYEntities, linkedList, panelOptionInfo, list);
    }

    public void remove(SNYEntities sNYEntities, LinkedList<PanelOptionInfo> linkedList, PanelOptionInfo panelOptionInfo, List<SpecOpeningOptionComboInfo> list) {
        List<PanelOptionInfo> list2 = this.findManyHeldInfo(list, linkedList, panelOptionInfo.mHeightArrangementType, panelOptionInfo.mTerraceId, panelOptionInfo.mIndex, panelOptionInfo.mHeightIndex);
        if (!list2.isEmpty() && linkedList.removeAll(list2)) {
            HashSet<PanelInfo> hashSet = this.mPanelCutCommonService.getChangedPanelSet(sNYEntities, list2, null, panelOptionInfo.mDirectionType);
            this.updatePanelCutInfo(sNYEntities, hashSet, panelOptionInfo.mDirectionType);
        }
    }

    public void removeFrontBySide(SNYEntities sNYEntities, List<SpecOpeningOptionComboInfo> list) {
        List<PanelOptionInfo> list2 = this.findManyPanelOptionInfoByComboInfo(sNYEntities.mFrontPanelOptionInfoList, list);
        sNYEntities.mFrontPanelOptionInfoList.removeAll(list2);
    }

    private void updatePanelCutInfo(SNYEntities sNYEntities, HashSet<PanelInfo> hashSet, PanelDirectionType panelDirectionType) {
        if (GdMutableTypeUtil.matchOR(panelDirectionType, PanelDirectionType.LEFT, PanelDirectionType.RIGHT)) {
            this.mPanelCutCommonService.updateSidePanelCutInfo(sNYEntities, hashSet, panelDirectionType);
        } else {
            this.mPanelCutCommonService.updateFrontPanelCutInfo(sNYEntities, hashSet);
        }
    }

    public List<PanelOptionInfo> findManyHeldInfo(List<SpecOpeningOptionComboInfo> list, List<PanelOptionInfo> list2, HeightArrangementType heightArrangementType, Integer n, Integer n2, Integer n3) {
        ArrayList<PanelOptionInfo> arrayList = new ArrayList<PanelOptionInfo>();
        for (PanelOptionInfo panelOptionInfo : list2) {
            boolean bl = this.equalsHeightArrangementType(heightArrangementType, panelOptionInfo.mHeightArrangementType);
            if (!bl) continue;
            for (SpecOpeningOptionComboInfo specOpeningOptionComboInfo : list) {
                int n4 = 1 << panelOptionInfo.mPanelOptionType.ordinal();
                long l = Long.parseLong(specOpeningOptionComboInfo.option2Type, 2);
                long l2 = l & (long)n4;
                if (l2 == 0L || n != null && n != panelOptionInfo.mTerraceId || specOpeningOptionComboInfo.checkOptionIndex != null && specOpeningOptionComboInfo.checkOptionIndex.equals("1") && n2 != panelOptionInfo.mIndex || specOpeningOptionComboInfo.checkOptionHeightIndex != null && specOpeningOptionComboInfo.checkOptionHeightIndex.equals("1") && n3 != panelOptionInfo.mHeightIndex) continue;
                arrayList.add(panelOptionInfo);
            }
        }
        return arrayList;
    }

    public List<PanelOptionInfo> findManyPanelOptionInfoByComboInfo(LinkedList<PanelOptionInfo> linkedList, List<SpecOpeningOptionComboInfo> list) {
        HashSet<PanelOptionType> hashSet = new HashSet<PanelOptionType>();
        for (SpecOpeningOptionComboInfo specOpeningOptionComboInfo : list) {
            int n = (int)Long.parseLong(specOpeningOptionComboInfo.option2Type, 2);
            int n2 = 0;
            while (n2 < specOpeningOptionComboInfo.option2Type.length()) {
                int n3 = 1 << n2;
                int n4 = n & n3;
                if (n4 != 0) {
                    PanelOptionType panelOptionType = PanelOptionType.values()[n2];
                    hashSet.add(panelOptionType);
                }
                ++n2;
            }
        }
        return this.findManyPanelOptionInfoByType(linkedList, new ArrayList<PanelOptionType>(hashSet));
    }

    public List<PanelOptionInfo> findManyPanelOptionInfoByType(LinkedList<PanelOptionInfo> linkedList, List<PanelOptionType> list) {
        ArrayList<PanelOptionInfo> arrayList = new ArrayList<PanelOptionInfo>();
        for (PanelOptionInfo panelOptionInfo : linkedList) {
            if (!list.contains(panelOptionInfo.mPanelOptionType)) continue;
            arrayList.add(panelOptionInfo);
        }
        return arrayList;
    }

    public List<PanelOptionType> findManyDependingOptionType(PanelOptionType panelOptionType) {
        ArrayList<PanelOptionType> arrayList = new ArrayList<PanelOptionType>();
        if (panelOptionType == PanelOptionType.SIDE_FENCE) {
            arrayList.add(PanelOptionType.ASHIGAKARI_BOUSHI_NET);
        }
        return arrayList;
    }

    public TobukuroNigeInfo findOneTobukuroNigeInfo(LinkedList<PanelOptionInfo> linkedList, TerraceInfo terraceInfo) {
        Integer n = null;
        if (terraceInfo != null) {
            n = terraceInfo.mId;
        }
        return (TobukuroNigeInfo)this.findOnePanelOptionInfo(linkedList, n, null, null, null, PanelOptionType.TOBUKURO_NIGE);
    }

    public AmidoInfo findOneAmidoInfo(LinkedList<PanelOptionInfo> linkedList, TerraceInfo terraceInfo, Integer n) {
        AmidoInfo amidoInfo;
        Integer n2 = null;
        if (terraceInfo != null) {
            n2 = terraceInfo.mId;
        }
        if ((amidoInfo = (AmidoInfo)this.findOnePanelOptionInfo(linkedList, n2, n, null, HeightArrangementType.PANEL, PanelOptionType.AMIDO)) != null) {
            return amidoInfo;
        }
        return (AmidoInfo)this.findOnePanelOptionInfo(linkedList, n2, n, null, HeightArrangementType.UPPER_PANEL_PARTS, PanelOptionType.AMIDO);
    }

    public AmidoInfo findOneRanmaAmidoInfo(LinkedList<PanelOptionInfo> linkedList, TerraceInfo terraceInfo, Integer n) {
        Integer n2 = null;
        if (terraceInfo != null) {
            n2 = terraceInfo.mId;
        }
        return (AmidoInfo)this.findOnePanelOptionInfo(linkedList, n2, n, null, HeightArrangementType.RANMA, PanelOptionType.AMIDO);
    }

    public RanmaSlidingInfo findOneRanmaSlidingInfo(LinkedList<PanelOptionInfo> linkedList, TerraceInfo terraceInfo, Integer n) {
        Integer n2 = null;
        if (terraceInfo != null) {
            n2 = terraceInfo.mId;
        }
        return (RanmaSlidingInfo)this.findOnePanelOptionInfo(linkedList, n2, n, null, null, PanelOptionType.RANMA_SLIDING);
    }

    public NakasanInfo findOneNakasanInfo(LinkedList<PanelOptionInfo> linkedList, TerraceInfo terraceInfo, Integer n) {
        Integer n2 = null;
        if (terraceInfo != null) {
            n2 = terraceInfo.mId;
        }
        return (NakasanInfo)this.findOnePanelOptionInfo(linkedList, n2, n, null, null, PanelOptionType.NAKASAN);
    }

    public Tuple<Boolean, Boolean> hasAmido(LinkedList<PanelOptionInfo> linkedList, int n, int n2) {
        Tuple tuple = new Tuple();
        tuple.value1 = this.hasRanmaAmido(linkedList, n, n2);
        tuple.value2 = this.hasPanelAmido(linkedList, n, n2) || this.hasUpperPanelPartsAmido(linkedList, n, n2);
        return tuple;
    }

    public boolean hasRanmaAmido(LinkedList<PanelOptionInfo> linkedList, int n, int n2) {
        return this.hasPanelOption(linkedList, PanelOptionType.AMIDO, n, n2, null, HeightArrangementType.RANMA);
    }

    public boolean hasPanelAmido(LinkedList<PanelOptionInfo> linkedList, int n, int n2) {
        return this.hasPanelOption(linkedList, PanelOptionType.AMIDO, n, n2, null, HeightArrangementType.PANEL);
    }

    public boolean hasUpperPanelPartsAmido(LinkedList<PanelOptionInfo> linkedList, int n, int n2) {
        return this.hasPanelOption(linkedList, PanelOptionType.AMIDO, n, n2, null, HeightArrangementType.UPPER_PANEL_PARTS);
    }

    public boolean hasNakazan(LinkedList<PanelOptionInfo> linkedList, int n, int n2) {
        return this.hasPanelOption(linkedList, PanelOptionType.NAKASAN, n, n2);
    }

    public boolean hasMekakushiPanel(LinkedList<PanelOptionInfo> linkedList, int n, int n2) {
        return this.hasPanelOption(linkedList, PanelOptionType.MEKAKUSHI_PANEL_SET, n, n2);
    }

    public boolean hasRanmaSliding(LinkedList<PanelOptionInfo> linkedList, int n, int n2) {
        return this.hasPanelOption(linkedList, PanelOptionType.RANMA_SLIDING, n, n2);
    }

    public RanmaType judgeRanmaType(SNYEntities sNYEntities, RanmaType ranmaType, Integer n, Integer n2, PanelDirectionType panelDirectionType) {
        if (panelDirectionType == null) {
            return ranmaType;
        }
        LinkedList<PanelOptionInfo> linkedList = null;
        if (panelDirectionType == PanelDirectionType.FRONT) {
            linkedList = sNYEntities.mFrontPanelOptionInfoList;
        } else if (panelDirectionType == PanelDirectionType.LEFT) {
            linkedList = sNYEntities.mLeftPanelOptionInfoList;
        } else if (panelDirectionType == PanelDirectionType.RIGHT) {
            linkedList = sNYEntities.mRightPanelOptionInfoList;
        }
        Object t = this.findOnePanelOptionInfo(linkedList, n, n2, null, HeightArrangementType.RANMA, PanelOptionType.RANMA_SLIDING);
        return t == null ? ranmaType : RanmaType.SLIDING;
    }
}

