/*
 * Decompiled with CFR 0.152.
 */
package option.loneterrace.common.service.parts;

import java.util.LinkedList;
import option.gad.core.inject.GdInject;
import option.gad.core.inject.GdInjector;
import option.gad.core.util.GdMutableTypeUtil;
import option.loneterrace.common.dao.cache.spec.SpecOpeningHeightCacheDao;
import option.loneterrace.common.dao.cache.type.TypeTerraceWidthCacheDao;
import option.loneterrace.common.entity.BasicInfo;
import option.loneterrace.common.entity.Constants;
import option.loneterrace.common.entity.FloorInfo;
import option.loneterrace.common.entity.PanelCutInfo;
import option.loneterrace.common.entity.PanelInfo;
import option.loneterrace.common.entity.PartsFigureInfo;
import option.loneterrace.common.entity.TerracesInfo;
import option.loneterrace.common.entity.spec.SpecOpeningHeightInfo;
import option.loneterrace.common.entity.type.TypeTerraceWidthInfo;
import option.loneterrace.common.service.parts.TerraceFigureCommonService;
import option.loneterrace.common.type.KenType;
import option.loneterrace.common.type.RanmaUseType;
import option.loneterrace.common.type.SubProductType;
import option.loneterrace.common.type.TerraceHeightType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PanelFigureCommonService {
    @GdInject
    protected Constants mConstants;
    @GdInject
    protected TerraceFigureCommonService mTerraceFigureCommonService;
    @GdInject
    protected SpecOpeningHeightCacheDao mSpecOpeningHeightCacheDao;
    @GdInject
    protected TypeTerraceWidthCacheDao mTypeTerraceWidthCacheDao;
    private static final int LOUVER_W = 749;
    private static final int RANMA_H = 430;
    private Log mLog = LogFactory.getLog(PanelFigureCommonService.class);

    public PanelFigureCommonService() {
        GdInjector.getInstance().inject((Object)this);
    }

    public <PI extends PanelInfo> float calcTotalWidth(LinkedList<PI> linkedList, Integer n) {
        float f = 0.0f;
        for (PanelInfo panelInfo : linkedList) {
            if (panelInfo.mTerraceGroupId != null && panelInfo.mTerraceGroupId != n) continue;
            f += panelInfo.mWidth.floatValue();
        }
        return f;
    }

    public <PI extends PanelInfo> float calcTotalDefaultWidth(LinkedList<PI> linkedList, Integer n) {
        float f = 0.0f;
        for (PanelInfo panelInfo : linkedList) {
            if (panelInfo.mTerraceGroupId != null && panelInfo.mTerraceGroupId != n) continue;
            f += panelInfo.mDefaultWidth.floatValue();
        }
        return f;
    }

    public <PI extends PanelInfo> float calcTotalTypeWidth(LinkedList<PI> linkedList, Integer n, KenType kenType) {
        float f = 0.0f;
        for (PanelInfo panelInfo : linkedList) {
            if (panelInfo.mTerraceGroupId != null && panelInfo.mTerraceGroupId != n) continue;
            TypeTerraceWidthInfo typeTerraceWidthInfo = this.mTypeTerraceWidthCacheDao.findOneByType(panelInfo.mWidthType, kenType);
            f += typeTerraceWidthInfo.length.floatValue();
        }
        return f;
    }

    public float calcOpeningPanelHeight(BasicInfo basicInfo, TerracesInfo terracesInfo, PanelInfo panelInfo, FloorInfo floorInfo, PartsFigureInfo partsFigureInfo) {
        SubProductType subProductType = basicInfo.mSubProductType;
        float f = terracesInfo.mHeight.floatValue() - this.mTerraceFigureCommonService.calcH2(basicInfo, floorInfo);
        if (subProductType == SubProductType.TSUKURITSUKE) {
            f -= 28.0f;
        } else if (GdMutableTypeUtil.matchOR(subProductType, SubProductType.ALMI_BALCONY_PILLAR, SubProductType.ALMI_BALCONY_ROOF)) {
            f -= 56.0f;
        }
        if (panelInfo != null && panelInfo.mRanmaUseType == RanmaUseType.EXIST) {
            f -= (float)this.getRanmaHeight();
        }
        return f;
    }

    public float diffOpeningPanelHeight(BasicInfo basicInfo, TerracesInfo terracesInfo, PanelInfo panelInfo, FloorInfo floorInfo, PartsFigureInfo partsFigureInfo, boolean bl, boolean bl2) {
        SubProductType subProductType = basicInfo.mSubProductType;
        RanmaUseType ranmaUseType = panelInfo != null ? panelInfo.mRanmaUseType : RanmaUseType.NONE;
        TerraceHeightType terraceHeightType = terracesInfo.mHeightType;
        SpecOpeningHeightInfo specOpeningHeightInfo = this.mSpecOpeningHeightCacheDao.findOneByTypes(subProductType, ranmaUseType, terraceHeightType, bl, bl2);
        float f = this.calcOpeningPanelHeight(basicInfo, terracesInfo, panelInfo, floorInfo, partsFigureInfo);
        float f2 = specOpeningHeightInfo != null ? specOpeningHeightInfo.openingHeight : 0;
        return f2 - f;
    }

    public float calcFH(BasicInfo basicInfo, TerracesInfo terracesInfo, FloorInfo floorInfo, PartsFigureInfo partsFigureInfo, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        float f = 0.0f;
        float f2 = terracesInfo.mHeight.floatValue();
        if (bl) {
            f = f2 - 29.0f;
        } else {
            f = f2 - 1.0f;
            if (bl2) {
                f = basicInfo.mSubProductType != SubProductType.TSUKURITSUKE ? (f -= this.mTerraceFigureCommonService.calcH2(basicInfo, floorInfo)) : (f -= 68.0f);
            }
            if (bl3) {
                f -= (float)this.getRanmaHeight();
            }
            if (GdMutableTypeUtil.matchOR(basicInfo.mSubProductType, SubProductType.ALMI_BALCONY_PILLAR, SubProductType.ALMI_BALCONY_ROOF)) {
                f -= 56.0f;
            }
        }
        return f;
    }

    public float calcSH(BasicInfo basicInfo, TerracesInfo terracesInfo, FloorInfo floorInfo, PartsFigureInfo partsFigureInfo, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        float f = terracesInfo.mHeight.floatValue();
        float f2 = f - 51.0f;
        if (bl2) {
            f2 = basicInfo.mSubProductType != SubProductType.TSUKURITSUKE ? (f2 -= this.mTerraceFigureCommonService.calcH2(basicInfo, floorInfo)) : (f2 -= 68.0f);
        }
        if (bl3) {
            f2 -= (float)this.getRanmaHeight();
        }
        if (GdMutableTypeUtil.matchOR(basicInfo.mSubProductType, SubProductType.ALMI_BALCONY_PILLAR, SubProductType.ALMI_BALCONY_ROOF)) {
            f2 -= 56.0f;
        }
        if (bl4) {
            f2 = (float)((double)f2 + 16.5);
        }
        return f2;
    }

    public float calcMH(BasicInfo basicInfo, TerracesInfo terracesInfo, FloorInfo floorInfo, PartsFigureInfo partsFigureInfo, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        float f = terracesInfo.mHeight.floatValue();
        float f2 = f - 41.0f;
        if (bl3) {
            f2 -= (float)this.getRanmaHeight();
        }
        if (GdMutableTypeUtil.matchOR(basicInfo.mSubProductType, SubProductType.ALMI_BALCONY_PILLAR, SubProductType.ALMI_BALCONY_ROOF)) {
            f2 -= 56.0f;
        }
        if (bl4) {
            f2 -= 3.0f;
        }
        return f2;
    }

    public float calcDH(BasicInfo basicInfo, TerracesInfo terracesInfo, FloorInfo floorInfo, PartsFigureInfo partsFigureInfo, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        float f = terracesInfo.mHeight.floatValue();
        float f2 = f - 1.0f;
        if (bl2) {
            f2 = basicInfo.mSubProductType != SubProductType.TSUKURITSUKE ? (f2 -= this.mTerraceFigureCommonService.calcH2(basicInfo, floorInfo) + 19.0f - 1.0f) : (f2 -= 68.0f);
        }
        if (GdMutableTypeUtil.matchOR(basicInfo.mSubProductType, SubProductType.ALMI_BALCONY_PILLAR, SubProductType.ALMI_BALCONY_ROOF)) {
            f2 -= 56.0f;
        }
        if (bl3) {
            f2 -= (float)this.getRanmaHeight();
        }
        return f2;
    }

    public float calcFW(PanelInfo panelInfo, PanelCutInfo panelCutInfo, Integer n) {
        float f = n.intValue();
        if (panelCutInfo.mShoujiNum == 2) {
            f = panelInfo.mWidth.floatValue() / 2.0f - 53.5f;
        }
        return f;
    }

    public int getRanmaHeight() {
        return 430;
    }

    public int getLouverWidth() {
        return 749;
    }

    public int getTatesuberiWidth(BasicInfo basicInfo, boolean bl) {
        int n = 0;
        n = basicInfo.mKenType == KenType.KANTOUMA || !bl ? 354 : 399;
        return n;
    }
}

