/*
 * Decompiled with CFR 0.152.
 */
package option.loneterrace.common.service.parts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import option.gad.core.inject.GdInject;
import option.gad.core.util.ListUniqueDecorator;
import option.loneterrace.common.entity.Constants;
import option.loneterrace.common.entity.option.GeneralOptionInfo;
import option.loneterrace.common.entity.option.OptionInfo;
import option.loneterrace.common.type.OptionType;
import option.loneterrace.server.type.PickCategoryType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OptionCommonService {
    @GdInject
    protected Constants constants;
    private static final Log log = LogFactory.getLog(OptionCommonService.class);

    protected OptionCommonService() {
    }

    public <T extends OptionInfo> T findOneOptionInfo(OptionType optionType, List<OptionInfo> list) {
        for (OptionInfo optionInfo : list) {
            if (optionInfo.mOptionType != optionType) continue;
            return (T)optionInfo;
        }
        return null;
    }

    public List<GeneralOptionInfo> findManyOptionInfoByCategoryType(PickCategoryType pickCategoryType, List<OptionInfo> list) {
        ArrayList<GeneralOptionInfo> arrayList = new ArrayList<GeneralOptionInfo>();
        for (OptionInfo optionInfo : list) {
            if (!(optionInfo instanceof GeneralOptionInfo)) continue;
            GeneralOptionInfo generalOptionInfo = (GeneralOptionInfo)optionInfo;
            if (generalOptionInfo.mCategoryType != pickCategoryType) continue;
            arrayList.add(generalOptionInfo);
        }
        return arrayList;
    }

    public boolean hasOptionByCategoryType(PickCategoryType pickCategoryType, List<OptionInfo> list) {
        boolean bl = false;
        for (OptionInfo optionInfo : list) {
            if (!(optionInfo instanceof GeneralOptionInfo)) continue;
            GeneralOptionInfo generalOptionInfo = (GeneralOptionInfo)optionInfo;
            if (generalOptionInfo.mCategoryType != pickCategoryType) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean judgeUseOption(OptionType[] optionTypeArray, List<OptionInfo> list) {
        return this.judgeUseOption(Arrays.asList(optionTypeArray), list);
    }

    public boolean judgeUseOption(List<OptionType> list, List<OptionInfo> list2) {
        boolean bl = false;
        for (OptionType optionType : list) {
            Object t = this.findOneOptionInfo(optionType, list2);
            if (!((OptionInfo)t).mUsed.booleanValue()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public List<OptionInfo> findManySelectedOptionInfo(List<OptionType> list, List<OptionInfo> list2) {
        ListUniqueDecorator listUniqueDecorator = new ListUniqueDecorator(new ArrayList());
        for (OptionType optionType : list) {
            Object t = this.findOneOptionInfo(optionType, list2);
            if (t == null || !((OptionInfo)t).mUsed.booleanValue()) continue;
            listUniqueDecorator.add(t);
        }
        return listUniqueDecorator;
    }

    public List<OptionType> findManySelectedOptionType(List<OptionInfo> list) {
        ArrayList<OptionType> arrayList = new ArrayList<OptionType>();
        for (OptionInfo optionInfo : list) {
            if (!optionInfo.mUsed.booleanValue()) continue;
            arrayList.add(optionInfo.mOptionType);
        }
        return arrayList;
    }

    public boolean matchOptionTypeSet(Set<OptionType> set, Set<OptionType> set2) {
        if (set.size() != set2.size()) {
            return false;
        }
        for (OptionType optionType : set) {
            boolean bl = false;
            for (OptionType optionType2 : set2) {
                if (!optionType.equals(optionType2)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }
}

