/*
 * Decompiled with CFR 0.152.
 */
package option.loneterrace.common.service.parts;

import com.kt.annotation.Reflectable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import option.gad.core.inject.GdInject;
import option.loneterrace.common.dao.cache.spec.SpecBuildingSizeComboCacheDao;
import option.loneterrace.common.entity.BasicInfo;
import option.loneterrace.common.entity.SNYEntities;
import option.loneterrace.common.entity.TerraceInfo;
import option.loneterrace.common.entity.TerracesInfo;
import option.loneterrace.common.entity.spec.SpecBuildingSizeComboInfo;
import option.loneterrace.common.type.BuildingType;

@Reflectable
public class MultiSpanCommonService {
    @GdInject
    protected SpecBuildingSizeComboCacheDao mSpecBuildingSizeComboCacheDao;

    public boolean judgeCombo(SNYEntities sNYEntities) {
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        LinkedList<TerraceInfo> linkedList = sNYEntities.mTerraceInfoList;
        for (TerraceInfo terraceInfo : linkedList) {
            if (terraceInfo.mBuildingType == BuildingType.CORNER) continue;
            boolean bl = false;
            Collection<SpecBuildingSizeComboInfo> collection = this.mSpecBuildingSizeComboCacheDao.findManyByTypes(basicInfo, terracesInfo, terraceInfo, linkedList);
            for (SpecBuildingSizeComboInfo specBuildingSizeComboInfo : collection) {
                if (specBuildingSizeComboInfo == null || specBuildingSizeComboInfo.permission.equals("0")) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    public boolean hasAdditional(List<TerraceInfo> list) {
        boolean bl = false;
        for (TerraceInfo terraceInfo : list) {
            if (terraceInfo.mIsStarting.booleanValue()) continue;
            bl = true;
            break;
        }
        return bl;
    }
}

