/*
 * Decompiled with CFR 0.152.
 */
package option.loneterrace.common.service.parts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import option.gad.core.inject.GdInject;
import option.gad.core.inject.GdInjector;
import option.gad.core.util.EnumUtil;
import option.gad.core.util.ObjectUtil;
import option.loneterrace.common.dao.cache.spec.SpecOpeningOptionCacheDao;
import option.loneterrace.common.entity.BasicInfo;
import option.loneterrace.common.entity.SNYEntities;
import option.loneterrace.common.entity.TerraceInfo;
import option.loneterrace.common.entity.TerracesInfo;
import option.loneterrace.common.entity.paneloption.PanelOptionInfo;
import option.loneterrace.common.entity.spec.SpecOpeningOptionComboInfo;
import option.loneterrace.common.entity.spec.SpecOpeningOptionInfo;
import option.loneterrace.common.service.parts.PanelOptionCommonService;
import option.loneterrace.common.service.parts.TerraceFigureCommonService;
import option.loneterrace.common.type.FloorArrangementType;
import option.loneterrace.common.type.OpeningPanelType;
import option.loneterrace.common.type.RanmaType;
import option.loneterrace.common.type.RanmaUseType;
import option.loneterrace.common.type.TerraceWidthType;
import option.loneterrace.common.type.constant.HeightArrangementType;
import option.loneterrace.common.type.constant.SurfaceArrangementType;
import option.loneterrace.common.type.paneloption.PanelOptionType;

public class FrontPanelOptionCommonService
extends PanelOptionCommonService {
    @GdInject
    protected TerraceFigureCommonService mTerraceFigureCommonService;
    @GdInject
    protected SpecOpeningOptionCacheDao mSpecOpeningOptionCacheDao;

    public FrontPanelOptionCommonService() {
        GdInjector.getInstance().inject((Object)this);
    }

    public void addAllFront(SNYEntities sNYEntities, PanelOptionInfo panelOptionInfo, List<SpecOpeningOptionComboInfo> list) {
        for (TerraceInfo terraceInfo : sNYEntities.mTerraceInfoList) {
            int n = this.mTerraceFigureCommonService.calcFrontHalfSpanNum(sNYEntities, terraceInfo);
            int n2 = 0;
            while (n2 < n) {
                PanelOptionInfo panelOptionInfo2 = (PanelOptionInfo)ObjectUtil.shallowCopy((Object)panelOptionInfo);
                panelOptionInfo2.mTerraceId = terraceInfo.mId;
                panelOptionInfo2.mIndex = n2;
                this.add(sNYEntities, panelOptionInfo, list);
                ++n2;
            }
        }
    }

    public List<PanelOptionInfo> findManyOptionInfoByTypes(LinkedList<PanelOptionInfo> linkedList, PanelOptionType ... panelOptionTypeArray) {
        ArrayList<PanelOptionInfo> arrayList = new ArrayList<PanelOptionInfo>();
        for (PanelOptionInfo panelOptionInfo : linkedList) {
            if (!EnumUtil.matchOR((Enum)panelOptionInfo.mPanelOptionType, (Enum[])panelOptionTypeArray)) continue;
            arrayList.add(panelOptionInfo);
        }
        return arrayList;
    }

    public LinkedList<PanelOptionInfo> findManySimilarFrontPanelOptionByOptionInfo(List<PanelOptionInfo> list, List<PanelOptionType> list2, PanelOptionInfo panelOptionInfo) {
        LinkedList<PanelOptionInfo> linkedList = new LinkedList<PanelOptionInfo>();
        for (PanelOptionInfo panelOptionInfo2 : list) {
            if (!panelOptionInfo2.mTerraceId.equals(panelOptionInfo.mTerraceId)) continue;
            if (panelOptionInfo2.mPanelOptionType == panelOptionInfo.mPanelOptionType) {
                linkedList.add(panelOptionInfo2);
            }
            for (PanelOptionType panelOptionType : list2) {
                if (panelOptionInfo2.mPanelOptionType != panelOptionType) continue;
                linkedList.add(panelOptionInfo2);
            }
        }
        return linkedList;
    }

    public boolean isFrontOptionPerm(SNYEntities sNYEntities, PanelOptionType panelOptionType, OpeningPanelType openingPanelType, HeightArrangementType heightArrangementType, FloorArrangementType floorArrangementType, Integer n) {
        LinkedList<TerraceInfo> linkedList = sNYEntities.mTerraceInfoList;
        boolean bl = false;
        for (TerraceInfo terraceInfo : linkedList) {
            if (!this.isFrontOptionPerm(sNYEntities, terraceInfo, panelOptionType, openingPanelType, heightArrangementType, floorArrangementType, n)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean isFrontOptionPerm(SNYEntities sNYEntities, TerraceInfo terraceInfo, PanelOptionType panelOptionType, OpeningPanelType openingPanelType, HeightArrangementType heightArrangementType, FloorArrangementType floorArrangementType, Integer n) {
        return this.isFrontOptionPerm(sNYEntities, terraceInfo, panelOptionType, null, null, null, openingPanelType, heightArrangementType, floorArrangementType, n);
    }

    public boolean isFrontOptionPerm(SNYEntities sNYEntities, TerraceInfo terraceInfo, PanelOptionType panelOptionType, TerraceWidthType terraceWidthType, RanmaType ranmaType, RanmaUseType ranmaUseType, OpeningPanelType openingPanelType, HeightArrangementType heightArrangementType, FloorArrangementType floorArrangementType, Integer n) {
        Integer n2;
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        Integer n3 = n2 = openingPanelType == null ? null : openingPanelType.id();
        if (terraceWidthType == null) {
            terraceWidthType = terraceInfo.mWidthType;
        }
        boolean bl = !terraceInfo.mDefaultWidth.equals(terraceInfo.mWidth);
        boolean bl2 = !terraceInfo.mDefaultDepth.equals(terraceInfo.mDepth);
        boolean bl3 = !terracesInfo.mDefaultHeight.equals(terracesInfo.mHeight);
        Collection<SpecOpeningOptionInfo> collection = this.mSpecOpeningOptionCacheDao.findManyByTypes(panelOptionType, basicInfo, terracesInfo, terraceInfo.mDepthType, terraceInfo.mWidthType, n2, null, terraceWidthType, ranmaType, ranmaUseType, n, null, SurfaceArrangementType.FRONT, heightArrangementType, floorArrangementType, bl, bl2, bl3);
        boolean bl4 = false;
        for (SpecOpeningOptionInfo specOpeningOptionInfo : collection) {
            if (!specOpeningOptionInfo.permission.equals("1")) continue;
            bl4 = true;
            break;
        }
        return bl4;
    }
}

