/*
 * Decompiled with CFR 0.152.
 */
package option.loneterrace.common.service.parts;

import com.kt.annotation.Reflectable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import option.gad.core.inject.GdInject;
import option.gad.core.util.GdMutableTypeUtil;
import option.gad.core.util.Tuple3;
import option.loneterrace.common.dao.cache.spec.SpecOpeningPanelCacheDao;
import option.loneterrace.common.dao.cache.spec.SpecOpeningPanelHeightCacheDao;
import option.loneterrace.common.dxo.TerraceWidthTypeDxo;
import option.loneterrace.common.entity.BasicInfo;
import option.loneterrace.common.entity.FrontPanelInfo;
import option.loneterrace.common.entity.SNYEntities;
import option.loneterrace.common.entity.TerraceInfo;
import option.loneterrace.common.entity.TerracesInfo;
import option.loneterrace.common.entity.spec.SpecOpeningPanelHeightInfo;
import option.loneterrace.common.entity.spec.SpecOpeningPanelInfo;
import option.loneterrace.common.service.cut.PanelCutCommonService;
import option.loneterrace.common.service.material.PanelInfoCommonService;
import option.loneterrace.common.service.parts.FrontPanelOptionCommonService;
import option.loneterrace.common.service.parts.TerraceCommonService;
import option.loneterrace.common.service.parts.TerraceFigureCommonService;
import option.loneterrace.common.type.BuildingType;
import option.loneterrace.common.type.DirectionType;
import option.loneterrace.common.type.EnforcementDirType;
import option.loneterrace.common.type.EnforcementType;
import option.loneterrace.common.type.FloorType;
import option.loneterrace.common.type.KamachiType;
import option.loneterrace.common.type.OpeningPanelType;
import option.loneterrace.common.type.OpeningPanelWidthType;
import option.loneterrace.common.type.PanelDirectionType;
import option.loneterrace.common.type.PanelHeightType;
import option.loneterrace.common.type.RanmaType;
import option.loneterrace.common.type.RanmaUseType;
import option.loneterrace.common.type.SubProductType;
import option.loneterrace.common.type.TerraceWidthType;

@Reflectable
public class FrontPanelCommonService {
    @GdInject
    protected TerraceCommonService mTerraceCommonService;
    @GdInject
    protected TerraceFigureCommonService mTerraceFigureCommonService;
    @GdInject
    protected FrontPanelOptionCommonService mFrontPanelOptionCommonService;
    @GdInject
    protected PanelCutCommonService mPanelCutCommonService;
    @GdInject
    protected PanelInfoCommonService mPanelInfoCommonService;
    @GdInject
    protected SpecOpeningPanelCacheDao mSpecOpeningPanelCacheDao;
    @GdInject
    protected SpecOpeningPanelHeightCacheDao mSpecOpeningPanelHeightCacheDao;

    public LinkedList<FrontPanelInfo> getPanelInfoList(SNYEntities sNYEntities, PanelDirectionType panelDirectionType) {
        LinkedList<FrontPanelInfo> linkedList = null;
        if (panelDirectionType == PanelDirectionType.FRONT) {
            linkedList = sNYEntities.mFrontPanelInfoList;
        }
        return linkedList;
    }

    public void initFrontPanel(SNYEntities sNYEntities) {
        sNYEntities.mFrontPanelInfoList.clear();
        sNYEntities.mFrontPanelCutInfoList.clear();
        sNYEntities.mFrontPanelOptionInfoList.clear();
        sNYEntities.mTerracesInfo.mIsCutAdjustment = false;
    }

    public void resetFrontPanels(SNYEntities sNYEntities) {
        this.resetFrontPanels(sNYEntities, sNYEntities.mFrontPanelInfoList);
    }

    public void resetFrontPanels(SNYEntities sNYEntities, LinkedList<FrontPanelInfo> linkedList) {
        for (FrontPanelInfo frontPanelInfo : linkedList) {
            this.resetFrontPanel(sNYEntities, frontPanelInfo);
        }
    }

    public void resetFrontPanel(SNYEntities sNYEntities, FrontPanelInfo frontPanelInfo) {
        frontPanelInfo.mWidth = frontPanelInfo.mDefaultWidth;
        frontPanelInfo.mHeight = frontPanelInfo.mDefaultHeight;
        this.mPanelCutCommonService.updateFrontPanelCutInfo(sNYEntities, frontPanelInfo);
    }

    public FrontPanelInfo createFrontPanelInfo(int n, int n2, int n3, float f, TerraceWidthType terraceWidthType) {
        FrontPanelInfo frontPanelInfo = new FrontPanelInfo();
        frontPanelInfo.mTerraceId = n;
        frontPanelInfo.mIndex = n2;
        frontPanelInfo.mSpan = n3;
        frontPanelInfo.mWidth = Float.valueOf(f);
        frontPanelInfo.mWidthType = terraceWidthType;
        return frontPanelInfo;
    }

    public void add(SNYEntities sNYEntities, FrontPanelInfo frontPanelInfo, int n, int n2, int n3) {
        LinkedList<FrontPanelInfo> linkedList = this.getPanelInfoList(sNYEntities, PanelDirectionType.FRONT);
        this.add(sNYEntities, linkedList, frontPanelInfo, n, n2, n3);
    }

    public void add(SNYEntities sNYEntities, LinkedList<FrontPanelInfo> linkedList, FrontPanelInfo frontPanelInfo, int n, int n2, int n3) {
        this.remove(sNYEntities, n, n2, n3);
        linkedList.add(frontPanelInfo);
        Collections.sort(linkedList, new Comparator<FrontPanelInfo>(){

            @Override
            public int compare(FrontPanelInfo frontPanelInfo, FrontPanelInfo frontPanelInfo2) {
                return frontPanelInfo.mIndex < frontPanelInfo2.mIndex ? -1 : 1;
            }
        });
        this.mPanelCutCommonService.updateFrontPanelCutInfo(sNYEntities, frontPanelInfo);
    }

    public void remove(SNYEntities sNYEntities, int n, int n2, int n3) {
        LinkedList<FrontPanelInfo> linkedList = this.getPanelInfoList(sNYEntities, PanelDirectionType.FRONT);
        this.remove(sNYEntities, linkedList, n, n2, n3);
    }

    public void remove(SNYEntities sNYEntities, LinkedList<FrontPanelInfo> linkedList, int n, int n2, int n3) {
        List<FrontPanelInfo> list = this.findManyFrontPanelInfo(linkedList, n, n2, n3);
        linkedList.removeAll(list);
        this.mPanelCutCommonService.removeFrontPanelCutInfo(sNYEntities, list);
        this.mFrontPanelOptionCommonService.remove(sNYEntities, PanelDirectionType.FRONT, n, n2);
    }

    public FrontPanelInfo findOneFrontPanelInfo(List<FrontPanelInfo> list, int n, int n2) {
        for (FrontPanelInfo frontPanelInfo : list) {
            if (frontPanelInfo.mTerraceId != n || frontPanelInfo.mIndex != n2) continue;
            return frontPanelInfo;
        }
        return null;
    }

    public FrontPanelInfo findOneFrontPanelInfo(List<FrontPanelInfo> list, int n, int n2, int n3) {
        for (FrontPanelInfo frontPanelInfo : list) {
            if (frontPanelInfo.mTerraceId != n || frontPanelInfo.mIndex != n2 || frontPanelInfo.mSpan != n3) continue;
            return frontPanelInfo;
        }
        return null;
    }

    public List<FrontPanelInfo> findManyFrontPanelInfo(List<FrontPanelInfo> list, int n, int n2, int n3) {
        ArrayList<FrontPanelInfo> arrayList = new ArrayList<FrontPanelInfo>();
        for (FrontPanelInfo frontPanelInfo : list) {
            if (frontPanelInfo.mTerraceId != n || frontPanelInfo.mIndex + frontPanelInfo.mSpan <= n2 || frontPanelInfo.mIndex >= n2 + n3) continue;
            arrayList.add(frontPanelInfo);
        }
        return arrayList;
    }

    public List<FrontPanelInfo> findManyFrontPanelInfo(List<FrontPanelInfo> list, int n) {
        ArrayList<FrontPanelInfo> arrayList = new ArrayList<FrontPanelInfo>();
        for (FrontPanelInfo frontPanelInfo : list) {
            if (frontPanelInfo.mTerraceId != n) continue;
            arrayList.add(frontPanelInfo);
        }
        return arrayList;
    }

    public int calcFrontPanelRestSpan(SNYEntities sNYEntities, DirectionType directionType) {
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        LinkedList<TerraceInfo> linkedList = sNYEntities.mTerraceInfoList;
        LinkedList<FrontPanelInfo> linkedList2 = sNYEntities.mFrontPanelInfoList;
        int n = 0;
        for (TerraceInfo terraceInfo : linkedList) {
            int n2;
            if (terraceInfo.mBuildingType == BuildingType.CORNER) continue;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            if (terraceInfo.mIsMaster.booleanValue()) {
                if (terracesInfo.mEnforcementType == EnforcementType.BUBUN_KAKOI) {
                    if (basicInfo.mSubProductType == SubProductType.TSUKURITSUKE) {
                        n3 = this.mTerraceFigureCommonService.calcFrontHalfSpanNum(sNYEntities, terraceInfo);
                    } else if (terracesInfo.mEnforcementDirType == EnforcementDirType.L) {
                        n3 = this.mTerraceFigureCommonService.calcLeftFrontHalfSpanNum(sNYEntities, terraceInfo);
                    } else if (terracesInfo.mEnforcementDirType == EnforcementDirType.R) {
                        n3 = this.mTerraceFigureCommonService.calcRightFrontHalfSpanNum(sNYEntities, terraceInfo);
                    }
                } else if (terracesInfo.mEnforcementType == EnforcementType.DOMA_YUKA_W) {
                    n4 = this.mTerraceFigureCommonService.calcLeftFrontHalfSpanNum(sNYEntities, terraceInfo);
                    n5 = this.mTerraceFigureCommonService.calcRightFrontHalfSpanNum(sNYEntities, terraceInfo);
                    n3 = directionType == DirectionType.LEFT ? n4 : n5;
                } else {
                    n3 = this.mTerraceFigureCommonService.calcFrontHalfSpanNum(sNYEntities, terraceInfo);
                }
            } else {
                n2 = 0;
                if (terracesInfo.mEnforcementType == EnforcementType.BUBUN_KAKOI) {
                    if (basicInfo.mSubProductType == SubProductType.TSUKURITSUKE) {
                        if (terraceInfo.mBuildingType == BuildingType.BALCONY) {
                            n2 = 1;
                        }
                    } else if (terracesInfo.mEnforcementDirType == EnforcementDirType.L) {
                        if (terraceInfo.mId > 0) {
                            n2 = 1;
                        }
                    } else if (terracesInfo.mEnforcementDirType == EnforcementDirType.R && terraceInfo.mId < 0) {
                        n2 = 1;
                    }
                } else if (terracesInfo.mEnforcementType == EnforcementType.DOMA_YUKA_W) {
                    if (directionType == DirectionType.LEFT) {
                        if (terraceInfo.mId > 0) {
                            n2 = 1;
                        }
                    } else if (directionType == DirectionType.RIGHT && terraceInfo.mId < 0) {
                        n2 = 1;
                    }
                }
                if (n2 == 0) {
                    n3 = this.mTerraceFigureCommonService.calcFrontHalfSpanNum(sNYEntities, terraceInfo);
                }
            }
            n2 = 0;
            if (terracesInfo.mEnforcementType == EnforcementType.DOMA_YUKA_W && terraceInfo.mIsMaster.booleanValue() && directionType == DirectionType.RIGHT) {
                n2 = n4;
            }
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            List<FrontPanelInfo> list = this.findManyFrontPanelInfo(linkedList2, terraceInfo.mId);
            while (n8 < n3) {
                FrontPanelInfo frontPanelInfo = this.findOneFrontPanelInfo(list, terraceInfo.mId, n2 + n8);
                if (frontPanelInfo != null) {
                    n6 = Math.max(n6, n7);
                    n7 = 0;
                    n8 += frontPanelInfo.mSpan.intValue();
                    continue;
                }
                ++n7;
                ++n8;
            }
            if (n8 == n3) {
                n6 = Math.max(n6, n7);
            }
            n = Math.max(n, n6);
        }
        return n;
    }

    public boolean hasRanmaType(List<FrontPanelInfo> list, RanmaType ... ranmaTypeArray) {
        for (FrontPanelInfo frontPanelInfo : list) {
            if (frontPanelInfo.mRanmaType == null || !GdMutableTypeUtil.matchOR(frontPanelInfo.mRanmaType, ranmaTypeArray)) continue;
            return true;
        }
        return false;
    }

    public boolean isFrontPanelPerm(SNYEntities sNYEntities, OpeningPanelType openingPanelType, OpeningPanelWidthType openingPanelWidthType, PanelHeightType panelHeightType, RanmaUseType ranmaUseType, RanmaType ranmaType, KamachiType kamachiType, int n, int n2) {
        SpecOpeningPanelInfo specOpeningPanelInfo;
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        TerraceInfo terraceInfo = this.mTerraceCommonService.findTerraceInfoByIndex(sNYEntities.mTerraceInfoList, n);
        Tuple3<Float, Float, FloorType> tuple3 = this.findFrontOpening(sNYEntities, terraceInfo, n2);
        float f = ((Float)tuple3.value1).floatValue();
        float f2 = ((Float)tuple3.value2).floatValue();
        FloorType floorType = (FloorType)tuple3.value3;
        TerraceWidthType terraceWidthType = TerraceWidthTypeDxo.convert(f, basicInfo.mKenType);
        if (terraceWidthType.id() > TerraceWidthType.T20.id()) {
            terraceWidthType = TerraceWidthType.T20;
        }
        if ((specOpeningPanelInfo = this.mSpecOpeningPanelCacheDao.findOneWidthByTypes(basicInfo, terracesInfo, openingPanelType, openingPanelWidthType, kamachiType, terraceWidthType)) == null) {
            return false;
        }
        if (!specOpeningPanelInfo.permission.equals("1")) {
            return false;
        }
        SpecOpeningPanelHeightInfo specOpeningPanelHeightInfo = this.mSpecOpeningPanelHeightCacheDao.findOneWidthByTypes(openingPanelType, panelHeightType, ranmaUseType, ranmaType, kamachiType, openingPanelWidthType, f2, floorType, basicInfo, terracesInfo, terraceInfo);
        return specOpeningPanelHeightInfo != null && specOpeningPanelHeightInfo.permission.equals("1");
    }

    public boolean judgeInstalledPanel(SNYEntities sNYEntities) {
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        int n = 0;
        if (terracesInfo.mEnforcementType == EnforcementType.BUBUN_KAKOI) {
            if (terracesInfo.mEnforcementDirType == EnforcementDirType.L) {
                n = this.mTerraceFigureCommonService.calcFrontHalfSpanNum(sNYEntities, true, false);
            } else if (terracesInfo.mEnforcementDirType == EnforcementDirType.R) {
                n = this.mTerraceFigureCommonService.calcFrontHalfSpanNum(sNYEntities, false, true);
            }
        } else {
            n = this.mTerraceFigureCommonService.calcFrontHalfSpanNum(sNYEntities);
        }
        int n2 = 0;
        for (FrontPanelInfo frontPanelInfo : sNYEntities.mFrontPanelInfoList) {
            n2 += frontPanelInfo.mSpan.intValue();
        }
        return n2 == n;
    }

    public Tuple3<Float, Float, FloorType> findFrontOpening(SNYEntities sNYEntities, TerraceInfo terraceInfo, int n) {
        float f = sNYEntities.mBasicInfo.mKenLen.floatValue();
        List<Tuple3<Float, Float, FloorType>> list = this.createFrontOpeningList(sNYEntities, terraceInfo);
        float f2 = (float)n * f * 0.5f;
        float f3 = 0.0f;
        for (Tuple3<Float, Float, FloorType> tuple3 : list) {
            if (!(f2 < (f3 += ((Float)tuple3.value1).floatValue()))) continue;
            return tuple3;
        }
        if (!list.isEmpty()) {
            return list.get(list.size() - 1);
        }
        return null;
    }

    public List<Tuple3<Float, Float, FloorType>> createFrontOpeningList(SNYEntities sNYEntities, TerraceInfo terraceInfo) {
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        EnforcementType enforcementType = terracesInfo.mEnforcementType;
        EnforcementDirType enforcementDirType = terracesInfo.mEnforcementDirType;
        SubProductType subProductType = sNYEntities.mBasicInfo.mSubProductType;
        FloorType floorType = terraceInfo.mFloorType;
        if (GdMutableTypeUtil.matchOR(subProductType, SubProductType.TSUKURITSUKE)) {
            floorType = null;
        }
        ArrayList<Tuple3<Float, Float, FloorType>> arrayList = new ArrayList<Tuple3<Float, Float, FloorType>>();
        if (enforcementType == EnforcementType.DESUMI) {
            if (terraceInfo.mBuildingType != BuildingType.CORNER) {
                if (terraceInfo.mIsStarting.booleanValue()) {
                    float f = this.mTerraceFigureCommonService.calcGroupWidth(sNYEntities.mTerracesInfo, sNYEntities.mTerraceInfoList, Integer.MAX_VALUE);
                    arrayList.add(this.createOpening(sNYEntities, terraceInfo, terraceInfo.mWidth.floatValue() + f, floorType));
                } else {
                    arrayList.add(this.createOpening(sNYEntities, terraceInfo, terraceInfo.mWidth.floatValue(), floorType));
                }
            }
        } else if (enforcementType == EnforcementType.IRISUMI) {
            if (terraceInfo.mBuildingType != BuildingType.CORNER) {
                arrayList.add(this.createOpening(sNYEntities, terraceInfo, terraceInfo.mWidth.floatValue() + 139.0f - 35.0f, floorType));
            }
        } else if (enforcementType == EnforcementType.BUBUN_KAKOI) {
            if (terraceInfo.mIsMaster.booleanValue()) {
                if (subProductType == SubProductType.TSUKURITSUKE) {
                    arrayList.add(this.createOpening(sNYEntities, terraceInfo, terraceInfo.mWidth.floatValue(), terraceInfo.mLeftFloorType));
                } else if (enforcementDirType == EnforcementDirType.L) {
                    arrayList.add(this.createOpening(sNYEntities, terraceInfo, terraceInfo.mLeftWidth.floatValue(), terraceInfo.mLeftFloorType));
                } else {
                    arrayList.add(this.createOpening(sNYEntities, terraceInfo, terraceInfo.mRightWidth.floatValue(), terraceInfo.mRightFloorType));
                }
            } else if (enforcementDirType == EnforcementDirType.L && terraceInfo.mId < 0) {
                arrayList.add(this.createOpening(sNYEntities, terraceInfo, terraceInfo.mWidth.floatValue(), floorType));
            } else if (enforcementDirType == EnforcementDirType.R && terraceInfo.mId > 0) {
                arrayList.add(this.createOpening(sNYEntities, terraceInfo, terraceInfo.mWidth.floatValue(), floorType));
            }
        } else if (enforcementType == EnforcementType.DOMA_YUKA_W && terraceInfo.mIsMaster.booleanValue()) {
            if (enforcementDirType == EnforcementDirType.L) {
                if (terraceInfo.mLeftWidth.floatValue() > 0.0f) {
                    arrayList.add(this.createOpening(sNYEntities, terraceInfo, terraceInfo.mLeftWidth.floatValue(), FloorType.DOMA));
                }
                if (terraceInfo.mRightWidth.floatValue() > 0.0f) {
                    arrayList.add(this.createOpening(sNYEntities, terraceInfo, terraceInfo.mRightWidth.floatValue(), FloorType.YUKA));
                }
            } else {
                if (terraceInfo.mLeftWidth.floatValue() > 0.0f) {
                    arrayList.add(this.createOpening(sNYEntities, terraceInfo, terraceInfo.mLeftWidth.floatValue(), FloorType.YUKA));
                }
                if (terraceInfo.mRightWidth.floatValue() > 0.0f) {
                    arrayList.add(this.createOpening(sNYEntities, terraceInfo, terraceInfo.mRightWidth.floatValue(), FloorType.DOMA));
                }
            }
        } else if (enforcementType == EnforcementType.DOMA_YUKA_D) {
            arrayList.add(this.createOpening(sNYEntities, terraceInfo, terraceInfo.mWidth.floatValue(), FloorType.DOMA));
        } else {
            arrayList.add(this.createOpening(sNYEntities, terraceInfo, terraceInfo.mWidth.floatValue(), floorType));
        }
        return arrayList;
    }

    private Tuple3<Float, Float, FloorType> createOpening(SNYEntities sNYEntities, TerraceInfo terraceInfo, float f, FloorType floorType) {
        float f2 = this.mPanelInfoCommonService.calcOpeningHeight(sNYEntities, terraceInfo, floorType, null);
        return new Tuple3((Object)Float.valueOf(f), (Object)Float.valueOf(f2), (Object)floorType);
    }
}

