/*
 * Decompiled with CFR 0.152.
 */
package option.loneterrace.common.service.material;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import option.gad.core.inject.GdInject;
import option.gad.core.util.GdMutableTypeUtil;
import option.gad.core.util.MathUtil;
import option.loneterrace.common.dao.cache.spec.SpecFrameSizeCacheDao;
import option.loneterrace.common.dao.cache.type.TypeTerraceDepthCacheDao;
import option.loneterrace.common.dao.cache.type.TypeTerraceHeightCacheDao;
import option.loneterrace.common.dao.cache.type.TypeTerraceWidthCacheDao;
import option.loneterrace.common.dxo.TerraceDepthTypeDxo;
import option.loneterrace.common.dxo.TerraceWidthTypeDxo;
import option.loneterrace.common.entity.BasicInfo;
import option.loneterrace.common.entity.Constants;
import option.loneterrace.common.entity.DomaTileInfo;
import option.loneterrace.common.entity.PartsFigureUnitInfo;
import option.loneterrace.common.entity.SNYEntities;
import option.loneterrace.common.entity.TerraceInfo;
import option.loneterrace.common.entity.TerracesInfo;
import option.loneterrace.common.entity.spec.SpecFrameSizeInfo;
import option.loneterrace.common.entity.type.TypeTerraceDepthInfo;
import option.loneterrace.common.entity.type.TypeTerraceHeightInfo;
import option.loneterrace.common.entity.type.TypeTerraceWidthInfo;
import option.loneterrace.common.service.parts.FrontPanelCommonService;
import option.loneterrace.common.service.parts.SidePanelCommonService;
import option.loneterrace.common.service.parts.SidePanelFigureCommonService;
import option.loneterrace.common.service.parts.TerraceCommonService;
import option.loneterrace.common.service.parts.TerraceFigureCommonService;
import option.loneterrace.common.type.BuildingType;
import option.loneterrace.common.type.DirectionType;
import option.loneterrace.common.type.EnforcementDirType;
import option.loneterrace.common.type.EnforcementType;
import option.loneterrace.common.type.FloorType;
import option.loneterrace.common.type.KenType;
import option.loneterrace.common.type.PillarLengthType;
import option.loneterrace.common.type.SodePosType;
import option.loneterrace.common.type.SubProductType;
import option.loneterrace.common.type.TerraceDepthType;
import option.loneterrace.common.type.TerraceHeightType;
import option.loneterrace.common.type.TerraceWidthType;
import option.loneterrace.common.type.constant.CutPlaceType;
import option.loneterrace.common.type.factory.TerraceWidthTypeFactory;

public class TerraceInfoService {
    @GdInject
    private Constants mConstants;
    @GdInject
    private TerraceCommonService mTerraceCommonService;
    @GdInject
    private TerraceFigureCommonService mTerraceFigureCommonService;
    @GdInject
    private FrontPanelCommonService mFrontPanelCommonService;
    @GdInject
    private SidePanelCommonService mSidePanelCommonService;
    @GdInject
    private SidePanelFigureCommonService mSidePanelFigureCommonService;
    @GdInject
    private SpecFrameSizeCacheDao mSpecFrameSizeCacheDao;
    @GdInject
    private TypeTerraceWidthCacheDao mTypeTerraceWidthCacheDao;
    @GdInject
    private TypeTerraceDepthCacheDao mTypeTerraceDepthCacheDao;
    @GdInject
    private TypeTerraceHeightCacheDao mTypeTerraceHeightCacheDao;

    protected TerraceInfoService() {
    }

    public List<TerraceInfo> create(SNYEntities sNYEntities) {
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        EnforcementType enforcementType = terracesInfo.mEnforcementType;
        EnforcementDirType enforcementDirType = terracesInfo.mEnforcementDirType;
        ArrayList<TerraceInfo> arrayList = new ArrayList<TerraceInfo>();
        if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.STD)) {
            arrayList.addAll(this.createStandard(sNYEntities));
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.DESUMI)) {
            arrayList.addAll(this.createDesumi(sNYEntities));
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.IRISUMI)) {
            arrayList.addAll(this.createIrisumi(sNYEntities));
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.SHOMEN_DAIKEI)) {
            arrayList.addAll(this.createShomenDaikei(sNYEntities));
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.SOKUMEN_DAIKEI)) {
            arrayList.addAll(this.createSokumenDaikei(sNYEntities));
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.MAEWAKU_DEHABA_CHIGAI) && GdMutableTypeUtil.matchOR(enforcementDirType, EnforcementDirType.L)) {
            arrayList.addAll(this.createMaewakuDehabaChigaiL(sNYEntities));
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.MAEWAKU_DEHABA_CHIGAI) && GdMutableTypeUtil.matchOR(enforcementDirType, EnforcementDirType.R)) {
            arrayList.addAll(this.createMaewakuDehabaChigaiR(sNYEntities));
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.KUTAI_DEHABA_CHIGAI) && GdMutableTypeUtil.matchOR(enforcementDirType, EnforcementDirType.L)) {
            arrayList.addAll(this.createKutaiDehabaChigaiL(sNYEntities));
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.KUTAI_DEHABA_CHIGAI) && GdMutableTypeUtil.matchOR(enforcementDirType, EnforcementDirType.R)) {
            arrayList.addAll(this.createKutaiDehabaChigaiR(sNYEntities));
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.HANEDASHI) && GdMutableTypeUtil.matchOR(enforcementDirType, EnforcementDirType.L)) {
            arrayList.addAll(this.createHanedashiL(sNYEntities));
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.HANEDASHI) && GdMutableTypeUtil.matchOR(enforcementDirType, EnforcementDirType.R)) {
            arrayList.addAll(this.createHanedashiR(sNYEntities));
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.JIZAIKETA_HANEDASHI) && GdMutableTypeUtil.matchOR(enforcementDirType, EnforcementDirType.L)) {
            arrayList.addAll(this.createJizaiKetaHanedashiL(sNYEntities));
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.JIZAIKETA_HANEDASHI) && GdMutableTypeUtil.matchOR(enforcementDirType, EnforcementDirType.R)) {
            arrayList.addAll(this.createJizaiKetaHanedashiR(sNYEntities));
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.JIZAIKETA_HANEDASHI) && GdMutableTypeUtil.matchOR(enforcementDirType, EnforcementDirType.BOTH)) {
            arrayList.addAll(this.createJizaiKetaHanedashiBoth(sNYEntities));
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.KEISHA)) {
            arrayList.addAll(this.createStandard(sNYEntities));
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.BUBUN_IRISUMI) && GdMutableTypeUtil.matchOR(enforcementDirType, EnforcementDirType.L)) {
            arrayList.addAll(this.createStandard(sNYEntities));
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.BUBUN_IRISUMI) && GdMutableTypeUtil.matchOR(enforcementDirType, EnforcementDirType.R)) {
            arrayList.addAll(this.createStandard(sNYEntities));
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.BUBUN_KAKOI) && GdMutableTypeUtil.matchOR(enforcementDirType, EnforcementDirType.L)) {
            if (basicInfo.mSubProductType == SubProductType.TSUKURITSUKE) {
                arrayList.addAll(this.createTsukuritsukeBubunKakoiL(sNYEntities));
            } else {
                arrayList.addAll(this.createBubunKakoiL(sNYEntities));
            }
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.BUBUN_KAKOI) && GdMutableTypeUtil.matchOR(enforcementDirType, EnforcementDirType.R)) {
            if (basicInfo.mSubProductType == SubProductType.TSUKURITSUKE) {
                arrayList.addAll(this.createTsukuritsukeBubunKakoiR(sNYEntities));
            } else {
                arrayList.addAll(this.createBubunKakoiR(sNYEntities));
            }
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.DOMA_YUKA_W) && GdMutableTypeUtil.matchOR(enforcementDirType, EnforcementDirType.L)) {
            arrayList.addAll(this.createDomaYukaL(sNYEntities));
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.DOMA_YUKA_W) && GdMutableTypeUtil.matchOR(enforcementDirType, EnforcementDirType.R)) {
            arrayList.addAll(this.createDomaYukaR(sNYEntities));
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.DOMA_YUKA_D)) {
            arrayList.addAll(this.createDomaYukaD(sNYEntities));
        }
        return arrayList;
    }

    private List<TerraceInfo> createStandard(SNYEntities sNYEntities) {
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        ArrayList<TerraceInfo> arrayList = new ArrayList<TerraceInfo>();
        if (basicInfo.mSubProductType == SubProductType.HALF_KAKOI) {
            arrayList.addAll(this.createStandardForHalfKakoi(sNYEntities));
        } else {
            arrayList.addAll(this.createStandardStandard(sNYEntities));
        }
        return arrayList;
    }

    private List<TerraceInfo> createStandardStandard(SNYEntities sNYEntities) {
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        FloorType floorType = this.judgeFloorType(basicInfo);
        TerraceWidthType terraceWidthType = TerraceWidthType.T10;
        TerraceDepthType terraceDepthType = TerraceDepthType.T4;
        if (GdMutableTypeUtil.matchOR(basicInfo.mSubProductType, SubProductType.OPEN)) {
            terraceWidthType = TerraceWidthType.T15;
            terraceDepthType = TerraceDepthType.T6;
        }
        TypeTerraceWidthInfo typeTerraceWidthInfo = this.mTypeTerraceWidthCacheDao.findOneByType(terraceWidthType, basicInfo.mKenType);
        TypeTerraceDepthInfo typeTerraceDepthInfo = this.mTypeTerraceDepthCacheDao.findOneStdByType(terraceDepthType);
        ArrayList<TerraceInfo> arrayList = new ArrayList<TerraceInfo>();
        TerraceInfo terraceInfo = new TerraceInfo();
        terraceInfo.mIsMaster = true;
        terraceInfo.mIsStarting = true;
        terraceInfo.mId = 0;
        terraceInfo.mGroupId = 0;
        terraceInfo.mBuildingType = basicInfo.mBuildingType;
        terraceInfo.mFloorType = floorType;
        terraceInfo.mTurningAngle = Float.valueOf(0.0f);
        terraceInfo.mWidthType = terraceWidthType;
        terraceInfo.mDefaultWidth = typeTerraceWidthInfo.length;
        terraceInfo.mWidth = typeTerraceWidthInfo.length;
        terraceInfo.mDepthType = terraceDepthType;
        terraceInfo.mDefaultDepth = typeTerraceDepthInfo.length;
        terraceInfo.mDepth = typeTerraceDepthInfo.length;
        terraceInfo.mLeftKutaiPillarWidth = Float.valueOf(0.0f);
        terraceInfo.mRightKutaiPillarWidth = Float.valueOf(0.0f);
        if (GdMutableTypeUtil.matchOR(terracesInfo.mSodePosType, SodePosType.L, SodePosType.BOTH)) {
            terraceInfo.mLeftKutaiPillarWidth = this.mConstants.defaultKutaiPillarWidth;
        }
        if (GdMutableTypeUtil.matchOR(terracesInfo.mSodePosType, SodePosType.R, SodePosType.BOTH)) {
            terraceInfo.mRightKutaiPillarWidth = this.mConstants.defaultKutaiPillarWidth;
        }
        arrayList.add(terraceInfo);
        return arrayList;
    }

    private List<TerraceInfo> createStandardForHalfKakoi(SNYEntities sNYEntities) {
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        FloorType floorType = this.judgeFloorType(basicInfo);
        TerraceWidthType terraceWidthType = TerraceWidthType.T15;
        TerraceDepthType terraceDepthType = TerraceDepthType.T6;
        TypeTerraceWidthInfo typeTerraceWidthInfo = this.mTypeTerraceWidthCacheDao.findOneByType(terraceWidthType, basicInfo.mKenType);
        TypeTerraceDepthInfo typeTerraceDepthInfo = this.mTypeTerraceDepthCacheDao.findOneStdByType(terraceDepthType);
        TerraceDepthType terraceDepthType2 = TerraceDepthType.T2;
        TypeTerraceDepthInfo typeTerraceDepthInfo2 = this.mTypeTerraceDepthCacheDao.findOneStdByType(terraceDepthType2);
        TerraceDepthType terraceDepthType3 = TerraceDepthType.T4;
        TypeTerraceDepthInfo typeTerraceDepthInfo3 = this.mTypeTerraceDepthCacheDao.findOneStdByType(terraceDepthType3);
        ArrayList<TerraceInfo> arrayList = new ArrayList<TerraceInfo>();
        TerraceInfo terraceInfo = new TerraceInfo();
        terraceInfo.mIsMaster = true;
        terraceInfo.mIsStarting = true;
        terraceInfo.mId = 0;
        terraceInfo.mGroupId = 0;
        terraceInfo.mBuildingType = basicInfo.mBuildingType;
        terraceInfo.mFloorType = floorType;
        terraceInfo.mTurningAngle = Float.valueOf(0.0f);
        terraceInfo.mWidthType = terraceWidthType;
        terraceInfo.mDefaultWidth = typeTerraceWidthInfo.length;
        terraceInfo.mWidth = typeTerraceWidthInfo.length;
        terraceInfo.mDepthType = terraceDepthType;
        terraceInfo.mDefaultDepth = typeTerraceDepthInfo.length;
        terraceInfo.mDepth = typeTerraceDepthInfo.length;
        if (terraceDepthType2 != null) {
            terraceInfo.mFrontDepthType = terraceDepthType2;
            terraceInfo.mFrontDepth = typeTerraceDepthInfo2.length;
        }
        if (terraceDepthType3 != null) {
            terraceInfo.mBackDepthType = terraceDepthType3;
            terraceInfo.mBackDepth = typeTerraceDepthInfo3.length;
        }
        arrayList.add(terraceInfo);
        return arrayList;
    }

    private List<TerraceInfo> createDesumi(SNYEntities sNYEntities) {
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        EnforcementDirType enforcementDirType = terracesInfo.mEnforcementDirType;
        float f = enforcementDirType == EnforcementDirType.L ? -90 : 0;
        return this.createDesumiIrisumi(sNYEntities, Float.valueOf(f), Float.valueOf(90.0f));
    }

    private List<TerraceInfo> createIrisumi(SNYEntities sNYEntities) {
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        EnforcementDirType enforcementDirType = terracesInfo.mEnforcementDirType;
        float f = enforcementDirType == EnforcementDirType.L ? 90 : 0;
        return this.createDesumiIrisumi(sNYEntities, Float.valueOf(f), Float.valueOf(-90.0f));
    }

    private List<TerraceInfo> createDesumiIrisumi(SNYEntities sNYEntities, Float f, Float f2) {
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        FloorType floorType = this.judgeFloorType(basicInfo);
        TerraceWidthType terraceWidthType = TerraceWidthType.T10;
        TypeTerraceWidthInfo typeTerraceWidthInfo = this.mTypeTerraceWidthCacheDao.findOneByType(terraceWidthType, basicInfo.mKenType);
        float f3 = 0.0f;
        if (terracesInfo.mEnforcementType == EnforcementType.DESUMI) {
            f3 = this.mConstants.kutaiPillarWidthForDesumi.floatValue();
        }
        ArrayList<TerraceInfo> arrayList = new ArrayList<TerraceInfo>();
        TerraceInfo terraceInfo = new TerraceInfo();
        terraceInfo.mIsMaster = true;
        terraceInfo.mIsStarting = true;
        terraceInfo.mId = 0;
        terraceInfo.mGroupId = 0;
        terraceInfo.mIsLeftEnd = true;
        terraceInfo.mIsRightEnd = false;
        terraceInfo.mBuildingType = basicInfo.mBuildingType;
        terraceInfo.mFloorType = floorType;
        terraceInfo.mTurningAngle = f;
        terraceInfo.mWidthType = terraceWidthType;
        terraceInfo.mDefaultWidth = typeTerraceWidthInfo.length;
        terraceInfo.mWidth = typeTerraceWidthInfo.length;
        terraceInfo.mLeftKutaiPillarWidth = Float.valueOf(0.0f);
        terraceInfo.mRightKutaiPillarWidth = Float.valueOf(f3);
        arrayList.add(terraceInfo);
        TerraceInfo terraceInfo2 = new TerraceInfo();
        terraceInfo2.mIsStarting = true;
        terraceInfo2.mId = 1;
        terraceInfo2.mGroupId = Integer.MAX_VALUE;
        terraceInfo2.mIsLeftEnd = false;
        terraceInfo2.mIsRightEnd = false;
        terraceInfo2.mBuildingType = BuildingType.CORNER;
        terraceInfo2.mFloorType = floorType;
        terraceInfo2.mTurningAngle = f2;
        terraceInfo2.mWidthType = TerraceWidthType.DEPTH;
        terraceInfo2.mDefaultWidth = terraceInfo2.mDepth;
        terraceInfo2.mWidth = terraceInfo2.mDepth;
        arrayList.add(terraceInfo2);
        TerraceInfo terraceInfo3 = new TerraceInfo();
        terraceInfo3.mIsStarting = true;
        terraceInfo3.mId = 2;
        terraceInfo3.mGroupId = 1;
        terraceInfo3.mIsLeftEnd = false;
        terraceInfo3.mIsRightEnd = true;
        terraceInfo3.mBuildingType = basicInfo.mBuildingType;
        terraceInfo3.mFloorType = floorType;
        terraceInfo3.mTurningAngle = Float.valueOf(0.0f);
        terraceInfo3.mWidthType = terraceWidthType;
        terraceInfo3.mDefaultWidth = typeTerraceWidthInfo.length;
        terraceInfo3.mWidth = typeTerraceWidthInfo.length;
        terraceInfo3.mLeftKutaiPillarWidth = Float.valueOf(f3);
        terraceInfo3.mRightKutaiPillarWidth = Float.valueOf(0.0f);
        arrayList.add(terraceInfo3);
        return arrayList;
    }

    private List<TerraceInfo> createShomenDaikei(SNYEntities sNYEntities) {
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        EnforcementDirType enforcementDirType = terracesInfo.mEnforcementDirType;
        FloorType floorType = this.judgeFloorType(basicInfo);
        TerraceWidthType terraceWidthType = TerraceWidthType.T10;
        TypeTerraceWidthInfo typeTerraceWidthInfo = this.mTypeTerraceWidthCacheDao.findOneByType(terraceWidthType, basicInfo.mKenType);
        TerraceDepthType terraceDepthType = TerraceDepthType.T6;
        TypeTerraceDepthInfo typeTerraceDepthInfo = this.mTypeTerraceDepthCacheDao.findOneStdByType(terraceDepthType);
        float f = typeTerraceDepthInfo.length.floatValue();
        float f2 = typeTerraceDepthInfo.length.floatValue();
        if (enforcementDirType == EnforcementDirType.L) {
            f -= 300.0f;
        } else if (enforcementDirType == EnforcementDirType.R) {
            f2 -= 300.0f;
        }
        ArrayList<TerraceInfo> arrayList = new ArrayList<TerraceInfo>();
        TerraceInfo terraceInfo = new TerraceInfo();
        terraceInfo.mIsMaster = true;
        terraceInfo.mIsStarting = true;
        terraceInfo.mId = 0;
        terraceInfo.mGroupId = 0;
        terraceInfo.mBuildingType = basicInfo.mBuildingType;
        terraceInfo.mFloorType = floorType;
        terraceInfo.mTurningAngle = Float.valueOf(0.0f);
        terraceInfo.mWidthType = terraceWidthType;
        terraceInfo.mDefaultWidth = typeTerraceWidthInfo.length;
        terraceInfo.mWidth = typeTerraceWidthInfo.length;
        terraceInfo.mDepthType = terraceDepthType;
        terraceInfo.mDefaultDepth = typeTerraceDepthInfo.length;
        terraceInfo.mDepth = typeTerraceDepthInfo.length;
        terraceInfo.mLeftDepthType = terraceDepthType;
        terraceInfo.mLeftDepth = Float.valueOf(f);
        terraceInfo.mRightDepthType = terraceDepthType;
        terraceInfo.mRightDepth = Float.valueOf(f2);
        arrayList.add(terraceInfo);
        return arrayList;
    }

    private List<TerraceInfo> createSokumenDaikei(SNYEntities sNYEntities) {
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        FloorType floorType = this.judgeFloorType(basicInfo);
        KenType kenType = basicInfo.mKenType;
        TerraceWidthType terraceWidthType = TerraceWidthType.T15;
        TypeTerraceWidthInfo typeTerraceWidthInfo = this.mTypeTerraceWidthCacheDao.findOneByType(terraceWidthType, kenType);
        float f = typeTerraceWidthInfo.length.floatValue() - basicInfo.mKenLen.floatValue();
        float f2 = typeTerraceWidthInfo.length.floatValue();
        TerraceDepthType terraceDepthType = TerraceDepthType.T4;
        TypeTerraceDepthInfo typeTerraceDepthInfo = this.mTypeTerraceDepthCacheDao.findOneStdByType(terraceDepthType);
        ArrayList<TerraceInfo> arrayList = new ArrayList<TerraceInfo>();
        TerraceInfo terraceInfo = new TerraceInfo();
        terraceInfo.mIsMaster = true;
        terraceInfo.mIsStarting = true;
        terraceInfo.mId = 0;
        terraceInfo.mGroupId = 0;
        terraceInfo.mBuildingType = basicInfo.mBuildingType;
        terraceInfo.mFloorType = floorType;
        terraceInfo.mTurningAngle = Float.valueOf(0.0f);
        terraceInfo.mWidthType = terraceWidthType;
        terraceInfo.mDefaultWidth = typeTerraceWidthInfo.length;
        terraceInfo.mWidth = typeTerraceWidthInfo.length;
        terraceInfo.mFrontWidthType = terraceWidthType;
        terraceInfo.mFrontWidth = Float.valueOf(f);
        terraceInfo.mBackWidthType = terraceWidthType;
        terraceInfo.mBackWidth = Float.valueOf(f2);
        terraceInfo.mDepthType = terraceDepthType;
        terraceInfo.mDefaultDepth = typeTerraceDepthInfo.length;
        terraceInfo.mDepth = typeTerraceDepthInfo.length;
        arrayList.add(terraceInfo);
        return arrayList;
    }

    private List<TerraceInfo> createMaewakuDehabaChigaiL(SNYEntities sNYEntities) {
        return this.createMaewakuDehabaChigai(sNYEntities, TerraceDepthType.T4, TerraceDepthType.T6);
    }

    private List<TerraceInfo> createMaewakuDehabaChigaiR(SNYEntities sNYEntities) {
        return this.createMaewakuDehabaChigai(sNYEntities, TerraceDepthType.T6, TerraceDepthType.T4);
    }

    private List<TerraceInfo> createMaewakuDehabaChigai(SNYEntities sNYEntities, TerraceDepthType terraceDepthType, TerraceDepthType terraceDepthType2) {
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        FloorType floorType = this.judgeFloorType(basicInfo);
        TerraceWidthType terraceWidthType = TerraceWidthType.T10;
        TypeTerraceWidthInfo typeTerraceWidthInfo = this.mTypeTerraceWidthCacheDao.findOneByType(terraceWidthType, basicInfo.mKenType);
        TypeTerraceDepthInfo typeTerraceDepthInfo = this.mTypeTerraceDepthCacheDao.findOneStdByType(terraceDepthType);
        TypeTerraceDepthInfo typeTerraceDepthInfo2 = this.mTypeTerraceDepthCacheDao.findOneStdByType(terraceDepthType2);
        ArrayList<TerraceInfo> arrayList = new ArrayList<TerraceInfo>();
        TerraceInfo terraceInfo = new TerraceInfo();
        terraceInfo.mIsMaster = true;
        terraceInfo.mIsStarting = true;
        terraceInfo.mId = 0;
        terraceInfo.mGroupId = 0;
        terraceInfo.mBuildingType = basicInfo.mBuildingType;
        terraceInfo.mFloorType = floorType;
        terraceInfo.mTurningAngle = Float.valueOf(0.0f);
        terraceInfo.mWidthType = terraceWidthType;
        terraceInfo.mDefaultWidth = typeTerraceWidthInfo.length;
        terraceInfo.mWidth = typeTerraceWidthInfo.length;
        terraceInfo.mDepthType = terraceDepthType;
        terraceInfo.mDefaultDepth = typeTerraceDepthInfo.length;
        terraceInfo.mDepth = typeTerraceDepthInfo.length;
        terraceInfo.mIsLeftEnd = true;
        terraceInfo.mIsRightEnd = false;
        arrayList.add(terraceInfo);
        TerraceInfo terraceInfo2 = new TerraceInfo();
        terraceInfo2.mIsStarting = true;
        terraceInfo2.mId = 1;
        terraceInfo2.mGroupId = 1;
        terraceInfo2.mBuildingType = basicInfo.mBuildingType;
        terraceInfo2.mFloorType = floorType;
        terraceInfo2.mTurningAngle = Float.valueOf(0.0f);
        terraceInfo2.mWidthType = terraceWidthType;
        terraceInfo2.mDefaultWidth = typeTerraceWidthInfo.length;
        terraceInfo2.mWidth = typeTerraceWidthInfo.length;
        terraceInfo2.mDepthType = terraceDepthType2;
        terraceInfo2.mDefaultDepth = typeTerraceDepthInfo2.length;
        terraceInfo2.mDepth = typeTerraceDepthInfo2.length;
        terraceInfo2.mIsLeftEnd = false;
        terraceInfo2.mIsRightEnd = true;
        arrayList.add(terraceInfo2);
        return arrayList;
    }

    private List<TerraceInfo> createKutaiDehabaChigaiL(SNYEntities sNYEntities) {
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        FloorType floorType = this.judgeFloorType(basicInfo);
        TerraceWidthType terraceWidthType = TerraceWidthType.T10;
        TypeTerraceWidthInfo typeTerraceWidthInfo = this.mTypeTerraceWidthCacheDao.findOneByType(terraceWidthType, basicInfo.mKenType);
        TerraceWidthType terraceWidthType2 = TerraceWidthType.T05;
        TypeTerraceWidthInfo typeTerraceWidthInfo2 = this.mTypeTerraceWidthCacheDao.findOneByType(terraceWidthType2, basicInfo.mKenType);
        TerraceDepthType terraceDepthType = TerraceDepthType.T4;
        TypeTerraceDepthInfo typeTerraceDepthInfo = this.mTypeTerraceDepthCacheDao.findOneStdByType(terraceDepthType);
        float f = 10.0f;
        ArrayList<TerraceInfo> arrayList = new ArrayList<TerraceInfo>();
        TerraceInfo terraceInfo = new TerraceInfo();
        terraceInfo.mIsMaster = true;
        terraceInfo.mIsStarting = true;
        terraceInfo.mId = 0;
        terraceInfo.mGroupId = 0;
        terraceInfo.mBuildingType = basicInfo.mBuildingType;
        terraceInfo.mFloorType = floorType;
        terraceInfo.mTurningAngle = Float.valueOf(0.0f);
        terraceInfo.mWidthType = terraceWidthType;
        terraceInfo.mDefaultWidth = typeTerraceWidthInfo.length;
        terraceInfo.mWidth = typeTerraceWidthInfo.length;
        terraceInfo.mLeftWidthType = terraceWidthType2;
        terraceInfo.mLeftWidth = typeTerraceWidthInfo2.length;
        terraceInfo.mLeftDepthType = terraceDepthType;
        terraceInfo.mLeftDepth = Float.valueOf(typeTerraceDepthInfo.length.floatValue() - f);
        arrayList.add(terraceInfo);
        return arrayList;
    }

    private List<TerraceInfo> createKutaiDehabaChigaiR(SNYEntities sNYEntities) {
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        FloorType floorType = this.judgeFloorType(basicInfo);
        TerraceWidthType terraceWidthType = TerraceWidthType.T10;
        TypeTerraceWidthInfo typeTerraceWidthInfo = this.mTypeTerraceWidthCacheDao.findOneByType(terraceWidthType, basicInfo.mKenType);
        TerraceWidthType terraceWidthType2 = TerraceWidthType.T05;
        TypeTerraceWidthInfo typeTerraceWidthInfo2 = this.mTypeTerraceWidthCacheDao.findOneByType(terraceWidthType2, basicInfo.mKenType);
        TerraceDepthType terraceDepthType = TerraceDepthType.T4;
        TypeTerraceDepthInfo typeTerraceDepthInfo = this.mTypeTerraceDepthCacheDao.findOneStdByType(terraceDepthType);
        float f = 10.0f;
        ArrayList<TerraceInfo> arrayList = new ArrayList<TerraceInfo>();
        TerraceInfo terraceInfo = new TerraceInfo();
        terraceInfo.mIsMaster = true;
        terraceInfo.mIsStarting = true;
        terraceInfo.mId = 0;
        terraceInfo.mGroupId = 0;
        terraceInfo.mBuildingType = basicInfo.mBuildingType;
        terraceInfo.mFloorType = floorType;
        terraceInfo.mTurningAngle = Float.valueOf(0.0f);
        terraceInfo.mWidthType = terraceWidthType;
        terraceInfo.mDefaultWidth = typeTerraceWidthInfo.length;
        terraceInfo.mWidth = typeTerraceWidthInfo.length;
        terraceInfo.mLeftWidthType = terraceWidthType2;
        terraceInfo.mLeftWidth = typeTerraceWidthInfo2.length;
        terraceInfo.mRightDepthType = terraceDepthType;
        terraceInfo.mRightDepth = Float.valueOf(typeTerraceDepthInfo.length.floatValue() - f);
        arrayList.add(terraceInfo);
        return arrayList;
    }

    private List<TerraceInfo> createHanedashiL(SNYEntities sNYEntities) {
        return this.createHanedashi(sNYEntities, this.mConstants.minHanedashiLen.floatValue(), 0.0f);
    }

    private List<TerraceInfo> createHanedashiR(SNYEntities sNYEntities) {
        return this.createHanedashi(sNYEntities, 0.0f, this.mConstants.minHanedashiLen.floatValue());
    }

    private List<TerraceInfo> createHanedashi(SNYEntities sNYEntities, float f, float f2) {
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        FloorType floorType = this.judgeFloorType(basicInfo);
        TerraceWidthType terraceWidthType = TerraceWidthType.T10;
        TerraceDepthType terraceDepthType = TerraceDepthType.T4;
        TypeTerraceWidthInfo typeTerraceWidthInfo = this.mTypeTerraceWidthCacheDao.findOneByType(terraceWidthType, basicInfo.mKenType);
        TypeTerraceDepthInfo typeTerraceDepthInfo = this.mTypeTerraceDepthCacheDao.findOneStdByType(terraceDepthType);
        terracesInfo.mLeftHanedashiLen = Float.valueOf(f);
        terracesInfo.mRightHanedashiLen = Float.valueOf(f2);
        ArrayList<TerraceInfo> arrayList = new ArrayList<TerraceInfo>();
        TerraceInfo terraceInfo = new TerraceInfo();
        terraceInfo.mIsMaster = true;
        terraceInfo.mIsStarting = true;
        terraceInfo.mId = 0;
        terraceInfo.mGroupId = 0;
        terraceInfo.mBuildingType = basicInfo.mBuildingType;
        terraceInfo.mFloorType = floorType;
        terraceInfo.mTurningAngle = Float.valueOf(0.0f);
        terraceInfo.mWidthType = terraceWidthType;
        terraceInfo.mDefaultWidth = typeTerraceWidthInfo.length;
        terraceInfo.mWidth = typeTerraceWidthInfo.length;
        terraceInfo.mDepthType = terraceDepthType;
        terraceInfo.mDefaultDepth = typeTerraceDepthInfo.length;
        terraceInfo.mDepth = typeTerraceDepthInfo.length;
        if (GdMutableTypeUtil.matchOR(terracesInfo.mSodePosType, SodePosType.L, SodePosType.BOTH)) {
            terraceInfo.mLeftKutaiPillarWidth = this.mConstants.defaultKutaiPillarWidth;
        }
        if (GdMutableTypeUtil.matchOR(terracesInfo.mSodePosType, SodePosType.R, SodePosType.BOTH)) {
            terraceInfo.mRightKutaiPillarWidth = this.mConstants.defaultKutaiPillarWidth;
        }
        arrayList.add(terraceInfo);
        return arrayList;
    }

    private List<TerraceInfo> createJizaiKetaHanedashiL(SNYEntities sNYEntities) {
        return this.createJizaiKetaHanedashi(sNYEntities, 300.0f, 0.0f);
    }

    private List<TerraceInfo> createJizaiKetaHanedashiR(SNYEntities sNYEntities) {
        return this.createJizaiKetaHanedashi(sNYEntities, 0.0f, 300.0f);
    }

    private List<TerraceInfo> createJizaiKetaHanedashiBoth(SNYEntities sNYEntities) {
        return this.createJizaiKetaHanedashi(sNYEntities, 300.0f, 300.0f);
    }

    private List<TerraceInfo> createJizaiKetaHanedashi(SNYEntities sNYEntities, float f, float f2) {
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        FloorType floorType = this.judgeFloorType(basicInfo);
        TerraceWidthType terraceWidthType = TerraceWidthType.T10;
        TerraceDepthType terraceDepthType = TerraceDepthType.T4;
        TypeTerraceWidthInfo typeTerraceWidthInfo = this.mTypeTerraceWidthCacheDao.findOneByType(terraceWidthType, basicInfo.mKenType);
        TypeTerraceDepthInfo typeTerraceDepthInfo = this.mTypeTerraceDepthCacheDao.findOneStdByType(terraceDepthType);
        terracesInfo.mLeftJizaiKetaLen = Float.valueOf(f);
        terracesInfo.mRightJizaiKetaLen = Float.valueOf(f2);
        ArrayList<TerraceInfo> arrayList = new ArrayList<TerraceInfo>();
        TerraceInfo terraceInfo = new TerraceInfo();
        terraceInfo.mIsMaster = true;
        terraceInfo.mIsStarting = true;
        terraceInfo.mId = 0;
        terraceInfo.mGroupId = 0;
        terraceInfo.mBuildingType = basicInfo.mBuildingType;
        terraceInfo.mFloorType = floorType;
        terraceInfo.mTurningAngle = Float.valueOf(0.0f);
        terraceInfo.mWidthType = terraceWidthType;
        terraceInfo.mDefaultWidth = typeTerraceWidthInfo.length;
        terraceInfo.mWidth = typeTerraceWidthInfo.length;
        terraceInfo.mDepthType = terraceDepthType;
        terraceInfo.mDefaultDepth = typeTerraceDepthInfo.length;
        terraceInfo.mDepth = typeTerraceDepthInfo.length;
        arrayList.add(terraceInfo);
        return arrayList;
    }

    private List<TerraceInfo> createBubunKakoiL(SNYEntities sNYEntities) {
        return this.createBubunKakoi(sNYEntities, TerraceWidthType.T10, TerraceWidthType.T05, this.judgeFloorType(sNYEntities.mBasicInfo), FloorType.DOMA);
    }

    private List<TerraceInfo> createBubunKakoiR(SNYEntities sNYEntities) {
        return this.createBubunKakoi(sNYEntities, TerraceWidthType.T05, TerraceWidthType.T10, FloorType.DOMA, this.judgeFloorType(sNYEntities.mBasicInfo));
    }

    private List<TerraceInfo> createBubunKakoi(SNYEntities sNYEntities, TerraceWidthType terraceWidthType, TerraceWidthType terraceWidthType2, FloorType floorType, FloorType floorType2) {
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        TerraceWidthType terraceWidthType3 = TerraceWidthType.T15;
        TypeTerraceWidthInfo typeTerraceWidthInfo = this.mTypeTerraceWidthCacheDao.findOneByType(terraceWidthType3, basicInfo.mKenType);
        TypeTerraceWidthInfo typeTerraceWidthInfo2 = null;
        if (terraceWidthType != null) {
            typeTerraceWidthInfo2 = this.mTypeTerraceWidthCacheDao.findOneByType(terraceWidthType, basicInfo.mKenType);
        }
        TypeTerraceWidthInfo typeTerraceWidthInfo3 = null;
        if (terraceWidthType2 != null) {
            typeTerraceWidthInfo3 = this.mTypeTerraceWidthCacheDao.findOneByType(terraceWidthType2, basicInfo.mKenType);
        }
        TerraceDepthType terraceDepthType = TerraceDepthType.T4;
        TypeTerraceDepthInfo typeTerraceDepthInfo = this.mTypeTerraceDepthCacheDao.findOneStdByType(terraceDepthType);
        ArrayList<TerraceInfo> arrayList = new ArrayList<TerraceInfo>();
        TerraceInfo terraceInfo = new TerraceInfo();
        terraceInfo.mIsMaster = true;
        terraceInfo.mIsStarting = true;
        terraceInfo.mId = 0;
        terraceInfo.mGroupId = 0;
        terraceInfo.mBuildingType = basicInfo.mBuildingType;
        terraceInfo.mLeftFloorType = floorType;
        terraceInfo.mRightFloorType = floorType2;
        terraceInfo.mTurningAngle = Float.valueOf(0.0f);
        terraceInfo.mWidthType = terraceWidthType3;
        terraceInfo.mDefaultWidth = typeTerraceWidthInfo.length;
        terraceInfo.mWidth = typeTerraceWidthInfo.length;
        if (terraceWidthType != null) {
            terraceInfo.mLeftWidthType = terraceWidthType;
            terraceInfo.mLeftWidth = typeTerraceWidthInfo2.length;
        }
        if (terraceWidthType2 != null) {
            terraceInfo.mRightWidthType = terraceWidthType2;
            terraceInfo.mRightWidth = typeTerraceWidthInfo3.length;
        }
        terraceInfo.mDepthType = terraceDepthType;
        terraceInfo.mDefaultDepth = typeTerraceDepthInfo.length;
        terraceInfo.mDepth = typeTerraceDepthInfo.length;
        terraceInfo.mIsLeftEnd = true;
        terraceInfo.mIsRightEnd = true;
        arrayList.add(terraceInfo);
        return arrayList;
    }

    private List<TerraceInfo> createTsukuritsukeBubunKakoiL(SNYEntities sNYEntities) {
        return this.createTsukuritsukeBubunKakoi(sNYEntities, true, false);
    }

    private List<TerraceInfo> createTsukuritsukeBubunKakoiR(SNYEntities sNYEntities) {
        return this.createTsukuritsukeBubunKakoi(sNYEntities, false, true);
    }

    private List<TerraceInfo> createTsukuritsukeBubunKakoi(SNYEntities sNYEntities, boolean bl, boolean bl2) {
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        TerraceWidthType terraceWidthType = TerraceWidthType.T10;
        TypeTerraceWidthInfo typeTerraceWidthInfo = this.mTypeTerraceWidthCacheDao.findOneByType(terraceWidthType, basicInfo.mKenType);
        TerraceDepthType terraceDepthType = TerraceDepthType.T4;
        TypeTerraceDepthInfo typeTerraceDepthInfo = this.mTypeTerraceDepthCacheDao.findOneStdByType(terraceDepthType);
        terracesInfo.mKutaiCoping = terracesInfo.mDepth;
        LinkedList<TerraceInfo> linkedList = new LinkedList<TerraceInfo>();
        TerraceInfo terraceInfo = new TerraceInfo();
        terraceInfo.mIsMaster = true;
        terraceInfo.mIsStarting = true;
        terraceInfo.mId = 0;
        terraceInfo.mGroupId = 0;
        terraceInfo.mBuildingType = basicInfo.mBuildingType;
        terraceInfo.mFloorType = FloorType.DOMA;
        terraceInfo.mTurningAngle = Float.valueOf(0.0f);
        terraceInfo.mWidthType = terraceWidthType;
        terraceInfo.mDefaultWidth = typeTerraceWidthInfo.length;
        terraceInfo.mWidth = typeTerraceWidthInfo.length;
        terraceInfo.mDepthType = terraceDepthType;
        terraceInfo.mDefaultDepth = typeTerraceDepthInfo.length;
        terraceInfo.mDepth = typeTerraceDepthInfo.length;
        terraceInfo.mIsLeftEnd = bl;
        terraceInfo.mIsRightEnd = bl2;
        linkedList.add(terraceInfo);
        TerraceInfo terraceInfo2 = new TerraceInfo();
        terraceInfo2.mIsMaster = false;
        terraceInfo2.mIsStarting = true;
        terraceInfo2.mId = bl ? 1 : -1;
        terraceInfo2.mGroupId = 1;
        terraceInfo2.mBuildingType = BuildingType.BALCONY;
        terraceInfo2.mFloorType = FloorType.DOMA;
        terraceInfo2.mTurningAngle = Float.valueOf(0.0f);
        terraceInfo2.mWidthType = terraceInfo.mWidthType;
        terraceInfo2.mDefaultWidth = terraceInfo.mDefaultWidth;
        terraceInfo2.mWidth = terraceInfo.mWidth;
        terraceInfo2.mDepthType = terraceInfo.mDepthType;
        terraceInfo2.mDefaultDepth = terraceInfo.mDefaultDepth;
        terraceInfo2.mDepth = terraceInfo.mDepth;
        terraceInfo2.mIsLeftEnd = !bl;
        terraceInfo2.mIsRightEnd = !bl2;
        if (bl) {
            linkedList.addLast(terraceInfo2);
        } else {
            linkedList.addFirst(terraceInfo2);
        }
        return linkedList;
    }

    private List<TerraceInfo> createDomaYukaL(SNYEntities sNYEntities) {
        return this.createDomaYukaW(sNYEntities, TerraceWidthType.T10, TerraceWidthType.T10, FloorType.DOMA, FloorType.YUKA);
    }

    private List<TerraceInfo> createDomaYukaR(SNYEntities sNYEntities) {
        return this.createDomaYukaW(sNYEntities, TerraceWidthType.T10, TerraceWidthType.T10, FloorType.YUKA, FloorType.DOMA);
    }

    private List<TerraceInfo> createDomaYukaW(SNYEntities sNYEntities, TerraceWidthType terraceWidthType, TerraceWidthType terraceWidthType2, FloorType floorType, FloorType floorType2) {
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        TerraceWidthType terraceWidthType3 = TerraceWidthType.T10;
        if (terracesInfo.mEnforcementType == EnforcementType.DOMA_YUKA_W) {
            terraceWidthType3 = TerraceWidthType.T20;
        }
        TypeTerraceWidthInfo typeTerraceWidthInfo = this.mTypeTerraceWidthCacheDao.findOneByType(terraceWidthType3, basicInfo.mKenType);
        TypeTerraceWidthInfo typeTerraceWidthInfo2 = null;
        if (terraceWidthType != null) {
            typeTerraceWidthInfo2 = this.mTypeTerraceWidthCacheDao.findOneByType(terraceWidthType, basicInfo.mKenType);
        }
        TypeTerraceWidthInfo typeTerraceWidthInfo3 = null;
        if (terraceWidthType2 != null) {
            typeTerraceWidthInfo3 = this.mTypeTerraceWidthCacheDao.findOneByType(terraceWidthType2, basicInfo.mKenType);
        }
        TerraceDepthType terraceDepthType = TerraceDepthType.T4;
        TypeTerraceDepthInfo typeTerraceDepthInfo = this.mTypeTerraceDepthCacheDao.findOneStdByType(terraceDepthType);
        ArrayList<TerraceInfo> arrayList = new ArrayList<TerraceInfo>();
        TerraceInfo terraceInfo = new TerraceInfo();
        terraceInfo.mIsMaster = true;
        terraceInfo.mIsStarting = true;
        terraceInfo.mId = 0;
        terraceInfo.mGroupId = 0;
        terraceInfo.mBuildingType = basicInfo.mBuildingType;
        terraceInfo.mLeftFloorType = floorType;
        terraceInfo.mRightFloorType = floorType2;
        terraceInfo.mTurningAngle = Float.valueOf(0.0f);
        terraceInfo.mWidthType = terraceWidthType3;
        terraceInfo.mDefaultWidth = typeTerraceWidthInfo.length;
        terraceInfo.mWidth = typeTerraceWidthInfo.length;
        if (terraceWidthType != null) {
            terraceInfo.mLeftWidthType = terraceWidthType;
            terraceInfo.mLeftWidth = typeTerraceWidthInfo2.length;
        }
        if (terraceWidthType2 != null) {
            terraceInfo.mRightWidthType = terraceWidthType2;
            terraceInfo.mRightWidth = typeTerraceWidthInfo3.length;
        }
        terraceInfo.mDepthType = terraceDepthType;
        terraceInfo.mDefaultDepth = typeTerraceDepthInfo.length;
        terraceInfo.mDepth = typeTerraceDepthInfo.length;
        terraceInfo.mIsLeftEnd = true;
        terraceInfo.mIsRightEnd = true;
        arrayList.add(terraceInfo);
        return arrayList;
    }

    private List<TerraceInfo> createDomaYukaD(SNYEntities sNYEntities) {
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        TerraceWidthType terraceWidthType = TerraceWidthType.T10;
        TypeTerraceWidthInfo typeTerraceWidthInfo = this.mTypeTerraceWidthCacheDao.findOneByType(terraceWidthType, basicInfo.mKenType);
        TerraceDepthType terraceDepthType = TerraceDepthType.T4;
        if (basicInfo.mSubProductType == SubProductType.DOMA_YUKA && terracesInfo.mEnforcementType == EnforcementType.DOMA_YUKA_D) {
            terraceDepthType = TerraceDepthType.T5;
        }
        TypeTerraceDepthInfo typeTerraceDepthInfo = this.mTypeTerraceDepthCacheDao.findOneStdByType(terraceDepthType);
        TerraceDepthType terraceDepthType2 = TerraceDepthType.T2;
        TypeTerraceDepthInfo typeTerraceDepthInfo2 = this.mTypeTerraceDepthCacheDao.findOneStdByType(terraceDepthType2);
        TerraceDepthType terraceDepthType3 = TerraceDepthType.T3;
        TypeTerraceDepthInfo typeTerraceDepthInfo3 = this.mTypeTerraceDepthCacheDao.findOneStdByType(terraceDepthType3);
        ArrayList<TerraceInfo> arrayList = new ArrayList<TerraceInfo>();
        TerraceInfo terraceInfo = new TerraceInfo();
        terraceInfo.mIsMaster = true;
        terraceInfo.mIsStarting = true;
        terraceInfo.mId = 0;
        terraceInfo.mGroupId = 0;
        terraceInfo.mBuildingType = basicInfo.mBuildingType;
        terraceInfo.mTurningAngle = Float.valueOf(0.0f);
        terraceInfo.mWidthType = terraceWidthType;
        terraceInfo.mDefaultWidth = typeTerraceWidthInfo.length;
        terraceInfo.mWidth = typeTerraceWidthInfo.length;
        terraceInfo.mDepthType = terraceDepthType;
        terraceInfo.mDefaultDepth = typeTerraceDepthInfo.length;
        terraceInfo.mDepth = typeTerraceDepthInfo.length;
        if (terraceDepthType2 != null) {
            terraceInfo.mFrontDepthType = terraceDepthType2;
            terraceInfo.mFrontDepth = typeTerraceDepthInfo2.length;
        }
        if (terraceDepthType3 != null) {
            terraceInfo.mBackDepthType = terraceDepthType3;
            terraceInfo.mBackDepth = typeTerraceDepthInfo3.length;
        }
        terraceInfo.mIsLeftEnd = true;
        terraceInfo.mIsRightEnd = true;
        arrayList.add(terraceInfo);
        return arrayList;
    }

    private FloorType judgeFloorType(BasicInfo basicInfo) {
        return this.judgeFloorType(basicInfo.mSubProductType);
    }

    private FloorType judgeFloorType(SubProductType subProductType) {
        FloorType floorType = null;
        if (subProductType == SubProductType.DOMA) {
            floorType = FloorType.DOMA;
        } else if (subProductType == SubProductType.YUKA) {
            floorType = FloorType.YUKA;
        } else if (subProductType == SubProductType.HALF_KAKOI) {
            floorType = FloorType.YUKA;
        } else if (subProductType == SubProductType.OPEN) {
            floorType = FloorType.YUKA;
        } else if (subProductType == SubProductType.ALMI_BALCONY_PILLAR) {
            floorType = FloorType.YUKA;
        } else if (subProductType == SubProductType.ALMI_BALCONY_ROOF) {
            floorType = FloorType.YUKA;
        }
        return floorType;
    }

    public TerraceInfo addTerrace(SNYEntities sNYEntities, DirectionType directionType) {
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        LinkedList<TerraceInfo> linkedList = sNYEntities.mTerraceInfoList;
        return this.addTerrace(sNYEntities, terracesInfo, linkedList, directionType);
    }

    public TerraceInfo addTerrace(SNYEntities sNYEntities, TerracesInfo terracesInfo, LinkedList<TerraceInfo> linkedList, DirectionType directionType) {
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        LinkedList<PartsFigureUnitInfo> linkedList2 = sNYEntities.mPartsFigureUnitInfoList;
        TerraceInfo terraceInfo = linkedList.getFirst();
        TerraceInfo terraceInfo2 = linkedList.getLast();
        TerraceInfo terraceInfo3 = new TerraceInfo();
        TerraceWidthType terraceWidthType = TerraceWidthType.T10;
        TypeTerraceWidthInfo typeTerraceWidthInfo = this.mTypeTerraceWidthCacheDao.findOneByType(terraceWidthType, basicInfo.mKenType);
        FloorType floorType = null;
        TerraceDepthType terraceDepthType = null;
        float f = 0.0f;
        TerraceDepthType terraceDepthType2 = null;
        float f2 = 0.0f;
        int n = 0;
        TerraceInfo terraceInfo4 = null;
        if (directionType == DirectionType.LEFT) {
            n = -1;
            terraceInfo4 = linkedList.getFirst();
            linkedList.addFirst(terraceInfo3);
            floorType = terraceInfo4.mLeftFloorType;
            terraceDepthType = terraceInfo4.mDepthType;
            f = terraceInfo4.mDepth.floatValue();
            terraceDepthType2 = terraceInfo4.mLeftDepthType;
            f2 = terraceInfo4.mLeftDepth.floatValue();
        } else if (directionType == DirectionType.RIGHT) {
            n = 1;
            terraceInfo4 = linkedList.getLast();
            linkedList.addLast(terraceInfo3);
            floorType = terraceInfo4.mRightFloorType;
            terraceDepthType = terraceInfo4.mDepthType;
            f = terraceInfo4.mDepth.floatValue();
            terraceDepthType2 = terraceInfo4.mRightDepthType;
            f2 = terraceInfo4.mRightDepth.floatValue();
        }
        if (floorType == null) {
            floorType = terraceInfo4.mFloorType;
        }
        if (terracesInfo.mEnforcementType != EnforcementType.BUBUN_IRISUMI) {
            terraceDepthType = terraceDepthType2;
            f = f2;
        }
        TypeTerraceDepthInfo typeTerraceDepthInfo = this.mTypeTerraceDepthCacheDao.findOneStdByType(terraceDepthType);
        terraceInfo3.mIsMaster = false;
        terraceInfo3.mIsStarting = false;
        terraceInfo3.mId = terraceInfo4.mId + n;
        terraceInfo3.mGroupId = terraceInfo4.mGroupId;
        terraceInfo3.mFloorType = floorType;
        terraceInfo3.mWidthType = terraceWidthType;
        terraceInfo3.mDefaultWidth = typeTerraceWidthInfo.length;
        terraceInfo3.mWidth = typeTerraceWidthInfo.length;
        terraceInfo3.mDepthType = terraceDepthType;
        terraceInfo3.mDefaultDepth = typeTerraceDepthInfo.length;
        terraceInfo3.mDepth = Float.valueOf(f);
        terraceInfo3.mFrontDepthType = terraceInfo4.mFrontDepthType;
        terraceInfo3.mFrontDepth = terraceInfo4.mFrontDepth;
        terraceInfo3.mBackDepthType = terraceInfo4.mBackDepthType;
        terraceInfo3.mBackDepth = terraceInfo4.mBackDepth;
        if (terracesInfo.mEnforcementType == EnforcementType.BUBUN_IRISUMI) {
            if (terracesInfo.mEnforcementDirType == EnforcementDirType.L) {
                terraceInfo3.mLeftDepthType = terraceDepthType2;
                terraceInfo3.mLeftDepth = Float.valueOf(f2);
                terraceInfo3.mRightDepthType = terraceDepthType;
                terraceInfo3.mRightDepth = Float.valueOf(f);
            } else if (terracesInfo.mEnforcementDirType == EnforcementDirType.R) {
                terraceInfo3.mLeftDepthType = terraceDepthType;
                terraceInfo3.mLeftDepth = Float.valueOf(f);
                terraceInfo3.mRightDepthType = terraceDepthType2;
                terraceInfo3.mRightDepth = Float.valueOf(f2);
            }
        } else {
            terraceInfo3.mLeftDepthType = terraceDepthType2;
            terraceInfo3.mLeftDepth = Float.valueOf(f2);
            terraceInfo3.mRightDepthType = terraceDepthType2;
            terraceInfo3.mRightDepth = Float.valueOf(f2);
        }
        if (terracesInfo.mEnforcementType == EnforcementType.BUBUN_KAKOI) {
            if (terracesInfo.mEnforcementDirType == EnforcementDirType.L) {
                if (directionType == DirectionType.LEFT) {
                    terraceInfo3.mBuildingType = BuildingType.ROOM;
                } else if (directionType == DirectionType.RIGHT) {
                    terraceInfo3.mBuildingType = BuildingType.TERRACE;
                }
            } else if (terracesInfo.mEnforcementDirType == EnforcementDirType.R) {
                if (directionType == DirectionType.LEFT) {
                    terraceInfo3.mBuildingType = BuildingType.TERRACE;
                } else if (directionType == DirectionType.RIGHT) {
                    terraceInfo3.mBuildingType = BuildingType.ROOM;
                }
            }
        } else {
            terraceInfo3.mBuildingType = basicInfo.mBuildingType;
        }
        terraceInfo3.mTurningAngle = terraceInfo4.mTurningAngle;
        terraceInfo4.mTurningAngle = Float.valueOf(0.0f);
        TerraceInfo terraceInfo5 = linkedList.getFirst();
        TerraceInfo terraceInfo6 = linkedList.getLast();
        if (directionType == DirectionType.LEFT) {
            terraceInfo5.mIsLeftEnd = true;
            terraceInfo5.mLeftKutaiPillarWidth = terraceInfo.mLeftKutaiPillarWidth;
            if (terraceInfo5 != terraceInfo) {
                terraceInfo.mIsLeftEnd = false;
                terraceInfo.mLeftKutaiPillarWidth = Float.valueOf(0.0f);
            }
        } else {
            terraceInfo6.mIsRightEnd = true;
            terraceInfo6.mRightKutaiPillarWidth = terraceInfo2.mRightKutaiPillarWidth;
            if (terraceInfo6 != terraceInfo2) {
                terraceInfo2.mIsRightEnd = false;
                terraceInfo2.mRightKutaiPillarWidth = Float.valueOf(0.0f);
            }
        }
        if (terraceInfo5 != terraceInfo6) {
            terraceInfo5.mIsRightEnd = false;
            terraceInfo5.mRightKutaiPillarWidth = Float.valueOf(0.0f);
            terraceInfo6.mIsLeftEnd = false;
            terraceInfo6.mLeftKutaiPillarWidth = Float.valueOf(0.0f);
        }
        this.mFrontPanelCommonService.initFrontPanel(sNYEntities);
        this.mSidePanelCommonService.initSidePanel(sNYEntities);
        this.mTerraceCommonService.changeWidth(sNYEntities);
        this.updateDepth(sNYEntities);
        this.updateCutInfo(sNYEntities);
        PartsFigureUnitInfo partsFigureUnitInfo = new PartsFigureUnitInfo();
        partsFigureUnitInfo.mId = terraceInfo3.mId;
        if (directionType == DirectionType.LEFT) {
            linkedList2.addFirst(partsFigureUnitInfo);
        } else if (directionType == DirectionType.RIGHT) {
            linkedList2.addLast(partsFigureUnitInfo);
        }
        return terraceInfo3;
    }

    public void removeTerrace(SNYEntities sNYEntities, DirectionType directionType) {
        LinkedList<TerraceInfo> linkedList = sNYEntities.mTerraceInfoList;
        LinkedList<PartsFigureUnitInfo> linkedList2 = sNYEntities.mPartsFigureUnitInfoList;
        if (directionType == DirectionType.RIGHT) {
            TerraceInfo terraceInfo = linkedList.getFirst();
            if (terraceInfo.mIsMaster.booleanValue()) {
                return;
            }
            linkedList.removeFirst();
            TerraceInfo terraceInfo2 = linkedList.getFirst();
            terraceInfo2.mIsLeftEnd = true;
            terraceInfo2.mTurningAngle = terraceInfo.mTurningAngle;
            terraceInfo2.mLeftKutaiPillarWidth = terraceInfo.mLeftKutaiPillarWidth;
            linkedList2.removeFirst();
        } else if (directionType == DirectionType.LEFT) {
            TerraceInfo terraceInfo = linkedList.getLast();
            if (terraceInfo.mIsMaster.booleanValue()) {
                return;
            }
            linkedList.removeLast();
            TerraceInfo terraceInfo3 = linkedList.getLast();
            terraceInfo3.mIsRightEnd = true;
            terraceInfo3.mTurningAngle = terraceInfo.mTurningAngle;
            terraceInfo3.mRightKutaiPillarWidth = terraceInfo.mRightKutaiPillarWidth;
            linkedList2.removeLast();
        }
        this.fixTerraceInfo(sNYEntities);
        this.mFrontPanelCommonService.initFrontPanel(sNYEntities);
        this.mSidePanelCommonService.initSidePanel(sNYEntities);
        this.mTerraceCommonService.changeWidth(sNYEntities);
        this.updateDepth(sNYEntities);
    }

    public void fixTerraceInfo(SNYEntities sNYEntities) {
        this.fixLeftTerraceInfo(sNYEntities);
        this.fixRightTerraceInfo(sNYEntities);
    }

    public void fixLeftTerraceInfo(SNYEntities sNYEntities) {
        TypeTerraceWidthInfo typeTerraceWidthInfo;
        boolean bl;
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        LinkedList<TerraceInfo> linkedList = sNYEntities.mTerraceInfoList;
        if (!(terracesInfo.mEnforcementType == EnforcementType.DOMA_YUKA_W && terracesInfo.mEnforcementDirType == EnforcementDirType.R || terracesInfo.mEnforcementType == EnforcementType.BUBUN_KAKOI && terracesInfo.mEnforcementDirType == EnforcementDirType.L)) {
            return;
        }
        TerraceInfo terraceInfo = this.mTerraceCommonService.findMasterTerraceInfo(linkedList);
        TerraceInfo terraceInfo2 = linkedList.getLast();
        boolean bl2 = bl = linkedList.size() == 1 || terracesInfo.mEnforcementType == EnforcementType.DOMA_YUKA_W && terraceInfo2.mId == 0;
        if (bl && terraceInfo.mWidthType == TerraceWidthType.T10) {
            terraceInfo.mWidthType = TerraceWidthType.T15;
        }
        TypeTerraceWidthInfo typeTerraceWidthInfo2 = this.mTypeTerraceWidthCacheDao.findOneByType(terraceInfo.mWidthType, basicInfo.mKenType);
        terraceInfo.mDefaultWidth = typeTerraceWidthInfo2.length;
        terraceInfo.mWidth = typeTerraceWidthInfo2.length;
        int n = 0;
        if (terracesInfo.mEnforcementType == EnforcementType.DOMA_YUKA_W) {
            typeTerraceWidthInfo = this.mTypeTerraceWidthCacheDao.findOneByType(terraceInfo.mLeftWidthType, basicInfo.mKenType);
            n = typeTerraceWidthInfo.typeTerraceWidthId;
        } else if (bl) {
            if (terraceInfo.mWidthType.id() > terraceInfo.mLeftWidthType.id()) {
                return;
            }
            n = typeTerraceWidthInfo2.typeTerraceWidthId - 1;
        } else {
            if (terraceInfo.mWidthType.id() >= terraceInfo.mLeftWidthType.id()) {
                return;
            }
            n = typeTerraceWidthInfo2.typeTerraceWidthId;
        }
        typeTerraceWidthInfo = this.mTypeTerraceWidthCacheDao.findOneById((Integer)n, basicInfo.mKenType);
        TerraceWidthType terraceWidthType = (TerraceWidthType)TerraceWidthTypeFactory.getInstance().getTypeById(typeTerraceWidthInfo.typeTerraceWidthId);
        float f = typeTerraceWidthInfo2.length.floatValue() - typeTerraceWidthInfo.length.floatValue();
        TypeTerraceWidthInfo typeTerraceWidthInfo3 = this.mTypeTerraceWidthCacheDao.findOneByLength(Float.valueOf(f), basicInfo.mKenType);
        TerraceWidthType terraceWidthType2 = (TerraceWidthType)TerraceWidthTypeFactory.getInstance().getTypeById(typeTerraceWidthInfo3.typeTerraceWidthId);
        terraceInfo.mLeftWidthType = terraceWidthType;
        terraceInfo.mLeftWidth = typeTerraceWidthInfo.length;
        terraceInfo.mRightWidthType = terraceWidthType2;
        terraceInfo.mRightWidth = Float.valueOf(f);
    }

    public void fixRightTerraceInfo(SNYEntities sNYEntities) {
        TerraceWidthType terraceWidthType;
        TypeTerraceWidthInfo typeTerraceWidthInfo;
        boolean bl;
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        LinkedList<TerraceInfo> linkedList = sNYEntities.mTerraceInfoList;
        if (!(terracesInfo.mEnforcementType == EnforcementType.DOMA_YUKA_W && terracesInfo.mEnforcementDirType == EnforcementDirType.L || terracesInfo.mEnforcementType == EnforcementType.BUBUN_KAKOI && terracesInfo.mEnforcementDirType == EnforcementDirType.R)) {
            return;
        }
        TerraceInfo terraceInfo = this.mTerraceCommonService.findMasterTerraceInfo(linkedList);
        TerraceInfo terraceInfo2 = linkedList.getFirst();
        boolean bl2 = bl = linkedList.size() == 1 || terracesInfo.mEnforcementType == EnforcementType.DOMA_YUKA_W && terraceInfo2.mId == 0;
        if (bl && terraceInfo.mWidthType == TerraceWidthType.T10) {
            terraceInfo.mWidthType = TerraceWidthType.T15;
        }
        TypeTerraceWidthInfo typeTerraceWidthInfo2 = this.mTypeTerraceWidthCacheDao.findOneByType(terraceInfo.mWidthType, basicInfo.mKenType);
        terraceInfo.mDefaultWidth = typeTerraceWidthInfo2.length;
        terraceInfo.mWidth = typeTerraceWidthInfo2.length;
        int n = 0;
        if (terracesInfo.mEnforcementType == EnforcementType.DOMA_YUKA_W) {
            typeTerraceWidthInfo = this.mTypeTerraceWidthCacheDao.findOneByType(terraceInfo.mRightWidthType, basicInfo.mKenType);
            n = typeTerraceWidthInfo.typeTerraceWidthId;
        } else if (bl) {
            if (terraceInfo.mWidthType.id() > terraceInfo.mRightWidthType.id()) {
                return;
            }
            n = typeTerraceWidthInfo2.typeTerraceWidthId - 1;
        } else {
            if (terraceInfo.mWidthType.id() >= terraceInfo.mRightWidthType.id()) {
                return;
            }
            n = typeTerraceWidthInfo2.typeTerraceWidthId;
        }
        typeTerraceWidthInfo = this.mTypeTerraceWidthCacheDao.findOneById((Integer)n, basicInfo.mKenType);
        TerraceWidthType terraceWidthType2 = (TerraceWidthType)TerraceWidthTypeFactory.getInstance().getTypeById(typeTerraceWidthInfo.typeTerraceWidthId);
        float f = typeTerraceWidthInfo2.length.floatValue() - typeTerraceWidthInfo.length.floatValue();
        TypeTerraceWidthInfo typeTerraceWidthInfo3 = this.mTypeTerraceWidthCacheDao.findOneByLength(Float.valueOf(f), basicInfo.mKenType);
        terraceInfo.mLeftWidthType = terraceWidthType = (TerraceWidthType)TerraceWidthTypeFactory.getInstance().getTypeById(typeTerraceWidthInfo3.typeTerraceWidthId);
        terraceInfo.mLeftWidth = Float.valueOf(f);
        terraceInfo.mRightWidthType = terraceWidthType2;
        terraceInfo.mRightWidth = typeTerraceWidthInfo.length;
    }

    public void initDepthForTerracesInfo(SNYEntities sNYEntities) {
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        DomaTileInfo domaTileInfo = sNYEntities.mDomaTileInfo;
        EnforcementType enforcementType = terracesInfo.mEnforcementType;
        EnforcementDirType enforcementDirType = terracesInfo.mEnforcementDirType;
        terracesInfo.mKutaiCoping = Float.valueOf(0.0f);
        if (enforcementType == EnforcementType.STD) {
            terracesInfo.mPartialDepth = Float.valueOf(0.0f);
            terracesInfo.mDepthGap = Float.valueOf(0.0f);
            domaTileInfo.mCutDepth = Float.valueOf(0.0f);
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.STD)) {
            terracesInfo.mPartialDepth = Float.valueOf(0.0f);
            terracesInfo.mDepthGap = Float.valueOf(0.0f);
            domaTileInfo.mCutDepth = Float.valueOf(0.0f);
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.DESUMI)) {
            terracesInfo.mPartialDepth = Float.valueOf(0.0f);
            terracesInfo.mDepthGap = Float.valueOf(0.0f);
            domaTileInfo.mCutDepth = Float.valueOf(0.0f);
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.IRISUMI)) {
            terracesInfo.mPartialDepth = Float.valueOf(0.0f);
            terracesInfo.mDepthGap = Float.valueOf(0.0f);
            domaTileInfo.mCutDepth = Float.valueOf(0.0f);
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.SHOMEN_DAIKEI)) {
            terracesInfo.mPartialDepth = Float.valueOf(0.0f);
            terracesInfo.mDepthGap = Float.valueOf(0.0f);
            domaTileInfo.mCutDepth = Float.valueOf(0.0f);
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.SOKUMEN_DAIKEI)) {
            terracesInfo.mPartialDepth = Float.valueOf(0.0f);
            terracesInfo.mDepthGap = Float.valueOf(0.0f);
            domaTileInfo.mCutDepth = Float.valueOf(0.0f);
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.MAEWAKU_DEHABA_CHIGAI) && GdMutableTypeUtil.matchOR(enforcementDirType, EnforcementDirType.L)) {
            terracesInfo.mPartialDepth = Float.valueOf(0.0f);
            terracesInfo.mDepthGap = Float.valueOf(0.0f);
            domaTileInfo.mCutDepth = Float.valueOf(0.0f);
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.MAEWAKU_DEHABA_CHIGAI) && GdMutableTypeUtil.matchOR(enforcementDirType, EnforcementDirType.R)) {
            terracesInfo.mPartialDepth = Float.valueOf(0.0f);
            terracesInfo.mDepthGap = Float.valueOf(0.0f);
            domaTileInfo.mCutDepth = Float.valueOf(0.0f);
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.KUTAI_DEHABA_CHIGAI) && GdMutableTypeUtil.matchOR(enforcementDirType, EnforcementDirType.L)) {
            terracesInfo.mPartialDepth = Float.valueOf(0.0f);
            domaTileInfo.mCutDepth = terracesInfo.mDepthGap = this.mConstants.minDepthGap;
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.KUTAI_DEHABA_CHIGAI) && GdMutableTypeUtil.matchOR(enforcementDirType, EnforcementDirType.R)) {
            terracesInfo.mPartialDepth = Float.valueOf(0.0f);
            domaTileInfo.mCutDepth = terracesInfo.mDepthGap = this.mConstants.minDepthGap;
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.HANEDASHI)) {
            terracesInfo.mPartialDepth = Float.valueOf(0.0f);
            terracesInfo.mDepthGap = Float.valueOf(0.0f);
            domaTileInfo.mCutDepth = Float.valueOf(0.0f);
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.JIZAIKETA_HANEDASHI)) {
            terracesInfo.mPartialDepth = Float.valueOf(0.0f);
            terracesInfo.mDepthGap = Float.valueOf(0.0f);
            domaTileInfo.mCutDepth = Float.valueOf(0.0f);
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.KEISHA)) {
            terracesInfo.mPartialDepth = Float.valueOf(0.0f);
            terracesInfo.mDepthGap = Float.valueOf(0.0f);
            domaTileInfo.mCutDepth = Float.valueOf(0.0f);
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.BUBUN_IRISUMI) && GdMutableTypeUtil.matchOR(enforcementDirType, EnforcementDirType.L)) {
            terracesInfo.mPartialDepth = this.mConstants.minPartialDepth;
            terracesInfo.mDepthGap = Float.valueOf(0.0f);
            domaTileInfo.mCutDepth = terracesInfo.mPartialDepth;
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.BUBUN_IRISUMI) && GdMutableTypeUtil.matchOR(enforcementDirType, EnforcementDirType.R)) {
            terracesInfo.mPartialDepth = this.mConstants.minPartialDepth;
            terracesInfo.mDepthGap = Float.valueOf(0.0f);
            domaTileInfo.mCutDepth = terracesInfo.mPartialDepth;
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.BUBUN_KAKOI) && basicInfo.mSubProductType != SubProductType.TSUKURITSUKE) {
            terracesInfo.mPartialDepth = Float.valueOf(0.0f);
            terracesInfo.mDepthGap = Float.valueOf(0.0f);
            domaTileInfo.mCutDepth = Float.valueOf(0.0f);
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.BUBUN_KAKOI) && basicInfo.mSubProductType == SubProductType.TSUKURITSUKE) {
            terracesInfo.mPartialDepth = Float.valueOf(0.0f);
            terracesInfo.mDepthGap = Float.valueOf(0.0f);
            domaTileInfo.mCutDepth = Float.valueOf(0.0f);
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.DOMA_YUKA_W)) {
            terracesInfo.mPartialDepth = Float.valueOf(0.0f);
            terracesInfo.mDepthGap = Float.valueOf(0.0f);
            domaTileInfo.mCutDepth = Float.valueOf(0.0f);
        } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.DOMA_YUKA_D)) {
            terracesInfo.mPartialDepth = Float.valueOf(0.0f);
            terracesInfo.mDepthGap = Float.valueOf(0.0f);
            domaTileInfo.mCutDepth = Float.valueOf(0.0f);
        }
    }

    public void updateDepthForTerracesInfo(SNYEntities sNYEntities) {
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        EnforcementType enforcementType = terracesInfo.mEnforcementType;
        terracesInfo.mKutaiCoping = Float.valueOf(0.0f);
        if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.BUBUN_KAKOI) && basicInfo.mSubProductType == SubProductType.TSUKURITSUKE) {
            SpecFrameSizeInfo specFrameSizeInfo = this.mSpecFrameSizeCacheDao.findOneByTypes(basicInfo, terracesInfo);
            terracesInfo.mKutaiCoping = specFrameSizeInfo.defD1;
        }
    }

    public void updateDepth(SNYEntities sNYEntities) {
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        LinkedList<TerraceInfo> linkedList = sNYEntities.mTerraceInfoList;
        EnforcementType enforcementType = terracesInfo.mEnforcementType;
        EnforcementDirType enforcementDirType = terracesInfo.mEnforcementDirType;
        float f = this.mTerraceCommonService.findOneMaxDepth(linkedList);
        for (TerraceInfo terraceInfo : linkedList) {
            BuildingType buildingType = terraceInfo.mBuildingType;
            if (buildingType == BuildingType.CORNER) {
                terraceInfo.mLeftDepth = terraceInfo.mDepth;
                terraceInfo.mRightDepth = terraceInfo.mDepth;
                terraceInfo.mWidth = terraceInfo.mDepth;
                terraceInfo.mDefaultWidth = terraceInfo.mDepth;
            } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.STD)) {
                terraceInfo.mLeftDepth = terraceInfo.mDepth;
                terraceInfo.mRightDepth = terraceInfo.mDepth;
            } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.DESUMI)) {
                terraceInfo.mLeftDepth = terraceInfo.mDepth;
                terraceInfo.mRightDepth = terraceInfo.mDepth;
            } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.IRISUMI)) {
                terraceInfo.mLeftDepth = terraceInfo.mDepth;
                terraceInfo.mRightDepth = terraceInfo.mDepth;
            } else if (!GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.SHOMEN_DAIKEI)) {
                if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.SOKUMEN_DAIKEI)) {
                    terraceInfo.mLeftDepth = terraceInfo.mDepth;
                    terraceInfo.mRightDepth = terraceInfo.mDepth;
                } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.MAEWAKU_DEHABA_CHIGAI) && GdMutableTypeUtil.matchOR(enforcementDirType, EnforcementDirType.L)) {
                    terraceInfo.mLeftDepth = Float.valueOf(terraceInfo.mDepth.floatValue() - terracesInfo.mDepthGap.floatValue());
                    terraceInfo.mRightDepth = terraceInfo.mDepth;
                } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.MAEWAKU_DEHABA_CHIGAI) && GdMutableTypeUtil.matchOR(enforcementDirType, EnforcementDirType.R)) {
                    terraceInfo.mLeftDepth = terraceInfo.mDepth;
                    terraceInfo.mRightDepth = Float.valueOf(terraceInfo.mDepth.floatValue() - terracesInfo.mDepthGap.floatValue());
                } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.KUTAI_DEHABA_CHIGAI) && GdMutableTypeUtil.matchOR(enforcementDirType, EnforcementDirType.L)) {
                    if (terraceInfo.mId == 0) {
                        terraceInfo.mLeftDepth = Float.valueOf(f - terracesInfo.mDepthGap.floatValue());
                        terraceInfo.mRightDepth = Float.valueOf(f);
                    } else if (terraceInfo.mId < 0) {
                        terraceInfo.mLeftDepth = Float.valueOf(f - terracesInfo.mDepthGap.floatValue());
                        terraceInfo.mRightDepth = Float.valueOf(f - terracesInfo.mDepthGap.floatValue());
                    } else if (terraceInfo.mId > 0) {
                        terraceInfo.mLeftDepth = Float.valueOf(f);
                        terraceInfo.mRightDepth = Float.valueOf(f);
                    }
                } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.KUTAI_DEHABA_CHIGAI) && GdMutableTypeUtil.matchOR(enforcementDirType, EnforcementDirType.R)) {
                    if (terraceInfo.mId == 0) {
                        terraceInfo.mLeftDepth = Float.valueOf(f);
                        terraceInfo.mRightDepth = Float.valueOf(f - terracesInfo.mDepthGap.floatValue());
                    } else if (terraceInfo.mId < 0) {
                        terraceInfo.mLeftDepth = Float.valueOf(f);
                        terraceInfo.mRightDepth = Float.valueOf(f);
                    } else if (terraceInfo.mId > 0) {
                        terraceInfo.mLeftDepth = Float.valueOf(f - terracesInfo.mDepthGap.floatValue());
                        terraceInfo.mRightDepth = Float.valueOf(f - terracesInfo.mDepthGap.floatValue());
                    }
                } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.HANEDASHI)) {
                    terraceInfo.mLeftDepth = terraceInfo.mDepth;
                    terraceInfo.mRightDepth = terraceInfo.mDepth;
                } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.JIZAIKETA_HANEDASHI)) {
                    terraceInfo.mLeftDepth = terraceInfo.mDepth;
                    terraceInfo.mRightDepth = terraceInfo.mDepth;
                } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.KEISHA)) {
                    terraceInfo.mLeftDepth = terraceInfo.mDepth;
                    terraceInfo.mRightDepth = terraceInfo.mDepth;
                } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.BUBUN_IRISUMI) && GdMutableTypeUtil.matchOR(enforcementDirType, EnforcementDirType.L)) {
                    terraceInfo.mLeftDepth = Float.valueOf(terraceInfo.mDepth.floatValue() - terracesInfo.mPartialDepth.floatValue() - 5.0f + 35.0f);
                    terraceInfo.mRightDepth = terraceInfo.mDepth;
                } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.BUBUN_IRISUMI) && GdMutableTypeUtil.matchOR(enforcementDirType, EnforcementDirType.R)) {
                    terraceInfo.mLeftDepth = terraceInfo.mDepth;
                    terraceInfo.mRightDepth = Float.valueOf(terraceInfo.mDepth.floatValue() - terracesInfo.mPartialDepth.floatValue() - 5.0f + 35.0f);
                } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.BUBUN_KAKOI) && basicInfo.mSubProductType != SubProductType.TSUKURITSUKE) {
                    terraceInfo.mLeftDepth = terraceInfo.mDepth;
                    terraceInfo.mRightDepth = terraceInfo.mDepth;
                } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.BUBUN_KAKOI) && basicInfo.mSubProductType == SubProductType.TSUKURITSUKE && GdMutableTypeUtil.matchOR(enforcementDirType, EnforcementDirType.L)) {
                    terraceInfo.mLeftDepth = terraceInfo.mDepth;
                    terraceInfo.mRightDepth = terraceInfo.mDepth;
                } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.BUBUN_KAKOI) && basicInfo.mSubProductType == SubProductType.TSUKURITSUKE && GdMutableTypeUtil.matchOR(enforcementDirType, EnforcementDirType.R)) {
                    terraceInfo.mLeftDepth = terraceInfo.mDepth;
                    terraceInfo.mRightDepth = terraceInfo.mDepth;
                } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.DOMA_YUKA_W)) {
                    terraceInfo.mLeftDepth = terraceInfo.mDepth;
                    terraceInfo.mRightDepth = terraceInfo.mDepth;
                } else if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.DOMA_YUKA_D)) {
                    terraceInfo.mLeftDepth = terraceInfo.mDepth;
                    terraceInfo.mRightDepth = terraceInfo.mDepth;
                }
            }
            terraceInfo.mLeftDepthType = TerraceDepthTypeDxo.convert(terraceInfo.mLeftDepth.floatValue(), basicInfo.mSubProductType);
            terraceInfo.mRightDepthType = TerraceDepthTypeDxo.convert(terraceInfo.mRightDepth.floatValue(), basicInfo.mSubProductType);
        }
        if (GdMutableTypeUtil.matchOR(enforcementType, EnforcementType.SHOMEN_DAIKEI)) {
            this.updateDepthForShomenDaikei(sNYEntities);
        }
        this.updateTotalDepth(basicInfo, terracesInfo, linkedList);
        this.updateDepthForTerracesInfo(sNYEntities);
        this.updateDepthForOpening(sNYEntities);
    }

    private void updateDepthForShomenDaikei(SNYEntities sNYEntities) {
        TerraceInfo terraceInfo3;
        LinkedList<TerraceInfo> linkedList = sNYEntities.mTerraceInfoList;
        if (linkedList.size() <= 1) {
            return;
        }
        TerraceInfo terraceInfo2 = linkedList.getFirst();
        for (TerraceInfo terraceInfo3 : linkedList) {
            if (terraceInfo3.mId > 0) continue;
            if (terraceInfo3.mId == 0) {
                terraceInfo3.mLeftDepth = terraceInfo2.mDepth;
                continue;
            }
            terraceInfo3.mLeftDepth = terraceInfo2.mDepth;
            terraceInfo3.mRightDepth = terraceInfo2.mDepth;
        }
        terraceInfo3 = linkedList.getLast();
        for (TerraceInfo terraceInfo4 : linkedList) {
            if (terraceInfo4.mId < 0) continue;
            if (terraceInfo4.mId == 0) {
                terraceInfo4.mRightDepth = terraceInfo3.mDepth;
                continue;
            }
            terraceInfo4.mLeftDepth = terraceInfo3.mDepth;
            terraceInfo4.mRightDepth = terraceInfo3.mDepth;
        }
    }

    public void updateDepthForOpening(SNYEntities sNYEntities) {
        LinkedList<TerraceInfo> linkedList = sNYEntities.mTerraceInfoList;
        for (TerraceInfo terraceInfo : linkedList) {
            this.updateDepthForOpening(sNYEntities, terraceInfo);
        }
    }

    private void updateDepthForOpening(SNYEntities sNYEntities, TerraceInfo terraceInfo) {
        terraceInfo.mLeftOpeningDepth = Float.valueOf(this.mSidePanelFigureCommonService.calcLeftOpeningDepth(sNYEntities, terraceInfo));
        terraceInfo.mRightOpeningDepth = Float.valueOf(this.mSidePanelFigureCommonService.calcRightOpeningDepth(sNYEntities, terraceInfo));
        terraceInfo.mOpeningDepth = Float.valueOf(Math.max(terraceInfo.mLeftOpeningDepth.floatValue(), terraceInfo.mRightOpeningDepth.floatValue()));
    }

    public void updateTotalDepth(SNYEntities sNYEntities) {
        this.updateTotalDepth(sNYEntities.mBasicInfo, sNYEntities.mTerracesInfo, sNYEntities.mTerraceInfoList);
    }

    public void updateTotalDepth(BasicInfo basicInfo, TerracesInfo terracesInfo, List<TerraceInfo> list) {
        float f = this.mTerraceCommonService.findOneMaxDepth(list);
        terracesInfo.mDepth = Float.valueOf(f);
        terracesInfo.mDepthType = TerraceDepthTypeDxo.convert(f, basicInfo.mSubProductType);
    }

    public void updateWidth(SNYEntities sNYEntities) {
        this.updateWidth(sNYEntities.mBasicInfo, sNYEntities.mTerracesInfo, sNYEntities.mTerraceInfoList);
    }

    public void updateWidth(BasicInfo basicInfo, TerracesInfo terracesInfo, LinkedList<TerraceInfo> linkedList) {
        for (TerraceInfo terraceInfo : linkedList) {
            this.updateWidth(terracesInfo, terraceInfo);
        }
        this.updateTotalWidth(basicInfo, terracesInfo, linkedList);
    }

    private void updateWidth(TerracesInfo terracesInfo, TerraceInfo terraceInfo) {
        terraceInfo.mWidth = Float.valueOf(this.mTerraceFigureCommonService.calcWidth(terracesInfo, terraceInfo));
        terraceInfo.mOpeningWidth = Float.valueOf(this.mTerraceFigureCommonService.calcOpeningWidth(terracesInfo, terraceInfo));
    }

    private void updateTotalWidth(BasicInfo basicInfo, TerracesInfo terracesInfo, LinkedList<TerraceInfo> linkedList) {
        float f = 0.0f;
        float f2 = 0.0f;
        for (TerraceInfo terraceInfo : linkedList) {
            f += terraceInfo.mWidth.floatValue();
            f2 += terraceInfo.mOpeningWidth.floatValue();
        }
        terracesInfo.mWidth = Float.valueOf(f);
        terracesInfo.mWidthType = TerraceWidthTypeDxo.convert(f, basicInfo.mKenType);
        terracesInfo.mOpeningWidth = Float.valueOf(f2);
    }

    public void updateTerraceHeightType(SNYEntities sNYEntities) {
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        PillarLengthType pillarLengthType = basicInfo.mPillarLengthType;
        TerraceHeightType terraceHeightType = null;
        if (pillarLengthType == PillarLengthType.NONE) {
            terraceHeightType = TerraceHeightType.NONE;
        } else if (pillarLengthType == PillarLengthType.STD) {
            terraceHeightType = TerraceHeightType.STD;
        } else if (pillarLengthType == PillarLengthType.LONG) {
            terraceHeightType = TerraceHeightType.LONG;
        } else if (pillarLengthType == PillarLengthType.YUKAUE_LONG) {
            terraceHeightType = TerraceHeightType.YUKAUE_LONG;
        } else if (pillarLengthType == PillarLengthType.YUKASHITA_LONG) {
            terraceHeightType = TerraceHeightType.YUKASHITA_LONG;
        } else if (pillarLengthType == PillarLengthType.YUKAUESHITA_LONG) {
            terraceHeightType = TerraceHeightType.YUKAUESHITA_LONG;
        }
        terracesInfo.mHeightType = terraceHeightType;
        float f = (float)this.mTerraceFigureCommonService.calcRoofHeight(sNYEntities);
        float f2 = (float)MathUtil.ceil((double)f);
        terracesInfo.mRoofHeight = Float.valueOf(f);
        TypeTerraceHeightInfo typeTerraceHeightInfo = this.mTypeTerraceHeightCacheDao.findOneByTypes(basicInfo.mSubProductType, terracesInfo.mEnforcementType, terraceHeightType, basicInfo.mFloorNum);
        if (basicInfo.mSubProductType == SubProductType.TSUKURITSUKE) {
            if (terracesInfo.mEnforcementType == EnforcementType.BUBUN_KAKOI) {
                SpecFrameSizeInfo specFrameSizeInfo = this.mSpecFrameSizeCacheDao.findOneByTypes(basicInfo, terracesInfo);
                terracesInfo.mHeight = Float.valueOf(specFrameSizeInfo.defH2.floatValue() - f2);
                terracesInfo.mDefaultHeight = Float.valueOf(specFrameSizeInfo.defH2.floatValue() - f2);
                terracesInfo.mDefaultOpeningHeight = Float.valueOf(specFrameSizeInfo.defH1.floatValue() - f2);
                terracesInfo.mOpeningHeight = Float.valueOf(specFrameSizeInfo.defH1.floatValue() - f2);
            } else {
                terracesInfo.mHeight = typeTerraceHeightInfo.length;
                terracesInfo.mDefaultHeight = typeTerraceHeightInfo.length;
                terracesInfo.mDefaultOpeningHeight = terracesInfo.mHeight;
                terracesInfo.mOpeningHeight = terracesInfo.mHeight;
            }
        } else {
            terracesInfo.mHeight = typeTerraceHeightInfo.length;
            terracesInfo.mDefaultHeight = typeTerraceHeightInfo.length;
        }
    }

    public void updateCutInfo(SNYEntities sNYEntities) {
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        LinkedList<TerraceInfo> linkedList = sNYEntities.mTerraceInfoList;
        CutPlaceType cutPlaceType = terracesInfo.mSodePosType != SodePosType.NONE ? CutPlaceType.FIELD : CutPlaceType.FACTORY;
        terracesInfo.mHeightCutPlaceType = basicInfo.mSubProductType == SubProductType.TSUKURITSUKE && terracesInfo.mEnforcementType == EnforcementType.BUBUN_KAKOI ? CutPlaceType.FIELD : cutPlaceType;
        for (TerraceInfo terraceInfo : linkedList) {
            terraceInfo.mCutPlaceType = cutPlaceType;
        }
    }
}

