/*
 * Decompiled with CFR 0.152.
 */
package option.loneterrace.common.service.material;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import option.gad.core.inject.GdInject;
import option.gad.core.util.GdMutableTypeUtil;
import option.gad.core.util.Tuple3;
import option.loneterrace.common.dao.cache.spec.SpecOpeningPanelCacheDao;
import option.loneterrace.common.dao.cache.spec.SpecOpeningPanelHeightCacheDao;
import option.loneterrace.common.dao.cache.spec.SpecOpeningPanelHeightSizeCacheDao;
import option.loneterrace.common.dao.cache.spec.SpecOpeningPanelSizeCacheDao;
import option.loneterrace.common.dao.cache.type.TypeTerraceDepthCacheDao;
import option.loneterrace.common.dxo.TerraceWidthTypeDxo;
import option.loneterrace.common.entity.BasicInfo;
import option.loneterrace.common.entity.FloorInfo;
import option.loneterrace.common.entity.FrontPanelInfo;
import option.loneterrace.common.entity.PanelInfo;
import option.loneterrace.common.entity.PartsFigureInfo;
import option.loneterrace.common.entity.SNYEntities;
import option.loneterrace.common.entity.SidePanelInfo;
import option.loneterrace.common.entity.TerraceInfo;
import option.loneterrace.common.entity.TerracesInfo;
import option.loneterrace.common.entity.spec.SpecOpeningPanelHeightInfo;
import option.loneterrace.common.entity.spec.SpecOpeningPanelHeightSizeInfo;
import option.loneterrace.common.entity.spec.SpecOpeningPanelInfo;
import option.loneterrace.common.entity.spec.SpecOpeningPanelSizeInfo;
import option.loneterrace.common.entity.type.TypeTerraceDepthInfo;
import option.loneterrace.common.service.parts.FrontPanelCommonService;
import option.loneterrace.common.service.parts.SidePanelCommonService;
import option.loneterrace.common.type.DirectionType;
import option.loneterrace.common.type.EnforcementDirType;
import option.loneterrace.common.type.EnforcementType;
import option.loneterrace.common.type.FloorArrangementType;
import option.loneterrace.common.type.FloorType;
import option.loneterrace.common.type.KamachiType;
import option.loneterrace.common.type.OpeningPanelDepthType;
import option.loneterrace.common.type.OpeningPanelType;
import option.loneterrace.common.type.OpeningPanelWidthType;
import option.loneterrace.common.type.PanelHeightType;
import option.loneterrace.common.type.RanmaType;
import option.loneterrace.common.type.RanmaUseType;
import option.loneterrace.common.type.SubProductType;
import option.loneterrace.common.type.TerraceDepthType;
import option.loneterrace.common.type.TerraceWidthType;
import option.loneterrace.common.type.constant.TsukuritsukeKoshikabeType;
import option.loneterrace.common.type.factory.KamachiTypeFactory;
import option.loneterrace.common.type.factory.OpeningPanelDepthTypeFactory;
import option.loneterrace.common.type.factory.OpeningPanelTypeFactory;
import option.loneterrace.common.type.factory.OpeningPanelWidthTypeFactory;
import option.loneterrace.common.type.factory.PanelHeightTypeFactory;
import option.loneterrace.common.type.factory.RanmaTypeFactory;
import option.loneterrace.common.type.factory.RanmaUseTypeFactory;
import option.loneterrace.common.type.factory.TerraceDepthTypeFactory;

public class PanelInfoCommonService {
    @GdInject
    protected FrontPanelCommonService mFrontPanelService;
    @GdInject
    protected SidePanelCommonService mSidePanelService;
    @GdInject
    private SpecOpeningPanelCacheDao mSpecOpeningPanelCacheDao;
    @GdInject
    private SpecOpeningPanelHeightCacheDao mSpecOpeningPanelHeightCacheDao;
    @GdInject
    private SpecOpeningPanelSizeCacheDao mSpecOpeningPanelSizeCacheDao;
    @GdInject
    private SpecOpeningPanelHeightSizeCacheDao mSpecOpeningPanelHeightSizeCacheDao;
    @GdInject
    protected TypeTerraceDepthCacheDao mTypeTerraceDepthCacheDao;
    private static final float RANMA_HEIGHT = 430.0f;
    private static final float RANMA_FIX_BASE_HEIGHT = 430.0f;
    private static final float RANMA_SLIDING_BASE_HEIGHT = 375.0f;
    private static final float PILLAR_WIDTH = 70.0f;

    protected PanelInfoCommonService() {
    }

    public List<PanelInfo> createFrontPanelInfos(SNYEntities sNYEntities) {
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        LinkedList<TerraceInfo> linkedList = sNYEntities.mTerraceInfoList;
        ArrayList<Tuple3<Integer, Integer, PanelInfo>> arrayList = new ArrayList<Tuple3<Integer, Integer, PanelInfo>>();
        for (TerraceInfo terraceInfo : linkedList) {
            List<Tuple3<Float, Float, FloorType>> list = this.mFrontPanelService.createFrontOpeningList(sNYEntities, terraceInfo);
            for (Tuple3<Float, Float, FloorType> tuple3 : list) {
                TerraceWidthType terraceWidthType = TerraceWidthTypeDxo.convert(((Float)tuple3.value1).floatValue(), sNYEntities.mBasicInfo.mKenType);
                if (terraceWidthType.id() > TerraceWidthType.T20.id()) {
                    terraceWidthType = TerraceWidthType.T20;
                }
                List<Tuple3<Integer, Integer, PanelInfo>> list2 = this.createPanelList(sNYEntities, terracesInfo.mDepthType, terraceWidthType, ((Float)tuple3.value2).floatValue(), (FloorType)tuple3.value3, null, true);
                this.addUnique(arrayList, list2);
            }
        }
        return this.toSortedPanelInfos(arrayList);
    }

    public List<PanelInfo> createSidePanelInfos(SNYEntities sNYEntities) {
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        DirectionType[] directionTypeArray = new DirectionType[]{DirectionType.LEFT, DirectionType.RIGHT};
        ArrayList<Tuple3<Integer, Integer, PanelInfo>> arrayList = new ArrayList<Tuple3<Integer, Integer, PanelInfo>>();
        DirectionType[] directionTypeArray2 = directionTypeArray;
        int n = directionTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            DirectionType directionType = directionTypeArray2[n2];
            List<Tuple3<Float, Float, FloorType>> list = this.mSidePanelService.createSideOpeningList(sNYEntities, directionType);
            for (Tuple3<Float, Float, FloorType> tuple3 : list) {
                int n3 = (int)Math.ceil((((Float)tuple3.value1).floatValue() + 15.0f) / 300.0f);
                TypeTerraceDepthInfo typeTerraceDepthInfo = this.mTypeTerraceDepthCacheDao.findOneStdBySpan(n3);
                TerraceDepthType terraceDepthType = (TerraceDepthType)TerraceDepthTypeFactory.getInstance().getTypeById(typeTerraceDepthInfo.typeTerraceDepthId);
                TsukuritsukeKoshikabeType tsukuritsukeKoshikabeType = this.mSidePanelService.judgeKoshikabeType(directionType, basicInfo, terracesInfo);
                List<Tuple3<Integer, Integer, PanelInfo>> list2 = this.createPanelList(sNYEntities, terraceDepthType, null, ((Float)tuple3.value2).floatValue(), (FloorType)tuple3.value3, tsukuritsukeKoshikabeType, false);
                this.addUnique(arrayList, list2);
            }
            ++n2;
        }
        return this.toSortedPanelInfos(arrayList);
    }

    protected List<Tuple3<Integer, Integer, PanelInfo>> createPanelList(SNYEntities sNYEntities, TerraceDepthType terraceDepthType, TerraceWidthType terraceWidthType, float f, FloorType floorType, TsukuritsukeKoshikabeType tsukuritsukeKoshikabeType, boolean bl) {
        BasicInfo basicInfo = sNYEntities.mBasicInfo;
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        ArrayList<Tuple3<Integer, Integer, PanelInfo>> arrayList = new ArrayList<Tuple3<Integer, Integer, PanelInfo>>();
        Collection<SpecOpeningPanelInfo> collection = this.mSpecOpeningPanelCacheDao.findManyByTypes(basicInfo, terracesInfo, terraceDepthType, terraceWidthType, tsukuritsukeKoshikabeType, bl);
        for (SpecOpeningPanelInfo specOpeningPanelInfo : collection) {
            OpeningPanelType openingPanelType = (OpeningPanelType)OpeningPanelTypeFactory.getInstance().getTypeById(specOpeningPanelInfo.openingPanelType);
            OpeningPanelDepthType openingPanelDepthType = null;
            if (specOpeningPanelInfo.openingPanelDepthType != null) {
                openingPanelDepthType = (OpeningPanelDepthType)OpeningPanelDepthTypeFactory.getInstance().getTypeById(specOpeningPanelInfo.openingPanelDepthType);
            }
            OpeningPanelWidthType openingPanelWidthType = null;
            if (specOpeningPanelInfo.openingPanelWidthType != null) {
                openingPanelWidthType = (OpeningPanelWidthType)OpeningPanelWidthTypeFactory.getInstance().getTypeById(specOpeningPanelInfo.openingPanelWidthType);
            }
            KamachiType kamachiType = null;
            if (specOpeningPanelInfo.kamachiType != null) {
                kamachiType = (KamachiType)KamachiTypeFactory.getInstance().getTypeById(specOpeningPanelInfo.kamachiType);
            }
            Collection<SpecOpeningPanelHeightInfo> collection2 = this.mSpecOpeningPanelHeightCacheDao.findManyByTypes(basicInfo, terracesInfo, openingPanelType, kamachiType, openingPanelDepthType, openingPanelWidthType, f, floorType, tsukuritsukeKoshikabeType, bl);
            for (SpecOpeningPanelHeightInfo specOpeningPanelHeightInfo : collection2) {
                TerraceDepthType terraceDepthType2 = (TerraceDepthType)TerraceDepthTypeFactory.getInstance().getTypeById(specOpeningPanelInfo.span);
                TerraceWidthType terraceWidthType2 = TerraceWidthTypeDxo.convert((float)specOpeningPanelInfo.span.intValue() * basicInfo.mKenLen.floatValue() * 0.5f, basicInfo.mKenType);
                RanmaUseType ranmaUseType = (RanmaUseType)RanmaUseTypeFactory.getInstance().getTypeById(specOpeningPanelHeightInfo.panelRanmaUseType);
                RanmaType ranmaType = null;
                if (specOpeningPanelHeightInfo.ranmaType != null) {
                    ranmaType = (RanmaType)RanmaTypeFactory.getInstance().getTypeById(specOpeningPanelHeightInfo.ranmaType);
                }
                boolean bl2 = false;
                boolean bl3 = false;
                if (bl) {
                    bl2 = specOpeningPanelInfo.span >= 6;
                    bl3 = specOpeningPanelInfo.span >= 6;
                } else {
                    bl2 = specOpeningPanelInfo.span >= 7;
                    bl3 = specOpeningPanelInfo.span >= 7;
                }
                PanelInfo panelInfo = bl ? new FrontPanelInfo() : new SidePanelInfo();
                panelInfo.mPanelType = openingPanelType;
                panelInfo.mRanmaUseType = ranmaUseType;
                panelInfo.mRanmaType = ranmaType;
                panelInfo.mKamachiType = kamachiType;
                panelInfo.mShoujiNum = specOpeningPanelInfo.shoujiNum;
                panelInfo.mSpan = specOpeningPanelInfo.span;
                panelInfo.mSpecialOpening = specOpeningPanelInfo.specialOpening != false || specOpeningPanelHeightInfo.specialOpening != false;
                panelInfo.mSpecialRanma = specOpeningPanelInfo.specialRanma != false || specOpeningPanelHeightInfo.specialRanma != false;
                panelInfo.mHasOpeningHoutate = bl2;
                panelInfo.mHasRanmaHoutate = bl3;
                this.updateWidth(panelInfo, bl, basicInfo, terraceDepthType2, terraceWidthType2, openingPanelDepthType, openingPanelWidthType);
                this.updateHeight(panelInfo, basicInfo, f, specOpeningPanelInfo.koshikabeType, specOpeningPanelHeightInfo);
                this.updateNonstandardOpening(panelInfo, bl, openingPanelWidthType, openingPanelDepthType);
                this.updateOnlyBldEdge(panelInfo, bl);
                this.updateFloor(panelInfo, floorType, tsukuritsukeKoshikabeType);
                Tuple3 tuple3 = new Tuple3((Object)specOpeningPanelInfo.specOpeningPanelId, (Object)specOpeningPanelHeightInfo.specOpeningPanelHeightId, (Object)panelInfo);
                arrayList.add((Tuple3<Integer, Integer, PanelInfo>)tuple3);
            }
        }
        return arrayList;
    }

    protected void updateWidth(PanelInfo panelInfo, boolean bl, BasicInfo basicInfo, TerraceDepthType terraceDepthType, TerraceWidthType terraceWidthType, OpeningPanelDepthType openingPanelDepthType, OpeningPanelWidthType openingPanelWidthType) {
        SpecOpeningPanelSizeInfo specOpeningPanelSizeInfo = this.mSpecOpeningPanelSizeCacheDao.findOneByTypes(panelInfo.mPanelType, openingPanelDepthType, openingPanelWidthType, basicInfo, bl);
        if (bl) {
            panelInfo.mOpeningPanelWidthType = openingPanelWidthType;
            panelInfo.mWidthType = terraceWidthType;
        } else {
            panelInfo.mOpeningPanelDepthType = openingPanelDepthType;
            panelInfo.mDepthType = terraceDepthType;
        }
        panelInfo.mBaseWidth = specOpeningPanelSizeInfo.baseWidth;
        panelInfo.mWidth = panelInfo.mDefaultWidth = specOpeningPanelSizeInfo.defaultWidth;
        panelInfo.mDefaultOpeningWidth = Float.valueOf(panelInfo.mDefaultWidth.floatValue() - 70.0f);
        panelInfo.mOpeningWidth = Float.valueOf(panelInfo.mWidth.floatValue() - 70.0f);
    }

    protected void updateHeight(PanelInfo panelInfo, BasicInfo basicInfo, float f, String string, SpecOpeningPanelHeightInfo specOpeningPanelHeightInfo) {
        PanelHeightType panelHeightType = (PanelHeightType)PanelHeightTypeFactory.getInstance().getTypeById(specOpeningPanelHeightInfo.heightType);
        SpecOpeningPanelHeightSizeInfo specOpeningPanelHeightSizeInfo = this.mSpecOpeningPanelHeightSizeCacheDao.findOneByTypes(panelHeightType, panelInfo.mPanelType, panelInfo.mKamachiType, string, basicInfo);
        panelInfo.mPanelHeightType = panelHeightType;
        panelInfo.mBaseHeight = specOpeningPanelHeightSizeInfo.baseHeight;
        panelInfo.mDefaultTotalHeight = specOpeningPanelHeightSizeInfo.defaultHeight;
        panelInfo.mDefaultHeight = specOpeningPanelHeightSizeInfo.defaultHeight;
        panelInfo.mTotalHeight = Float.valueOf(f);
        panelInfo.mHeight = Float.valueOf(f);
        if (panelInfo.mRanmaUseType == RanmaUseType.EXIST) {
            panelInfo.mBaseRanmaHeight = Float.valueOf(panelInfo.mRanmaType == RanmaType.FIX ? 430.0f : 375.0f);
            panelInfo.mRanmaHeight = Float.valueOf(430.0f);
            panelInfo.mHeight = Float.valueOf(panelInfo.mHeight.floatValue() - 430.0f);
            panelInfo.mDefaultTotalHeight = Float.valueOf(panelInfo.mDefaultTotalHeight.floatValue() + 430.0f);
        }
    }

    public String createName(PanelInfo panelInfo, String string) {
        StringBuilder stringBuilder = new StringBuilder(panelInfo.mPanelType.mName);
        if (panelInfo.mKamachiType != null && panelInfo.mKamachiType != KamachiType.AUTO) {
            stringBuilder.append(panelInfo.mKamachiType.mName);
        }
        stringBuilder.append("\n");
        stringBuilder.append(string);
        if (panelInfo.mPanelHeightType == PanelHeightType.LARGE) {
            stringBuilder.append("\n");
            stringBuilder.append(PanelHeightType.LARGE.mName);
        }
        return stringBuilder.toString();
    }

    private void updateOnlyBldEdge(PanelInfo panelInfo, boolean bl) {
        boolean bl2 = false;
        if (panelInfo.mSpan == 1 && bl && panelInfo.mPanelType == OpeningPanelType.TATESUBERI) {
            bl2 = true;
        }
        panelInfo.mOnlyBldEdge = bl2;
    }

    private void updateFloor(PanelInfo panelInfo, FloorType floorType, TsukuritsukeKoshikabeType tsukuritsukeKoshikabeType) {
        if (floorType == null) {
            if (tsukuritsukeKoshikabeType == TsukuritsukeKoshikabeType.NONE) {
                panelInfo.mFloorArrangementType = FloorArrangementType.YUKA;
            } else if (tsukuritsukeKoshikabeType == TsukuritsukeKoshikabeType.EXIST) {
                panelInfo.mFloorArrangementType = FloorArrangementType.KOSHIKABE;
            }
        } else if (floorType == FloorType.DOMA) {
            panelInfo.mFloorArrangementType = FloorArrangementType.DOMA;
        } else if (floorType == FloorType.YUKA) {
            panelInfo.mFloorArrangementType = FloorArrangementType.YUKA;
        }
    }

    private void updateNonstandardOpening(PanelInfo panelInfo, boolean bl, OpeningPanelWidthType openingPanelWidthType, OpeningPanelDepthType openingPanelDepthType) {
        boolean bl2 = false;
        bl2 = bl ? GdMutableTypeUtil.matchOR(openingPanelWidthType, OpeningPanelWidthType.THW2000, OpeningPanelWidthType.THW2300, OpeningPanelWidthType.TSW3000, OpeningPanelWidthType.TFW1946, OpeningPanelWidthType.THW3899, OpeningPanelWidthType.TSW3929) : GdMutableTypeUtil.matchOR(openingPanelDepthType, OpeningPanelDepthType.T7_CUT_9, OpeningPanelDepthType.T7_CUT_HW2000, OpeningPanelDepthType.T7_CUT_HW2300, OpeningPanelDepthType.T7_CUT_SW2614, OpeningPanelDepthType.T8_CUT_9, OpeningPanelDepthType.T8_CUT_HW2000, OpeningPanelDepthType.T8_CUT_HW2300, OpeningPanelDepthType.T8_CUT_SW2614, OpeningPanelDepthType.TDW900, OpeningPanelDepthType.TSW2614);
        panelInfo.mNonstandardOpening = bl2;
    }

    protected void addUnique(List<Tuple3<Integer, Integer, PanelInfo>> list, List<Tuple3<Integer, Integer, PanelInfo>> list2) {
        ArrayList<Tuple3<Integer, Integer, PanelInfo>> arrayList = new ArrayList<Tuple3<Integer, Integer, PanelInfo>>();
        for (Tuple3<Integer, Integer, PanelInfo> tuple3 : list2) {
            boolean bl = true;
            for (Tuple3<Integer, Integer, PanelInfo> tuple32 : list) {
                if (!((Integer)tuple3.value1).equals(tuple32.value1) || !((Integer)tuple3.value2).equals(tuple32.value2)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            arrayList.add(tuple3);
        }
        list.addAll(arrayList);
    }

    protected List<PanelInfo> toSortedPanelInfos(List<Tuple3<Integer, Integer, PanelInfo>> list) {
        Collections.sort(list, new Comparator<Tuple3<Integer, Integer, PanelInfo>>(){

            @Override
            public int compare(Tuple3<Integer, Integer, PanelInfo> tuple3, Tuple3<Integer, Integer, PanelInfo> tuple32) {
                if ((Integer)tuple3.value1 < (Integer)tuple32.value1) {
                    return -1;
                }
                if ((Integer)tuple3.value1 > (Integer)tuple32.value1) {
                    return 1;
                }
                if ((Integer)tuple3.value2 < (Integer)tuple32.value2) {
                    return -1;
                }
                if ((Integer)tuple3.value2 > (Integer)tuple32.value2) {
                    return 1;
                }
                return 0;
            }
        });
        ArrayList<PanelInfo> arrayList = new ArrayList<PanelInfo>();
        for (Tuple3<Integer, Integer, PanelInfo> tuple3 : list) {
            arrayList.add((PanelInfo)tuple3.value3);
        }
        return arrayList;
    }

    public float calcOpeningHeight(SNYEntities sNYEntities, TerraceInfo terraceInfo, FloorType floorType, TsukuritsukeKoshikabeType tsukuritsukeKoshikabeType) {
        TerracesInfo terracesInfo = sNYEntities.mTerracesInfo;
        PartsFigureInfo partsFigureInfo = sNYEntities.mPartsFigureInfo;
        FloorInfo floorInfo = sNYEntities.mFloorInfo;
        EnforcementDirType enforcementDirType = terracesInfo.mEnforcementDirType;
        SubProductType subProductType = sNYEntities.mBasicInfo.mSubProductType;
        if (subProductType == SubProductType.TSUKURITSUKE) {
            if (terracesInfo.mEnforcementType == EnforcementType.BUBUN_KAKOI) {
                if (tsukuritsukeKoshikabeType == TsukuritsukeKoshikabeType.NONE) {
                    float f = 68.0f;
                    if (enforcementDirType == EnforcementDirType.L) {
                        return terracesInfo.mOpeningHeight.floatValue() + partsFigureInfo.mBalconyHeight.floatValue() - f;
                    }
                    return terracesInfo.mOpeningHeight.floatValue() + partsFigureInfo.mBalconyHeight.floatValue() - f;
                }
                return terracesInfo.mOpeningHeight.floatValue() - 28.0f;
            }
            return terracesInfo.mHeight.floatValue() - 28.0f;
        }
        if (GdMutableTypeUtil.matchOR(subProductType, SubProductType.ALMI_BALCONY_PILLAR, SubProductType.ALMI_BALCONY_ROOF)) {
            return 1894.0f;
        }
        if (floorType == FloorType.YUKA) {
            return terracesInfo.mHeight.floatValue() - floorInfo.mFloorLevel.floatValue() + 50.0f;
        }
        return terracesInfo.mHeight.floatValue();
    }
}

