/*
 * Decompiled with CFR 0.152.
 */
package option.loneterrace.common.service.material;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import option.gad.core.inject.GdInject;
import option.gad.core.util.Tuple;
import option.gad.core.util.Tuple3;
import option.loneterrace.common.dao.cache.GlassLengthFormulaCacheDao;
import option.loneterrace.common.dao.cache.spec.SpecGlassNumCacheDao;
import option.loneterrace.common.dao.cache.type.TypeTerraceWidthCacheDao;
import option.loneterrace.common.entity.BasicInfo;
import option.loneterrace.common.entity.FloorInfo;
import option.loneterrace.common.entity.FrontPanelInfo;
import option.loneterrace.common.entity.GlassLengthFormulaInfo;
import option.loneterrace.common.entity.PanelCutInfo;
import option.loneterrace.common.entity.SidePanelInfo;
import option.loneterrace.common.entity.TerracesInfo;
import option.loneterrace.common.entity.paneloption.PanelOptionInfo;
import option.loneterrace.common.entity.spec.SpecGlassNumInfo;
import option.loneterrace.common.service.cut.PanelCutCommonService;
import option.loneterrace.common.service.parts.PanelFigureCommonService;
import option.loneterrace.common.service.parts.PanelOptionCommonService;
import option.loneterrace.common.type.GlassType;
import option.loneterrace.common.type.KamachiType;

public class GlassCommonService {
    private static final int WIDTH_TARGET = 1;
    private static final int HEIGHT_TARGET = 2;
    @GdInject
    protected GlassLengthFormulaCacheDao mGlassLengthFormulaCacheDao;
    @GdInject
    protected TypeTerraceWidthCacheDao mTypeTerraceWidthCacheDao;
    @GdInject
    protected SpecGlassNumCacheDao mSpecGlassNumCacheDao;
    @GdInject
    protected PanelCutCommonService mPanelCutCommonService;
    @GdInject
    protected PanelOptionCommonService mPanelOptionCommonService;
    @GdInject
    protected PanelFigureCommonService mPanelFigureCommonService;

    public List<Tuple<Integer, Float>> calcGlassWidth(BasicInfo basicInfo, TerracesInfo terracesInfo, FloorInfo floorInfo, LinkedList<PanelCutInfo> linkedList, PanelCutInfo panelCutInfo, KamachiType kamachiType, boolean bl, boolean bl2, boolean bl3) {
        return this.calcGlassWidth(basicInfo, terracesInfo, floorInfo, linkedList, panelCutInfo, null, kamachiType, bl, bl2, bl3);
    }

    public List<Tuple<Integer, Float>> calcGlassWidth(BasicInfo basicInfo, TerracesInfo terracesInfo, FloorInfo floorInfo, LinkedList<PanelCutInfo> linkedList, PanelCutInfo panelCutInfo, Integer n, KamachiType kamachiType, boolean bl, boolean bl2, boolean bl3) {
        ArrayList<Tuple<Integer, Float>> arrayList = new ArrayList<Tuple<Integer, Float>>();
        if (panelCutInfo == null) {
            return arrayList;
        }
        Integer n2 = this.findOpeningType(linkedList, panelCutInfo);
        Integer n3 = this.convoOeningElementType(panelCutInfo);
        Integer n4 = basicInfo.mKenType.mDbId;
        Integer n5 = this.convEnforcementType(panelCutInfo);
        Integer n6 = bl3 ? 1 : 6;
        int n7 = this.calcShoujiNum(panelCutInfo.mShoujiNum);
        Integer n8 = this.convGlassPosType(linkedList, panelCutInfo, n2, n3, bl);
        float f = this.mPanelCutCommonService.calcPanelWidth(panelCutInfo);
        float f2 = this.mPanelCutCommonService.calcPanelHeight(panelCutInfo);
        Integer n9 = this.convCalcType(n, 1, n2, n3, n8);
        Integer n10 = 1;
        Integer n11 = 64;
        Integer n12 = 128;
        float f3 = 749.0f;
        boolean bl4 = n8 != null && n8 == 2;
        Integer n13 = this.convTatesuberiCalcType(n, n9);
        if (n2 == 512 && panelCutInfo.mPanelElementType == 512 && bl4) {
            float f4 = this.calcGlassLength(basicInfo, terracesInfo, floorInfo, linkedList, panelCutInfo, n, n2, n12, 1, n4, n5, n6, n7, n8, kamachiType, Float.valueOf(f), Float.valueOf(f2), n13, bl, bl2);
            arrayList.add(this.packGlassLengthByOpeningType(n12, Float.valueOf(f4)));
            arrayList.add(this.packGlassLengthByOpeningType(n12, Float.valueOf(f4)));
        } else if (n2 == 512 && panelCutInfo.mPanelElementType == 1 && bl4) {
            float f5 = this.calcGlassLength(basicInfo, terracesInfo, floorInfo, linkedList, panelCutInfo, n, n2, n10, 1, n4, n5, n6, n7, n8, kamachiType, Float.valueOf(f), Float.valueOf(f2), n9, bl, bl2);
            arrayList.add(this.packGlassLengthByOpeningType(n10, Float.valueOf(f5)));
            if (n7 == 2) {
                arrayList.add(this.packGlassLengthByOpeningType(n10, Float.valueOf(f5)));
            }
        } else {
            if (n3 == n11 && bl4) {
                f = f3;
            }
            int n14 = 0;
            while (n14 < n7) {
                float f6 = this.calcGlassLength(basicInfo, terracesInfo, floorInfo, linkedList, panelCutInfo, n, n2, n3, 1, n4, n5, n6, n7, n8, kamachiType, Float.valueOf(f), Float.valueOf(f2), n9, bl, bl2);
                arrayList.add(this.packGlassLengthByOpeningType(n3, Float.valueOf(f6)));
                ++n14;
            }
        }
        return arrayList;
    }

    public List<Tuple<Integer, Float>> calcGlassHeight(BasicInfo basicInfo, TerracesInfo terracesInfo, FloorInfo floorInfo, LinkedList<PanelCutInfo> linkedList, PanelCutInfo panelCutInfo, KamachiType kamachiType, boolean bl, boolean bl2, boolean bl3) {
        return this.calcGlassHeight(basicInfo, terracesInfo, floorInfo, linkedList, panelCutInfo, null, kamachiType, bl, bl2, bl3);
    }

    public List<Tuple<Integer, Float>> calcGlassHeight(BasicInfo basicInfo, TerracesInfo terracesInfo, FloorInfo floorInfo, LinkedList<PanelCutInfo> linkedList, PanelCutInfo panelCutInfo, Integer n, KamachiType kamachiType, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4;
        ArrayList<Tuple<Integer, Float>> arrayList = new ArrayList<Tuple<Integer, Float>>();
        if (panelCutInfo == null) {
            return arrayList;
        }
        Integer n2 = this.findOpeningType(linkedList, panelCutInfo);
        Integer n3 = this.convoOeningElementType(panelCutInfo);
        Integer n4 = basicInfo.mKenType.mDbId;
        Integer n5 = this.convEnforcementType(panelCutInfo);
        Integer n6 = bl3 ? 1 : 6;
        int n7 = this.calcShoujiNum(panelCutInfo.mShoujiNum);
        Integer n8 = this.convGlassPosType(linkedList, panelCutInfo, n2, n3, bl);
        float f = this.mPanelCutCommonService.calcPanelWidth(panelCutInfo);
        float f2 = this.mPanelCutCommonService.calcPanelHeight(panelCutInfo);
        Integer n9 = this.convCalcType(n, 2, n2, n3, n8);
        Integer n10 = 1;
        Integer n11 = 128;
        boolean bl5 = bl4 = n8 != null && n8 == 2;
        if (n2 == 512 && panelCutInfo.mPanelElementType == 512 && bl4) {
            float f3 = this.calcGlassLength(basicInfo, terracesInfo, floorInfo, linkedList, panelCutInfo, n, n2, n11, 2, n4, n5, n6, n7, n8, kamachiType, Float.valueOf(f), Float.valueOf(f2), 1, bl, bl2);
            arrayList.add(this.packGlassLengthByOpeningType(n11, Float.valueOf(f3)));
            arrayList.add(this.packGlassLengthByOpeningType(n11, Float.valueOf(f3)));
        } else if (n2 == 512 && panelCutInfo.mPanelElementType == 1 && bl4) {
            float f4 = this.calcGlassLength(basicInfo, terracesInfo, floorInfo, linkedList, panelCutInfo, n, n2, n10, 2, n4, n5, n6, n7, n8, kamachiType, Float.valueOf(f), Float.valueOf(f2), 1, bl, bl2);
            arrayList.add(this.packGlassLengthByOpeningType(n10, Float.valueOf(f4)));
            if (n7 == 2) {
                arrayList.add(this.packGlassLengthByOpeningType(n10, Float.valueOf(f4)));
            }
        } else {
            float f5 = this.calcGlassLength(basicInfo, terracesInfo, floorInfo, linkedList, panelCutInfo, n, n2, n3, 2, n4, n5, n6, n7, n8, kamachiType, Float.valueOf(f), Float.valueOf(f2), n9, bl, bl2);
            arrayList.add(this.packGlassLengthByOpeningType(n3, Float.valueOf(f5)));
        }
        return arrayList;
    }

    private Tuple<Integer, Float> packGlassLengthByOpeningType(Integer n, Float f) {
        Tuple tuple = new Tuple();
        tuple.value1 = n;
        tuple.value2 = f;
        return tuple;
    }

    private Integer convEnforcementType(PanelCutInfo panelCutInfo) {
        Integer n = null;
        if (panelCutInfo.mOsamariType == 1) {
            n = 1;
        } else if (panelCutInfo.mOsamariType == 2 || panelCutInfo.mOsamariType == 5) {
            n = 2;
        } else if (panelCutInfo.mOsamariType == 3) {
            n = 4;
        } else if (panelCutInfo.mOsamariType == 4) {
            n = 8;
        }
        return n;
    }

    private Integer findOpeningType(LinkedList<PanelCutInfo> linkedList, PanelCutInfo panelCutInfo) {
        Integer n = null;
        int n2 = 0;
        while (n2 < linkedList.size()) {
            PanelCutInfo panelCutInfo2 = linkedList.get(n2);
            if (panelCutInfo2.mPanelElementType != 1 && panelCutInfo2.mPanelElementType != 1024 && panelCutInfo2.mPanelElementType != 2048 && panelCutInfo2.mPanelElementType != 4096 && panelCutInfo2.mPanelElementType != 8192 && panelCutInfo2.mPanelElementType != 16384) {
                n = panelCutInfo2.mPanelElementType;
                break;
            }
            ++n2;
        }
        if (n == null) {
            n = panelCutInfo.mPanelElementType;
        }
        return n;
    }

    private Integer convoOeningElementType(PanelCutInfo panelCutInfo) {
        Integer n = panelCutInfo.mPanelElementType;
        if (n == 256 || n == 512) {
            n = 128;
        }
        return n;
    }

    private Integer convGlassPosType(LinkedList<PanelCutInfo> linkedList, PanelCutInfo panelCutInfo, Integer n, Integer n2, boolean bl) {
        boolean bl2;
        Integer n3 = panelCutInfo.mHeightCutIdx;
        boolean bl3 = this.mPanelCutCommonService.hasRanma(linkedList, panelCutInfo);
        boolean bl4 = bl2 = bl || n == 1 || n == 2 || n == 32 && n2 == 1 || n == 16 && n2 == 1 || n == 64 || n == 128 || n == 256 || n == 512 || n2 == 4096;
        if (bl3) {
            if (bl2) {
                if (panelCutInfo.mHeightCutIdx == 0) {
                    n3 = 1;
                }
                if (panelCutInfo.mHeightCutIdx == 1) {
                    n3 = 2;
                }
                if (panelCutInfo.mHeightCutIdx == 2) {
                    n3 = 4;
                }
            } else {
                n3 = 1;
            }
        } else if (bl2) {
            if (panelCutInfo.mHeightCutIdx == 0) {
                n3 = 2;
            }
            if (panelCutInfo.mHeightCutIdx == 1) {
                n3 = 4;
            }
        } else {
            n3 = 1;
        }
        return n3;
    }

    private int convCalcType(Integer n, Integer n2, Integer n3, Integer n4, Integer n5) {
        int n6 = 1;
        if (n == null || n == 1) {
            boolean bl;
            boolean bl2 = bl = n4 == 4 || n4 == 8 || n4 == 32;
            if (bl && n5 != null && n5 == 4 && n2 == 2) {
                n6 = 2;
            }
            if ((n3 == 64 && n4 == 64 && n2 == 2 || (n4 == 128 || n4 == 256 || n4 == 512) && n2 == 1) && n5 == 2) {
                n6 = 2;
            }
        } else if (n3 == 1024 && n2 == 2) {
            n6 = 2;
        }
        return n6;
    }

    private Integer convTatesuberiCalcType(Integer n, Integer n2) {
        Integer n3 = n2;
        if (n == null || n == 1) {
            n3 = 2;
        }
        return n3;
    }

    private int calcShoujiNum(Integer n) {
        int n2 = 1;
        if (n != null && n != 0) {
            n2 = n;
        }
        return n2;
    }

    public float calcGlassLength(BasicInfo basicInfo, TerracesInfo terracesInfo, FloorInfo floorInfo, LinkedList<PanelCutInfo> linkedList, PanelCutInfo panelCutInfo, Integer n, Integer n2, Integer n3, Integer n4, Integer n5, Integer n6, Integer n7, Integer n8, KamachiType kamachiType, Float f, Float f2, Integer n9, boolean bl, boolean bl2) {
        return this.calcGlassLength(basicInfo, terracesInfo, floorInfo, linkedList, panelCutInfo, null, n, n2, n3, n4, n5, n6, n7, n8, kamachiType, f, f2, n9, bl, bl2);
    }

    public float calcGlassLength(BasicInfo basicInfo, TerracesInfo terracesInfo, FloorInfo floorInfo, LinkedList<PanelCutInfo> linkedList, PanelCutInfo panelCutInfo, Integer n, Integer n2, Integer n3, Integer n4, Integer n5, Integer n6, Integer n7, Integer n8, Integer n9, KamachiType kamachiType, Float f, Float f2, Integer n10, boolean bl, boolean bl2) {
        GlassLengthFormulaInfo glassLengthFormulaInfo = null;
        float f3 = f2.floatValue();
        boolean bl3 = n6 != null && n6 == 4;
        boolean bl4 = n6 != null && n6 == 2;
        boolean bl5 = this.mPanelCutCommonService.hasRanma(linkedList, panelCutInfo);
        if (n3 == 4) {
            f3 = this.mPanelFigureCommonService.calcSH(basicInfo, terracesInfo, floorInfo, null, bl3, bl4, bl5, false);
            if (n9 == 2) {
                f2 = Float.valueOf(f3);
            }
        } else if (n3 == 8) {
            f3 = this.mPanelFigureCommonService.calcMH(basicInfo, terracesInfo, floorInfo, null, bl3, bl4, bl5, false);
            if (n9 == 2) {
                f2 = Float.valueOf(f3);
            }
        } else if (n3 == 32) {
            f3 = this.mPanelFigureCommonService.calcDH(basicInfo, terracesInfo, floorInfo, null, bl3, bl4, bl5, false);
            if (n9 == 2) {
                f2 = Float.valueOf(f3);
            }
        }
        if ((n == null || n == 1) && n3 == 8 && n8 == 2 && kamachiType != null && kamachiType == KamachiType.THICK && f3 >= 2200.0f) {
            kamachiType = KamachiType.H24;
        }
        if (n10 == 1) {
            glassLengthFormulaInfo = this.mGlassLengthFormulaCacheDao.findOneForCoefficient(n, n2, n3, n4, n5, n6, n7, n8, n9, kamachiType, f, Float.valueOf(f3));
        } else if (n10 == 2) {
            glassLengthFormulaInfo = this.mGlassLengthFormulaCacheDao.findOneForConstant(n, n2, n3, n4, n5, n6, n7, n8, n9, kamachiType, f, Float.valueOf(f3));
        }
        float f4 = 0.0f;
        if (n4 == 1) {
            f4 = this.calcGlassLength(n, n2, n3, glassLengthFormulaInfo, f.floatValue(), n10, bl2);
        } else if (n4 == 2) {
            f4 = this.calcGlassLength(n, n2, n3, glassLengthFormulaInfo, f2.floatValue(), n10, bl2);
        }
        return f4;
    }

    private float calcGlassLength(Integer n, Integer n2, Integer n3, GlassLengthFormulaInfo glassLengthFormulaInfo, float f, Integer n4, boolean bl) {
        if (!(n3 != 16 && (n3 != 64 || bl) && n3 != 16384 || n != null && n != 1)) {
            return 0.0f;
        }
        if (glassLengthFormulaInfo == null) {
            return f;
        }
        float f2 = 0.0f;
        int n5 = 1;
        float f3 = 0.0f;
        float f4 = 0.0f;
        if (glassLengthFormulaInfo.divisionNum != null) {
            n5 = glassLengthFormulaInfo.divisionNum;
        }
        if (glassLengthFormulaInfo.coefficient != null) {
            f3 = glassLengthFormulaInfo.coefficient.floatValue();
        }
        if (glassLengthFormulaInfo.constant != null) {
            f4 = glassLengthFormulaInfo.constant.floatValue();
        }
        if (n4 == 1) {
            if (glassLengthFormulaInfo.divisionRange == null) {
                f2 = f + f3;
            } else if (glassLengthFormulaInfo.divisionRange == 1) {
                f2 = f / (float)n5 + f3;
            } else if (glassLengthFormulaInfo.divisionRange == 2) {
                f2 = (f + f3) / (float)n5;
            }
        } else if (n4 == 2) {
            f2 = f4;
        }
        return (float)Math.floor(f2);
    }

    public List<Tuple3<Integer, Float, Float>> packGlassWidthAndHeightByOpeningType(BasicInfo basicInfo, TerracesInfo terracesInfo, FloorInfo floorInfo, LinkedList<PanelCutInfo> linkedList, PanelCutInfo panelCutInfo, KamachiType kamachiType, boolean bl, boolean bl2) {
        return this.packGlassWidthAndHeightByOpeningType(basicInfo, terracesInfo, floorInfo, linkedList, panelCutInfo, null, kamachiType, bl, bl2);
    }

    public List<Tuple3<Integer, Float, Float>> packGlassWidthAndHeightByOpeningType(BasicInfo basicInfo, TerracesInfo terracesInfo, FloorInfo floorInfo, LinkedList<PanelCutInfo> linkedList, PanelCutInfo panelCutInfo, Integer n, KamachiType kamachiType, boolean bl, boolean bl2) {
        ArrayList<Tuple3<Integer, Float, Float>> arrayList = new ArrayList<Tuple3<Integer, Float, Float>>();
        List<Tuple<Integer, Float>> list = this.calcGlassWidth(basicInfo, terracesInfo, floorInfo, linkedList, panelCutInfo, n, kamachiType, bl, true, bl2);
        List<Tuple<Integer, Float>> list2 = this.calcGlassHeight(basicInfo, terracesInfo, floorInfo, linkedList, panelCutInfo, n, kamachiType, bl, true, bl2);
        ArrayList<Float> arrayList2 = new ArrayList<Float>();
        for (Tuple<Integer, Float> tuple : list2) {
            arrayList2.add((Float)tuple.value2);
        }
        int n2 = arrayList2.size();
        int n3 = 0;
        while (n3 < list.size()) {
            Tuple<Integer, Float> tuple = list.get(n3);
            Tuple3 tuple3 = new Tuple3();
            tuple3.value1 = (Integer)tuple.value1;
            tuple3.value2 = (Float)tuple.value2;
            tuple3.value3 = n2 > n3 ? (Float)arrayList2.get(n3) : (Float)arrayList2.get(0);
            arrayList.add((Tuple3<Integer, Float, Float>)tuple3);
            ++n3;
        }
        return arrayList;
    }

    public List<Tuple<Float, Float>> findManyGlassWidthAndHeightByOpeningType(BasicInfo basicInfo, TerracesInfo terracesInfo, FloorInfo floorInfo, LinkedList<PanelCutInfo> linkedList, PanelCutInfo panelCutInfo, Integer n, KamachiType kamachiType, boolean bl, boolean bl2) {
        return this.findManyGlassWidthAndHeightByOpeningType(basicInfo, terracesInfo, floorInfo, linkedList, panelCutInfo, null, n, kamachiType, bl, bl2);
    }

    public List<Tuple<Float, Float>> findManyGlassWidthAndHeightByOpeningType(BasicInfo basicInfo, TerracesInfo terracesInfo, FloorInfo floorInfo, LinkedList<PanelCutInfo> linkedList, PanelCutInfo panelCutInfo, Integer n, Integer n2, KamachiType kamachiType, boolean bl, boolean bl2) {
        ArrayList<Tuple<Float, Float>> arrayList = new ArrayList<Tuple<Float, Float>>();
        if (panelCutInfo == null) {
            return arrayList;
        }
        Tuple tuple = new Tuple();
        List<Tuple3<Integer, Float, Float>> list = this.packGlassWidthAndHeightByOpeningType(basicInfo, terracesInfo, floorInfo, linkedList, panelCutInfo, n, kamachiType, bl, bl2);
        for (Tuple3<Integer, Float, Float> tuple3 : list) {
            if (!n2.equals(tuple3.value1)) continue;
            tuple.value1 = (Float)tuple3.value2;
            tuple.value2 = (Float)tuple3.value3;
            arrayList.add((Tuple<Float, Float>)tuple);
        }
        return arrayList;
    }

    public Tuple<Float, Float> calcGurechanAndBeadLength(BasicInfo basicInfo, TerracesInfo terracesInfo, FloorInfo floorInfo, LinkedList<PanelCutInfo> linkedList, PanelCutInfo panelCutInfo, KamachiType kamachiType, boolean bl, boolean bl2) {
        Tuple tuple = new Tuple();
        tuple.value1 = Float.valueOf(0.0f);
        tuple.value2 = Float.valueOf(0.0f);
        List<Tuple<Integer, Float>> list = this.calcGlassWidth(basicInfo, terracesInfo, floorInfo, linkedList, panelCutInfo, kamachiType, bl, false, bl2);
        List<Tuple<Integer, Float>> list2 = this.calcGlassHeight(basicInfo, terracesInfo, floorInfo, linkedList, panelCutInfo, kamachiType, bl, false, bl2);
        ArrayList<Float> arrayList = new ArrayList<Float>();
        for (Tuple<Integer, Float> tuple2 : list2) {
            arrayList.add((Float)tuple2.value2);
        }
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < list.size()) {
            Tuple<Integer, Float> tuple3 = list.get(n2);
            float f = 0.0f;
            f = n > n2 ? ((Float)arrayList.get(n2)).floatValue() : ((Float)arrayList.get(0)).floatValue();
            if (this.judgeBead(linkedList, panelCutInfo, (Integer)tuple3.value1)) {
                tuple.value1 = Float.valueOf(((Float)tuple.value1).floatValue() + this.calcGurechanLength(((Float)tuple3.value2).floatValue(), f));
            } else if (!panelCutInfo.mGlassBuiltin.booleanValue()) {
                tuple.value2 = Float.valueOf(((Float)tuple.value2).floatValue() + this.calcGurechanLength(((Float)tuple3.value2).floatValue(), f));
            }
            ++n2;
        }
        return tuple;
    }

    public float calcGurechanLength(float f, float f2) {
        float f3 = 0.0f;
        if (f != 0.0f && f2 != 0.0f) {
            f3 = (f + f2) * 2.0f + 300.0f;
        }
        return f3;
    }

    private boolean judgeBead(LinkedList<PanelCutInfo> linkedList, PanelCutInfo panelCutInfo, Integer n) {
        return n == 1 || n == 1024 || n == 4096 || n == 8192;
    }

    public List<Tuple3<GlassType, Float, Float>> calcGurechanTotalLength(BasicInfo basicInfo, TerracesInfo terracesInfo, FloorInfo floorInfo, LinkedList<FrontPanelInfo> linkedList, LinkedList<SidePanelInfo> linkedList2, LinkedList<SidePanelInfo> linkedList3, LinkedList<PanelCutInfo> linkedList4, LinkedList<PanelCutInfo> linkedList5, LinkedList<PanelCutInfo> linkedList6, LinkedList<PanelOptionInfo> linkedList7, LinkedList<PanelOptionInfo> linkedList8, LinkedList<PanelOptionInfo> linkedList9) {
        boolean bl;
        Object object;
        LinkedList<Tuple3<GlassType, Float, Float>> linkedList10 = new LinkedList<Tuple3<GlassType, Float, Float>>();
        for (FrontPanelInfo serializable2 : linkedList) {
            object = this.mPanelCutCommonService.findManyPanelCutInfoByIndex(linkedList4, serializable2.mTerraceId, serializable2.mIndex);
            bl = this.mPanelOptionCommonService.hasNakazan(linkedList7, serializable2.mTerraceId, serializable2.mIndex);
            linkedList10.addAll(this.calcGurechanTotalLength(basicInfo, terracesInfo, floorInfo, (LinkedList<PanelCutInfo>)object, serializable2.mKamachiType, bl, true));
        }
        for (SidePanelInfo sidePanelInfo : linkedList2) {
            object = this.mPanelCutCommonService.findManyPanelCutInfoByIndex(linkedList5, sidePanelInfo.mTerraceId, sidePanelInfo.mIndex);
            bl = this.mPanelOptionCommonService.hasNakazan(linkedList8, sidePanelInfo.mTerraceId, sidePanelInfo.mIndex);
            linkedList10.addAll(this.calcGurechanTotalLength(basicInfo, terracesInfo, floorInfo, (LinkedList<PanelCutInfo>)object, sidePanelInfo.mKamachiType, bl, false));
        }
        for (SidePanelInfo sidePanelInfo : linkedList3) {
            object = this.mPanelCutCommonService.findManyPanelCutInfoByIndex(linkedList6, sidePanelInfo.mTerraceId, sidePanelInfo.mIndex);
            bl = this.mPanelOptionCommonService.hasNakazan(linkedList9, sidePanelInfo.mTerraceId, sidePanelInfo.mIndex);
            linkedList10.addAll(this.calcGurechanTotalLength(basicInfo, terracesInfo, floorInfo, (LinkedList<PanelCutInfo>)object, sidePanelInfo.mKamachiType, bl, false));
        }
        LinkedList<Tuple3<GlassType, Float, Float>> linkedList11 = new LinkedList<Tuple3<GlassType, Float, Float>>();
        Tuple tuple = new Tuple();
        object = new Tuple();
        Tuple tuple2 = new Tuple();
        Tuple tuple3 = new Tuple();
        Tuple tuple4 = new Tuple();
        tuple.value1 = Float.valueOf(0.0f);
        tuple.value2 = Float.valueOf(0.0f);
        object.value1 = Float.valueOf(0.0f);
        object.value2 = Float.valueOf(0.0f);
        tuple2.value1 = Float.valueOf(0.0f);
        tuple2.value2 = Float.valueOf(0.0f);
        tuple3.value1 = Float.valueOf(0.0f);
        tuple3.value2 = Float.valueOf(0.0f);
        tuple4.value1 = Float.valueOf(0.0f);
        tuple4.value2 = Float.valueOf(0.0f);
        for (Tuple3 tuple32 : linkedList10) {
            GlassType glassType = (GlassType)tuple32.value1;
            float f = ((Float)tuple32.value2).floatValue();
            float f2 = ((Float)tuple32.value3).floatValue();
            if (glassType == GlassType.FL3) {
                tuple.value1 = Float.valueOf(((Float)tuple.value1).floatValue() + f);
                tuple.value2 = Float.valueOf(((Float)tuple.value2).floatValue() + f2);
                continue;
            }
            if (glassType == GlassType.F4) {
                object.value1 = Float.valueOf(((Float)object.value1).floatValue() + f);
                object.value2 = Float.valueOf(((Float)object.value2).floatValue() + f2);
                continue;
            }
            if (glassType == GlassType.FL5) {
                tuple2.value1 = Float.valueOf(((Float)tuple2.value1).floatValue() + f);
                tuple2.value2 = Float.valueOf(((Float)tuple2.value2).floatValue() + f2);
                continue;
            }
            if (glassType == GlassType.FL6) {
                tuple3.value1 = Float.valueOf(((Float)tuple3.value1).floatValue() + f);
                tuple3.value2 = Float.valueOf(((Float)tuple3.value2).floatValue() + f2);
                continue;
            }
            if (glassType != GlassType.PHW) continue;
            tuple4.value1 = Float.valueOf(((Float)tuple4.value1).floatValue() + f);
            tuple4.value2 = Float.valueOf(((Float)tuple4.value2).floatValue() + f2);
        }
        linkedList11.add(this.packGurechanLengthByGlassType(GlassType.FL3, (Float)tuple.value1, (Float)tuple.value2));
        linkedList11.add(this.packGurechanLengthByGlassType(GlassType.F4, (Float)object.value1, (Float)object.value2));
        linkedList11.add(this.packGurechanLengthByGlassType(GlassType.FL5, (Float)tuple2.value1, (Float)tuple2.value2));
        linkedList11.add(this.packGurechanLengthByGlassType(GlassType.FL6, (Float)tuple3.value1, (Float)tuple3.value2));
        linkedList11.add(this.packGurechanLengthByGlassType(GlassType.PHW, (Float)tuple4.value1, (Float)tuple4.value2));
        return linkedList11;
    }

    public List<Tuple3<GlassType, Float, Float>> calcGurechanTotalLength(BasicInfo basicInfo, TerracesInfo terracesInfo, FloorInfo floorInfo, LinkedList<PanelCutInfo> linkedList, KamachiType kamachiType, boolean bl, boolean bl2) {
        ArrayList<Tuple3<GlassType, Float, Float>> arrayList = new ArrayList<Tuple3<GlassType, Float, Float>>();
        Tuple tuple = new Tuple();
        Tuple tuple2 = new Tuple();
        Tuple tuple3 = new Tuple();
        Tuple tuple4 = new Tuple();
        Tuple tuple5 = new Tuple();
        tuple.value1 = Float.valueOf(0.0f);
        tuple.value2 = Float.valueOf(0.0f);
        tuple2.value1 = Float.valueOf(0.0f);
        tuple2.value2 = Float.valueOf(0.0f);
        tuple3.value1 = Float.valueOf(0.0f);
        tuple3.value2 = Float.valueOf(0.0f);
        tuple4.value1 = Float.valueOf(0.0f);
        tuple4.value2 = Float.valueOf(0.0f);
        tuple5.value1 = Float.valueOf(0.0f);
        tuple5.value2 = Float.valueOf(0.0f);
        for (PanelCutInfo panelCutInfo : linkedList) {
            float f;
            Tuple<Float, Float> tuple6 = this.calcGurechanAndBeadLength(basicInfo, terracesInfo, floorInfo, linkedList, panelCutInfo, kamachiType, bl, bl2);
            float f2 = tuple6.value1 != null ? ((Float)tuple6.value1).floatValue() : 0.0f;
            float f3 = f = tuple6.value2 != null ? ((Float)tuple6.value2).floatValue() : 0.0f;
            if (this.isSpecialOpeningType(linkedList, panelCutInfo)) {
                PanelCutInfo panelCutInfo2 = this.mPanelCutCommonService.findOneLowerPanelCutInfoByIndex(linkedList, panelCutInfo.mTerraceId, panelCutInfo.mPanelId);
                if (panelCutInfo2.mGlassType == GlassType.FL3) {
                    tuple.value1 = Float.valueOf(((Float)tuple.value1).floatValue() + f2);
                } else if (panelCutInfo2.mGlassType == GlassType.F4) {
                    tuple2.value1 = Float.valueOf(((Float)tuple2.value1).floatValue() + f2);
                } else if (panelCutInfo2.mGlassType == GlassType.FL5) {
                    tuple3.value1 = Float.valueOf(((Float)tuple3.value1).floatValue() + f2);
                } else if (panelCutInfo2.mGlassType == GlassType.FL6) {
                    tuple4.value1 = Float.valueOf(((Float)tuple4.value1).floatValue() + f2);
                } else if (panelCutInfo2.mGlassType == GlassType.PHW) {
                    tuple5.value1 = Float.valueOf(((Float)tuple5.value1).floatValue() + f2);
                }
                if (panelCutInfo.mGlassType == GlassType.FL3) {
                    tuple.value2 = Float.valueOf(((Float)tuple.value2).floatValue() + f);
                    continue;
                }
                if (panelCutInfo.mGlassType == GlassType.F4) {
                    tuple2.value2 = Float.valueOf(((Float)tuple2.value2).floatValue() + f);
                    continue;
                }
                if (panelCutInfo.mGlassType == GlassType.FL5) {
                    tuple3.value2 = Float.valueOf(((Float)tuple3.value2).floatValue() + f);
                    continue;
                }
                if (panelCutInfo.mGlassType == GlassType.FL6) {
                    tuple4.value2 = Float.valueOf(((Float)tuple4.value2).floatValue() + f);
                    continue;
                }
                if (panelCutInfo.mGlassType != GlassType.PHW) continue;
                tuple5.value2 = Float.valueOf(((Float)tuple5.value2).floatValue() + f);
                continue;
            }
            if (panelCutInfo.mGlassType == GlassType.FL3) {
                tuple.value1 = Float.valueOf(((Float)tuple.value1).floatValue() + f2);
                tuple.value2 = Float.valueOf(((Float)tuple.value2).floatValue() + f);
                continue;
            }
            if (panelCutInfo.mGlassType == GlassType.F4) {
                tuple2.value1 = Float.valueOf(((Float)tuple2.value1).floatValue() + f2);
                tuple2.value2 = Float.valueOf(((Float)tuple2.value2).floatValue() + f);
                continue;
            }
            if (panelCutInfo.mGlassType == GlassType.FL5) {
                tuple3.value1 = Float.valueOf(((Float)tuple3.value1).floatValue() + f2);
                tuple3.value2 = Float.valueOf(((Float)tuple3.value2).floatValue() + f);
                continue;
            }
            if (panelCutInfo.mGlassType == GlassType.FL6) {
                tuple4.value1 = Float.valueOf(((Float)tuple4.value1).floatValue() + f2);
                tuple4.value2 = Float.valueOf(((Float)tuple4.value2).floatValue() + f);
                continue;
            }
            if (panelCutInfo.mGlassType != GlassType.PHW) continue;
            tuple5.value1 = Float.valueOf(((Float)tuple5.value1).floatValue() + f2);
            tuple5.value2 = Float.valueOf(((Float)tuple5.value2).floatValue() + f);
        }
        arrayList.add(this.packGurechanLengthByGlassType(GlassType.FL3, (Float)tuple.value1, (Float)tuple.value2));
        arrayList.add(this.packGurechanLengthByGlassType(GlassType.F4, (Float)tuple2.value1, (Float)tuple2.value2));
        arrayList.add(this.packGurechanLengthByGlassType(GlassType.FL5, (Float)tuple3.value1, (Float)tuple3.value2));
        arrayList.add(this.packGurechanLengthByGlassType(GlassType.FL6, (Float)tuple4.value1, (Float)tuple4.value2));
        arrayList.add(this.packGurechanLengthByGlassType(GlassType.PHW, (Float)tuple5.value1, (Float)tuple5.value2));
        return arrayList;
    }

    public List<Tuple3<GlassType, Float, Float>> calcGurechanTotalLengthForHanedashi(BasicInfo basicInfo, TerracesInfo terracesInfo, FloorInfo floorInfo, LinkedList<PanelCutInfo> linkedList, LinkedList<PanelCutInfo> linkedList2, LinkedList<PanelCutInfo> linkedList3) {
        LinkedList<Tuple3<GlassType, Float, Float>> linkedList4 = new LinkedList<Tuple3<GlassType, Float, Float>>();
        LinkedList<PanelCutInfo> linkedList5 = new LinkedList<PanelCutInfo>();
        linkedList5.addAll(linkedList);
        linkedList5.addAll(linkedList2);
        linkedList5.addAll(linkedList3);
        LinkedList<PanelCutInfo> linkedList6 = this.mPanelCutCommonService.createPanelCutInfoListByHanedashi(linkedList5);
        linkedList4.addAll(this.calcGurechanTotalLengthForHanedashi(basicInfo, terracesInfo, floorInfo, linkedList6));
        LinkedList<Tuple3<GlassType, Float, Float>> linkedList7 = new LinkedList<Tuple3<GlassType, Float, Float>>();
        Tuple tuple = new Tuple();
        tuple.value1 = Float.valueOf(0.0f);
        tuple.value2 = Float.valueOf(0.0f);
        for (Tuple3 tuple3 : linkedList4) {
            float f = ((Float)tuple3.value2).floatValue();
            float f2 = ((Float)tuple3.value3).floatValue();
            tuple.value1 = Float.valueOf(((Float)tuple.value1).floatValue() + f);
            tuple.value2 = Float.valueOf(((Float)tuple.value2).floatValue() + f2);
        }
        linkedList7.add(this.packGurechanLengthByGlassType(GlassType.NONE, (Float)tuple.value1, (Float)tuple.value2));
        return linkedList7;
    }

    public List<Tuple3<GlassType, Float, Float>> calcGurechanTotalLengthForHanedashi(BasicInfo basicInfo, TerracesInfo terracesInfo, FloorInfo floorInfo, LinkedList<PanelCutInfo> linkedList) {
        ArrayList<Tuple3<GlassType, Float, Float>> arrayList = new ArrayList<Tuple3<GlassType, Float, Float>>();
        Tuple tuple = new Tuple();
        tuple.value1 = Float.valueOf(0.0f);
        tuple.value2 = Float.valueOf(0.0f);
        for (PanelCutInfo panelCutInfo : linkedList) {
            Tuple<Float, Float> tuple2 = this.calcGurechanAndBeadLength(basicInfo, terracesInfo, floorInfo, linkedList, panelCutInfo, null, false, false);
            float f = tuple2.value1 != null ? ((Float)tuple2.value1).floatValue() : 0.0f;
            float f2 = tuple2.value2 != null ? ((Float)tuple2.value2).floatValue() : 0.0f;
            tuple.value1 = Float.valueOf(((Float)tuple.value1).floatValue() + f);
            tuple.value2 = Float.valueOf(((Float)tuple.value2).floatValue() + f2);
        }
        arrayList.add(this.packGurechanLengthByGlassType(GlassType.NONE, (Float)tuple.value1, (Float)tuple.value2));
        return arrayList;
    }

    private boolean isSpecialOpeningType(LinkedList<PanelCutInfo> linkedList, PanelCutInfo panelCutInfo) {
        boolean bl = false;
        int n = this.findOpeningType(linkedList, panelCutInfo);
        if ((n == 64 || n == 256 || n == 512) && panelCutInfo.mPanelElementType != 1) {
            bl = true;
        }
        return bl;
    }

    private Tuple3<GlassType, Float, Float> packGurechanLengthByGlassType(GlassType glassType, Float f, Float f2) {
        Tuple3 tuple3 = new Tuple3();
        tuple3.value1 = glassType;
        tuple3.value2 = f;
        tuple3.value3 = f2;
        return tuple3;
    }

    protected int countGlassQuantity(Integer n, float f) {
        if (n == 64) {
            SpecGlassNumInfo specGlassNumInfo = this.mSpecGlassNumCacheDao.findOneByheight(f);
            return specGlassNumInfo.glassNum;
        }
        return 1;
    }
}

