/*
 * Decompiled with CFR 0.152.
 */
package option.loneterrace.common.service.cut;

import com.kt.util.RefList;
import com.kt.util.StringUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import nethome.geom.primitive.GPoint2Df;
import option.gad.core.inject.GdInject;
import option.gad.core.util.ObjectUtil;
import option.loneterrace.common.dao.cache.GlassCandidateCacheDao;
import option.loneterrace.common.dao.cache.PanelElementCacheDao;
import option.loneterrace.common.dao.cache.type.TypeTerraceDepthCacheDao;
import option.loneterrace.common.dao.cache.type.TypeTerraceWidthCacheDao;
import option.loneterrace.common.entity.BasicInfo;
import option.loneterrace.common.entity.FrontPanelInfo;
import option.loneterrace.common.entity.GlassCandidateInfo;
import option.loneterrace.common.entity.PanelCutInfo;
import option.loneterrace.common.entity.PanelElementInfo;
import option.loneterrace.common.entity.PanelInfo;
import option.loneterrace.common.entity.PartsFigureInfo;
import option.loneterrace.common.entity.SNYEntities;
import option.loneterrace.common.entity.SidePanelInfo;
import option.loneterrace.common.entity.TerraceInfo;
import option.loneterrace.common.entity.TerracesInfo;
import option.loneterrace.common.entity.paneloption.PanelOptionInfo;
import option.loneterrace.common.service.common.DocumentCommonService;
import option.loneterrace.common.service.parts.FrontPanelCommonService;
import option.loneterrace.common.service.parts.SidePanelCommonService;
import option.loneterrace.common.service.parts.TerraceCommonService;
import option.loneterrace.common.type.DirectionType;
import option.loneterrace.common.type.EnforcementDirType;
import option.loneterrace.common.type.EnforcementType;
import option.loneterrace.common.type.FloorArrangementType;
import option.loneterrace.common.type.KenType;
import option.loneterrace.common.type.OpeningPanelType;
import option.loneterrace.common.type.PanelDirectionType;
import option.loneterrace.common.type.PanelHeightType;
import option.loneterrace.common.type.ProductSeriesType;
import option.loneterrace.common.type.RanmaType;
import option.loneterrace.common.type.RanmaUseType;
import option.loneterrace.common.type.SashGlassBuiltinType;
import option.loneterrace.common.type.SubProductType;
import option.loneterrace.common.type.TileUsedType;
import option.loneterrace.common.type.constant.CutPlaceType;
import option.loneterrace.common.type.constant.HeightArrangementType;
import option.loneterrace.common.type.paneloption.PanelOptionType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PanelCutCommonService {
    @GdInject
    private TypeTerraceDepthCacheDao mTypeTerraceDepthCacheDao;
    @GdInject
    private PanelElementCacheDao mPanelElementCacheDao;
    @GdInject
    private DocumentCommonService mDocumentService;
    @GdInject
    protected TypeTerraceWidthCacheDao mTypeTerraceWidthCacheDao;
    @GdInject
    private GlassCandidateCacheDao mGlassCandidateCacheDao;
    @GdInject
    private FrontPanelCommonService mFrontPanelCommonService;
    @GdInject
    private SidePanelCommonService mSidePanelCommonService;
    @GdInject
    private TerraceCommonService mTerraceCommonService;
    private Log mLog = LogFactory.getLog(PanelCutCommonService.class);
    protected static HashMap<String, List<RefList<GPoint2Df>>> mProductLimitMap;
    protected static String errorMessage;
    protected static final String FIXED_SIZE = "fixed";

    public PanelCutCommonService() {
        if (mProductLimitMap == null) {
            mProductLimitMap = new HashMap();
        }
    }

    public LinkedList<PanelCutInfo> getPanelCutInfoList(SNYEntities sNYEntities, PanelDirectionType panelDirectionType) {
        LinkedList<PanelCutInfo> linkedList = null;
        linkedList = panelDirectionType == PanelDirectionType.LEFT ? sNYEntities.mLeftPanelCutInfoList : (panelDirectionType == PanelDirectionType.RIGHT ? sNYEntities.mRightPanelCutInfoList : sNYEntities.mFrontPanelCutInfoList);
        return linkedList;
    }

    public void updateFrontPanelCutInfo(SNYEntities sNYEntities, FrontPanelInfo frontPanelInfo) {
        LinkedList<PanelCutInfo> linkedList = sNYEntities.mFrontPanelCutInfoList;
        this.rempvePanelCutInfo(linkedList, frontPanelInfo.mTerraceId, frontPanelInfo.mIndex);
        LinkedList<PanelCutInfo> linkedList2 = new LinkedList<PanelCutInfo>();
        PanelSpec panelSpec = new PanelSpec(frontPanelInfo, sNYEntities.mFrontPanelOptionInfoList);
        this.getFrontWidthCutInfo(sNYEntities, frontPanelInfo, panelSpec, linkedList2);
        this.setDefault(sNYEntities, linkedList2);
        linkedList.addAll(linkedList2);
    }

    public void updateFrontPanelCutInfo(SNYEntities sNYEntities, HashSet<PanelInfo> hashSet) {
        if (hashSet == null) {
            return;
        }
        for (PanelInfo panelInfo : hashSet) {
            this.updateFrontPanelCutInfo(sNYEntities, (FrontPanelInfo)panelInfo);
        }
    }

    public void removeFrontPanelCutInfo(SNYEntities sNYEntities, List<FrontPanelInfo> list) {
        for (FrontPanelInfo frontPanelInfo : list) {
            this.removeFrontPanelCutInfo(sNYEntities, frontPanelInfo);
        }
    }

    public void removeFrontPanelCutInfo(SNYEntities sNYEntities, FrontPanelInfo frontPanelInfo) {
        int n = sNYEntities.mFrontPanelCutInfoList.size() - 1;
        while (n >= 0) {
            PanelCutInfo panelCutInfo = sNYEntities.mFrontPanelCutInfoList.get(n);
            if (panelCutInfo.mTerraceId.equals(frontPanelInfo.mTerraceId) && panelCutInfo.mPanelId.equals(frontPanelInfo.mIndex)) {
                sNYEntities.mFrontPanelCutInfoList.remove(n);
            }
            --n;
        }
    }

    public void updateSidePanelCutInfo(SNYEntities sNYEntities, SidePanelInfo sidePanelInfo, PanelDirectionType panelDirectionType) {
        LinkedList<PanelCutInfo> linkedList = panelDirectionType == PanelDirectionType.LEFT ? sNYEntities.mLeftPanelCutInfoList : sNYEntities.mRightPanelCutInfoList;
        LinkedList<PanelOptionInfo> linkedList2 = panelDirectionType == PanelDirectionType.LEFT ? sNYEntities.mLeftPanelOptionInfoList : sNYEntities.mRightPanelOptionInfoList;
        this.rempvePanelCutInfo(linkedList, sidePanelInfo.mTerraceId, sidePanelInfo.mIndex);
        LinkedList<PanelCutInfo> linkedList3 = new LinkedList<PanelCutInfo>();
        PanelSpec panelSpec = new PanelSpec(sidePanelInfo, linkedList2);
        this.getSideWidthCutInfo(sNYEntities, sidePanelInfo, panelSpec, panelDirectionType, linkedList3);
        this.setDefault(sNYEntities, linkedList3);
        linkedList.addAll(linkedList3);
    }

    public void updateSidePanelCutInfo(SNYEntities sNYEntities, HashSet<PanelInfo> hashSet, PanelDirectionType panelDirectionType) {
        if (hashSet == null) {
            return;
        }
        for (PanelInfo panelInfo : hashSet) {
            this.updateSidePanelCutInfo(sNYEntities, (SidePanelInfo)panelInfo, panelDirectionType);
        }
    }

    public void removeSidePanelCutInfo(SNYEntities sNYEntities, List<SidePanelInfo> list, PanelDirectionType panelDirectionType) {
        for (SidePanelInfo sidePanelInfo : list) {
            this.removeSidePanelCutInfo(sNYEntities, sidePanelInfo, panelDirectionType);
        }
    }

    public void removeSidePanelCutInfo(SNYEntities sNYEntities, SidePanelInfo sidePanelInfo, PanelDirectionType panelDirectionType) {
        LinkedList<PanelCutInfo> linkedList = panelDirectionType == PanelDirectionType.LEFT ? sNYEntities.mLeftPanelCutInfoList : sNYEntities.mRightPanelCutInfoList;
        int n = linkedList.size() - 1;
        while (n >= 0) {
            PanelCutInfo panelCutInfo = (PanelCutInfo)linkedList.get(n);
            if (panelCutInfo.mTerraceId.equals(sidePanelInfo.mTerraceId) && panelCutInfo.mPanelId.equals(sidePanelInfo.mIndex)) {
                linkedList.remove(n);
            }
            --n;
        }
    }

    public void updateRearPanelCutInfo(SNYEntities sNYEntities) {
        this.removeRearPanelCutInfo(sNYEntities);
        if (sNYEntities.mTerracesInfo.mEnforcementType == EnforcementType.HANEDASHI) {
            boolean bl = sNYEntities.mTerracesInfo.mEnforcementDirType == EnforcementDirType.L;
            LinkedList<PanelCutInfo> linkedList = bl ? sNYEntities.mLeftPanelCutInfoList : sNYEntities.mRightPanelCutInfoList;
            LinkedList<PanelCutInfo> linkedList2 = new LinkedList<PanelCutInfo>();
            this.getHanedashiCutInfo(sNYEntities, linkedList2);
            this.setDefault(sNYEntities, linkedList2);
            linkedList.addAll(linkedList2);
        }
    }

    public void removeRearPanelCutInfo(SNYEntities sNYEntities) {
        PanelCutInfo panelCutInfo;
        LinkedList<PanelCutInfo> linkedList = sNYEntities.mLeftPanelCutInfoList;
        int n = linkedList.size() - 1;
        while (n >= 0) {
            panelCutInfo = (PanelCutInfo)linkedList.get(n);
            if (panelCutInfo.mPanelId == -1) {
                linkedList.remove(n);
            }
            --n;
        }
        linkedList = sNYEntities.mRightPanelCutInfoList;
        n = linkedList.size() - 1;
        while (n >= 0) {
            panelCutInfo = (PanelCutInfo)linkedList.get(n);
            if (panelCutInfo.mPanelId == -1) {
                linkedList.remove(n);
            }
            --n;
        }
    }

    public void updatePanelCutInfoByOption(SNYEntities sNYEntities, Object object) {
        PanelOptionInfo panelOptionInfo;
        String string;
        HashMap hashMap = (HashMap)object;
        HashMap hashMap2 = (HashMap)this.getOptionSnapShot(sNYEntities);
        HashSet<PanelInfo> hashSet = new HashSet<PanelInfo>();
        HashSet<PanelInfo> hashSet2 = new HashSet<PanelInfo>();
        HashSet<PanelInfo> hashSet3 = new HashSet<PanelInfo>();
        for (Map.Entry entry : hashMap.entrySet()) {
            string = (String)entry.getKey();
            if (hashMap2.containsKey(string)) continue;
            panelOptionInfo = (PanelOptionInfo)entry.getValue();
            if (string.startsWith("F")) {
                this.getChangedPanelSet(sNYEntities, panelOptionInfo, hashSet, PanelDirectionType.FRONT);
                continue;
            }
            if (string.startsWith("L")) {
                this.getChangedPanelSet(sNYEntities, panelOptionInfo, hashSet2, PanelDirectionType.LEFT);
                continue;
            }
            this.getChangedPanelSet(sNYEntities, panelOptionInfo, hashSet3, PanelDirectionType.RIGHT);
        }
        for (Map.Entry entry : hashMap2.entrySet()) {
            string = (String)entry.getKey();
            if (hashMap.containsKey(string)) continue;
            panelOptionInfo = (PanelOptionInfo)entry.getValue();
            if (string.startsWith("F")) {
                this.getChangedPanelSet(sNYEntities, panelOptionInfo, hashSet, PanelDirectionType.FRONT);
                continue;
            }
            if (string.startsWith("L")) {
                this.getChangedPanelSet(sNYEntities, panelOptionInfo, hashSet2, PanelDirectionType.LEFT);
                continue;
            }
            this.getChangedPanelSet(sNYEntities, panelOptionInfo, hashSet3, PanelDirectionType.RIGHT);
        }
        this.updateFrontPanelCutInfo(sNYEntities, hashSet);
        this.updateSidePanelCutInfo(sNYEntities, hashSet2, PanelDirectionType.LEFT);
        this.updateSidePanelCutInfo(sNYEntities, hashSet3, PanelDirectionType.RIGHT);
    }

    private void rempvePanelCutInfo(List<PanelCutInfo> list, int n, int n2) {
        int n3 = list.size() - 1;
        while (n3 >= 0) {
            PanelCutInfo panelCutInfo = list.get(n3);
            if (panelCutInfo.mTerraceId == n && panelCutInfo.mPanelId == n2) {
                list.remove(panelCutInfo);
            }
            --n3;
        }
    }

    public HashSet<PanelInfo> getChangedPanelSet(SNYEntities sNYEntities, List<? extends PanelOptionInfo> list, HashSet<PanelInfo> hashSet, PanelDirectionType panelDirectionType) {
        for (PanelOptionInfo panelOptionInfo : list) {
            hashSet = this.getChangedPanelSet(sNYEntities, panelOptionInfo, hashSet, panelDirectionType);
        }
        return hashSet;
    }

    public HashSet<PanelInfo> getChangedPanelSet(SNYEntities sNYEntities, PanelOptionInfo panelOptionInfo, HashSet<PanelInfo> hashSet, PanelDirectionType panelDirectionType) {
        if (!this.isAffectingOption(panelOptionInfo)) {
            return hashSet;
        }
        PanelInfo panelInfo = null;
        if (panelDirectionType == PanelDirectionType.FRONT) {
            panelInfo = this.mFrontPanelCommonService.findOneFrontPanelInfo(sNYEntities.mFrontPanelInfoList, panelOptionInfo.mTerraceId, panelOptionInfo.mIndex);
        } else if (panelDirectionType == PanelDirectionType.LEFT) {
            panelInfo = this.mSidePanelCommonService.findOneSidePanelInfo(sNYEntities.mLeftPanelInfoList, panelOptionInfo.mIndex);
        } else if (panelDirectionType == PanelDirectionType.RIGHT) {
            panelInfo = this.mSidePanelCommonService.findOneSidePanelInfo(sNYEntities.mRightPanelInfoList, panelOptionInfo.mIndex);
        }
        if (panelInfo != null) {
            if (hashSet == null) {
                hashSet = new HashSet();
            }
            hashSet.add(panelInfo);
        }
        return hashSet;
    }

    public Object getOptionSnapShot(SNYEntities sNYEntities) {
        HashMap<String, PanelOptionInfo> hashMap = new HashMap<String, PanelOptionInfo>();
        int n = 0;
        while (n < 3) {
            String string;
            LinkedList<PanelOptionInfo> linkedList;
            switch (n) {
                case 0: {
                    linkedList = sNYEntities.mFrontPanelOptionInfoList;
                    string = "F,";
                    break;
                }
                case 1: {
                    linkedList = sNYEntities.mLeftPanelOptionInfoList;
                    string = "L,";
                    break;
                }
                default: {
                    linkedList = sNYEntities.mRightPanelOptionInfoList;
                    string = "R,";
                }
            }
            if (linkedList != null) {
                for (PanelOptionInfo panelOptionInfo : linkedList) {
                    String string2 = String.valueOf(string) + panelOptionInfo.mTerraceId + ',' + panelOptionInfo.mIndex + ',' + panelOptionInfo.mPanelOptionType.name();
                    if (panelOptionInfo.mHeightArrangementType != null) {
                        string2 = String.valueOf(string2) + "," + panelOptionInfo.mHeightArrangementType.name();
                    }
                    hashMap.put(string2, (PanelOptionInfo)ObjectUtil.shallowCopy((Object)panelOptionInfo));
                }
            }
            ++n;
        }
        return hashMap;
    }

    private boolean isAffectingOption(PanelOptionInfo panelOptionInfo) {
        if (panelOptionInfo.mPanelOptionType == PanelOptionType.AMIDO) {
            return true;
        }
        if (panelOptionInfo.mPanelOptionType == PanelOptionType.NAKASAN) {
            return true;
        }
        if (panelOptionInfo.mPanelOptionType == PanelOptionType.RANMA_SLIDING) {
            return true;
        }
        if (panelOptionInfo.mPanelOptionType == PanelOptionType.KANKISEN) {
            return true;
        }
        if (panelOptionInfo.mPanelOptionType == PanelOptionType.ECOCARAT) {
            return true;
        }
        return panelOptionInfo.mPanelOptionType == PanelOptionType.MEKAKUSHI_PANEL_SET;
    }

    public void updateOverWidth(SNYEntities sNYEntities) {
        this.setOverWidth(sNYEntities, sNYEntities.mLeftPanelCutInfoList, PanelDirectionType.LEFT);
        this.setOverWidth(sNYEntities, sNYEntities.mFrontPanelCutInfoList, PanelDirectionType.FRONT);
        this.setOverWidth(sNYEntities, sNYEntities.mRightPanelCutInfoList, PanelDirectionType.RIGHT);
    }

    private void getSideWidthCutInfo(SNYEntities sNYEntities, SidePanelInfo sidePanelInfo, PanelSpec panelSpec, PanelDirectionType panelDirectionType, List<PanelCutInfo> list) {
        ProductSeriesType productSeriesType = sNYEntities.mBasicInfo.mProductSeriesType;
        int n = sidePanelInfo.mPanelType.id();
        KenType kenType = null;
        int n2 = sidePanelInfo.mDepthType.mDbId;
        int n3 = sidePanelInfo.mKamachiType != null ? sidePanelInfo.mKamachiType.mDbId : 0;
        int n4 = this.getOsamariType(sNYEntities, sidePanelInfo, sidePanelInfo.mTerraceId, sidePanelInfo.mIndex, panelDirectionType);
        float f = this.getOverHeight(sNYEntities, n4, sidePanelInfo, panelSpec, panelDirectionType);
        int n5 = sidePanelInfo.mShoujiNum != null ? sidePanelInfo.mShoujiNum : 0;
        int n6 = 0;
        List<PanelElementInfo> list2 = this.mPanelElementCacheDao.findManyByParams(productSeriesType, n4, n, kenType, n2, panelSpec.bNakazan, n3, n5);
        for (PanelElementInfo panelElementInfo : list2) {
            boolean bl;
            PanelCutInfo panelCutInfo = this.getPanelCutInfo(panelElementInfo, kenType, sidePanelInfo.mDefaultWidth.floatValue(), panelSpec.bLarge, panelSpec.bAmido, panelSpec.bNakazan, sidePanelInfo.mName, null);
            boolean bl2 = bl = panelSpec.bRanma && panelCutInfo.mWidthCutIdx == n6;
            if (bl && n6 > 0 && panelElementInfo.panelType != 7 && panelElementInfo.panelType != 8) {
                bl = false;
            }
            if (bl) {
                int n7 = n2;
                float f2 = sidePanelInfo.mDefaultWidth.floatValue();
                int n8 = panelSpec.bRanmaSliding ? 101 : 100;
                int n9 = panelSpec.bRanmaSliding ? sidePanelInfo.mShoujiNum : 0;
                for (PanelElementInfo panelElementInfo2 : this.mPanelElementCacheDao.findManyByParams(productSeriesType, n4, n8, kenType, n7, false, 0, n9)) {
                    PanelCutInfo panelCutInfo2 = this.getPanelCutInfo(panelElementInfo2, kenType, f2, false, panelSpec.bRanmaAmido, false, null, null);
                    panelCutInfo2.mTerraceId = sidePanelInfo.mTerraceId;
                    panelCutInfo2.mPanelId = sidePanelInfo.mIndex;
                    panelCutInfo2.mOsamariType = n4;
                    panelCutInfo2.mOverHeight = Float.valueOf(f);
                    panelCutInfo2.mWidthCutIdx = n6;
                    list.add(panelCutInfo2);
                }
                ++n6;
            }
            panelCutInfo.mTerraceId = sidePanelInfo.mTerraceId;
            panelCutInfo.mPanelId = sidePanelInfo.mIndex;
            panelCutInfo.mOsamariType = n4;
            panelCutInfo.mOverHeight = Float.valueOf(f);
            this.replaceOptionPanel(panelCutInfo, panelSpec);
            if (panelSpec.bRanma) {
                panelCutInfo.mHeightCutIdx = panelCutInfo.mHeightCutIdx + 1;
            }
            list.add(panelCutInfo);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void getFrontWidthCutInfo(SNYEntities sNYEntities, FrontPanelInfo frontPanelInfo, PanelSpec panelSpec, List<PanelCutInfo> list) {
        ProductSeriesType productSeriesType = sNYEntities.mBasicInfo.mProductSeriesType;
        int n = frontPanelInfo.mPanelType.id();
        KenType kenType = sNYEntities.mBasicInfo.mKenType;
        int n2 = frontPanelInfo.mWidthType.mDbId;
        int n3 = frontPanelInfo.mKamachiType != null ? frontPanelInfo.mKamachiType.mDbId : 0;
        int n4 = this.getOsamariType(sNYEntities, frontPanelInfo, frontPanelInfo.mTerraceId, frontPanelInfo.mIndex, PanelDirectionType.FRONT);
        float f = this.getOverHeight(sNYEntities, n4, frontPanelInfo, panelSpec, PanelDirectionType.FRONT);
        int n5 = frontPanelInfo.mShoujiNum != null ? frontPanelInfo.mShoujiNum : 0;
        int n6 = 0;
        if (panelSpec.bRanma) {
            n6 = panelSpec.bRanmaSliding ? 101 : 100;
            int n7 = panelSpec.bRanmaSliding ? frontPanelInfo.mShoujiNum : 0;
            Object object = null;
            if (!panelSpec.bRanmaSliding && frontPanelInfo.mPanelType == OpeningPanelType.TATESUBERI && n2 < 4) {
                String string = "(419,430)(1947,430)";
            }
            for (PanelElementInfo panelElementInfo : this.mPanelElementCacheDao.findManyByParams(productSeriesType, n4, n6, kenType, n2, false, 0, n7)) {
                void var15_18;
                PanelCutInfo panelCutInfo = this.getPanelCutInfo(panelElementInfo, kenType, frontPanelInfo.mDefaultWidth.floatValue(), false, panelSpec.bRanmaAmido, false, null, (String)var15_18);
                panelCutInfo.mTerraceId = frontPanelInfo.mTerraceId;
                panelCutInfo.mPanelId = frontPanelInfo.mIndex;
                panelCutInfo.mOsamariType = n4;
                panelCutInfo.mOverHeight = Float.valueOf(f);
                list.add(panelCutInfo);
            }
        }
        List<PanelElementInfo> list2 = this.mPanelElementCacheDao.findManyByParams(productSeriesType, n4, n, kenType, n2, panelSpec.bNakazan, n3, n5);
        for (PanelElementInfo panelElementInfo : list2) {
            PanelCutInfo panelCutInfo = this.getPanelCutInfo(panelElementInfo, kenType, frontPanelInfo.mDefaultWidth.floatValue(), panelSpec.bLarge, panelSpec.bAmido, panelSpec.bNakazan, frontPanelInfo.mName, null);
            panelCutInfo.mTerraceId = frontPanelInfo.mTerraceId;
            panelCutInfo.mPanelId = frontPanelInfo.mIndex;
            panelCutInfo.mOsamariType = n4;
            panelCutInfo.mOverHeight = Float.valueOf(f);
            this.replaceOptionPanel(panelCutInfo, panelSpec);
            if (n6 != 0) {
                panelCutInfo.mHeightCutIdx = panelCutInfo.mHeightCutIdx + 1;
            }
            list.add(panelCutInfo);
        }
    }

    private void replaceOptionPanel(PanelCutInfo panelCutInfo, PanelSpec panelSpec) {
        if (panelSpec.bKankisen && panelCutInfo.mHeightCutIdx == 0) {
            panelCutInfo.mPanelElementType = 16384;
            panelCutInfo.mHeightTypeName = "\u63db\u6c17\u6247\u53d6\u4ed8\u7528\u30d1\u30cd\u30eb";
            panelCutInfo.mElementLimit = FIXED_SIZE;
        }
        if (panelSpec.bEcocaratUpper && panelCutInfo.mHeightCutIdx == 0 || panelSpec.bEcocaratLower && panelCutInfo.mHeightCutIdx == 1) {
            panelCutInfo.mPanelElementType = 16384;
            panelCutInfo.mHeightTypeName = "\u30a8\u30b3\u30ab\u30e9\u30c3\u30c8";
            panelCutInfo.mElementLimit = null;
        }
        if (panelSpec.bMekakusiUpper && panelCutInfo.mHeightCutIdx == 0 || panelSpec.bMekakusiLower && panelCutInfo.mHeightCutIdx == 1) {
            panelCutInfo.mPanelElementType = 16384;
            panelCutInfo.mHeightTypeName = "\u76ee\u96a0\u3057\u30d1\u30cd\u30eb";
            panelCutInfo.mElementLimit = null;
        }
    }

    private void getHanedashiCutInfo(SNYEntities sNYEntities, List<PanelCutInfo> list) {
        float f;
        int n;
        float f2;
        Integer n2 = -1;
        if (sNYEntities.mTerracesInfo.mEnforcementDirType == EnforcementDirType.L) {
            f2 = sNYEntities.mTerracesInfo.mLeftHanedashiLen.floatValue();
            n = sNYEntities.mTerraceInfoList.getFirst().mId;
        } else {
            f2 = sNYEntities.mTerracesInfo.mRightHanedashiLen.floatValue();
            n = sNYEntities.mTerraceInfoList.getLast().mId;
        }
        f2 -= 150.0f;
        boolean bl = sNYEntities.mBasicInfo.mRanmaUseType == RanmaUseType.EXIST;
        int n3 = this.getOsamariType(sNYEntities, null, 0, 0, PanelDirectionType.FRONT);
        float f3 = sNYEntities.mTerracesInfo.mHeight.floatValue();
        if (sNYEntities.mBasicInfo.mSubProductType == SubProductType.DOMA && sNYEntities.mDomaTileInfo.mTileUsedType == TileUsedType.ON) {
            f = sNYEntities.mDomaTileInfo.mFloorLevel.floatValue();
            f3 -= f;
        } else {
            f = sNYEntities.mFloorInfo.mFloorLevel.floatValue();
        }
        PartsFigureInfo partsFigureInfo = sNYEntities.mPartsFigureInfo;
        float f4 = partsFigureInfo.mLeftWallHeight.floatValue() + f;
        float f5 = f3;
        if (sNYEntities.mBasicInfo.mSubProductType == SubProductType.YUKA) {
            f5 -= f - 30.0f;
        }
        if (bl) {
            f5 -= 430.0f;
        }
        float f6 = f5 > 2000.0f ? 1169 : 954;
        PanelCutInfo panelCutInfo = new PanelCutInfo();
        panelCutInfo.mTerraceId = n;
        panelCutInfo.mPanelId = n2;
        panelCutInfo.mOsamariType = n3;
        panelCutInfo.mNakazanUmu = false;
        panelCutInfo.mPanelType = 100;
        panelCutInfo.mPanelElementType = 8192;
        panelCutInfo.mShoujiNum = 0;
        panelCutInfo.mWidthTypeName = "FIX";
        panelCutInfo.mWidthCutIdx = 0;
        panelCutInfo.mStandardWidth = Float.valueOf(f2);
        panelCutInfo.mHeightTypeName = "\u30e9\u30f3\u30deFIX";
        panelCutInfo.mHeightCutIdx = 0;
        panelCutInfo.mUpperLowerType = 1;
        panelCutInfo.mStandardHeight = Float.valueOf(f4 - f3 - 118.0f + (float)(bl ? 430 : 0));
        panelCutInfo.mOverHeight = Float.valueOf(0.0f);
        panelCutInfo.mHoudateWidth = Float.valueOf(0.0f);
        list.add(panelCutInfo);
        panelCutInfo = new PanelCutInfo();
        panelCutInfo.mTerraceId = n;
        panelCutInfo.mPanelId = n2;
        panelCutInfo.mOsamariType = n3;
        panelCutInfo.mNakazanUmu = false;
        panelCutInfo.mPanelType = 5;
        panelCutInfo.mPanelElementType = 4096;
        panelCutInfo.mShoujiNum = 0;
        panelCutInfo.mWidthTypeName = "FIX";
        panelCutInfo.mWidthCutIdx = 0;
        panelCutInfo.mStandardWidth = Float.valueOf(f2);
        panelCutInfo.mHeightTypeName = "\u4e0a\u90e8";
        panelCutInfo.mHeightCutIdx = 1;
        panelCutInfo.mUpperLowerType = 1;
        panelCutInfo.mStandardHeight = Float.valueOf(f5 - f6 - 92.0f);
        panelCutInfo.mOverHeight = Float.valueOf(0.0f);
        panelCutInfo.mHoudateWidth = Float.valueOf(0.0f);
        list.add(panelCutInfo);
        panelCutInfo = new PanelCutInfo();
        panelCutInfo.mTerraceId = n;
        panelCutInfo.mPanelId = n2;
        panelCutInfo.mOsamariType = n3;
        panelCutInfo.mNakazanUmu = false;
        panelCutInfo.mPanelType = 5;
        panelCutInfo.mPanelElementType = 4096;
        panelCutInfo.mShoujiNum = 0;
        panelCutInfo.mWidthTypeName = "FIX";
        panelCutInfo.mWidthCutIdx = 0;
        panelCutInfo.mStandardWidth = Float.valueOf(f2);
        panelCutInfo.mHeightTypeName = "\u4e0b\u90e8";
        panelCutInfo.mHeightCutIdx = 2;
        panelCutInfo.mUpperLowerType = 2;
        panelCutInfo.mStandardHeight = Float.valueOf(f6 - 30.0f);
        panelCutInfo.mOverHeight = Float.valueOf(0.0f);
        panelCutInfo.mHoudateWidth = Float.valueOf(0.0f);
        list.add(panelCutInfo);
    }

    private PanelCutInfo getPanelCutInfo(PanelElementInfo panelElementInfo, KenType kenType, float f, boolean bl, boolean bl2, boolean bl3, String string, String string2) {
        List<RefList<GPoint2Df>> list;
        PanelCutInfo panelCutInfo = new PanelCutInfo();
        panelCutInfo.mNakazanUmu = bl3;
        panelCutInfo.mPanelType = panelElementInfo.panelType;
        panelCutInfo.mPanelElementType = panelElementInfo.panelElementType;
        panelCutInfo.mShoujiNum = panelElementInfo.shoujiNum;
        panelCutInfo.mWidthTypeName = panelElementInfo.widthElementName;
        panelCutInfo.mWidthCutIdx = panelElementInfo.widthCutIdx;
        panelCutInfo.mHeightTypeName = panelElementInfo.heightElementName;
        panelCutInfo.mHeightCutIdx = panelElementInfo.heightCutIdx;
        panelCutInfo.mUpperLowerType = panelCutInfo.mHeightCutIdx + 1;
        Float f2 = panelCutInfo.mStandardHeight = bl ? panelElementInfo.longHeight : panelElementInfo.height;
        if (panelElementInfo.shoujiUmuType == 1) {
            panelCutInfo.mShoujiCut = false;
        }
        if (bl2 && panelElementInfo.amidoUmuType == 1) {
            panelCutInfo.mAmidoCut = false;
            panelCutInfo.mAmidoFieldCut = false;
        }
        panelCutInfo.mElementLimit = panelElementInfo.elementLimit;
        panelCutInfo.mProductLimit = string2 != null ? string2 : panelElementInfo.productLimit;
        panelCutInfo.mAmidoLimit = panelElementInfo.amidoLimit;
        panelCutInfo.mHoudateWidth = panelElementInfo.houdateWidth;
        if (string != null && string.indexOf("\u73fe\u5834\u5207\u8a70") != -1) {
            panelCutInfo.mOnlyFieldCut = true;
        }
        if (!StringUtil.isEmpty((String)panelCutInfo.mElementLimit) && !mProductLimitMap.containsKey(panelCutInfo.mElementLimit) && (list = this.getRefListList(panelCutInfo.mElementLimit)) != null) {
            mProductLimitMap.put(panelCutInfo.mElementLimit, list);
        }
        if (!StringUtil.isEmpty((String)panelCutInfo.mProductLimit) && !mProductLimitMap.containsKey(panelCutInfo.mProductLimit) && (list = this.getRefListList(panelCutInfo.mProductLimit)) != null) {
            mProductLimitMap.put(panelCutInfo.mProductLimit, list);
        }
        if (!StringUtil.isEmpty((String)panelCutInfo.mAmidoLimit) && !mProductLimitMap.containsKey(panelCutInfo.mAmidoLimit) && (list = this.getRefListList(panelCutInfo.mAmidoLimit)) != null) {
            mProductLimitMap.put(panelCutInfo.mAmidoLimit, list);
        }
        panelCutInfo.mStandardWidth = panelElementInfo.fixWidth.floatValue() > 0.0f ? panelElementInfo.fixWidth : Float.valueOf(f - panelElementInfo.diffWidth.floatValue());
        if (panelElementInfo.houdateWidth.floatValue() > 0.0f) {
            panelCutInfo.mShoujiNum = panelCutInfo.mStandardWidth.floatValue() >= panelElementInfo.houdateWidth.floatValue() ? Integer.valueOf(2) : Integer.valueOf(0);
        }
        return panelCutInfo;
    }

    private List<RefList<GPoint2Df>> getRefListList(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        if (string.equals(FIXED_SIZE)) {
            return null;
        }
        ArrayList<RefList<GPoint2Df>> arrayList = new ArrayList<RefList<GPoint2Df>>();
        String[] stringArray = string.split("[+|]");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray[n2];
            if ((string2 = string2.trim()).length() > 0) {
                arrayList.add(this.getRefList(string2));
            }
            ++n2;
        }
        return arrayList;
    }

    private RefList<GPoint2Df> getRefList(String string) {
        int n = 0;
        float[] fArray = new float[2];
        RefList refList = new RefList();
        String[] stringArray = string.split("[,\\(\\)]");
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String string2 = stringArray[n3];
            if (!string2.equals("")) {
                try {
                    fArray[n++] = Float.parseFloat(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
                if (n > 1) {
                    GPoint2Df gPoint2Df = new GPoint2Df(fArray[0], fArray[1]);
                    refList.addElement((Object)gPoint2Df);
                    n = 0;
                }
            }
            ++n3;
        }
        return refList;
    }

    protected int getOsamariType(SNYEntities sNYEntities, PanelInfo panelInfo, int n, int n2, PanelDirectionType panelDirectionType) {
        return this.getOsamariType(sNYEntities.mBasicInfo, panelInfo, sNYEntities.mTerracesInfo, sNYEntities.mTerraceInfoList, n, n2, panelDirectionType);
    }

    protected int getOsamariType(BasicInfo basicInfo, PanelInfo panelInfo, TerracesInfo terracesInfo, Collection<TerraceInfo> collection, int n, int n2, PanelDirectionType panelDirectionType) {
        SubProductType subProductType = basicInfo.mSubProductType;
        if (subProductType == SubProductType.DOMA) {
            return 1;
        }
        if (subProductType == SubProductType.YUKA) {
            return 2;
        }
        if (subProductType == SubProductType.TSUKURITSUKE) {
            if (terracesInfo.mEnforcementType == EnforcementType.BUBUN_KAKOI && panelInfo != null && panelInfo.mFloorArrangementType == FloorArrangementType.YUKA) {
                return 2;
            }
            return 3;
        }
        if (subProductType == SubProductType.ALMI_BALCONY_PILLAR || subProductType == SubProductType.ALMI_BALCONY_ROOF) {
            return 4;
        }
        if (subProductType == SubProductType.HALF_KAKOI) {
            return 5;
        }
        if (subProductType == SubProductType.DOMA_YUKA) {
            if (panelInfo != null && panelInfo.mFloorArrangementType == FloorArrangementType.DOMA) {
                return 1;
            }
            return 2;
        }
        return -1;
    }

    private float getOverHeight(SNYEntities sNYEntities, int n, PanelInfo panelInfo, PanelSpec panelSpec, PanelDirectionType panelDirectionType) {
        float f = panelDirectionType == PanelDirectionType.LEFT ? sNYEntities.mPartsFigureInfo.mLeftSideOpeningHeight.floatValue() : (panelDirectionType == PanelDirectionType.RIGHT ? sNYEntities.mPartsFigureInfo.mRightSideOpeningHeight.floatValue() : sNYEntities.mPartsFigureInfo.mFrontOpeningHeight.floatValue());
        if (sNYEntities.mTerracesInfo.mEnforcementType == EnforcementType.DOMA_YUKA_W) {
            if (panelDirectionType == PanelDirectionType.FRONT && panelInfo.mFloorArrangementType == FloorArrangementType.DOMA) {
                f += sNYEntities.mPartsFigureInfo.mYukaHeight.floatValue();
            }
        } else if (sNYEntities.mTerracesInfo.mEnforcementType == EnforcementType.DOMA_YUKA_D) {
            if (panelInfo.mFloorArrangementType == FloorArrangementType.DOMA) {
                f = sNYEntities.mPartsFigureInfo.mFrontOpeningHeight.floatValue();
            } else if (panelInfo.mFloorArrangementType == FloorArrangementType.YUKA) {
                f = sNYEntities.mPartsFigureInfo.mFrontOpeningHeight.floatValue() - sNYEntities.mPartsFigureInfo.mYukaHeight.floatValue();
            }
        }
        if (panelSpec.bRanma) {
            f -= 430.0f;
        }
        return panelInfo.mDefaultHeight.floatValue() - f;
    }

    private float getFrontOverWidth(SNYEntities sNYEntities, int n) {
        float f = 0.0f;
        if (sNYEntities.mFrontPanelInfoList.size() > 0) {
            boolean bl = true;
            for (PanelInfo panelInfo : sNYEntities.mFrontPanelInfoList) {
                if (panelInfo.mTerraceId != n) continue;
                if (bl) {
                    bl = false;
                    TerraceInfo terraceInfo = this.getTerraceInfo(sNYEntities, n);
                    f = sNYEntities.mTerracesInfo.mEnforcementType == EnforcementType.BUBUN_KAKOI && terraceInfo.mIsMaster.booleanValue() ? (sNYEntities.mBasicInfo.mSubProductType == SubProductType.TSUKURITSUKE ? -terraceInfo.mOpeningWidth.floatValue() - 70.0f : (sNYEntities.mTerracesInfo.mEnforcementDirType == EnforcementDirType.L ? -terraceInfo.mLeftWidth.floatValue() : -terraceInfo.mRightWidth.floatValue())) : -terraceInfo.mOpeningWidth.floatValue() - 70.0f;
                }
                f += panelInfo.mBaseWidth.floatValue();
                if (panelInfo.mPanelType == OpeningPanelType.TATESUBERI && panelInfo.mSpan == 1) {
                    f += 36.0f;
                    continue;
                }
                if (panelInfo.mPanelType == OpeningPanelType.HIKIDO) {
                    f += 101.0f;
                    continue;
                }
                f += 71.0f;
            }
        }
        return f;
    }

    private float getSideOverWidth(SNYEntities sNYEntities, DirectionType directionType) {
        LinkedList<PanelOptionInfo> linkedList;
        float f = 0.0f;
        LinkedList<SidePanelInfo> linkedList2 = directionType == DirectionType.LEFT ? sNYEntities.mLeftPanelInfoList : sNYEntities.mRightPanelInfoList;
        LinkedList<PanelOptionInfo> linkedList3 = linkedList = directionType == DirectionType.LEFT ? sNYEntities.mLeftPanelOptionInfoList : sNYEntities.mRightPanelOptionInfoList;
        if (linkedList2.size() > 0) {
            TerraceInfo terraceInfo;
            TerraceInfo terraceInfo2 = terraceInfo = directionType == DirectionType.LEFT ? sNYEntities.mTerraceInfoList.getFirst() : sNYEntities.mTerraceInfoList.getLast();
            f = sNYEntities.mBasicInfo.mSubProductType == SubProductType.HALF_KAKOI ? -sNYEntities.mPartsFigureInfo.mKutaiUniversalPillarDepth1.floatValue() - 15.0f : (directionType == DirectionType.LEFT ? -terraceInfo.mLeftOpeningDepth.floatValue() - 85.0f : -terraceInfo.mRightOpeningDepth.floatValue() - 85.0f);
            if (this.containsOption(linkedList, PanelOptionType.TOBUKURO_NIGE)) {
                f += 300.0f;
            }
            for (PanelInfo panelInfo : linkedList2) {
                f += panelInfo.mBaseWidth.floatValue() + 15.0f;
                if (panelInfo.mPanelType == OpeningPanelType.HIKIDO) {
                    f += 101.0f;
                    continue;
                }
                f += 71.0f;
            }
        }
        return f;
    }

    private TerraceInfo getTerraceInfo(SNYEntities sNYEntities, int n) {
        for (TerraceInfo terraceInfo : sNYEntities.mTerraceInfoList) {
            if (terraceInfo.mId != n) continue;
            return terraceInfo;
        }
        return null;
    }

    private boolean containsOption(LinkedList<PanelOptionInfo> linkedList, PanelOptionType panelOptionType) {
        for (PanelOptionInfo panelOptionInfo : linkedList) {
            if (panelOptionInfo.mPanelOptionType != panelOptionType) continue;
            return true;
        }
        return false;
    }

    private void setDefault(SNYEntities sNYEntities, List<PanelCutInfo> list) {
        int n = Integer.MIN_VALUE;
        boolean bl = false;
        boolean bl2 = sNYEntities.mTerracesInfo.mHeightCutPlaceType == CutPlaceType.FACTORY;
        ProductSeriesType productSeriesType = sNYEntities.mBasicInfo.mProductSeriesType;
        int n2 = sNYEntities.mBasicInfo.mFloorNum;
        for (PanelCutInfo panelCutInfo : list) {
            Serializable serializable;
            if (panelCutInfo.mTerraceId != n) {
                n = panelCutInfo.mTerraceId;
                serializable = this.mTerraceCommonService.findTerraceInfoByIndex(sNYEntities.mTerraceInfoList, n);
                bl = serializable.mCutPlaceType == CutPlaceType.FACTORY;
            }
            panelCutInfo.mCutWidth = Float.valueOf(0.0f);
            panelCutInfo.mOverWidth = Float.valueOf(0.0f);
            panelCutInfo.mFactoryWidthCut = bl;
            panelCutInfo.mFactoryHeightCut = bl2;
            if (panelCutInfo.mOnlyFieldCut != null && panelCutInfo.mOnlyFieldCut.booleanValue()) {
                panelCutInfo.mFactoryWidthCut = false;
                panelCutInfo.mFactoryHeightCut = false;
            }
            panelCutInfo.mCutHeight = Float.valueOf(0.0f);
            panelCutInfo.mWakuCut = bl || bl2;
            if (panelCutInfo.mShoujiCut != null) {
                panelCutInfo.mShoujiCut = bl || bl2;
            }
            panelCutInfo.mGlassBuiltin = sNYEntities.mBasicInfo.mSashGlassBuiltinType == SashGlassBuiltinType.BUILTIN;
            serializable = this.mGlassCandidateCacheDao.findOneByParams(productSeriesType, panelCutInfo.mPanelType, panelCutInfo.mPanelElementType, panelCutInfo.mNakazanUmu, panelCutInfo.mUpperLowerType, panelCutInfo.mGlassBuiltin, n2);
            panelCutInfo.mGlassType = GlassCandidateCacheDao.getInitialGlassType((GlassCandidateInfo)serializable, sNYEntities.mBasicInfo.mGlassType);
        }
    }

    protected void setOverWidth(SNYEntities sNYEntities, List<PanelCutInfo> list, PanelDirectionType panelDirectionType) {
        int n = Integer.MIN_VALUE;
        float f = 0.0f;
        for (PanelCutInfo panelCutInfo : list) {
            if (panelCutInfo.mPanelId == -1) continue;
            if (panelCutInfo.mTerraceId != n) {
                n = panelCutInfo.mTerraceId;
                f = panelDirectionType == PanelDirectionType.LEFT ? this.getSideOverWidth(sNYEntities, DirectionType.LEFT) : (panelDirectionType == PanelDirectionType.FRONT ? this.getFrontOverWidth(sNYEntities, n) : this.getSideOverWidth(sNYEntities, DirectionType.RIGHT));
            }
            panelCutInfo.mOverWidth = Float.valueOf(f);
        }
    }

    public boolean judgePanelCutInfo(SNYEntities sNYEntities) {
        if (!this.judgePanelCutSize(sNYEntities.mLeftPanelCutInfoList)) {
            return false;
        }
        if (!this.judgePanelCutSize(sNYEntities.mFrontPanelCutInfoList)) {
            return false;
        }
        if (!this.judgePanelCutSize(sNYEntities.mRightPanelCutInfoList)) {
            return false;
        }
        if (!this.judgeFactoryCut(sNYEntities)) {
            return false;
        }
        if (!this.judgeGlassFactoryInstall(sNYEntities)) {
            return false;
        }
        return this.judgeAmidoCut(sNYEntities);
    }

    private boolean judgePanelCutSize(List<PanelCutInfo> list) {
        int n = Integer.MIN_VALUE;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        for (PanelCutInfo panelCutInfo : list) {
            if (panelCutInfo.mTerraceId > n) {
                if (n != -1 && !this.judgeCutSize(f3, f)) {
                    return false;
                }
                n = panelCutInfo.mTerraceId;
                f3 = panelCutInfo.mOverWidth.floatValue();
                f = 0.0f;
                n3 = -1;
            }
            if (panelCutInfo.mPanelId != n2) {
                if (n2 != -1 && !this.judgeCutSize(f4, f2)) {
                    return false;
                }
                n2 = panelCutInfo.mPanelId;
                f4 = panelCutInfo.mOverHeight.floatValue();
                n3 = -1;
            }
            if (n3 == -1) {
                n3 = panelCutInfo.mWidthCutIdx;
                f += panelCutInfo.mCutWidth.floatValue();
                n5 = panelCutInfo.mHeightCutIdx;
                n4 = -1;
                f2 = 0.0f;
            } else if (panelCutInfo.mWidthCutIdx > n3) {
                if (panelCutInfo.mPanelType == 7 || panelCutInfo.mPanelType == 8) {
                    if (!this.judgeCutSize(f4, f2)) {
                        return false;
                    }
                    n3 = panelCutInfo.mWidthCutIdx;
                    f += panelCutInfo.mCutWidth.floatValue();
                    n5 = panelCutInfo.mHeightCutIdx;
                    f2 = 0.0f;
                    n4 = -1;
                } else if (panelCutInfo.mHeightCutIdx == n5) {
                    n3 = panelCutInfo.mWidthCutIdx;
                    f += panelCutInfo.mCutWidth.floatValue();
                }
            }
            if (panelCutInfo.mHeightCutIdx <= n4) continue;
            n4 = panelCutInfo.mHeightCutIdx;
            f2 += panelCutInfo.mCutHeight.floatValue();
        }
        if (n != -1 && !this.judgeCutSize(f3, f)) {
            return false;
        }
        return n2 == -1 || this.judgeCutSize(f4, f2);
    }

    private boolean judgeCutSize(float f, float f2) {
        if (f == f2) {
            return true;
        }
        errorMessage = "\u5404\u958b\u53e3\u306e\u5207\u8a70\u5bf8\u6cd5\u306e\u5408\u8a08\u304c\u30aa\u30fc\u30d0\u30fc\u5bf8\u6cd5\u3068\u4e00\u81f4\u3057\u307e\u305b\u3093\u3002\n\u5207\u8a70\u5bf8\u6cd5\u3092\u518d\u5ea6\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044";
        return false;
    }

    private boolean judgeFactoryCut(SNYEntities sNYEntities) {
        int n = 0;
        int n2 = 0;
        List[] listArray = new List[]{sNYEntities.mLeftPanelCutInfoList, sNYEntities.mFrontPanelCutInfoList, sNYEntities.mRightPanelCutInfoList};
        int n3 = listArray.length;
        int n4 = 0;
        while (n4 < n3) {
            List list = listArray[n4];
            for (PanelCutInfo panelCutInfo : list) {
                if (!(panelCutInfo.mCutHeight.floatValue() > 0.0f && panelCutInfo.mFactoryHeightCut != false) && (!(panelCutInfo.mCutWidth.floatValue() > 0.0f) || !panelCutInfo.mFactoryWidthCut.booleanValue())) continue;
                if (panelCutInfo.mWakuCut != null) {
                    ++n;
                    if (panelCutInfo.mWakuCut.booleanValue()) {
                        ++n2;
                    }
                }
                if (panelCutInfo.mShoujiCut == null) continue;
                ++n;
                if (!panelCutInfo.mShoujiCut.booleanValue()) continue;
                ++n2;
            }
            ++n4;
        }
        if (n > 0 && n2 == 0) {
            errorMessage = "\u5de5\u5834\u5207\u8a70\u3092\u9078\u629e\u3057\u3066\u3044\u307e\u3059\u304c\u3001\u67a0\u3001\u969c\u5b50\u306e\u5de5\u5834\u5207\u8a70\u306e\u30c1\u30a7\u30c3\u30af\u304c\u5168\u3066\u5916\u308c\u3066\u3044\u307e\u3059\u3002\n\uff11\u3064\u4ee5\u4e0a\u30c1\u30a7\u30c3\u30af\u3092\u5165\u308c\u3066\u304f\u3060\u3055\u3044\u3002";
            return false;
        }
        return true;
    }

    private boolean judgeGlassFactoryInstall(SNYEntities sNYEntities) {
        if (sNYEntities.mBasicInfo.mSashGlassBuiltinType == SashGlassBuiltinType.BUILTIN) {
            int n = 0;
            int n2 = 0;
            List[] listArray = new List[]{sNYEntities.mLeftPanelCutInfoList, sNYEntities.mFrontPanelCutInfoList, sNYEntities.mRightPanelCutInfoList};
            int n3 = listArray.length;
            int n4 = 0;
            while (n4 < n3) {
                List list = listArray[n4];
                for (PanelCutInfo panelCutInfo : list) {
                    ++n;
                    if (!panelCutInfo.mGlassBuiltin.booleanValue()) continue;
                    ++n2;
                }
                ++n4;
            }
            if (n > 0 && n2 == 0) {
                errorMessage = "\u30b5\u30c3\u30b7\u30ac\u30e9\u30b9\u7d44\u8fbc\u3042\u308a\u3092\u9078\u629e\u3057\u3066\u3044\u307e\u3059\u304c\u3001\u30ac\u30e9\u30b9\u5de5\u5834\u7d44\u8fbc\u306e\u30c1\u30a7\u30c3\u30af\u304c\u5168\u3066\u5916\u308c\u3066\u3044\u307e\u3059\u3002\n\uff11\u3064\u4ee5\u4e0a\u30c1\u30a7\u30c3\u30af\u3092\u5165\u308c\u3066\u304f\u3060\u3055\u3044\u3002";
                return false;
            }
        }
        return true;
    }

    private boolean judgeAmidoCut(SNYEntities sNYEntities) {
        List[] listArray = new List[]{sNYEntities.mLeftPanelCutInfoList, sNYEntities.mFrontPanelCutInfoList, sNYEntities.mRightPanelCutInfoList};
        int n = listArray.length;
        int n2 = 0;
        while (n2 < n) {
            List list = listArray[n2];
            for (PanelCutInfo panelCutInfo : list) {
                if ((!(panelCutInfo.mCutWidth.floatValue() > 0.0f) || panelCutInfo.mPanelElementType >= 64 && 512 >= panelCutInfo.mPanelElementType) && !(panelCutInfo.mCutHeight.floatValue() > 0.0f) || panelCutInfo.mAmidoCut == null || panelCutInfo.mAmidoCut.booleanValue() || panelCutInfo.mAmidoFieldCut != null && panelCutInfo.mAmidoFieldCut.booleanValue()) continue;
                errorMessage = "\u7db2\u6238\u5207\u8a70\u30fb\u30ac\u30e9\u30b9\u500b\u5225\u8a2d\u5b9a\u30bf\u30d6\u306e\u7db2\u6238\u6b04\u306b\u5de5\u5834\u5207\u8a70\u304b\u73fe\u5834\u5207\u8a70\u306e\u3069\u3061\u3089\u304b\u3092\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
                return false;
            }
            ++n2;
        }
        return true;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public void updatePanelInfo(SNYEntities sNYEntities) {
        for (PanelInfo panelInfo : sNYEntities.mLeftPanelInfoList) {
            this.setCutSize(panelInfo, sNYEntities.mLeftPanelCutInfoList);
        }
        for (PanelInfo panelInfo : sNYEntities.mFrontPanelInfoList) {
            this.setCutSize(panelInfo, sNYEntities.mFrontPanelCutInfoList);
        }
        for (PanelInfo panelInfo : sNYEntities.mRightPanelInfoList) {
            this.setCutSize(panelInfo, sNYEntities.mRightPanelCutInfoList);
        }
    }

    private void setCutSize(PanelInfo panelInfo, Collection<PanelCutInfo> collection) {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        int n = 0;
        for (PanelCutInfo panelCutInfo : collection) {
            if (!panelCutInfo.mTerraceId.equals(panelInfo.mTerraceId) || !panelCutInfo.mPanelId.equals(panelInfo.mIndex)) continue;
            if (panelCutInfo.mHoudateWidth.floatValue() > 0.0f) {
                if (panelCutInfo.isRanmaFix()) {
                    Boolean.valueOf(panelCutInfo.mShoujiNum == 2);
                } else {
                    Boolean.valueOf(panelCutInfo.mShoujiNum == 2);
                }
            }
            if (panelCutInfo.isRanma()) {
                n = 1;
            }
            if (panelCutInfo.mCutHeight.floatValue() > 0.0f) {
                if (panelCutInfo.mHeightCutIdx == n) {
                    f = panelCutInfo.mCutHeight.floatValue();
                } else {
                    f2 = panelCutInfo.mCutHeight.floatValue();
                }
            }
            if (!(panelCutInfo.mCutWidth.floatValue() > 0.0f)) continue;
            if (panelCutInfo.mWidthCutIdx == 1) {
                if (panelCutInfo.mPanelType == 16 || panelCutInfo.mPanelType == 32) {
                    f4 = panelCutInfo.mCutWidth.floatValue();
                    continue;
                }
                f3 = panelCutInfo.mCutWidth.floatValue();
                continue;
            }
            f3 = panelCutInfo.mCutWidth.floatValue();
        }
        panelInfo.mUpperHeightCut = Float.valueOf(f);
        panelInfo.mLowerHeightCut = Float.valueOf(f2);
        panelInfo.mWidthCut = Float.valueOf(f3 + f4);
        panelInfo.mHeight = Float.valueOf(panelInfo.mDefaultHeight.floatValue() - (f + f2));
        panelInfo.mTotalHeight = Float.valueOf(panelInfo.mDefaultTotalHeight.floatValue() - (f + f2));
        panelInfo.mWidth = Float.valueOf(panelInfo.mDefaultWidth.floatValue() - (f3 + f4));
        panelInfo.mOpeningWidth = Float.valueOf(panelInfo.mDefaultOpeningWidth.floatValue() - (f3 + f4));
    }

    public PanelInfo getPanelInfo(PanelCutInfo panelCutInfo, Collection<? extends PanelInfo> collection) {
        for (PanelInfo panelInfo : collection) {
            if (panelCutInfo.mTerraceId == null || panelCutInfo.mPanelId == null || !panelCutInfo.mTerraceId.equals(panelInfo.mTerraceId) || panelCutInfo.mPanelId != panelInfo.mIndex) continue;
            return panelInfo;
        }
        return null;
    }

    public ClassifiedCutInfo getClassifiedCutInfo(PanelInfo panelInfo, List<PanelCutInfo> list) {
        return this.getClassifiedCutInfo(panelInfo.mTerraceId, panelInfo.mIndex, list);
    }

    public ClassifiedCutInfo getClassifiedCutInfo(Integer n, Integer n2, List<PanelCutInfo> list) {
        ClassifiedCutInfo classifiedCutInfo = new ClassifiedCutInfo();
        for (PanelCutInfo panelCutInfo : list) {
            if (panelCutInfo.mTerraceId == null || panelCutInfo.mPanelId == null || !panelCutInfo.mTerraceId.equals(n) || panelCutInfo.mPanelId != n2) continue;
            if (panelCutInfo.isRanma()) {
                if (classifiedCutInfo.ranmaCutInfo != null) continue;
                classifiedCutInfo.ranmaCutInfo = panelCutInfo;
                continue;
            }
            int n3 = panelCutInfo.mHeightCutIdx;
            if (classifiedCutInfo.ranmaCutInfo != null) {
                --n3;
            }
            if (n3 == 0) {
                if (classifiedCutInfo.upperCutInfo != null) continue;
                classifiedCutInfo.upperCutInfo = panelCutInfo;
                continue;
            }
            if (classifiedCutInfo.lowerCutInfo != null) continue;
            classifiedCutInfo.lowerCutInfo = panelCutInfo;
        }
        return classifiedCutInfo;
    }

    public LinkedList<PanelCutInfo> findManyPanelCutInfoByIndex(List<PanelCutInfo> list, Integer n, Integer n2) {
        LinkedList<PanelCutInfo> linkedList = new LinkedList<PanelCutInfo>();
        for (PanelCutInfo panelCutInfo : list) {
            if (!panelCutInfo.mTerraceId.equals(n) || panelCutInfo.mPanelId != -1 && !panelCutInfo.mPanelId.equals(n2)) continue;
            linkedList.add(panelCutInfo);
        }
        return linkedList;
    }

    public LinkedList<PanelCutInfo> findManyPanelCutInfoByIndexExceptHanedashi(List<PanelCutInfo> list, Integer n, Integer n2) {
        LinkedList<PanelCutInfo> linkedList = new LinkedList<PanelCutInfo>();
        for (PanelCutInfo panelCutInfo : list) {
            if (!panelCutInfo.mTerraceId.equals(n) || !panelCutInfo.mPanelId.equals(n2) || panelCutInfo.mPanelId == -1) continue;
            linkedList.add(panelCutInfo);
        }
        return linkedList;
    }

    public PanelCutInfo findOneLowerPanelCutInfoByIndex(List<PanelCutInfo> list, Integer n, Integer n2) {
        LinkedList<PanelCutInfo> linkedList = this.findManyPanelCutInfoByIndex(list, n, n2);
        PanelCutInfo panelCutInfo = null;
        int n3 = 0;
        for (PanelCutInfo panelCutInfo2 : linkedList) {
            if (n3 > panelCutInfo2.mHeightCutIdx) continue;
            n3 = panelCutInfo2.mHeightCutIdx;
            panelCutInfo = panelCutInfo2;
        }
        return panelCutInfo;
    }

    public PanelCutInfo findOnePanelCutInfoByIndexWH(List<PanelCutInfo> list, Integer n, Integer n2) {
        for (PanelCutInfo panelCutInfo : list) {
            if (!panelCutInfo.mWidthCutIdx.equals(n) || !panelCutInfo.mHeightCutIdx.equals(n2)) continue;
            return panelCutInfo;
        }
        return null;
    }

    public LinkedList<PanelCutInfo> findManyPanelCutInfoByHeightCutIndex(List<PanelCutInfo> list, Integer n) {
        LinkedList<PanelCutInfo> linkedList = new LinkedList<PanelCutInfo>();
        for (PanelCutInfo panelCutInfo : list) {
            if (!panelCutInfo.mHeightCutIdx.equals(n)) continue;
            linkedList.add(panelCutInfo);
        }
        return linkedList;
    }

    public LinkedList<PanelCutInfo> findManyPanelCutInfoByWidthCutIndex(List<PanelCutInfo> list, Integer n) {
        LinkedList<PanelCutInfo> linkedList = new LinkedList<PanelCutInfo>();
        for (PanelCutInfo panelCutInfo : list) {
            if (!panelCutInfo.mWidthCutIdx.equals(n)) continue;
            linkedList.add(panelCutInfo);
        }
        return linkedList;
    }

    public LinkedList<PanelCutInfo> findManyPanelCutInfoByUpperIndex(PanelInfo panelInfo, List<PanelCutInfo> list) {
        int n = panelInfo.mRanmaUseType == RanmaUseType.NONE ? 0 : 1;
        return this.findManyPanelCutInfoByHeightCutIndex(list, n);
    }

    public LinkedList<PanelCutInfo> findManyPanelCutInfoByLowerIndex(PanelInfo panelInfo, List<PanelCutInfo> list) {
        int n = panelInfo.mRanmaUseType == RanmaUseType.NONE ? 0 : 1;
        return this.findManyPanelCutInfoByHeightCutIndex(list, n + 1);
    }

    public PanelCutInfo findOnePanelCutInfoByOpeningType(List<PanelCutInfo> list, Integer ... integerArray) {
        for (PanelCutInfo panelCutInfo : list) {
            int n = 0;
            while (n < integerArray.length) {
                Integer n2 = integerArray[n];
                if (panelCutInfo.mPanelElementType.equals(n2)) {
                    return panelCutInfo;
                }
                ++n;
            }
        }
        return null;
    }

    public PanelCutInfo findOnePanelCutInfoByWakuCut(LinkedList<PanelCutInfo> linkedList) {
        for (PanelCutInfo panelCutInfo : linkedList) {
            if (!panelCutInfo.isWakuCut()) continue;
            return panelCutInfo;
        }
        return null;
    }

    public float calcPanelWidth(PanelCutInfo panelCutInfo) {
        float f = 0.0f;
        float f2 = 0.0f;
        if (panelCutInfo.mStandardWidth != null) {
            f = panelCutInfo.mStandardWidth.floatValue();
        }
        if (panelCutInfo.mCutWidth != null) {
            f2 = panelCutInfo.mCutWidth.floatValue();
        }
        return f - f2;
    }

    public float calcPanelHeight(PanelCutInfo panelCutInfo) {
        float f = 0.0f;
        float f2 = 0.0f;
        if (panelCutInfo.mStandardHeight != null) {
            f = panelCutInfo.mStandardHeight.floatValue();
        }
        if (panelCutInfo.mCutHeight != null) {
            f2 = panelCutInfo.mCutHeight.floatValue();
        }
        return f - f2;
    }

    public boolean hasRanma(LinkedList<PanelCutInfo> linkedList, PanelCutInfo panelCutInfo) {
        boolean bl = false;
        LinkedList<PanelCutInfo> linkedList2 = new LinkedList<PanelCutInfo>();
        for (PanelCutInfo panelCutInfo2 : linkedList) {
            if (panelCutInfo2.mTerraceId != panelCutInfo.mTerraceId || panelCutInfo2.mPanelId != panelCutInfo.mPanelId) continue;
            linkedList2.add(panelCutInfo2);
        }
        for (PanelCutInfo panelCutInfo2 : linkedList2) {
            if (panelCutInfo2.mPanelElementType != 1024 && panelCutInfo2.mPanelElementType != 2048) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public LinkedList<PanelCutInfo> createPanelCutInfoListByRemoveRanma(LinkedList<PanelCutInfo> linkedList) {
        LinkedList<PanelCutInfo> linkedList2 = new LinkedList<PanelCutInfo>();
        for (PanelCutInfo panelCutInfo : linkedList) {
            if (panelCutInfo.mPanelElementType == 1024 || panelCutInfo.mPanelElementType == 2048) continue;
            linkedList2.add(panelCutInfo);
        }
        return linkedList2;
    }

    public LinkedList<PanelCutInfo> createPanelCutInfoListByHanedashi(LinkedList<PanelCutInfo> linkedList) {
        LinkedList<PanelCutInfo> linkedList2 = new LinkedList<PanelCutInfo>();
        for (PanelCutInfo panelCutInfo : linkedList) {
            if (panelCutInfo.mPanelElementType != 4096 && panelCutInfo.mPanelElementType != 8192) continue;
            linkedList2.add(panelCutInfo);
        }
        return linkedList2;
    }

    public boolean isFactoryCut(LinkedList<PanelCutInfo> linkedList) {
        boolean bl = false;
        for (PanelCutInfo panelCutInfo : linkedList) {
            boolean bl2;
            boolean bl3 = panelCutInfo.mFactoryWidthCut != false && panelCutInfo.mCutWidth.floatValue() > 0.0f;
            boolean bl4 = bl2 = panelCutInfo.mFactoryHeightCut != false && panelCutInfo.mCutHeight.floatValue() > 0.0f;
            if (!bl3 && !bl2) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public void sortPanelCutListsByHeightCutIdx(List<PanelCutInfo> list) {
        Collections.sort(list, new Comparator<PanelCutInfo>(){

            @Override
            public int compare(PanelCutInfo panelCutInfo, PanelCutInfo panelCutInfo2) {
                return panelCutInfo.mHeightCutIdx.compareTo(panelCutInfo2.mHeightCutIdx);
            }
        });
    }

    public static class ClassifiedCutInfo {
        public PanelCutInfo ranmaCutInfo;
        public PanelCutInfo upperCutInfo;
        public PanelCutInfo lowerCutInfo;
    }

    private class PanelSpec {
        public boolean bLarge;
        public boolean bRanma;
        public boolean bAmido;
        public boolean bRanmaAmido;
        public boolean bNakazan;
        public boolean bRanmaSliding;
        public boolean bKankisen;
        public boolean bEcocaratUpper;
        public boolean bEcocaratLower;
        public boolean bMekakusiUpper;
        public boolean bMekakusiLower;

        public PanelSpec(FrontPanelInfo frontPanelInfo, List<PanelOptionInfo> list) {
            this.checkHeight(frontPanelInfo.mPanelHeightType, frontPanelInfo.mRanmaUseType);
            this.checkRanma(frontPanelInfo.mRanmaType);
            if (list != null) {
                for (PanelOptionInfo panelOptionInfo : list) {
                    if (!frontPanelInfo.mTerraceId.equals(panelOptionInfo.mTerraceId)) continue;
                    this.checkOptionType(panelOptionInfo, frontPanelInfo.mIndex);
                }
            }
        }

        public PanelSpec(SidePanelInfo sidePanelInfo, List<PanelOptionInfo> list) {
            this.checkHeight(sidePanelInfo.mPanelHeightType, sidePanelInfo.mRanmaUseType);
            this.checkRanma(sidePanelInfo.mRanmaType);
            if (list != null) {
                for (PanelOptionInfo panelOptionInfo : list) {
                    if (!sidePanelInfo.mTerraceId.equals(panelOptionInfo.mTerraceId)) continue;
                    this.checkOptionType(panelOptionInfo, sidePanelInfo.mIndex);
                }
            }
        }

        private void checkHeight(PanelHeightType panelHeightType, RanmaUseType ranmaUseType) {
            this.bLarge = panelHeightType == PanelHeightType.LARGE;
            this.bRanma = ranmaUseType == RanmaUseType.EXIST;
        }

        private void checkRanma(RanmaType ranmaType) {
            this.bRanmaSliding = ranmaType == RanmaType.SLIDING;
        }

        private void checkOptionType(PanelOptionInfo panelOptionInfo, int n) {
            if (panelOptionInfo.mPanelOptionType == PanelOptionType.AMIDO && panelOptionInfo.mIndex == n) {
                if (panelOptionInfo.mHeightArrangementType == HeightArrangementType.RANMA) {
                    this.bRanmaAmido = true;
                } else {
                    this.bAmido = true;
                }
            } else if (panelOptionInfo.mPanelOptionType == PanelOptionType.NAKASAN && panelOptionInfo.mIndex == n) {
                this.bNakazan = true;
            } else if (panelOptionInfo.mPanelOptionType == PanelOptionType.RANMA_SLIDING && panelOptionInfo.mIndex == n) {
                this.bRanmaSliding = true;
            } else if (panelOptionInfo.mPanelOptionType == PanelOptionType.KANKISEN && panelOptionInfo.mIndex == n) {
                if (panelOptionInfo.mHeightArrangementType == HeightArrangementType.PANEL) {
                    this.bKankisen = true;
                }
            } else if (panelOptionInfo.mPanelOptionType == PanelOptionType.ECOCARAT && panelOptionInfo.mIndex == n) {
                if (panelOptionInfo.mHeightIndex == 1) {
                    this.bEcocaratUpper = true;
                } else {
                    this.bEcocaratLower = true;
                }
            } else if (panelOptionInfo.mPanelOptionType == PanelOptionType.MEKAKUSHI_PANEL_SET && panelOptionInfo.mIndex == n) {
                if (panelOptionInfo.mHeightIndex == 1) {
                    this.bMekakusiUpper = true;
                } else {
                    this.bMekakusiLower = true;
                }
            }
        }
    }
}

