/*
 * Decompiled with CFR 0.152.
 */
package option.loneterrace.common.service.common;

import option.gad.core.inject.GdInject;
import option.gad.core.util.GdMutableTypeUtil;
import option.loneterrace.common.dao.cache.type.TypeTerraceDepthCacheDao;
import option.loneterrace.common.dao.cache.type.TypeTerraceHeightCacheDao;
import option.loneterrace.common.dao.cache.type.TypeTerraceWidthCacheDao;
import option.loneterrace.common.entity.BasicInfo;
import option.loneterrace.common.entity.TerraceInfo;
import option.loneterrace.common.entity.TerracesInfo;
import option.loneterrace.common.entity.type.TypeTerraceDepthInfo;
import option.loneterrace.common.entity.type.TypeTerraceHeightInfo;
import option.loneterrace.common.entity.type.TypeTerraceWidthInfo;
import option.loneterrace.common.type.EnforcementDirType;
import option.loneterrace.common.type.EnforcementType;
import option.loneterrace.common.type.SodePosType;

public class EnforcementCommonService {
    @GdInject
    protected TypeTerraceDepthCacheDao typeTerraceDepthCacheDao;
    @GdInject
    protected TypeTerraceHeightCacheDao typeTerraceHeightCacheDao;
    @GdInject
    protected TypeTerraceWidthCacheDao typeTerraceWidthCacheDao;

    public boolean isHeightCut(BasicInfo basicInfo, TerracesInfo terracesInfo) {
        TypeTerraceHeightInfo typeTerraceHeightInfo = this.typeTerraceHeightCacheDao.findOneByTypes(basicInfo, terracesInfo);
        return !typeTerraceHeightInfo.length.equals(terracesInfo.mHeight);
    }

    public boolean isWidthCut(BasicInfo basicInfo, TerraceInfo terraceInfo) {
        TypeTerraceWidthInfo typeTerraceWidthInfo = this.typeTerraceWidthCacheDao.findOneByType(terraceInfo.mWidthType, basicInfo.mKenType);
        return !typeTerraceWidthInfo.length.equals(terraceInfo.mWidth);
    }

    public boolean isDehabaCut(TerracesInfo terracesInfo) {
        TypeTerraceDepthInfo typeTerraceDepthInfo = this.typeTerraceDepthCacheDao.findOneStdById(terracesInfo.mDepthType.id());
        return !typeTerraceDepthInfo.length.equals(terracesInfo.mDepth);
    }

    public boolean isLeftDehabaCut(TerracesInfo terracesInfo) {
        if (this.isDehabaCut(terracesInfo)) {
            return true;
        }
        if (GdMutableTypeUtil.matchOR(terracesInfo.mEnforcementType, EnforcementType.KUTAI_DEHABA_CHIGAI) && GdMutableTypeUtil.matchOR(terracesInfo.mEnforcementDirType, EnforcementDirType.L)) {
            return true;
        }
        return GdMutableTypeUtil.matchOR(terracesInfo.mEnforcementType, EnforcementType.BUBUN_IRISUMI) && GdMutableTypeUtil.matchOR(terracesInfo.mEnforcementDirType, EnforcementDirType.L);
    }

    public boolean isRightDehabaCut(TerracesInfo terracesInfo) {
        if (this.isDehabaCut(terracesInfo)) {
            return true;
        }
        if (GdMutableTypeUtil.matchOR(terracesInfo.mEnforcementType, EnforcementType.KUTAI_DEHABA_CHIGAI) && GdMutableTypeUtil.matchOR(terracesInfo.mEnforcementDirType, EnforcementDirType.R)) {
            return true;
        }
        return GdMutableTypeUtil.matchOR(terracesInfo.mEnforcementType, EnforcementType.BUBUN_IRISUMI) && GdMutableTypeUtil.matchOR(terracesInfo.mEnforcementDirType, EnforcementDirType.R);
    }

    public boolean hasSingleIrisumi(SodePosType sodePosType) {
        return sodePosType == SodePosType.L || sodePosType == SodePosType.R;
    }

    public boolean hasNecessaryIdouhoutateEnforcementType(EnforcementType enforcementType, EnforcementDirType enforcementDirType, boolean bl) {
        if (bl && enforcementType == EnforcementType.BUBUN_IRISUMI && enforcementDirType == EnforcementDirType.L) {
            return true;
        }
        return !bl && enforcementType == EnforcementType.BUBUN_IRISUMI && enforcementDirType == EnforcementDirType.R;
    }

    public boolean hasDeirisumi(TerracesInfo terracesInfo) {
        return GdMutableTypeUtil.matchOR(terracesInfo.mEnforcementType, EnforcementType.DESUMI, EnforcementType.IRISUMI);
    }
}

