/*
 * Decompiled with CFR 0.152.
 */
package option.loneterrace.common.dao.cache.spec;

import com.kt.annotation.Reflectable;
import java.util.Collection;
import java.util.List;
import option.gad.core.dao.GdDao;
import option.loneterrace.common.dao.cache.AbstractCacheCsvDao;
import option.loneterrace.common.entity.BasicInfo;
import option.loneterrace.common.entity.TerracesInfo;
import option.loneterrace.common.entity.spec.SpecFrameCutInfo;
import option.loneterrace.common.type.DeckRenkeiType;
import option.loneterrace.common.type.EnforcementType;
import option.loneterrace.common.type.SodePosType;
import option.loneterrace.common.type.SubProductType;
import option.loneterrace.common.type.WidthCutType;
import option.loneterrace.common.type.constant.CutExeType;
import option.loneterrace.common.type.constant.CutPlaceType;
import option.loneterrace.common.type.constant.factory.CutExeTypeFactory;
import option.loneterrace.common.type.factory.WidthCutTypeFactory;

@Reflectable(name="SpecFrameCutCacheDao")
@GdDao(entity=SpecFrameCutInfo.class)
public class SpecFrameCutCacheDao
extends AbstractCacheCsvDao<SpecFrameCutInfo> {
    public List<CutExeType> findManyCutExeTypeByTypes(BasicInfo basicInfo, TerracesInfo terracesInfo) {
        return this.findManyCutExeTypeByTypes(basicInfo.mSubProductType, terracesInfo.mEnforcementType, basicInfo.mDeckRenkeiType, terracesInfo.mSodePosType);
    }

    public List<CutExeType> findManyCutExeTypeByTypes(SubProductType subProductType, EnforcementType enforcementType, DeckRenkeiType deckRenkeiType, SodePosType sodePosType) {
        SpecFrameCutInfo specFrameCutInfo = new SpecFrameCutInfo();
        specFrameCutInfo.subProductType = this.convTypeToBin(subProductType);
        specFrameCutInfo.enforcementType = this.convTypeToBin(enforcementType);
        specFrameCutInfo.deckRenkeiType = this.convTypeToBin(deckRenkeiType);
        specFrameCutInfo.sodePosType = this.convTypeToBin(sodePosType);
        specFrameCutInfo.permission = "1";
        Collection collection = this.findMany(specFrameCutInfo, new boolean[]{true, true});
        return this.findManyType(collection, "cutExeType", CutExeTypeFactory.getInstance());
    }

    public List<WidthCutType> findManyWidthCutTypeByTypes(BasicInfo basicInfo, TerracesInfo terracesInfo, CutPlaceType cutPlaceType) {
        return this.findManyWidthCutTypeByTypes(basicInfo.mSubProductType, terracesInfo.mEnforcementType, basicInfo.mDeckRenkeiType, terracesInfo.mSodePosType, cutPlaceType);
    }

    public List<WidthCutType> findManyWidthCutTypeByTypes(SubProductType subProductType, EnforcementType enforcementType, DeckRenkeiType deckRenkeiType, SodePosType sodePosType, CutPlaceType cutPlaceType) {
        SpecFrameCutInfo specFrameCutInfo = new SpecFrameCutInfo();
        specFrameCutInfo.subProductType = this.convTypeToBin(subProductType);
        specFrameCutInfo.enforcementType = this.convTypeToBin(enforcementType);
        specFrameCutInfo.deckRenkeiType = this.convTypeToBin(deckRenkeiType);
        specFrameCutInfo.sodePosType = this.convTypeToBin(sodePosType);
        specFrameCutInfo.cutExeType = "10";
        specFrameCutInfo.cutPlaceType = this.convTypeToBin(cutPlaceType);
        specFrameCutInfo.permission = "1";
        Collection collection = this.findMany(specFrameCutInfo, new boolean[]{true, true});
        return this.findManyType(collection, "widthCutType", WidthCutTypeFactory.getInstance());
    }

    public boolean canCutFrame(BasicInfo basicInfo, TerracesInfo terracesInfo) {
        return this.canCutFrame(basicInfo.mSubProductType, terracesInfo.mEnforcementType, basicInfo.mDeckRenkeiType, terracesInfo.mSodePosType);
    }

    public boolean canCutFrame(SubProductType subProductType, EnforcementType enforcementType, DeckRenkeiType deckRenkeiType, SodePosType sodePosType) {
        List<CutExeType> list = this.findManyCutExeTypeByTypes(subProductType, enforcementType, deckRenkeiType, sodePosType);
        if (list == null) {
            return false;
        }
        if (list.isEmpty()) {
            return false;
        }
        for (CutExeType cutExeType : list) {
            if (cutExeType != CutExeType.EXE) continue;
            return true;
        }
        return false;
    }

    public boolean canChangeFloorLevel(BasicInfo basicInfo, TerracesInfo terracesInfo, CutExeType cutExeType) {
        return this.canChangeFloorLevel(basicInfo.mSubProductType, terracesInfo.mEnforcementType, basicInfo.mDeckRenkeiType, terracesInfo.mSodePosType, cutExeType);
    }

    public boolean canChangeFloorLevel(SubProductType subProductType, EnforcementType enforcementType, DeckRenkeiType deckRenkeiType, SodePosType sodePosType, CutExeType cutExeType) {
        SpecFrameCutInfo specFrameCutInfo = new SpecFrameCutInfo();
        specFrameCutInfo.subProductType = this.convTypeToBin(subProductType);
        specFrameCutInfo.enforcementType = this.convTypeToBin(enforcementType);
        specFrameCutInfo.deckRenkeiType = this.convTypeToBin(deckRenkeiType);
        specFrameCutInfo.sodePosType = this.convTypeToBin(sodePosType);
        specFrameCutInfo.cutExeType = this.convTypeToBin(cutExeType);
        specFrameCutInfo.permission = "1";
        Collection collection = this.findMany(specFrameCutInfo, new boolean[]{true, true});
        if (collection == null) {
            return false;
        }
        if (collection.isEmpty()) {
            return false;
        }
        SpecFrameCutInfo specFrameCutInfo2 = (SpecFrameCutInfo)collection.iterator().next();
        return specFrameCutInfo2.floorLevelType.equals("1");
    }
}

