/*
 * Decompiled with CFR 0.152.
 */
package option.loneterrace.common.dao.cache.spec;

import com.kt.annotation.Reflectable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import option.gad.core.dao.GdDao;
import option.gad.core.inject.GdInject;
import option.gad.core.util.DebugUtil;
import option.loneterrace.common.dao.cache.AbstractCacheCsvDao;
import option.loneterrace.common.entity.BasicInfo;
import option.loneterrace.common.entity.TerraceInfo;
import option.loneterrace.common.entity.TerracesInfo;
import option.loneterrace.common.entity.spec.SpecBuildingSizeComboInfo;
import option.loneterrace.common.service.parts.MultiSpanCommonService;
import option.loneterrace.common.type.EnforcementDirType;
import option.loneterrace.common.type.EnforcementType;
import option.loneterrace.common.type.KenType;
import option.loneterrace.common.type.KetaType;
import option.loneterrace.common.type.ProductSeriesType;
import option.loneterrace.common.type.ProductType;
import option.loneterrace.common.type.RoofFigureType;
import option.loneterrace.common.type.RoofToritsukeType;
import option.loneterrace.common.type.StrengthType;
import option.loneterrace.common.type.SubProductType;
import option.loneterrace.common.type.TerraceDepthType;
import option.loneterrace.common.type.TerraceWidthType;
import option.loneterrace.common.type.constant.DepthFigureType;
import option.loneterrace.common.type.factory.TerraceDepthTypeFactory;
import option.loneterrace.common.type.factory.TerraceWidthTypeFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Reflectable(name="SpecBuildingSizeComboCacheDao")
@GdDao(entity=SpecBuildingSizeComboInfo.class)
public class SpecBuildingSizeComboCacheDao
extends AbstractCacheCsvDao<SpecBuildingSizeComboInfo> {
    private static final Log mLog = LogFactory.getLog(SpecBuildingSizeComboCacheDao.class);
    @GdInject
    private MultiSpanCommonService mMultiSpanCommonService;

    public SpecBuildingSizeComboInfo findOneByTypes(BasicInfo basicInfo, TerracesInfo terracesInfo, TerraceInfo terraceInfo, LinkedList<TerraceInfo> linkedList) {
        return this.findOneByTypes(basicInfo, terracesInfo, linkedList, terraceInfo.mDepthType, terraceInfo.mWidthType, terraceInfo.mIsMaster);
    }

    public SpecBuildingSizeComboInfo findOneByTypes(BasicInfo basicInfo, TerracesInfo terracesInfo, LinkedList<TerraceInfo> linkedList, TerraceDepthType terraceDepthType, TerraceWidthType terraceWidthType, Boolean bl) {
        return this.findOneByTypes(basicInfo.mProductSeriesType, basicInfo.mProductType, basicInfo.mSubProductType, basicInfo.mRoofFigureType, terracesInfo.mEnforcementType, terracesInfo.mEnforcementDirType, basicInfo.mStrengthType, basicInfo.mFloorNum, basicInfo.mKetaType, basicInfo.mRoofToritsukeType, DepthFigureType.WHOLE, terracesInfo.mDepthType, terraceDepthType, terraceWidthType, basicInfo.mKenType, bl, this.mMultiSpanCommonService.hasAdditional(linkedList));
    }

    public SpecBuildingSizeComboInfo findOneByTypes(ProductSeriesType productSeriesType, ProductType productType, SubProductType subProductType, RoofFigureType roofFigureType, EnforcementType enforcementType, EnforcementDirType enforcementDirType, StrengthType strengthType, Integer n, KetaType ketaType, RoofToritsukeType roofToritsukeType, DepthFigureType depthFigureType, TerraceDepthType terraceDepthType, TerraceDepthType terraceDepthType2, TerraceWidthType terraceWidthType, KenType kenType, Boolean bl, Boolean bl2) {
        Integer n2 = null;
        if (bl != null) {
            n2 = bl != false ? 1 : 2;
        }
        SpecBuildingSizeComboInfo specBuildingSizeComboInfo = new SpecBuildingSizeComboInfo();
        specBuildingSizeComboInfo.productSeriesType = this.convTypeToBin(productSeriesType);
        specBuildingSizeComboInfo.productType = this.convTypeToBin(productType);
        specBuildingSizeComboInfo.subProductType = this.convTypeToBin(subProductType);
        specBuildingSizeComboInfo.roofFigureType = this.convTypeToBin(roofFigureType);
        specBuildingSizeComboInfo.enforcementType = this.convTypeToBin(enforcementType);
        specBuildingSizeComboInfo.enforcementDirType = this.convTypeToBin(enforcementDirType);
        specBuildingSizeComboInfo.strengthType = this.convTypeToBin(strengthType);
        specBuildingSizeComboInfo.floorNumType = this.convNumToBin(n);
        specBuildingSizeComboInfo.ketaType = this.convTypeToBin(ketaType);
        specBuildingSizeComboInfo.roofToritsukeType = this.convTypeToBin(roofToritsukeType);
        specBuildingSizeComboInfo.depthFigureType = this.convTypeToBin(depthFigureType);
        specBuildingSizeComboInfo.wholeDepthType = this.convTypeToBin(terraceDepthType);
        specBuildingSizeComboInfo.depthType = this.convTypeToBin(terraceDepthType2);
        specBuildingSizeComboInfo.widthType = this.convTypeToBin(terraceWidthType);
        specBuildingSizeComboInfo.kenType = this.convTypeToBin(kenType);
        specBuildingSizeComboInfo.msType = this.convNumToBin(n2);
        specBuildingSizeComboInfo.hasAdditional = bl2;
        mLog.debug((Object)"SpecBuildingSizeComboCacheDao.findOne");
        mLog.debug((Object)("key[" + specBuildingSizeComboInfo + "]"));
        mLog.debug((Object)("comboInfo[" + this.findOne(specBuildingSizeComboInfo, new boolean[]{true, true}) + "]"));
        return (SpecBuildingSizeComboInfo)this.findOne(specBuildingSizeComboInfo, new boolean[]{true, true});
    }

    public Collection<SpecBuildingSizeComboInfo> findManyByTypes(BasicInfo basicInfo, TerracesInfo terracesInfo, TerraceInfo terraceInfo, LinkedList<TerraceInfo> linkedList) {
        return this.findManyByTypes(basicInfo, terracesInfo, linkedList, terraceInfo.mDepthType, terraceInfo.mWidthType, terraceInfo.mIsStarting);
    }

    public Collection<SpecBuildingSizeComboInfo> findManyByTypes(BasicInfo basicInfo, TerracesInfo terracesInfo, LinkedList<TerraceInfo> linkedList, TerraceDepthType terraceDepthType, TerraceWidthType terraceWidthType, Boolean bl) {
        return this.findManyByTypes(basicInfo.mProductSeriesType, basicInfo.mProductType, basicInfo.mSubProductType, basicInfo.mRoofFigureType, terracesInfo.mEnforcementType, terracesInfo.mEnforcementDirType, basicInfo.mStrengthType, basicInfo.mFloorNum, basicInfo.mKetaType, basicInfo.mRoofToritsukeType, DepthFigureType.WHOLE, terracesInfo.mDepthType, terraceDepthType, terraceWidthType, basicInfo.mKenType, bl, this.mMultiSpanCommonService.hasAdditional(linkedList));
    }

    public Collection<SpecBuildingSizeComboInfo> findManyByTypes(ProductSeriesType productSeriesType, ProductType productType, SubProductType subProductType, RoofFigureType roofFigureType, EnforcementType enforcementType, EnforcementDirType enforcementDirType, StrengthType strengthType, Integer n, KetaType ketaType, RoofToritsukeType roofToritsukeType, DepthFigureType depthFigureType, TerraceDepthType terraceDepthType, TerraceDepthType terraceDepthType2, TerraceWidthType terraceWidthType, KenType kenType, Boolean bl, Boolean bl2) {
        Integer n2 = null;
        if (bl != null) {
            n2 = bl != false ? 1 : 2;
        }
        SpecBuildingSizeComboInfo specBuildingSizeComboInfo = new SpecBuildingSizeComboInfo();
        specBuildingSizeComboInfo.productSeriesType = this.convTypeToBin(productSeriesType);
        specBuildingSizeComboInfo.productType = this.convTypeToBin(productType);
        specBuildingSizeComboInfo.subProductType = this.convTypeToBin(subProductType);
        specBuildingSizeComboInfo.roofFigureType = this.convTypeToBin(roofFigureType);
        specBuildingSizeComboInfo.enforcementType = this.convTypeToBin(enforcementType);
        specBuildingSizeComboInfo.enforcementDirType = this.convTypeToBin(enforcementDirType);
        specBuildingSizeComboInfo.strengthType = this.convTypeToBin(strengthType);
        specBuildingSizeComboInfo.floorNumType = this.convNumToBin(n);
        specBuildingSizeComboInfo.ketaType = this.convTypeToBin(ketaType);
        specBuildingSizeComboInfo.roofToritsukeType = this.convTypeToBin(roofToritsukeType);
        specBuildingSizeComboInfo.depthFigureType = this.convTypeToBin(depthFigureType);
        specBuildingSizeComboInfo.wholeDepthType = this.convTypeToBin(terraceDepthType);
        specBuildingSizeComboInfo.depthType = this.convTypeToBin(terraceDepthType2);
        specBuildingSizeComboInfo.widthType = this.convTypeToBin(terraceWidthType);
        specBuildingSizeComboInfo.kenType = this.convTypeToBin(kenType);
        specBuildingSizeComboInfo.msType = this.convNumToBin(n2);
        specBuildingSizeComboInfo.hasAdditional = bl2;
        specBuildingSizeComboInfo.permission = this.convNumToBin(1);
        Collection collection = this.findMany(specBuildingSizeComboInfo, new boolean[]{true, true});
        mLog.debug((Object)"SpecBuildingSizeComboCacheDao.findMany");
        mLog.debug((Object)("key[" + specBuildingSizeComboInfo + "]"));
        mLog.debug((Object)("comboInfoList[\n" + DebugUtil.toString((Collection)collection) + "\n]"));
        return collection;
    }

    public List<TerraceWidthType> findManyWidthTypeByTypes(BasicInfo basicInfo, TerracesInfo terracesInfo, LinkedList<TerraceInfo> linkedList, TerraceDepthType terraceDepthType, Boolean bl) {
        Collection<SpecBuildingSizeComboInfo> collection = this.findManyByTypes(basicInfo.mProductSeriesType, basicInfo.mProductType, basicInfo.mSubProductType, basicInfo.mRoofFigureType, terracesInfo.mEnforcementType, terracesInfo.mEnforcementDirType, basicInfo.mStrengthType, basicInfo.mFloorNum, basicInfo.mKetaType, basicInfo.mRoofToritsukeType, DepthFigureType.WHOLE, null, terraceDepthType, null, basicInfo.mKenType, bl, this.mMultiSpanCommonService.hasAdditional(linkedList));
        Integer n = 0;
        for (SpecBuildingSizeComboInfo arrayList2 : collection) {
            n = n | Integer.parseInt(arrayList2.widthType, 2);
        }
        ArrayList<TerraceWidthType> arrayList = new ArrayList<TerraceWidthType>();
        int n2 = 0;
        while (n > 0) {
            ++n2;
            int n3 = n & 1;
            if (n3 == 1) {
                TerraceWidthType terraceWidthType = (TerraceWidthType)TerraceWidthTypeFactory.getInstance().getTypeById(n2);
                arrayList.add(terraceWidthType);
            }
            n = n >>> 1;
        }
        return arrayList;
    }

    public List<TerraceDepthType> findManyDepthTypeByTypes(BasicInfo basicInfo, TerracesInfo terracesInfo, LinkedList<TerraceInfo> linkedList, DepthFigureType depthFigureType, TerraceWidthType terraceWidthType, Boolean bl) {
        Collection<SpecBuildingSizeComboInfo> collection = this.findManyByTypes(basicInfo.mProductSeriesType, basicInfo.mProductType, basicInfo.mSubProductType, basicInfo.mRoofFigureType, terracesInfo.mEnforcementType, terracesInfo.mEnforcementDirType, basicInfo.mStrengthType, basicInfo.mFloorNum, basicInfo.mKetaType, basicInfo.mRoofToritsukeType, depthFigureType, terracesInfo.mDepthType, null, terraceWidthType, basicInfo.mKenType, bl, this.mMultiSpanCommonService.hasAdditional(linkedList));
        Integer n = 0;
        for (SpecBuildingSizeComboInfo arrayList2 : collection) {
            n = n | Integer.parseInt(arrayList2.depthType, 2);
        }
        ArrayList<TerraceDepthType> arrayList = new ArrayList<TerraceDepthType>();
        int n2 = 0;
        while (n > 0) {
            ++n2;
            int n3 = n & 1;
            if (n3 == 1) {
                TerraceDepthType terraceDepthType = (TerraceDepthType)TerraceDepthTypeFactory.getInstance().getTypeById(n2);
                arrayList.add(terraceDepthType);
            }
            n = n >>> 1;
        }
        return arrayList;
    }

    public boolean possibleMultiSpan(BasicInfo basicInfo, TerracesInfo terracesInfo) {
        Collection<SpecBuildingSizeComboInfo> collection = this.findManyByTypes(basicInfo.mProductSeriesType, basicInfo.mProductType, basicInfo.mSubProductType, basicInfo.mRoofFigureType, terracesInfo.mEnforcementType, terracesInfo.mEnforcementDirType, basicInfo.mStrengthType, basicInfo.mFloorNum, basicInfo.mKetaType, basicInfo.mRoofToritsukeType, DepthFigureType.WHOLE, null, null, null, basicInfo.mKenType, false, null);
        return !collection.isEmpty();
    }
}

