/*
 * Decompiled with CFR 0.152.
 */
package option.loneterrace.common.dao.cache;

import com.kt.annotation.Reflectable;
import java.util.ArrayList;
import java.util.Collection;
import option.gad.core.dao.GdDao;
import option.loneterrace.common.dao.cache.AbstractCacheCsvDao;
import option.loneterrace.common.dxo.ProductTypeDxo;
import option.loneterrace.common.entity.CategoryColorInfo;
import option.loneterrace.common.type.ProductSeriesType;
import option.loneterrace.common.type.ProductType;
import option.loneterrace.common.type.SubProductType;

@Reflectable(name="CategoryColorCacheDao")
@GdDao(entity=CategoryColorInfo.class)
public class CategoryColorCacheDao
extends AbstractCacheCsvDao<CategoryColorInfo> {
    public CategoryColorInfo findOneByCategoryId(ProductSeriesType productSeriesType, int n) {
        CategoryColorInfo categoryColorInfo = new CategoryColorInfo();
        categoryColorInfo.categoryId = n;
        categoryColorInfo.defaultStatus = true;
        return (CategoryColorInfo)this.findOne(categoryColorInfo, new boolean[]{true, true});
    }

    public CategoryColorInfo findOneByTypes(ProductSeriesType productSeriesType, ProductType productType, SubProductType subProductType, int n) {
        CategoryColorInfo categoryColorInfo = new CategoryColorInfo();
        categoryColorInfo.categoryId = n;
        categoryColorInfo.seriesType = productSeriesType.mDbId;
        categoryColorInfo.productType = ProductTypeDxo.convert(productType, subProductType);
        categoryColorInfo.defaultStatus = true;
        return (CategoryColorInfo)this.findOne(categoryColorInfo, new boolean[]{true, true});
    }

    public Collection<CategoryColorInfo> findManyByCategoryId(ProductSeriesType productSeriesType, int n) {
        CategoryColorInfo categoryColorInfo = new CategoryColorInfo();
        categoryColorInfo.categoryId = n;
        categoryColorInfo.seriesType = productSeriesType.mDbId;
        return this.findMany(categoryColorInfo, new boolean[]{true, true});
    }

    public Collection<CategoryColorInfo> findManyByCategoryIdForGenmaterial(ProductSeriesType productSeriesType, int n, Integer n2) {
        CategoryColorInfo categoryColorInfo = new CategoryColorInfo();
        categoryColorInfo.categoryId = n;
        categoryColorInfo.seriesType = productSeriesType.mDbId;
        ArrayList<CategoryColorInfo> arrayList = new ArrayList<CategoryColorInfo>();
        for (CategoryColorInfo categoryColorInfo2 : this.findMany(categoryColorInfo, new boolean[]{true, true})) {
            if (n2 != null && categoryColorInfo2.genmaterialSizeId != null && categoryColorInfo2.genmaterialSizeId > 0 && !n2.equals(categoryColorInfo2.genmaterialSizeId)) continue;
            arrayList.add(categoryColorInfo2);
        }
        return arrayList;
    }

    public Collection<CategoryColorInfo> findManyByTypes(ProductSeriesType productSeriesType, ProductType productType, SubProductType subProductType, int n) {
        CategoryColorInfo categoryColorInfo = new CategoryColorInfo();
        categoryColorInfo.categoryId = n;
        categoryColorInfo.seriesType = productSeriesType.mDbId;
        categoryColorInfo.productType = ProductTypeDxo.convert(productType, subProductType);
        return this.findMany(categoryColorInfo, new boolean[]{true, true});
    }
}

