/*
 * Decompiled with CFR 0.152.
 */
package option.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import javax.swing.border.Border;

public class TitledLineBorder
implements Border {
    private Insets mInsets;
    private FontMetrics mFm;
    private Color mFillcolor;
    private Color mFontColor;
    private Color mTitleColor1;
    private String mTitle;
    private Font mFont;
    private int mLabelHeight;
    protected int mRadius;

    public TitledLineBorder(String string) {
        this(string, 12);
    }

    public TitledLineBorder(String string, int n) {
        this.mTitle = string;
        Font font = new Font("\uff2d\uff33\u3000\uff30\u30b4\u30b7\u30c3\u30af", 1, n);
        this.setFont(font);
        this.setLabelHeight(n + 8);
        this.setRadius(5);
        this.setInsets(1, 1, 1, 1);
        this.setFontColor(new Color(110, 110, 110));
        this.setTitleColor(new Color(210, 210, 210));
        this.setFillColor(Color.LIGHT_GRAY);
    }

    public void setFont(Font font) {
        this.mFont = font;
        this.mFm = null;
    }

    public void setFontColor(Color color) {
        this.mFontColor = color;
    }

    public void setFillColor(Color color) {
        this.mFillcolor = color;
    }

    public Color getFillColor() {
        return this.mFillcolor;
    }

    public void setTitleColor(Color color) {
        this.mTitleColor1 = color;
    }

    public void setTitle(String string) {
        this.mTitle = string;
    }

    public void setLabelHeight(int n) {
        this.mLabelHeight = n;
    }

    public void setRadius(int n) {
        this.mRadius = n;
    }

    public void setInsets(int n, int n2, int n3, int n4) {
        this.mInsets = new Insets(n, n2, n3, n4);
    }

    @Override
    public Insets getBorderInsets(Component component) {
        return new Insets(this.mInsets.top + this.mLabelHeight, this.mInsets.left, this.mInsets.bottom, this.mInsets.right);
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Dimension dimension = new Dimension(n3, n4);
        Graphics2D graphics2D = (Graphics2D)graphics;
        AffineTransform affineTransform = graphics2D.getTransform();
        Shape shape = graphics2D.getClip();
        Color color = graphics2D.getColor();
        Font font = graphics2D.getFont();
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Stroke stroke = graphics2D.getStroke();
        if (this.mFm == null) {
            this.mFm = graphics.getFontMetrics(this.mFont);
        }
        int n5 = n + 18;
        int n6 = (int)((double)this.mFm.stringWidth(this.mTitle) + (double)this.mFont.getSize() * 1.4);
        int n7 = this.mLabelHeight;
        int n8 = dimension.width - 1;
        int n9 = dimension.height - 1;
        int n10 = this.mRadius;
        graphics2D.setColor(this.mTitleColor1);
        graphics2D.drawRect(n, (int)((double)n2 + (double)n7 * 0.3), n8, (int)((double)n9 - (double)n7 * 0.3));
        graphics2D.fillRoundRect(n5, n2, n6, n7, n10, n10);
        graphics2D.setFont(this.mFont);
        graphics2D.setColor(this.mFontColor);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.drawString(this.mTitle, (float)n5 + (float)this.mFont.getSize() * 0.7f, (float)n2 + (float)n7 * 0.5f + (float)this.mFont.getSize() * 0.4f);
        graphics2D.setTransform(affineTransform);
        graphics2D.setFont(font);
        graphics2D.setColor(color);
        graphics2D.setClip(shape);
        graphics2D.setStroke(stroke);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
    }
}

