/*
 * Decompiled with CFR 0.152.
 */
package option.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.RenderingHints;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;

public class RoundPanel
extends Panel {
    private Insets mInsets;
    private int mRadius = 5;
    private Color mLineColor;
    private Color mFillColor;
    private Image mOffImage;
    private Graphics mOffGraphics;
    private int mWidth = 1;

    public RoundPanel(int n, Color color, Color color2, int n2, int n3, int n4, int n5) {
        this.mRadius = n;
        this.setInsets(n2, n3, n4, n5);
        this.setColor(color2, color);
    }

    public RoundPanel(LayoutManager layoutManager) {
        super(layoutManager);
    }

    public void setColor(Color color, Color color2) {
        this.mLineColor = color;
        this.mFillColor = color2;
    }

    public void setWidth(int n) {
        this.mWidth = n;
    }

    public void setInsets(int n, int n2, int n3, int n4) {
        this.mInsets = new Insets(n, n2, n3, n4);
    }

    @Override
    public Insets getInsets() {
        return this.mInsets;
    }

    @Override
    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        int n = dimension.width - 1;
        int n2 = dimension.height - 1;
        int n3 = this.mRadius;
        this.mOffImage = this.createImage(n + 1, n2 + 1);
        this.mOffGraphics = this.mOffImage.getGraphics();
        this.mOffGraphics.setColor(this.getBackground());
        this.mOffGraphics.fillRect(0, 0, n, n2);
        Graphics2D graphics2D = (Graphics2D)this.mOffGraphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, n3);
        generalPath.lineTo(0.0f, n2 - n3);
        generalPath.append(new Arc2D.Float(0.0f, n2 - n3, n3, n3, 180.0f, 90.0f, 0), true);
        generalPath.lineTo(n - n3, n2);
        generalPath.append(new Arc2D.Float(n - n3, n2 - n3, n3, n3, 270.0f, 90.0f, 0), true);
        generalPath.lineTo(n, n3);
        generalPath.append(new Arc2D.Float(n - n3, 0.0f, n3, n3, 0.0f, 90.0f, 0), true);
        generalPath.lineTo(n3, 0.0f);
        generalPath.append(new Arc2D.Float(0.0f, 0.0f, n3, n3, 90.0f, 90.0f, 0), true);
        generalPath.closePath();
        graphics2D.setStroke(new BasicStroke(this.mWidth));
        this.mOffGraphics.setColor(this.mFillColor);
        graphics2D.fill(generalPath);
        this.mOffGraphics.setColor(this.mLineColor);
        graphics2D.draw(generalPath);
        graphics.drawImage(this.mOffImage, 0, 0, this);
        super.paint(graphics);
    }

    @Override
    public void update(Graphics graphics) {
        super.paint(graphics);
    }
}

