/*
 * Decompiled with CFR 0.152.
 */
package option.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;

public class RoundBox
extends Panel {
    public static final Color DEF_DISABLED_COLOR = new Color(128, 128, 128);
    private Insets mInsets;
    private FontMetrics mFm;
    private Color mLineColor;
    private Color mFillcolor;
    private Color mFontColor;
    private Color mTitleColor1;
    private Color mTitleColor2;
    private String mTitle;
    private Font mFont;

    public RoundBox(String string, int n) {
        this.mTitle = string;
        Font font = new Font("\uff2d\uff33\u3000\uff30\u30b4\u30b7\u30c3\u30af", 0, n);
        this.setFont(font);
        this.setInsets(2, 5, 5, 5);
        this.setFontColor(Color.WHITE);
        this.setLineColor(Color.BLACK);
        this.setTitleColor(Color.DARK_GRAY, Color.BLACK);
        this.setFillColor(Color.LIGHT_GRAY);
    }

    @Override
    public void setFont(Font font) {
        this.mFont = font;
        this.mFm = this.getFontMetrics(this.mFont);
    }

    public void setFontColor(Color color) {
        this.mFontColor = color;
    }

    public void setLineColor(Color color) {
        this.mLineColor = color;
    }

    public void setFillColor(Color color) {
        this.mFillcolor = color;
    }

    public Color getFillColor() {
        return this.mFillcolor;
    }

    public void setTitleColor(Color color, Color color2) {
        this.mTitleColor1 = color;
        this.mTitleColor2 = color2;
    }

    public void setTitle(String string) {
        this.mTitle = string;
    }

    public void setInsets(int n, int n2, int n3, int n4) {
        this.mInsets = new Insets(24 + n, n2, n3, n4);
    }

    @Override
    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.getParent() != null) {
            graphics2D.setColor(this.getParent().getBackground());
            graphics2D.fillRect(0, 0, dimension.width, dimension.height);
        }
        graphics2D.setColor(this.mFillcolor);
        graphics2D.fillRoundRect(2, 2, dimension.width - 3, dimension.height - 3, 16, 16);
        graphics2D.setColor(this.mLineColor);
        graphics2D.drawRoundRect(2, 2, dimension.width - 3, dimension.height - 3, 16, 16);
        int n = dimension.width - 0;
        graphics2D.setColor(Color.BLACK);
        GeneralPath generalPath = new GeneralPath(0);
        generalPath.moveTo(2.0f, 26.0f);
        generalPath.lineTo(n, 26.0f);
        generalPath.lineTo(n, 18.0f);
        Arc2D.Float float_ = new Arc2D.Float(n - 16, 2.0f, 16.0f, 16.0f, 0.0f, 90.0f, 0);
        generalPath.append(float_, true);
        generalPath.lineTo(18.0f, 2.0f);
        float_ = new Arc2D.Float(2.0f, 2.0f, 16.0f, 16.0f, 90.0f, 90.0f, 0);
        generalPath.append(float_, true);
        generalPath.lineTo(2.0f, 26.0f);
        generalPath.closePath();
        Rectangle rectangle = generalPath.getBounds();
        graphics2D.clip(generalPath);
        graphics2D.setColor(this.mTitleColor1);
        graphics2D.fill(rectangle);
        graphics2D.setColor(this.mTitleColor2);
        graphics2D.setStroke(new BasicStroke(2.0f));
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        int n2 = rectangle.y;
        while (n2 < rectangle.y + rectangle.height) {
            Line2D.Float float_2 = new Line2D.Float(rectangle.x, n2, rectangle.x + rectangle.width, n2);
            graphics2D.draw(float_2);
            n2 += 4;
        }
        graphics2D.setFont(this.mFont);
        graphics2D.setColor(this.mFontColor);
        graphics2D.drawString(this.mTitle, 16, this.mFm.getHeight() + 1);
        super.paint(graphics);
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    @Override
    public Insets getInsets() {
        return this.mInsets;
    }
}

