/*
 * Decompiled with CFR 0.152.
 */
package option.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import javax.swing.border.Border;

public class RoundBorder
implements Border {
    public static final Color DEF_DISABLED_COLOR = new Color(128, 128, 128);
    private Insets mInsets;
    private FontMetrics mFm;
    private Color mLineColor;
    private Color mFillcolor;
    private Color mFontColor;
    private Color mTitleColor1;
    private Color mTitleColor2;
    private String mTitle;
    private Font mFont;

    public RoundBorder(String string) {
        this(string, 12);
    }

    public RoundBorder(String string, int n) {
        this.mTitle = string;
        Font font = new Font("\uff2d\uff33\u3000\uff30\u30b4\u30b7\u30c3\u30af", 0, n);
        this.setFont(font);
        this.setInsets(2, 5, 5, 5);
        this.setFontColor(Color.BLACK);
        this.setLineColor(new Color(11317171));
        this.setTitleColor(new Color(13422515), new Color(232, 232, 232));
        this.setFillColor(Color.LIGHT_GRAY);
    }

    public void setFont(Font font) {
        this.mFont = font;
        this.mFm = null;
    }

    public void setFontColor(Color color) {
        this.mFontColor = color;
    }

    public void setLineColor(Color color) {
        this.mLineColor = color;
    }

    public void setFillColor(Color color) {
        this.mFillcolor = color;
    }

    public Color getFillColor() {
        return this.mFillcolor;
    }

    public void setTitleColor(Color color, Color color2) {
        this.mTitleColor1 = color;
        this.mTitleColor2 = color2;
    }

    public void setTitle(String string) {
        this.mTitle = string;
    }

    public void setInsets(int n, int n2, int n3, int n4) {
        this.mInsets = new Insets(24 + n, n2, n3, n4);
    }

    @Override
    public Insets getBorderInsets(Component component) {
        return this.mInsets;
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Dimension dimension = new Dimension(n3, n4);
        Graphics2D graphics2D = (Graphics2D)graphics;
        AffineTransform affineTransform = graphics2D.getTransform();
        Shape shape = graphics2D.getClip();
        Color color = graphics2D.getColor();
        Font font = graphics2D.getFont();
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Stroke stroke = graphics2D.getStroke();
        if (this.mFm == null) {
            this.mFm = graphics.getFontMetrics(this.mFont);
        }
        graphics2D.translate(n, n2);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(this.mLineColor);
        graphics2D.drawRoundRect(2, 2, dimension.width - 3, dimension.height - 3, 16, 16);
        int n5 = dimension.width - 0;
        graphics2D.setColor(Color.BLACK);
        GeneralPath generalPath = new GeneralPath(0);
        generalPath.moveTo(2.0f, 24.0f);
        generalPath.lineTo(n5, 24.0f);
        generalPath.lineTo(n5, 18.0f);
        Arc2D.Float float_ = new Arc2D.Float(n5 - 16, 2.0f, 16.0f, 16.0f, 0.0f, 90.0f, 0);
        generalPath.append(float_, true);
        generalPath.lineTo(18.0f, 2.0f);
        float_ = new Arc2D.Float(2.0f, 2.0f, 16.0f, 16.0f, 90.0f, 90.0f, 0);
        generalPath.append(float_, true);
        generalPath.lineTo(2.0f, 24.0f);
        generalPath.closePath();
        Rectangle rectangle = generalPath.getBounds();
        graphics2D.clip(generalPath);
        graphics2D.setColor(this.mTitleColor1);
        graphics2D.fill(rectangle);
        graphics2D.setColor(this.mTitleColor2);
        graphics2D.setStroke(new BasicStroke(2.0f));
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        int n6 = rectangle.y;
        while (n6 < rectangle.y + rectangle.height) {
            Line2D.Float float_2 = new Line2D.Float(rectangle.x, n6, rectangle.x + rectangle.width, n6);
            graphics2D.draw(float_2);
            n6 += 4;
        }
        graphics2D.setFont(this.mFont);
        graphics2D.setColor(this.mFontColor);
        graphics2D.drawString(this.mTitle, 16, this.mFm.getHeight() + 1);
        graphics2D.setTransform(affineTransform);
        graphics2D.setFont(font);
        graphics2D.setColor(color);
        graphics2D.setClip(shape);
        graphics2D.setStroke(stroke);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
    }

    public Dimension getMinimumSize(Component component) {
        if (this.mFm == null) {
            this.mFm = component.getFontMetrics(this.mFont);
        }
        Insets insets = this.getBorderInsets(component);
        Dimension dimension = new Dimension(insets.right + insets.left, insets.top + insets.bottom);
        dimension.width = Math.max(this.mFm.stringWidth(this.mTitle == null ? "" : this.mTitle), dimension.width) + 32;
        return dimension;
    }
}

