/*
 * Decompiled with CFR 0.152.
 */
package option.gui;

import gui.basic.ImageIcon;
import gui.basic.LabelComponent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import option.gui.ErrorIconPanel;
import option.gui.IconPanel;
import option.gui.InfoIconPanel;
import option.gui.WarningIconPanel;

public class JOptionDialog
extends JDialog
implements ActionListener,
KeyListener {
    public static final int CLOSE_OK = 0;
    public static final int CLOSE_CANCEL = 1;
    public static final int CLOSE_YES = 2;
    public static final int CLOSE_NO = 3;
    public static final int BUTTON_NONE = 0;
    public static final int BUTTON_OK = 1;
    public static final int BUTTON_CLOSE = 2;
    public static final int BUTTON_CANCEL = 4;
    public static final int BUTTON_YES = 8;
    public static final int BUTTON_NO = 16;
    public static final int ICON_NONE = -1;
    public static final int ICON_INFO = 0;
    public static final int ICON_WARNING = 1;
    public static final int ICON_ERROR = 2;
    protected static final int IDX_OK = 0;
    protected static final int IDX_SELECT = 1;
    protected static final int IDX_CLOSE = 2;
    protected static final int IDX_CANCEL = 3;
    protected static final int IDX_YES = 4;
    protected static final int IDX_NO = 5;
    protected static final int NUMBER_OF_BUTTONS = 6;
    protected String[] BUTTON_NAMES = new String[]{"\u3000\u3000OK\u3000\u3000", "\u3000SELECT\u3000", "\u3000\u9589\u3058\u308b\u3000", "\u3000\u30ad\u30e3\u30f3\u30bb\u30eb\u3000", "\u3000 \u306f\u3044 \u3000", "\u3000\u3044\u3044\u3048\u3000"};
    protected static final String DIALOG_DIRECTORY = "dialog";
    protected static final String BACKGROUND_IMAGE = "background.gif";
    protected static final String DEFAULT_FONT = "monospaced";
    protected static IconPanel[] mIcons = null;
    protected JButton[] mButtons;
    protected JButton mBtnExec;
    protected int mCloseState = 1;
    protected Frame mFrame;
    protected Object mObject;

    public JOptionDialog(Frame frame, Object object, String string, int n) {
        this(frame, object, string, n, -1);
        this.mFrame = frame;
    }

    public JOptionDialog(Frame frame, Object object, String string, int n, int n2) {
        super(frame, string, true);
        this.mFrame = frame;
        this.initDialog(object, n, n2);
    }

    public JOptionDialog(Frame frame, Object object, String string, int n, int n2, boolean bl) {
        super(frame, string, bl);
        this.mFrame = frame;
        this.initDialog(object, n, n2);
    }

    public JOptionDialog(Frame frame, Object object, String string, int n, int n2, String[] stringArray) {
        super(frame, string, true);
        this.mFrame = frame;
        int n3 = 0;
        while (n3 < Math.min(this.BUTTON_NAMES.length, stringArray.length)) {
            this.BUTTON_NAMES[n3] = stringArray[n3];
            ++n3;
        }
        this.initDialog(object, n, n2);
    }

    public JOptionDialog(Frame frame, Object object, String[] stringArray, String string, int n, int n2) {
        super(frame, string, true);
        this.mFrame = frame;
        this.initDialog(object, stringArray, n, n2);
    }

    protected void initDialog(Object object, int n, int n2) {
        this.initDialog(object, null, n, n2);
    }

    protected void initDialog(Object stringArray, String[] stringArray2, int n, int n2) {
        stringArray = stringArray instanceof String ? ((String)stringArray).split("\n") : stringArray;
        this.setObject(stringArray);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 10));
        Component component = null;
        if (stringArray instanceof Component) {
            component = (Component)stringArray;
        } else if (stringArray instanceof String) {
            component = this.createStringContent(new String[]{(String)stringArray});
        } else if (stringArray instanceof String[]) {
            component = this.createStringContent(stringArray);
        } else if (stringArray instanceof Image) {
            component = this.createImageContent((Image)stringArray);
        }
        if (component != null) {
            jPanel.add(component, "Center");
        }
        this.initIcons();
        component = this.createIcon(n2);
        if (component != null) {
            jPanel.add(component, "West");
        }
        if (stringArray2 == null) {
            this.initButton();
        } else {
            this.initButton(n, stringArray2);
        }
        component = this.createButtons(n);
        if (component != null) {
            jPanel.add(component, "South");
        }
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "Center");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                JOptionDialog.this.closeDialog();
            }
        });
        this.setResizable(false);
        this.addKeyListener(this);
        this.pack();
    }

    protected Component createStringContent(String[] stringArray) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(stringArray.length, 1));
        Font font = new Font(DEFAULT_FONT, 0, 14);
        Insets insets = stringArray.length > 1 ? new Insets(2, 20, 2, 20) : new Insets(5, 20, 5, 20);
        int n = 0;
        while (n < stringArray.length) {
            LabelComponent labelComponent = new LabelComponent(stringArray[n]);
            labelComponent.setFont(font);
            labelComponent.setInsets(insets);
            jPanel.add((Component)labelComponent);
            ++n;
        }
        return jPanel;
    }

    protected Component createImageContent(Image image) {
        return new ImageIcon(image);
    }

    protected Component createIcon(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new FlowLayout(1, 10, 10));
                jPanel.add(mIcons[n]);
                return jPanel;
            }
        }
        return null;
    }

    protected Component createButtons(int n) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 10, 0));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 15, 10));
        if (n == 0) {
            return null;
        }
        this.mBtnExec = null;
        if ((n & 1) != 0) {
            this.mBtnExec = this.mButtons[0];
        } else if ((n & 8) != 0) {
            this.mBtnExec = this.mButtons[4];
        }
        if (this.mBtnExec != null) {
            jPanel.add(this.mBtnExec);
        }
        if ((n & 0x10) != 0) {
            jPanel.add(this.mButtons[5]);
        }
        JButton jButton = null;
        if ((n & 2) != 0) {
            jButton = this.mButtons[2];
        } else if ((n & 4) != 0) {
            jButton = this.mButtons[3];
        }
        if (jButton != null) {
            jPanel.add(jButton);
        }
        return jPanel;
    }

    protected void initIcons() {
        if (mIcons == null) {
            mIcons = new IconPanel[3];
            JOptionDialog.mIcons[0] = new InfoIconPanel();
            JOptionDialog.mIcons[1] = new WarningIconPanel();
            JOptionDialog.mIcons[2] = new ErrorIconPanel();
        }
    }

    protected void initButton() {
        this.mButtons = new JButton[this.BUTTON_NAMES.length];
        int n = 0;
        while (n < this.BUTTON_NAMES.length) {
            this.mButtons[n] = new JButton(this.BUTTON_NAMES[n]);
            this.mButtons[n].addActionListener(this);
            ++n;
        }
    }

    protected void initButton(int n, String[] stringArray) {
        int n2 = 0;
        this.mButtons = new JButton[this.BUTTON_NAMES.length];
        int n3 = 0;
        while (n3 < this.BUTTON_NAMES.length) {
            String string = this.BUTTON_NAMES[n3];
            boolean bl = false;
            switch (n3) {
                case 0: {
                    if ((n & 1) == 0) break;
                    bl = true;
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    if ((n & 2) == 0) break;
                    bl = true;
                    break;
                }
                case 3: {
                    if ((n & 4) == 0) break;
                    bl = true;
                    break;
                }
                case 4: {
                    if ((n & 8) == 0) break;
                    bl = true;
                    break;
                }
                case 5: {
                    if ((n & 0x10) == 0) break;
                    bl = true;
                }
            }
            if (bl) {
                if (stringArray[n2] != null && !stringArray[n2].equals("")) {
                    string = stringArray[n2];
                }
                ++n2;
            }
            this.mButtons[n3] = new JButton(string);
            this.mButtons[n3].addActionListener(this);
            ++n3;
        }
    }

    public Object getObject() {
        return this.mObject;
    }

    protected void setObject(Object object) {
        this.mObject = object;
    }

    public void showDialog() {
        int n;
        int n2;
        Dimension dimension = this.getSize();
        Container container = this.getParent();
        if (container == null) {
            Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
            n2 = (dimension2.width - dimension.width) / 2;
            n = (dimension2.height - dimension.height) / 2;
        } else {
            Dimension dimension3 = container.getSize();
            Point point = container.getLocationOnScreen();
            n2 = point.x + (dimension3.width - dimension.width) / 2;
            n = point.y + (dimension3.height - dimension.height) / 2;
        }
        this.setLocation(n2, n);
        if (container != null) {
            container.setEnabled(false);
        }
        this.setVisible(true);
    }

    public void closeDialog() {
        Container container = this.getParent();
        if (container != null) {
            container.setEnabled(true);
        }
        this.setVisible(false);
        this.dispose();
    }

    protected int searchButton(Object object) {
        int n = 0;
        while (n < this.mButtons.length) {
            if (this.mButtons[n] == object) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int getCloseState() {
        return this.mCloseState;
    }

    protected void onButtonDown(Object object) {
        switch (this.searchButton(object)) {
            case 4: {
                this.mCloseState = 2;
                break;
            }
            case 0: 
            case 1: {
                this.mCloseState = 0;
                break;
            }
            case 5: {
                this.mCloseState = 3;
                break;
            }
            case 2: 
            case 3: {
                this.mCloseState = 1;
            }
        }
        this.closeDialog();
    }

    public Frame getFrame() {
        return this.mFrame;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.onButtonDown(actionEvent.getSource());
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() != 10) {
            return;
        }
        this.onButtonDown(keyEvent.getSource());
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }
}

