/*
 * Decompiled with CFR 0.152.
 */
package option.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import javax.swing.border.Border;
import option.gui.GradientDefine;

public class GradientBorder
implements Border {
    protected Insets mInsets;
    protected FontMetrics mFm;
    protected Color mLineColor;
    protected Color mFillcolor;
    protected Color mFontColor;
    protected String mTitle;
    protected Font mFont;
    protected Color mTitleLineColor;
    protected GradientDefine[] mGradientDefines;

    public GradientBorder(String string) {
        this(string, 12);
    }

    public GradientBorder(String string, int n) {
        this.mTitle = string;
        Font font = new Font("\uff2d\uff33\u3000\uff30\u30b4\u30b7\u30c3\u30af", 0, n);
        this.setFont(font);
        this.setInsets(2, 5, 5, 5);
        this.setFontColor(new Color(0x464D46));
        this.setLineColor(new Color(11317171));
        this.setFillColor(Color.LIGHT_GRAY);
        this.setTitleLineColor(new Color(8284223));
        GradientDefine[] gradientDefineArray = new GradientDefine[]{new GradientDefine(0.0f, 0.0f, new Color(16052449), 0.0f, 0.5f, new Color(15523509)), new GradientDefine(0.0f, 0.5f, new Color(14863245), 0.0f, 0.8f, new Color(15398355)), new GradientDefine(0.0f, 0.8f, new Color(15398355), 0.0f, 1.0f, new Color(10718296))};
        this.setGradientDefines(gradientDefineArray);
    }

    public void setFont(Font font) {
        this.mFont = font;
        this.mFm = null;
    }

    public void setFontColor(Color color) {
        this.mFontColor = color;
    }

    public void setLineColor(Color color) {
        this.mLineColor = color;
    }

    public void setFillColor(Color color) {
        this.mFillcolor = color;
    }

    public Color getFillColor() {
        return this.mFillcolor;
    }

    public void setTitleLineColor(Color color) {
        this.mTitleLineColor = color;
    }

    public Color getTitleLineColor() {
        return this.mTitleLineColor;
    }

    public void setTitle(String string) {
        this.mTitle = string;
    }

    public void setInsets(int n, int n2, int n3, int n4) {
        this.mInsets = new Insets(24 + n, n2, n3, n4);
    }

    @Override
    public Insets getBorderInsets(Component component) {
        return this.mInsets;
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    public void setGradientDefines(GradientDefine[] gradientDefineArray) {
        this.mGradientDefines = gradientDefineArray;
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Dimension dimension = new Dimension(n3, n4);
        Graphics2D graphics2D = (Graphics2D)graphics;
        AffineTransform affineTransform = graphics2D.getTransform();
        Shape shape = graphics2D.getClip();
        Color color = graphics2D.getColor();
        Font font = graphics2D.getFont();
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Stroke stroke = graphics2D.getStroke();
        if (this.mFm == null) {
            this.mFm = graphics.getFontMetrics(this.mFont);
        }
        graphics2D.translate(n, n2);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(this.mLineColor);
        graphics2D.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        int n5 = dimension.width;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        GradientDefine[] gradientDefineArray = this.mGradientDefines;
        int n6 = this.mGradientDefines.length;
        int n7 = 0;
        while (n7 < n6) {
            GradientDefine gradientDefine = gradientDefineArray[n7];
            int n8 = (int)(23.0f * gradientDefine.mY1);
            int n9 = (int)(23.0f * gradientDefine.mY2);
            GradientPaint gradientPaint = new GradientPaint(0.0f, n8, gradientDefine.mColor1, 0.0f, n9, gradientDefine.mColor2);
            graphics2D.setPaint(gradientPaint);
            graphics2D.fill(new Rectangle(0, n8, n5 - 1, n9 - n8));
            ++n7;
        }
        graphics2D.setStroke(new BasicStroke(1.0f));
        graphics2D.setColor(this.mTitleLineColor);
        graphics2D.drawRect(0, 0, n5 - 1, 23);
        graphics2D.setFont(this.mFont);
        graphics2D.setColor(this.mFontColor);
        graphics2D.drawString(this.mTitle, 16, this.mFm.getHeight() + 1);
        graphics2D.setTransform(affineTransform);
        graphics2D.setFont(font);
        graphics2D.setColor(color);
        graphics2D.setClip(shape);
        graphics2D.setStroke(stroke);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
    }

    public Dimension getMinimumSize(Component component) {
        if (this.mFm == null) {
            this.mFm = component.getFontMetrics(this.mFont);
        }
        Insets insets = this.getBorderInsets(component);
        Dimension dimension = new Dimension(insets.right + insets.left, insets.top + insets.bottom);
        dimension.width = Math.max(this.mFm.stringWidth(this.mTitle == null ? "" : this.mTitle), dimension.width) + 32;
        return dimension;
    }
}

