/*
 * Decompiled with CFR 0.152.
 */
package option.gad.toex.common.service.pickup;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class GdInquirer<REQ, RES, PAR> {
    private Log mLog = LogFactory.getLog(GdInquirer.class);

    protected GdInquirer() {
    }

    public PAR pickup(String string, REQ REQ) throws IllegalDataTypeException, ParseFailureException, IllegalStateException {
        try {
            Object object = this.serialize(REQ);
            if (this.mLog.isDebugEnabled()) {
                this.mLog.debug((Object)("\n" + new String((byte[])object)));
            }
            Object object2 = this.inquiry(string, object);
            if (this.mLog.isDebugEnabled()) {
                this.mLog.debug((Object)("\n" + new String((byte[])object2)));
            }
            this.checkDataType(object2);
            RES RES = this.deserialize(object2);
            String string2 = this.parseState(RES);
            this.mLog.info((Object)string2);
            return this.parseResult(RES);
        }
        catch (IllegalDataTypeException illegalDataTypeException) {
            this.mLog.error((Object)illegalDataTypeException.getMessage());
            throw illegalDataTypeException;
        }
        catch (IllegalStateException illegalStateException) {
            this.mLog.info((Object)illegalStateException.getMessage());
            throw illegalStateException;
        }
        catch (ParseFailureException parseFailureException) {
            this.mLog.info((Object)parseFailureException.getMessage());
            throw parseFailureException;
        }
    }

    protected abstract Object serialize(REQ var1);

    protected abstract Object inquiry(String var1, Object var2);

    protected abstract void checkDataType(Object var1) throws IllegalDataTypeException;

    protected abstract RES deserialize(Object var1) throws ParseFailureException, IllegalStateException;

    protected abstract String parseState(RES var1) throws ParseFailureException, IllegalStateException;

    protected abstract PAR parseResult(RES var1) throws ParseFailureException;

    public static class IllegalDataTypeException
    extends Exception {
        public IllegalDataTypeException(String string) {
            super(string);
        }
    }

    public static class ParseFailureException
    extends Exception {
        public ParseFailureException(String string) {
            super(string);
        }
    }
}

