/*
 * Decompiled with CFR 0.152.
 */
package option.gad.toex.client.service.step;

import java.util.HashMap;
import java.util.Map;
import option.gad.client.util.NetHomeUtil;
import option.gad.core.inject.GdInstanceFactory;
import option.gad.toex.client.doc.GdToexLayer;
import option.gad.toex.client.gui.step.GdNavigationBar;
import option.gad.toex.client.gui.step.GdStepComponentManager;
import option.gad.toex.client.service.step.GdChangeStepException;
import option.gad.toex.client.service.step.GdStep;
import option.gad.toex.client.service.step.GdStepLogic;
import option.gad.toex.client.service.step.GdStepState;
import option.gad.toex.client.service.step.GdTransitionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class GdStepManager {
    protected Log mLog = LogFactory.getLog(GdStepManager.class);
    protected Map<GdStepState, GdStep> mStepMap = new HashMap<GdStepState, GdStep>();
    protected GdStepState mState = null;

    protected GdStepManager() {
        this.load();
    }

    protected abstract GdStep[] configSteps();

    protected abstract GdNavigationBar configNavigationBar();

    protected void load() {
        GdStep[] gdStepArray = this.getSteps();
        int n = gdStepArray.length;
        int n2 = 0;
        while (n2 < n) {
            GdStep gdStep = gdStepArray[n2];
            this.mStepMap.put(gdStep.state, gdStep);
            ++n2;
        }
        this.setState(this.getSteps()[0].state);
    }

    public void setState(GdStepState gdStepState) {
        this.mState = gdStepState;
    }

    public GdStepState getState() {
        return this.mState;
    }

    public GdStepLogic getLogic() {
        return this.getLogic(this.mState);
    }

    public GdStepLogic getLogic(GdStepState gdStepState) {
        return this.mStepMap.get((Object)gdStepState).logic;
    }

    public boolean canTransit(GdStepState gdStepState) {
        if (!this.mStepMap.get((Object)gdStepState).transition.booleanValue()) {
            return false;
        }
        return !this.mStepMap.get((Object)this.mState).logic.canTransit(gdStepState);
    }

    public void setTransition(GdStepState gdStepState, Boolean bl) {
        GdNavigationBar gdNavigationBar = this.configNavigationBar();
        if (gdNavigationBar == null) {
            return;
        }
        gdNavigationBar.setState(gdStepState, false, bl);
        this.mStepMap.get((Object)gdStepState).transition = bl;
    }

    public void setTransitions(Map<GdStepState, Boolean> map) {
        for (GdStepState gdStepState : map.keySet()) {
            this.setTransition(gdStepState, map.get(gdStepState));
        }
    }

    public void goNext() {
        GdToexLayer gdToexLayer = (GdToexLayer)((Object)NetHomeUtil.getCurrentLayer());
        if (gdToexLayer == null) {
            return;
        }
        this.toStep(gdToexLayer.getStepState().next());
    }

    public void goPrev() {
        GdToexLayer gdToexLayer = (GdToexLayer)((Object)NetHomeUtil.getCurrentLayer());
        if (gdToexLayer == null) {
            return;
        }
        this.toStep(gdToexLayer.getStepState().prev());
    }

    public void toPrev() {
        GdToexLayer gdToexLayer = (GdToexLayer)((Object)NetHomeUtil.getCurrentLayer());
        if (gdToexLayer == null) {
            return;
        }
        this.toStep(gdToexLayer.getStepState().prev());
    }

    public void toNext() {
        GdToexLayer gdToexLayer = (GdToexLayer)((Object)NetHomeUtil.getCurrentLayer());
        if (gdToexLayer == null) {
            return;
        }
        this.toStep(gdToexLayer.getStepState().next());
    }

    public void toStep(GdStepState gdStepState) {
        GdToexLayer gdToexLayer = (GdToexLayer)((Object)NetHomeUtil.getCurrentLayer());
        if (gdToexLayer == null) {
            return;
        }
        GdStepState gdStepState2 = gdToexLayer.getStepState();
        this.toStep(gdStepState2, gdStepState);
    }

    public void toStep(GdStepState gdStepState, GdStepState gdStepState2) {
        if (gdStepState == gdStepState2) {
            return;
        }
        this.moveStep(gdStepState, gdStepState2);
    }

    /*
     * Unable to fully structure code
     */
    protected void moveStep(GdStepState var1_1, GdStepState var2_2) throws GdTransitionException {
        block12: {
            if (var1_1 == var2_2) {
                return;
            }
            var3_3 = var1_1;
            var4_4 = this.getLogic();
            try {
                if (var2_2.getNum() >= var1_1.getNum()) ** GOTO lbl44
                while (var3_3 != var2_2) {
                    block11: {
                        var5_5 = var3_3.prev();
                        if (var5_5 == null) {
                            return;
                        }
                        try {
                            var4_4.beforePrev(var1_1, var2_2);
                            var3_3 = var5_5;
                            var4_4.toPrev();
                            var4_4.afterPrev(var1_1, var2_2);
                        }
                        catch (GdChangeStepException var6_7) {
                            var7_9 = var6_7.getStepState();
                            if (var7_9 == null) break block11;
                            var2_2 = var5_5 = var7_9;
                        }
                    }
                    this.setState(var5_5);
                    var4_4 = this.getLogic();
                    var4_4.init();
                }
                break block12;
lbl-1000:
                // 1 sources

                {
                    block13: {
                        var5_6 = var3_3.next();
                        if (var5_6 == null) {
                            return;
                        }
                        try {
                            var4_4.beforeNext(var1_1, var2_2);
                            var3_3 = var5_6;
                            var4_4.toNext();
                            var4_4.afterNext(var1_1, var2_2);
                        }
                        catch (GdChangeStepException var6_8) {
                            var7_10 = var6_8.getStepState();
                            if (var7_10 == null) break block13;
                            var2_2 = var5_6 = var7_10;
                        }
                    }
                    this.setState(var5_6);
                    var4_4 = this.getLogic();
                    var4_4.init();
lbl44:
                    // 2 sources

                    ** while (var3_3 != var2_2)
                }
lbl45:
                // 1 sources

            }
            catch (GdTransitionException v0) {
                var2_2 = var3_3;
                this.setState(var3_3);
            }
        }
        this.stepMoved(var1_1, var2_2);
        var4_4.boot();
    }

    protected void stepMoved(GdStepState gdStepState, GdStepState gdStepState2) {
        this.updateNavigationBar(gdStepState, gdStepState2);
        this.selectStepComponent(gdStepState2);
    }

    protected void updateNavigationBar(GdStepState gdStepState, GdStepState gdStepState2) {
        GdNavigationBar gdNavigationBar = this.configNavigationBar();
        if (gdNavigationBar == null) {
            return;
        }
        int n = this.getSteps().length;
        int n2 = 0;
        while (n2 < n) {
            GdStepState gdStepState3 = this.getSteps()[n2].state;
            GdStepLogic gdStepLogic = this.getLogic(gdStepState3);
            boolean bl = gdStepLogic.canTransit(gdStepState3);
            boolean bl2 = gdStepState2 == gdStepState3;
            gdNavigationBar.setState(gdStepState3, bl2, bl);
            ++n2;
        }
    }

    protected void selectStepComponent(GdStepState gdStepState) {
        GdStepComponentManager gdStepComponentManager = (GdStepComponentManager)GdInstanceFactory.getInstance().getInstance(GdStepComponentManager.class, new Object[0]);
        gdStepComponentManager.select(gdStepState);
    }

    public GdStep[] getSteps() {
        return this.configSteps();
    }
}

