/*
 * Decompiled with CFR 0.152.
 */
package option.gad.toex.client.service.estimate;

import option.gad.client.pdf.GdPdfUtil;
import option.gad.toex.client.service.estimate.GdEstimatePdfUtil;
import option.gad.toex.client.service.estimate.GdSekisan;
import option.gad.toex.client.service.estimate.GdSekisanDrawer;
import option.gad.toex.client.service.estimate.GdStringSekisan;
import option.pdf.PdfCommandGraphics;

public class GdStringSekisanDrawer
extends GdSekisanDrawer {
    private static final int[][] DRAW_POINTS = new int[][]{{45, 129, 49}, {22, 134, 57}, {22, 139, 57}, {22, 144, 57}};
    protected int[][] mDrawPoints = null;
    protected int[] mLengths = null;

    public GdStringSekisanDrawer() {
        this(DRAW_POINTS);
    }

    protected GdStringSekisanDrawer(int[][] nArray) {
        this.mDrawPoints = nArray;
        this.mLengths = this.createLengths(this.mDrawPoints);
    }

    private int[] createLengths(int[][] nArray) {
        int[] nArray2 = new int[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            nArray2[n] = nArray[n][2];
            ++n;
        }
        return nArray2;
    }

    @Override
    public void draw(PdfCommandGraphics pdfCommandGraphics, String string, GdSekisan gdSekisan) {
        GdStringSekisan gdStringSekisan = (GdStringSekisan)gdSekisan;
        String[] stringArray = GdPdfUtil.shortenStrings(gdStringSekisan.mSekisan, gdStringSekisan.mSeparator, this.mLengths);
        pdfCommandGraphics.setFont(GdEstimatePdfUtil.getFont(0));
        int n = 0;
        while (n < stringArray.length) {
            int[] nArray = this.mDrawPoints[n];
            pdfCommandGraphics.drawString(stringArray[n], nArray[0], nArray[1]);
            ++n;
        }
    }
}

