/*
 * Decompiled with CFR 0.152.
 */
package option.gad.toex.client.gui.estimate;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import nethome.ui.gui.NethomeCommonDialog;
import option.gad.client.pdf.GdPdfUtil;
import option.gad.core.util.Closure;
import option.gad.ext.lixil.estsys.entity.GdRemark;
import option.gad.toex.client.gui.estimate.GdRemarkComponent;
import option.gui.JOptionDialogUtil;

public class GdRemarkDialog
extends NethomeCommonDialog {
    protected Frame mOwner;
    protected GdRemarkComponent mRemarkComp;
    protected GdRemark mRemark;
    protected List<Closure<String[], Void>> mChangeDocumentListenerList = new ArrayList<Closure<String[], Void>>();
    protected int mColSize = 100;
    protected int mRowSize = 3;

    public GdRemarkDialog(Frame frame, String string, boolean bl, GdRemark gdRemark) {
        super(frame, string, bl);
        this.mOwner = frame;
        this.mRemark = gdRemark;
        this.mRemarkComp = new GdRemarkComponent();
        this.mRemarkComp.setRemark(this.mRemark.mRemarks);
        this.mButtonExec = this.createOKButton();
        this.mButtonCancel = this.createCancelButton();
        this.setUI(this.mRemarkComp);
    }

    protected JButton createOKButton() {
        JButton jButton = (JButton)this.mControl.addButton("OK", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GdRemarkDialog.this.actionOKButton();
            }
        });
        jButton.setPreferredSize(new Dimension(80, 25));
        return jButton;
    }

    protected JButton createCancelButton() {
        JButton jButton = (JButton)this.mControl.addButton("\u30ad\u30e3\u30f3\u30bb\u30eb", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GdRemarkDialog.this.actionCancelButton();
            }
        });
        jButton.setPreferredSize(new Dimension(80, 25));
        return jButton;
    }

    public void addChangeDocumentListener(Closure<String[], Void> closure) {
        this.mChangeDocumentListenerList.add(closure);
    }

    protected void actionOKButton() {
        if (this.updateRemark()) {
            this.setVisible(false);
        } else {
            String string = "\u5165\u529b\u3055\u308c\u305f\u5185\u5bb9\u306f\u3001\u8868\u793a\u3067\u304d\u308b\u6587\u5b57\u6570\u3092\u8d85\u3048\u3066\u3044\u307e\u3059\u3002";
            JOptionDialogUtil.showWarningDialog(string);
        }
    }

    protected void actionCancelButton() {
        this.setVisible(false);
    }

    protected boolean updateRemark() {
        String[] stringArray = this.mRemarkComp.getRemark();
        if (GdRemarkDialog.canSetRemark(stringArray, this.mColSize, this.mRowSize)) {
            this.changeDocument(stringArray);
            return true;
        }
        return false;
    }

    protected static boolean canSetRemark(String[] stringArray, int n, int n2) {
        int n3 = stringArray.length;
        if (n3 > n2) {
            return false;
        }
        int n4 = n / 2;
        int n5 = 0;
        while (n5 < n3) {
            char[] cArray = stringArray[n5].toCharArray();
            float f = 0.0f;
            int n6 = 0;
            while (n6 < cArray.length) {
                if ((f += GdPdfUtil.getCharacterWidth(cArray[n6])) > (float)n4) {
                    return false;
                }
                ++n6;
            }
            ++n5;
        }
        return true;
    }

    protected void changeDocument(String[] stringArray) {
        for (Closure<String[], Void> closure : this.mChangeDocumentListenerList) {
            closure.execute((Object)stringArray);
        }
    }

    public void setColSize(int n) {
        this.mColSize = n;
    }

    public void setRowSize(int n) {
        this.mRowSize = n;
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl, (Component)this.mParentFrame, 0);
    }
}

