/*
 * Decompiled with CFR 0.152.
 */
package option.gad.core.resource;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import option.gad.core.resource.GdResourceInquirer;
import option.gad.core.resource.GdResourceRequest;
import option.gad.core.resource.GdResourceResponse;

public abstract class GdResourceService<REQ extends GdResourceRequest, RES extends GdResourceResponse> {
    private HashMap<String, Future<Object>> futureMap = new HashMap();
    private Boolean multiThread = true;

    protected GdResourceService() {
    }

    protected abstract String configURL();

    protected abstract Map<String, Integer> configRequestInfos();

    protected abstract GdResourceInquirer<REQ, RES> configInquirer();

    public void request() {
        this.request(false, Integer.MAX_VALUE);
    }

    public void request(boolean bl) {
        this.request(bl, Integer.MAX_VALUE);
    }

    public void request(int n) {
        this.request(false, n);
    }

    public void request(boolean bl, int n) {
        ThreadFactory threadFactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable);
                thread.setPriority(1);
                return thread;
            }
        };
        ExecutorService executorService = null;
        executorService = this.multiThread != false ? Executors.newCachedThreadPool(threadFactory) : Executors.newSingleThreadExecutor(threadFactory);
        for (Map.Entry<String, Integer> entry : this.configRequestInfos().entrySet()) {
            Integer n2;
            final String string = entry.getKey();
            if (!bl && this.futureMap.containsKey(string) || (n2 = entry.getValue()) > n) continue;
            Future<Object> future = executorService.submit(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return GdResourceService.this.request(string);
                }
            });
            this.futureMap.put(string, future);
        }
    }

    private Object request(String string) {
        Object var2_2 = null;
        try {
            var2_2 = this.configInquirer().request(this.configURL(), this.createRequest(string));
        }
        catch (Exception exception) {
            throw new RuntimeException("\u30b5\u30fc\u30d0\u304b\u3089\u306e\u5fdc\u7b54\u3067\u7570\u5e38\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002", exception);
        }
        return var2_2;
    }

    protected abstract REQ createRequest(String var1);

    public void setMultiThread(boolean bl) {
        this.multiThread = bl;
    }

    public Future<Object> getFuture(String string) {
        return this.futureMap.get(string);
    }

    public Map<String, Future<Object>> getFutureMap() {
        return new HashMap<String, Future<Object>>(this.futureMap);
    }
}

