/*
 * Decompiled with CFR 0.152.
 */
package option.gad.core.resource;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import option.gad.core.inquiry.GdDefaultInquiryResponseType;
import option.gad.core.inquiry.GdInquirer;
import option.gad.core.resource.GdResourceRequest;
import option.gad.core.resource.GdResourceRequestDao;
import option.gad.core.resource.GdResourceResponse;
import option.gad.core.resource.GdResourceResponseDao;
import option.gad.core.util.ReflectUtil;

public abstract class GdResourceInquirer<REQ extends GdResourceRequest, RES extends GdResourceResponse>
extends GdInquirer<REQ, RES, Object> {
    protected GdResourceInquirer() {
    }

    public abstract RES configResponse();

    public abstract GdResourceRequestDao<REQ> configRequestDao();

    public abstract GdResourceResponseDao<RES> configResponseDao();

    @Override
    protected Object serialize(REQ REQ) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.configRequestDao().save(byteArrayOutputStream, REQ);
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    protected void checkDataType(Object object) throws GdInquirer.IllegalDataTypeException {
        String string = null;
        if (object != null) {
            if (object instanceof byte[]) {
                return;
            }
            string = object.getClass().getName();
        }
        throw new GdInquirer.IllegalDataTypeException("resData type is " + string + "]");
    }

    @Override
    protected RES deserialize(Object object) throws GdInquirer.ParseFailureException, IllegalStateException {
        byte[] byArray = (byte[])object;
        RES RES = this.configResponse();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        this.configResponseDao().load(byteArrayInputStream, RES);
        return RES;
    }

    @Override
    protected String parseState(RES RES) throws GdInquirer.ParseFailureException, IllegalStateException {
        if (((GdResourceResponse)RES).responseType == GdDefaultInquiryResponseType.ERROR) {
            throw new IllegalStateException(((GdResourceResponse)RES).message);
        }
        return ((GdResourceResponse)RES).message;
    }

    @Override
    protected Object parseResult(RES RES) throws GdInquirer.ParseFailureException {
        return ReflectUtil.getFieldValue(RES, (String)((GdResourceResponse)RES).key);
    }
}

