/*
 * Decompiled with CFR 0.152.
 */
package option.gad.core.resource;

import com.kt.annotation.Reflectable;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Future;
import option.gad.core.util.ReflectUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class GdAbstractResourceManager<RS> {
    private static final Log log = LogFactory.getLog(GdAbstractResourceManager.class);
    private Map<String, Future<Object>> futureMap;

    public void setFutureMap(Map<String, Future<Object>> map) {
        this.futureMap = map;
    }

    public void putFutureMap(Map<String, Future<Object>> map) {
        this.futureMap.putAll(map);
    }

    protected abstract RS configResources();

    protected <R> R getResource() {
        return this.getResource(this.getKey());
    }

    protected <R> R getResource(String string) {
        RS RS = this.configResources();
        Object object = ReflectUtil.getFieldValue(RS, (String)string);
        boolean bl = false;
        if (object == null) {
            bl = true;
        } else if (object instanceof Collection) {
            bl = ((Collection)object).isEmpty();
        }
        if (bl) {
            object = this.loadResource(string);
        }
        return (R)object;
    }

    protected <R> R loadResource(String string) {
        log.info((Object)("loading start [" + string + "] hashCode[" + this.hashCode() + "] futureMap[" + this.futureMap + "]"));
        if (this.futureMap == null) {
            log.error((Object)("loading failure [" + string + "]"));
            throw new IllegalStateException("futureMap is null");
        }
        Future<Object> future = this.futureMap.get(string);
        Object object = null;
        try {
            object = future.get();
            if (object == null) {
                log.error((Object)("loading failure [" + string + "]"));
                throw new IllegalStateException("resource is null");
            }
            RS RS = this.configResources();
            ReflectUtil.setFieldValue(RS, (String)string, (Object)object);
            log.info((Object)("loading completion [" + string + "]"));
        }
        catch (Exception exception) {
            log.info((Object)("loading failure [" + string + "]"));
            log.info((Object)"", (Throwable)exception);
        }
        return (R)object;
    }

    protected String getKey() {
        StackTraceElement stackTraceElement;
        String string = null;
        int n = 0;
        while (!(string = (stackTraceElement = Thread.currentThread().getStackTrace()[n++]).getMethodName()).equals("getStackTrace")) {
        }
        int n2 = n;
        while (n2 < n + 3) {
            StackTraceElement stackTraceElement2 = Thread.currentThread().getStackTrace()[n2];
            string = stackTraceElement2.getMethodName();
            Method method = ReflectUtil.getMethod((Object)this, (String)string, (Class[])new Class[0]);
            Reflectable reflectable = method.getAnnotation(Reflectable.class);
            if (reflectable != null) {
                string = reflectable.name();
            }
            ++n2;
        }
        String string2 = string.substring(4);
        char c = Character.toLowerCase(string.charAt(3));
        return String.valueOf(c) + string2;
    }
}

