/*
 * Decompiled with CFR 0.152.
 */
package option.gad.core.dao;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import option.gad.core.db.NoUniqueRuntimeException;
import option.gad.core.util.ListNotNullDecorator;
import option.gad.core.util.MasterUtil;
import option.gad.core.util.ObjectUtil;
import option.gad.core.util.StructUtil;
import option.gad.core.util.master.Master;

public class AbstractMasterDao<E> {
    public Master<E> mMaster;

    protected AbstractMasterDao() {
    }

    public E findOne(E e, boolean ... blArray) {
        return this.findOne(StructUtil.createMap(e).values(), blArray);
    }

    public E findOne(Object[] objectArray, boolean ... blArray) {
        return this.findOne((Collection<Object>)Arrays.asList(objectArray), blArray);
    }

    public E findOne(Collection<Object> collection, boolean ... blArray) {
        if (blArray.length > 1) {
            throw new IllegalArgumentException();
        }
        boolean bl = blArray.length == 1 ? blArray[0] : false;
        Master<E> master = MasterUtil.select(this.mMaster, collection, bl);
        if (master.mRowList.size() > 1) {
            throw new NoUniqueRuntimeException(master.mRowList.size(), "key[" + ObjectUtil.toString(collection) + "]");
        }
        if (master.mRowList.size() == 0) {
            return null;
        }
        return master.mRowList.iterator().next();
    }

    public List<E> findAll() {
        return this.mMaster.mRowList;
    }

    public Collection<E> findMany(E e, boolean ... blArray) {
        return this.findMany(StructUtil.createMap(e).values(), blArray);
    }

    public Collection<E> findMany(Object[] objectArray, boolean ... blArray) {
        return this.findMany((Collection<Object>)Arrays.asList(objectArray), blArray);
    }

    public Collection<E> findMany(Collection<Object> collection, boolean ... blArray) {
        if (blArray.length > 1) {
            throw new IllegalArgumentException();
        }
        boolean bl = blArray.length == 1 ? blArray[0] : false;
        Master<E> master = MasterUtil.select(this.mMaster, collection, bl);
        ListNotNullDecorator listNotNullDecorator = new ListNotNullDecorator(new ArrayList());
        for (Object e : master.mRowList) {
            listNotNullDecorator.add(e);
        }
        return listNotNullDecorator;
    }

    public void regist(E e) {
        if (this.mMaster == null) {
            this.mMaster = new Master();
        }
        this.mMaster.mRowList.add(e);
    }
}

