/*
 * Decompiled with CFR 0.152.
 */
package option.gad.client.util;

import com.kt.io.AbstFile;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import java.awt.image.WritableRaster;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import option.gad.core.io.FileIOUtil;
import option.io.jpg.JPEGCoder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ImageUtil {
    private static final Log mLog = LogFactory.getLog(ImageUtil.class);

    protected ImageUtil() {
    }

    public static final AbstFile pixelToJPEGAbstFile(int[] nArray, int n, int n2) {
        AbstFile abstFile;
        block8: {
            abstFile = null;
            BufferedOutputStream bufferedOutputStream = null;
            try {
                try {
                    abstFile = new AbstFile();
                    abstFile.openNewFileToBuffer("");
                    bufferedOutputStream = new BufferedOutputStream(abstFile.getOutpuStreamToBuffer());
                    JPEGCoder jPEGCoder = new JPEGCoder(bufferedOutputStream);
                    jPEGCoder.setQFactor(5);
                    jPEGCoder.encodePixels(nArray, n, n2);
                }
                catch (IOException iOException) {
                    mLog.info((Object)"", (Throwable)iOException);
                    if (abstFile != null) {
                        abstFile.closeNewFileToBuffer();
                    }
                    FileIOUtil.close(bufferedOutputStream);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                if (abstFile != null) {
                    abstFile.closeNewFileToBuffer();
                }
                FileIOUtil.close(bufferedOutputStream);
                throw throwable;
            }
            if (abstFile != null) {
                abstFile.closeNewFileToBuffer();
            }
            FileIOUtil.close((OutputStream)bufferedOutputStream);
        }
        return abstFile;
    }

    public static BufferedImage convBufferedImage(Image image) {
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, -1, -1, false);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {}
        ColorModel colorModel = pixelGrabber.getColorModel();
        int n = pixelGrabber.getWidth();
        int n2 = pixelGrabber.getHeight();
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(n, n2);
        BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), new Hashtable());
        bufferedImage.getRaster().setDataElements(0, 0, n, n2, pixelGrabber.getPixels());
        return bufferedImage;
    }

    public static BufferedImage resize(BufferedImage bufferedImage, float f) {
        return ImageUtil.resizeByAffine(bufferedImage, f);
    }

    public static BufferedImage resize(BufferedImage bufferedImage, int n, int n2) {
        return ImageUtil.resizeByAffine(bufferedImage, n, n2);
    }

    public static BufferedImage resizeByAffine(BufferedImage bufferedImage, float f) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        int n3 = (int)((float)n * f / 100.0f);
        int n4 = (int)((float)n2 * f / 100.0f);
        return ImageUtil.resizeByAffine(bufferedImage, n3, n4);
    }

    public static BufferedImage resizeByAffine(BufferedImage bufferedImage, int n, int n2) {
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        float f = (float)n / (float)n3;
        float f2 = (float)n2 / (float)n4;
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, bufferedImage.getType());
        AffineTransformOp affineTransformOp = null;
        affineTransformOp = new AffineTransformOp(AffineTransform.getScaleInstance(f, f2), null);
        affineTransformOp.filter(bufferedImage, bufferedImage2);
        return bufferedImage2;
    }

    public static BufferedImage resizeByAreaAveraging(BufferedImage bufferedImage, float f) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        int n3 = (int)((float)n * f / 100.0f);
        int n4 = (int)((float)n2 * f / 100.0f);
        return ImageUtil.resizeByAreaAveraging(bufferedImage, n3, n4);
    }

    public static BufferedImage resizeByAreaAveraging(BufferedImage bufferedImage, int n, int n2) {
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, bufferedImage.getType());
        bufferedImage2.getGraphics().drawImage(bufferedImage.getScaledInstance(n, n2, 16), 0, 0, n, n2, null);
        return bufferedImage2;
    }
}

