/*
 * Decompiled with CFR 0.152.
 */
package option.gad.client.pdf;

import java.awt.Color;
import nethome.doc.Layer;
import option.pdf.PdfCommand;
import option.pdf.PdfCommandGraphics;

public abstract class GdAbstractPdfPage<T extends Layer> {
    protected T mLayer;
    protected PdfCommand mPdfCommand;
    protected PdfCommandGraphics mPdfGraphics;
    protected int mPdfSize = 3;
    protected int mPdfDirection = 0;
    protected String mPdfFormatName = null;
    protected int mPage;

    public GdAbstractPdfPage(int n, int n2, String string) {
        this.mPdfSize = n;
        this.mPdfDirection = n2;
        this.mPdfFormatName = string;
    }

    public final void execute() {
        if (this.mPdfCommand == null) {
            new IllegalStateException("PdfCommand is null.");
        }
        this.initialize();
        this.setUp();
        this.drawPage();
        this.tearDown();
        this.dispose();
    }

    private void initialize() {
        this.mPdfCommand.setFormat(this.mPdfFormatName);
        this.mPdfCommand.setPageInfo(this.mPdfSize, this.mPdfDirection);
        this.mPdfGraphics = (PdfCommandGraphics)this.mPdfCommand.getGraphics();
        this.mPdfGraphics.setColor(Color.BLACK);
    }

    protected abstract void setUp();

    protected abstract void tearDown();

    private void dispose() {
        this.mPdfGraphics.dispose();
        this.mPdfGraphics = null;
    }

    protected abstract void drawPage();

    public void setPdfCommand(PdfCommand pdfCommand) {
        this.mPdfCommand = pdfCommand;
    }

    public void setLayer(T t) {
        this.mLayer = t;
    }

    public void setPage(int n) {
        this.mPage = n;
    }
}

