/*
 * Decompiled with CFR 0.152.
 */
package option.gad.client.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import option.gad.client.gui.GdColorListModelRow;

public class GdColorListRenderer
extends JLabel
implements TableCellRenderer,
ListCellRenderer {
    Border unselectedBorder = null;
    Border selectedBorder = null;
    boolean isBordered = true;

    public GdColorListRenderer() {
        this(true);
    }

    public GdColorListRenderer(boolean bl) {
        this.isBordered = bl;
        this.setOpaque(true);
        this.setHorizontalAlignment(2);
        this.setVerticalAlignment(0);
        this.setHorizontalTextPosition(11);
        this.setVerticalTextPosition(0);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        GdColorListModelRow gdColorListModelRow = (GdColorListModelRow)object;
        Color color = jTable.getSelectionBackground();
        Color color2 = jTable.getBackground();
        return this.createComponent(gdColorListModelRow, bl, color, color2);
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        if (!(object instanceof GdColorListModelRow)) {
            return this;
        }
        GdColorListModelRow gdColorListModelRow = (GdColorListModelRow)object;
        Color color = jList.getSelectionBackground();
        Color color2 = jList.getBackground();
        return this.createComponent(gdColorListModelRow, bl, color, color2);
    }

    protected Component createComponent(GdColorListModelRow gdColorListModelRow, boolean bl, Color color, Color color2) {
        String string = gdColorListModelRow.getName();
        this.setText(string);
        this.setForeground(Color.BLACK);
        this.setBackground(Color.WHITE);
        Icon icon = this.createIcon(gdColorListModelRow, this.getFont());
        this.setIcon(icon);
        if (this.isBordered) {
            if (bl) {
                if (this.selectedBorder == null) {
                    this.selectedBorder = BorderFactory.createMatteBorder(1, 5, 1, 5, color);
                }
                this.setBorder(this.selectedBorder);
            } else {
                if (this.unselectedBorder == null) {
                    this.unselectedBorder = BorderFactory.createMatteBorder(1, 5, 1, 5, color2);
                }
                this.setBorder(this.unselectedBorder);
            }
        }
        return this;
    }

    protected Icon createIcon(GdColorListModelRow gdColorListModelRow, Font font) {
        if (!gdColorListModelRow.isShowSample()) {
            return null;
        }
        int n = font != null ? font.getSize() : 10;
        BufferedImage bufferedImage = new BufferedImage(n, n, 1);
        Graphics graphics = bufferedImage.getGraphics();
        if (gdColorListModelRow.getColor() == null) {
            graphics.setColor(Color.WHITE);
        } else {
            graphics.setColor(new Color(gdColorListModelRow.getColor().getRGB(), false));
        }
        graphics.fillRect(0, 0, n, n);
        graphics.dispose();
        return new ImageIcon(bufferedImage);
    }
}

