/*
 * Decompiled with CFR 0.152.
 */
package option.gad.client.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.BorderFactory;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import option.gad.client.gui.GdAbstractConfigItemComponent;

public abstract class GdAbstractConfigItemNumberComponent<TYPE extends Number, INFO>
extends GdAbstractConfigItemComponent<TYPE, INFO> {
    protected JFormattedTextField mNumField;

    @Override
    protected JPanel createMainComponent() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.gridx = 0;
        this.mNumField = new JFormattedTextField();
        this.mNumField.setFormatterFactory(this.configFormatterFactory());
        this.mNumField.setInputVerifier(new FormattedTextFieldVerifier());
        this.mNumField.setHorizontalAlignment(4);
        this.mNumField.setFocusLostBehavior(3);
        this.mNumField.setValue(this.configDefaultType());
        this.mNumField.setEnabled(this.configDefaultEnable());
        this.mNumField.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                GdAbstractConfigItemNumberComponent.this.itemChanged();
                GdAbstractConfigItemNumberComponent.this.focusLostAction();
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
                GdAbstractConfigItemNumberComponent.this.getInputContext().setCompositionEnabled(false);
                GdAbstractConfigItemNumberComponent.this.focusGainedAction();
            }
        });
        this.mNumField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (!propertyChangeEvent.getPropertyName().equals("value")) {
                    return;
                }
                GdAbstractConfigItemNumberComponent.this.itemChanged();
            }
        });
        this.mNumField.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 243 || keyEvent.getKeyCode() == 244) {
                    GdAbstractConfigItemNumberComponent.this.getInputContext().setCompositionEnabled(false);
                }
                GdAbstractConfigItemNumberComponent.this.keyReleasedAction();
            }
        });
        jPanel.add((Component)this.mNumField, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        ++gridBagConstraints.gridx;
        JLabel jLabel = new JLabel();
        jLabel.setText(this.configSuffix());
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.mSelectedType = (Number)this.configDefaultType();
        return jPanel;
    }

    protected abstract String configSuffix();

    protected abstract JFormattedTextField.AbstractFormatterFactory configFormatterFactory();

    protected Format configFieldFormat() {
        return null;
    }

    protected abstract TYPE configMaxNum();

    protected abstract TYPE configMinNum();

    protected boolean configDefaultEnable() {
        return true;
    }

    @Override
    protected void itemChanged() {
        try {
            this.mNumField.commitEdit();
            this.typeChanged((Number)this.mNumField.getValue());
        }
        catch (Exception exception) {}
        super.itemChanged();
    }

    protected void focusLostAction() {
    }

    protected void focusGainedAction() {
        NumberFormatter numberFormatter = (NumberFormatter)this.mNumField.getFormatter();
        numberFormatter.setMaximum((Comparable)this.configMaxNum());
        numberFormatter.setMinimum((Comparable)this.configMinNum());
    }

    @Override
    protected void keyReleasedAction() {
        try {
            int n = this.mNumField.getCaretPosition();
            this.mNumField.commitEdit();
            this.mNumField.setCaretPosition(n);
            this.typeChanged((Number)this.mNumField.getValue());
        }
        catch (Exception exception) {}
        super.keyReleasedAction();
    }

    @Override
    protected void updateComponents() {
        if (this.mConfigInfo == null) {
            return;
        }
        this.mNumField.setFormatterFactory(this.configFormatterFactory());
        this.mNumField.setValue(this.configDefaultType());
    }

    @Override
    public void setEditable(boolean bl) {
        this.mNumField.setEditable(bl);
    }

    @Override
    public boolean isValueValid() {
        if (this.mNumField == null) {
            return true;
        }
        return this.mNumField.isEditValid();
    }

    public class FloatFormatterFactory
    extends GdFormatterFactory {
        @Override
        protected Class<TYPE> configValueClass() {
            return Float.class;
        }
    }

    protected class FormattedTextFieldVerifier
    extends InputVerifier {
        protected FormattedTextFieldVerifier() {
        }

        @Override
        public boolean verify(JComponent jComponent) {
            JFormattedTextField jFormattedTextField;
            JFormattedTextField.AbstractFormatter abstractFormatter;
            if (jComponent instanceof JFormattedTextField && (abstractFormatter = (jFormattedTextField = (JFormattedTextField)jComponent).getFormatter()) != null) {
                String string = jFormattedTextField.getText();
                try {
                    abstractFormatter.stringToValue(string);
                    return true;
                }
                catch (ParseException parseException) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public boolean shouldYieldFocus(JComponent jComponent) {
            return this.verify(jComponent);
        }
    }

    protected abstract class GdFormatterFactory
    extends DefaultFormatterFactory {
        public GdFormatterFactory() {
            NumberFormatter numberFormatter = this.createFormatter();
            this.setDefaultFormatter(numberFormatter);
            this.setDisplayFormatter(numberFormatter);
            this.setEditFormatter(numberFormatter);
        }

        protected abstract Class<TYPE> configValueClass();

        protected NumberFormatter createFormatter() {
            NumberFormatter numberFormatter = new NumberFormatter();
            numberFormatter.setValueClass(this.configValueClass());
            numberFormatter.setMinimum((Comparable)GdAbstractConfigItemNumberComponent.this.configMinNum());
            numberFormatter.setMaximum((Comparable)GdAbstractConfigItemNumberComponent.this.configMaxNum());
            if (GdAbstractConfigItemNumberComponent.this.configFieldFormat() != null) {
                numberFormatter.setFormat(GdAbstractConfigItemNumberComponent.this.configFieldFormat());
            }
            ((NumberFormat)numberFormatter.getFormat()).setGroupingUsed(false);
            return numberFormatter;
        }
    }

    public class IntegerFormatterFactory
    extends GdFormatterFactory {
        @Override
        protected Class<TYPE> configValueClass() {
            return Integer.class;
        }
    }
}

