/*
 * Decompiled with CFR 0.152.
 */
package option.gad.client.geom.primitive;

import com.kt.util.tree.ObjectFolder;
import com.kt.util.tree.ObjectNode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import nethome.geom.primitive.Geometory;
import option.gad.client.geom.primitive.GdGeometryGraph;
import option.gad.client.util.GdGeomUtil;
import option.gad.core.util.ListNotNullDecorator;
import option.gad.core.util.ListUniqueDecorator;

public class GdGeometryGraphImpl<T extends Geometory>
implements GdGeometryGraph,
Serializable {
    private T mGeom = null;
    private List<Geometory> mParentGeomList = new ListNotNullDecorator((List)new ListUniqueDecorator(new ArrayList()));
    private List<Geometory> mChildGeomList = new ListNotNullDecorator((List)new ListUniqueDecorator(new ArrayList()));

    public GdGeometryGraphImpl(T t) {
        this.mGeom = t;
    }

    @Override
    public Collection<Geometory> getParentGeometries() {
        return this.mParentGeomList;
    }

    @Override
    public void addParentGeometry(Geometory geometory) {
        GdGeometryGraph gdGeometryGraph;
        this.mParentGeomList.add(geometory);
        if (geometory instanceof GdGeometryGraph && !(gdGeometryGraph = (GdGeometryGraph)geometory).getChildGeometries().contains(this.mGeom)) {
            gdGeometryGraph.addChildGeometry((Geometory)this.mGeom);
        }
    }

    @Override
    public void removeParentGeometry(Geometory geometory) {
        GdGeometryGraph gdGeometryGraph;
        if (geometory == null) {
            return;
        }
        this.mParentGeomList.remove(geometory);
        if (geometory instanceof GdGeometryGraph && (gdGeometryGraph = (GdGeometryGraph)geometory).getChildGeometries().contains(this.mGeom)) {
            gdGeometryGraph.removeChildGeometry((Geometory)this.mGeom);
        }
    }

    @Override
    public void clearParentGeometries() {
        for (Geometory geometory : new ArrayList<Geometory>(this.mParentGeomList)) {
            ((GdGeometryGraph)this.mGeom).removeParentGeometry(geometory);
        }
    }

    @Deprecated
    public Vector<Geometory> getChildGeometorys() {
        return new Vector<Geometory>(this.mChildGeomList);
    }

    @Override
    public Collection<Geometory> getChildGeometries() {
        return this.mChildGeomList;
    }

    @Override
    public void addChildGeometry(Geometory geometory) {
        GdGeometryGraph gdGeometryGraph;
        this.mChildGeomList.add(geometory);
        if (geometory instanceof GdGeometryGraph && !(gdGeometryGraph = (GdGeometryGraph)geometory).getParentGeometries().contains(this.mGeom)) {
            gdGeometryGraph.addParentGeometry((Geometory)this.mGeom);
        }
    }

    @Override
    public void removeChildGeometry(Geometory geometory) {
        GdGeometryGraph gdGeometryGraph;
        if (geometory == null) {
            return;
        }
        this.mChildGeomList.remove(geometory);
        if (geometory instanceof GdGeometryGraph && (gdGeometryGraph = (GdGeometryGraph)geometory).getParentGeometries().contains(this.mGeom)) {
            gdGeometryGraph.removeParentGeometry((Geometory)this.mGeom);
        }
    }

    @Override
    public void clearChildGeometries() {
        ((GdGeometryGraph)this.mGeom).clearChildGeometries(false);
    }

    @Override
    public void clearChildGeometries(boolean bl) {
        for (Geometory geometory : new ArrayList<Geometory>(this.mChildGeomList)) {
            if (bl) {
                GdGeomUtil.clearGeometry(geometory);
            }
            ((GdGeometryGraph)this.mGeom).removeChildGeometry(geometory);
        }
    }

    @Override
    public void clear() {
        ((GdGeometryGraph)this.mGeom).clear(false);
    }

    @Override
    public void clear(boolean bl) {
        ((GdGeometryGraph)this.mGeom).clearChildGeometries(bl);
        ((GdGeometryGraph)this.mGeom).clearParentGeometries();
    }

    public void save(ObjectFolder objectFolder) {
        if (objectFolder == null) {
            return;
        }
        this.saveGeometries(objectFolder, "parentGeometry", this.mParentGeomList);
        this.saveGeometries(objectFolder, "childGeometry", this.mChildGeomList);
    }

    private void saveGeometries(ObjectFolder objectFolder, String string, Collection<Geometory> collection) {
        for (Geometory geometory : collection) {
            ObjectFolder objectFolder2 = new ObjectFolder(string);
            objectFolder2.addChild(new ObjectNode("id", (Object)geometory.getID()));
            objectFolder.addChild((ObjectNode)objectFolder2, true);
        }
    }

    public void load(ObjectFolder objectFolder, Collection<Geometory> collection) {
        if (objectFolder == null) {
            return;
        }
        this.loadParentGeometries(objectFolder, "parentGeometry", collection);
        this.loadChildGeometries(objectFolder, "childGeometry", collection);
    }

    private void loadParentGeometries(ObjectFolder objectFolder, String string, Collection<Geometory> collection) {
        Vector vector = objectFolder.getNamedElement(string);
        if (vector == null) {
            return;
        }
        ArrayList<Geometory> arrayList = new ArrayList<Geometory>(collection);
        for (ObjectNode objectNode : vector) {
            if (!(objectNode instanceof ObjectFolder)) continue;
            ObjectNode objectNode2 = ((ObjectFolder)objectNode).getNode("id");
            int n = ObjectNode.getNodeInt((ObjectNode)objectNode2);
            ((GdGeometryGraph)this.mGeom).addParentGeometry((Geometory)GdGeomUtil.findGeometry(arrayList, n));
        }
    }

    private void loadChildGeometries(ObjectFolder objectFolder, String string, Collection<Geometory> collection) {
        Vector vector = objectFolder.getNamedElement(string);
        if (vector == null) {
            return;
        }
        ArrayList<Geometory> arrayList = new ArrayList<Geometory>(collection);
        for (ObjectNode objectNode : vector) {
            if (!(objectNode instanceof ObjectFolder)) continue;
            ObjectNode objectNode2 = ((ObjectFolder)objectNode).getNode("id");
            int n = ObjectNode.getNodeInt((ObjectNode)objectNode2);
            ((GdGeometryGraph)this.mGeom).addChildGeometry((Geometory)GdGeomUtil.findGeometry(arrayList, n));
        }
    }

    @Override
    public void setParent(Geometory geometory) {
        this.mParentGeomList.clear();
        if (geometory != null) {
            this.mParentGeomList.add(geometory);
        }
    }

    @Override
    public <G extends Geometory> G getParent() {
        Geometory geometory = null;
        if (!this.mParentGeomList.isEmpty()) {
            geometory = this.mParentGeomList.iterator().next();
        }
        return (G)geometory;
    }

    @Override
    public void setChild(Geometory geometory) {
        this.mChildGeomList.clear();
        if (geometory != null) {
            this.mChildGeomList.add(geometory);
        }
    }

    @Override
    public <G extends Geometory> G getChild() {
        Geometory geometory = null;
        if (!this.mChildGeomList.isEmpty()) {
            geometory = this.mChildGeomList.iterator().next();
        }
        return (G)geometory;
    }

    @Override
    public void repairRelation() {
    }
}

